/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_ORDERED;

@DatatypeDef(name="DV_DATE_TIME")
public class DV_DATE_TIME
extends DV_ORDERED
implements ICompositeType {
    @Child(name="value", type={DateTimeType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="ISO8601 date string", formalDefinition="ISO8601 date string.")
    protected DateTimeType value;
    private static final long serialVersionUID = 74859328L;

    public DateTimeType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_DATE_TIME.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new DateTimeType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public DV_DATE_TIME setValueElement(DateTimeType value) {
        this.value = value;
        return this;
    }

    public Date getValue() {
        return this.value == null ? null : (Date)this.value.getValue();
    }

    public DV_DATE_TIME setValue(Date value) {
        if (value == null) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            this.value.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "dateTime", "ISO8601 date string.", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "dateTime", "ISO8601 date string.", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = TypeConvertor.castToDateTime(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("value")) {
            return super.setProperty(name, value);
        }
        this.value = TypeConvertor.castToDateTime(value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"dateTime"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_DATE_TIME.value");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_DATE_TIME";
    }

    @Override
    public DV_DATE_TIME copy() {
        DV_DATE_TIME dst = new DV_DATE_TIME();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_DATE_TIME dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected DV_DATE_TIME typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_DATE_TIME)) {
            return false;
        }
        DV_DATE_TIME o = (DV_DATE_TIME)other_;
        return DV_DATE_TIME.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_DATE_TIME)) {
            return false;
        }
        DV_DATE_TIME o = (DV_DATE_TIME)other_;
        return DV_DATE_TIME.compareValues(this.value, o.value, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value});
    }
}

