/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_AMOUNT;

@DatatypeDef(name="DV_COUNT")
public class DV_COUNT
extends DV_AMOUNT
implements ICompositeType {
    @Child(name="magnitude", type={DecimalType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Numeric magnitude", formalDefinition="Numeric magnitude.")
    protected DecimalType magnitude;
    private static final long serialVersionUID = -829015249L;

    public DV_COUNT() {
    }

    public DV_COUNT(BigDecimal magnitude) {
        this.setMagnitude(magnitude);
    }

    public DecimalType getMagnitudeElement() {
        if (this.magnitude == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_COUNT.magnitude");
            }
            if (Configuration.doAutoCreate()) {
                this.magnitude = new DecimalType();
            }
        }
        return this.magnitude;
    }

    public boolean hasMagnitudeElement() {
        return this.magnitude != null && !this.magnitude.isEmpty();
    }

    public boolean hasMagnitude() {
        return this.magnitude != null && !this.magnitude.isEmpty();
    }

    public DV_COUNT setMagnitudeElement(DecimalType value) {
        this.magnitude = value;
        return this;
    }

    public BigDecimal getMagnitude() {
        return this.magnitude == null ? null : (BigDecimal)this.magnitude.getValue();
    }

    public DV_COUNT setMagnitude(BigDecimal value) {
        if (this.magnitude == null) {
            this.magnitude = new DecimalType();
        }
        this.magnitude.setValue(value);
        return this;
    }

    public DV_COUNT setMagnitude(long value) {
        this.magnitude = new DecimalType();
        this.magnitude.setValue(value);
        return this;
    }

    public DV_COUNT setMagnitude(double value) {
        this.magnitude = new DecimalType();
        this.magnitude.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("magnitude", "decimal", "Numeric magnitude.", 0, 1, this.magnitude));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -2016783856: {
                return new Property("magnitude", "decimal", "Numeric magnitude.", 0, 1, this.magnitude);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                Base[] baseArray;
                if (this.magnitude == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.magnitude;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                this.magnitude = TypeConvertor.castToDecimal(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("magnitude")) {
            return super.setProperty(name, value);
        }
        this.magnitude = TypeConvertor.castToDecimal(value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                return this.getMagnitudeElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                return new String[]{"decimal"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("magnitude")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_COUNT.magnitude");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_COUNT";
    }

    @Override
    public DV_COUNT copy() {
        DV_COUNT dst = new DV_COUNT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_COUNT dst) {
        super.copyValues(dst);
        dst.magnitude = this.magnitude == null ? null : this.magnitude.copy();
    }

    protected DV_COUNT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_COUNT)) {
            return false;
        }
        DV_COUNT o = (DV_COUNT)other_;
        return DV_COUNT.compareDeep(this.magnitude, o.magnitude, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_COUNT)) {
            return false;
        }
        DV_COUNT o = (DV_COUNT)other_;
        return DV_COUNT.compareValues(this.magnitude, o.magnitude, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.magnitude});
    }
}

