/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_QUANTIFIED;

@DatatypeDef(name="DV_AMOUNT")
public abstract class DV_AMOUNT
extends DV_QUANTIFIED
implements ICompositeType {
    @Child(name="accuracy_is_percent", type={BooleanType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="If True, indicates that when this object was created, accuracy was recorded as a percent value; if False, as an absolute quantity value", formalDefinition="If True, indicates that when this object was created, accuracy was recorded as a percent value; if False, as an absolute quantity value.")
    protected BooleanType accuracy_is_percent;
    private static final long serialVersionUID = 421282386L;

    public BooleanType getAccuracy_is_percentElement() {
        if (this.accuracy_is_percent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_AMOUNT.accuracy_is_percent");
            }
            if (Configuration.doAutoCreate()) {
                this.accuracy_is_percent = new BooleanType();
            }
        }
        return this.accuracy_is_percent;
    }

    public boolean hasAccuracy_is_percentElement() {
        return this.accuracy_is_percent != null && !this.accuracy_is_percent.isEmpty();
    }

    public boolean hasAccuracy_is_percent() {
        return this.accuracy_is_percent != null && !this.accuracy_is_percent.isEmpty();
    }

    public DV_AMOUNT setAccuracy_is_percentElement(BooleanType value) {
        this.accuracy_is_percent = value;
        return this;
    }

    public boolean getAccuracy_is_percent() {
        return this.accuracy_is_percent == null || this.accuracy_is_percent.isEmpty() ? false : (Boolean)this.accuracy_is_percent.getValue();
    }

    public DV_AMOUNT setAccuracy_is_percent(boolean value) {
        if (this.accuracy_is_percent == null) {
            this.accuracy_is_percent = new BooleanType();
        }
        this.accuracy_is_percent.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("accuracy_is_percent", "boolean", "If True, indicates that when this object was created, accuracy was recorded as a percent value; if False, as an absolute quantity value.", 0, 1, this.accuracy_is_percent));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 629785910: {
                return new Property("accuracy_is_percent", "boolean", "If True, indicates that when this object was created, accuracy was recorded as a percent value; if False, as an absolute quantity value.", 0, 1, this.accuracy_is_percent);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 629785910: {
                Base[] baseArray;
                if (this.accuracy_is_percent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.accuracy_is_percent;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 629785910: {
                this.accuracy_is_percent = TypeConvertor.castToBoolean(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("accuracy_is_percent")) {
            return super.setProperty(name, value);
        }
        this.accuracy_is_percent = TypeConvertor.castToBoolean(value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 629785910: {
                return this.getAccuracy_is_percentElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 629785910: {
                return new String[]{"boolean"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("accuracy_is_percent")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_AMOUNT.accuracy_is_percent");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_AMOUNT";
    }

    @Override
    public abstract DV_AMOUNT copy();

    public void copyValues(DV_AMOUNT dst) {
        super.copyValues(dst);
        dst.accuracy_is_percent = this.accuracy_is_percent == null ? null : this.accuracy_is_percent.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_AMOUNT)) {
            return false;
        }
        DV_AMOUNT o = (DV_AMOUNT)other_;
        return DV_AMOUNT.compareDeep(this.accuracy_is_percent, o.accuracy_is_percent, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_AMOUNT)) {
            return false;
        }
        DV_AMOUNT o = (DV_AMOUNT)other_;
        return DV_AMOUNT.compareValues(this.accuracy_is_percent, o.accuracy_is_percent, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.accuracy_is_percent});
    }
}

