/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.HIER_OBJECT_ID;
import org.hl7.fhir.r5.openehr.OBJECT_REF;

@DatatypeDef(name="CONTRIBUTION")
public class CONTRIBUTION
extends LogicalBase
implements ICompositeType {
    @Child(name="uid", type={HIER_OBJECT_ID.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Unique identifier for this Contribution", formalDefinition="Unique identifier for this Contribution.")
    protected HIER_OBJECT_ID uid;
    @Child(name="versions", type={OBJECT_REF.class}, order=1, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Set of references to Versions causing changes to this EHR", formalDefinition="Set of references to Versions causing changes to this EHR. Each contribution contains a list of versions, which may include paths pointing to any number of versionable items, i.e. items of types such as COMPOSITION and FOLDER.")
    protected List<OBJECT_REF> versionsList;
    @Child(name="audit", type={AUDIT_DETAILS.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Audit trail corresponding to the committal of this Contribution", formalDefinition="Audit trail corresponding to the committal of this Contribution.")
    protected AUDIT_DETAILS audit;
    private static final long serialVersionUID = 2043766363L;

    public CONTRIBUTION() {
    }

    public CONTRIBUTION(HIER_OBJECT_ID uid, OBJECT_REF versions, AUDIT_DETAILS audit) {
        this.setUid(uid);
        this.addVersions(versions);
        this.setAudit(audit);
    }

    public HIER_OBJECT_ID getUid() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CONTRIBUTION.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new HIER_OBJECT_ID();
            }
        }
        return this.uid;
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public CONTRIBUTION setUid(HIER_OBJECT_ID value) {
        this.uid = value;
        return this;
    }

    public List<OBJECT_REF> getVersionsList() {
        if (this.versionsList == null) {
            this.versionsList = new ArrayList<OBJECT_REF>();
        }
        return this.versionsList;
    }

    public CONTRIBUTION setVersionsList(List<OBJECT_REF> theVersions) {
        this.versionsList = theVersions;
        return this;
    }

    public boolean hasVersions() {
        if (this.versionsList == null) {
            return false;
        }
        for (OBJECT_REF item : this.versionsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_REF addVersions() {
        OBJECT_REF t = new OBJECT_REF();
        if (this.versionsList == null) {
            this.versionsList = new ArrayList<OBJECT_REF>();
        }
        this.versionsList.add(t);
        return t;
    }

    public CONTRIBUTION addVersions(OBJECT_REF t) {
        if (t == null) {
            return this;
        }
        if (this.versionsList == null) {
            this.versionsList = new ArrayList<OBJECT_REF>();
        }
        this.versionsList.add(t);
        return this;
    }

    public OBJECT_REF getVersionsFirstRep() {
        if (this.getVersionsList().isEmpty()) {
            this.addVersions();
        }
        return this.getVersionsList().get(0);
    }

    public AUDIT_DETAILS getAudit() {
        if (this.audit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CONTRIBUTION.audit");
            }
            if (Configuration.doAutoCreate()) {
                this.audit = new AUDIT_DETAILS();
            }
        }
        return this.audit;
    }

    public boolean hasAudit() {
        return this.audit != null && !this.audit.isEmpty();
    }

    public CONTRIBUTION setAudit(AUDIT_DETAILS value) {
        this.audit = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("uid", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "Unique identifier for this Contribution.", 0, 1, this.uid));
        children.add(new Property("versions", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Set of references to Versions causing changes to this EHR. Each contribution contains a list of versions, which may include paths pointing to any number of versionable items, i.e. items of types such as COMPOSITION and FOLDER.", 0, Integer.MAX_VALUE, this.versionsList));
        children.add(new Property("audit", "http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS", "Audit trail corresponding to the committal of this Contribution.", 0, 1, this.audit));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 115792: {
                return new Property("uid", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "Unique identifier for this Contribution.", 0, 1, this.uid);
            }
            case -1985053029: {
                return new Property("versions", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Set of references to Versions causing changes to this EHR. Each contribution contains a list of versions, which may include paths pointing to any number of versionable items, i.e. items of types such as COMPOSITION and FOLDER.", 0, Integer.MAX_VALUE, this.versionsList);
            }
            case 93166555: {
                return new Property("audit", "http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS", "Audit trail corresponding to the committal of this Contribution.", 0, 1, this.audit);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.uid;
                }
                return baseArray;
            }
            case -1985053029: {
                return this.versionsList == null ? new Base[]{} : this.versionsList.toArray(new Base[this.versionsList.size()]);
            }
            case 93166555: {
                Base[] baseArray;
                if (this.audit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.audit;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 115792: {
                this.uid = (HIER_OBJECT_ID)value;
                return value;
            }
            case -1985053029: {
                this.getVersionsList().add((OBJECT_REF)value);
                return value;
            }
            case 93166555: {
                this.audit = (AUDIT_DETAILS)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = (HIER_OBJECT_ID)value;
        } else if (name.equals("versions")) {
            this.getVersionsList().add((OBJECT_REF)value);
        } else if (name.equals("audit")) {
            this.audit = (AUDIT_DETAILS)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return this.getUid();
            }
            case -1985053029: {
                return this.addVersions();
            }
            case 93166555: {
                return this.getAudit();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID"};
            }
            case -1985053029: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case 93166555: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = new HIER_OBJECT_ID();
            return this.uid;
        }
        if (name.equals("versions")) {
            return this.addVersions();
        }
        if (name.equals("audit")) {
            this.audit = new AUDIT_DETAILS();
            return this.audit;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CONTRIBUTION";
    }

    @Override
    public CONTRIBUTION copy() {
        CONTRIBUTION dst = new CONTRIBUTION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CONTRIBUTION dst) {
        super.copyValues(dst);
        HIER_OBJECT_ID hIER_OBJECT_ID = dst.uid = this.uid == null ? null : this.uid.copy();
        if (this.versionsList != null) {
            dst.versionsList = new ArrayList<OBJECT_REF>();
            for (OBJECT_REF i : this.versionsList) {
                dst.versionsList.add(i.copy());
            }
        }
        dst.audit = this.audit == null ? null : this.audit.copy();
    }

    protected CONTRIBUTION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CONTRIBUTION)) {
            return false;
        }
        CONTRIBUTION o = (CONTRIBUTION)other_;
        return CONTRIBUTION.compareDeep(this.uid, o.uid, true) && CONTRIBUTION.compareDeep(this.versionsList, o.versionsList, true) && CONTRIBUTION.compareDeep(this.audit, o.audit, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CONTRIBUTION)) {
            return false;
        }
        CONTRIBUTION o = (CONTRIBUTION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.versionsList, this.audit});
    }
}

