/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ENTRY;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.OBJECT_REF;

@DatatypeDef(name="CARE_ENTRY")
public abstract class CARE_ENTRY
extends ENTRY
implements ICompositeType {
    @Child(name="protocol", type={ITEM_STRUCTURE.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of the method (i.e. how) the information in this entry was arrived at", formalDefinition="Description of the method (i.e. how) the information in this entry was arrived at. For OBSERVATIONs, this is a description of the method or instrument used. For EVALUATIONs, how the evaluation was arrived at. For INSTRUCTIONs, how to execute the Instruction. This may take the form of references to guidelines, including manually followed and executable; knowledge references such as a paper in Medline; clinical reasons within a larger care process.")
    protected ITEM_STRUCTURE protocol;
    @Child(name="guideline_id", type={OBJECT_REF.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional external identifier of guideline creating this Entry if relevant", formalDefinition="Optional external identifier of guideline creating this Entry if relevant.")
    protected OBJECT_REF guideline_id;
    private static final long serialVersionUID = 1019967948L;

    public ITEM_STRUCTURE getProtocol() {
        return this.protocol;
    }

    public boolean hasProtocol() {
        return this.protocol != null && !this.protocol.isEmpty();
    }

    public CARE_ENTRY setProtocol(ITEM_STRUCTURE value) {
        this.protocol = value;
        return this;
    }

    public OBJECT_REF getGuideline_id() {
        if (this.guideline_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CARE_ENTRY.guideline_id");
            }
            if (Configuration.doAutoCreate()) {
                this.guideline_id = new OBJECT_REF();
            }
        }
        return this.guideline_id;
    }

    public boolean hasGuideline_id() {
        return this.guideline_id != null && !this.guideline_id.isEmpty();
    }

    public CARE_ENTRY setGuideline_id(OBJECT_REF value) {
        this.guideline_id = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("protocol", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Description of the method (i.e. how) the information in this entry was arrived at. For OBSERVATIONs, this is a description of the method or instrument used. For EVALUATIONs, how the evaluation was arrived at. For INSTRUCTIONs, how to execute the Instruction. This may take the form of references to guidelines, including manually followed and executable; knowledge references such as a paper in Medline; clinical reasons within a larger care process.", 0, 1, this.protocol));
        children.add(new Property("guideline_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional external identifier of guideline creating this Entry if relevant.", 0, 1, this.guideline_id));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -989163880: {
                return new Property("protocol", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Description of the method (i.e. how) the information in this entry was arrived at. For OBSERVATIONs, this is a description of the method or instrument used. For EVALUATIONs, how the evaluation was arrived at. For INSTRUCTIONs, how to execute the Instruction. This may take the form of references to guidelines, including manually followed and executable; knowledge references such as a paper in Medline; clinical reasons within a larger care process.", 0, 1, this.protocol);
            }
            case 1211891402: {
                return new Property("guideline_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Optional external identifier of guideline creating this Entry if relevant.", 0, 1, this.guideline_id);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -989163880: {
                Base[] baseArray;
                if (this.protocol == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.protocol;
                }
                return baseArray;
            }
            case 1211891402: {
                Base[] baseArray;
                if (this.guideline_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.guideline_id;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -989163880: {
                this.protocol = (ITEM_STRUCTURE)value;
                return value;
            }
            case 1211891402: {
                this.guideline_id = (OBJECT_REF)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("protocol")) {
            this.protocol = (ITEM_STRUCTURE)value;
        } else if (name.equals("guideline_id")) {
            this.guideline_id = (OBJECT_REF)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -989163880: {
                throw new Error("Unable to make an instance of the abstract property 'protocol'");
            }
            case 1211891402: {
                return this.getGuideline_id();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -989163880: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
            case 1211891402: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("protocol")) {
            throw new FHIRException("Cannot call addChild on an abstract type CARE_ENTRY.protocol");
        }
        if (name.equals("guideline_id")) {
            this.guideline_id = new OBJECT_REF();
            return this.guideline_id;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CARE_ENTRY";
    }

    @Override
    public abstract CARE_ENTRY copy();

    public void copyValues(CARE_ENTRY dst) {
        super.copyValues(dst);
        dst.protocol = this.protocol == null ? null : this.protocol.copy();
        dst.guideline_id = this.guideline_id == null ? null : this.guideline_id.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CARE_ENTRY)) {
            return false;
        }
        CARE_ENTRY o = (CARE_ENTRY)other_;
        return CARE_ENTRY.compareDeep(this.protocol, o.protocol, true) && CARE_ENTRY.compareDeep(this.guideline_id, o.guideline_id, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CARE_ENTRY)) {
            return false;
        }
        CARE_ENTRY o = (CARE_ENTRY)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.protocol, this.guideline_id});
    }
}

