/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.ARCHETYPE_ID;
import org.hl7.fhir.r5.openehr.TEMPLATE_ID;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ARCHETYPED")
public class ARCHETYPED
extends LogicalBase
implements ICompositeType {
    @Child(name="archetype_id", type={ARCHETYPE_ID.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Globally unique archetype identifier", formalDefinition="Globally unique archetype identifier.")
    protected ARCHETYPE_ID archetype_id;
    @Child(name="template_id", type={TEMPLATE_ID.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Globally unique template identifier, if a template was active", formalDefinition="Globally unique template identifier, if a template was active at this point in the structure. Normally, a template would only be used at the top of a top-level structure, but the possibility exists for templates at lower levels.")
    protected TEMPLATE_ID template_id;
    @Child(name="rm_version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Version of the openEHR reference model used to create this object", formalDefinition="Version of the openEHR reference model used to create this object. Expressed in terms of the release version string, e.g. 1.0 , 1.2.4 .")
    protected StringType rm_version;
    private static final long serialVersionUID = 155490869L;

    public ARCHETYPED() {
    }

    public ARCHETYPED(ARCHETYPE_ID archetype_id) {
        this.setArchetype_id(archetype_id);
    }

    public ARCHETYPE_ID getArchetype_id() {
        if (this.archetype_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ARCHETYPED.archetype_id");
            }
            if (Configuration.doAutoCreate()) {
                this.archetype_id = new ARCHETYPE_ID();
            }
        }
        return this.archetype_id;
    }

    public boolean hasArchetype_id() {
        return this.archetype_id != null && !this.archetype_id.isEmpty();
    }

    public ARCHETYPED setArchetype_id(ARCHETYPE_ID value) {
        this.archetype_id = value;
        return this;
    }

    public TEMPLATE_ID getTemplate_id() {
        if (this.template_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ARCHETYPED.template_id");
            }
            if (Configuration.doAutoCreate()) {
                this.template_id = new TEMPLATE_ID();
            }
        }
        return this.template_id;
    }

    public boolean hasTemplate_id() {
        return this.template_id != null && !this.template_id.isEmpty();
    }

    public ARCHETYPED setTemplate_id(TEMPLATE_ID value) {
        this.template_id = value;
        return this;
    }

    public StringType getRm_versionElement() {
        if (this.rm_version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ARCHETYPED.rm_version");
            }
            if (Configuration.doAutoCreate()) {
                this.rm_version = new StringType();
            }
        }
        return this.rm_version;
    }

    public boolean hasRm_versionElement() {
        return this.rm_version != null && !this.rm_version.isEmpty();
    }

    public boolean hasRm_version() {
        return this.rm_version != null && !this.rm_version.isEmpty();
    }

    public ARCHETYPED setRm_versionElement(StringType value) {
        this.rm_version = value;
        return this;
    }

    public String getRm_version() {
        return this.rm_version == null ? null : (String)this.rm_version.getValue();
    }

    public ARCHETYPED setRm_version(String value) {
        if (Utilities.noString((String)value)) {
            this.rm_version = null;
        } else {
            if (this.rm_version == null) {
                this.rm_version = new StringType();
            }
            this.rm_version.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("archetype_id", "http://openehr.org/fhir/StructureDefinition/ARCHETYPE-ID", "Globally unique archetype identifier.", 0, 1, this.archetype_id));
        children.add(new Property("template_id", "http://openehr.org/fhir/StructureDefinition/TEMPLATE-ID", "Globally unique template identifier, if a template was active at this point in the structure. Normally, a template would only be used at the top of a top-level structure, but the possibility exists for templates at lower levels.", 0, 1, this.template_id));
        children.add(new Property("rm_version", "string", "Version of the openEHR reference model used to create this object. Expressed in terms of the release version string, e.g. 1.0 , 1.2.4 .", 0, 1, this.rm_version));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1252479343: {
                return new Property("archetype_id", "http://openehr.org/fhir/StructureDefinition/ARCHETYPE-ID", "Globally unique archetype identifier.", 0, 1, this.archetype_id);
            }
            case 1769642752: {
                return new Property("template_id", "http://openehr.org/fhir/StructureDefinition/TEMPLATE-ID", "Globally unique template identifier, if a template was active at this point in the structure. Normally, a template would only be used at the top of a top-level structure, but the possibility exists for templates at lower levels.", 0, 1, this.template_id);
            }
            case -1956878636: {
                return new Property("rm_version", "string", "Version of the openEHR reference model used to create this object. Expressed in terms of the release version string, e.g. 1.0 , 1.2.4 .", 0, 1, this.rm_version);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1252479343: {
                Base[] baseArray;
                if (this.archetype_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.archetype_id;
                }
                return baseArray;
            }
            case 1769642752: {
                Base[] baseArray;
                if (this.template_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.template_id;
                }
                return baseArray;
            }
            case -1956878636: {
                Base[] baseArray;
                if (this.rm_version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.rm_version;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1252479343: {
                this.archetype_id = (ARCHETYPE_ID)value;
                return value;
            }
            case 1769642752: {
                this.template_id = (TEMPLATE_ID)value;
                return value;
            }
            case -1956878636: {
                this.rm_version = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("archetype_id")) {
            this.archetype_id = (ARCHETYPE_ID)value;
        } else if (name.equals("template_id")) {
            this.template_id = (TEMPLATE_ID)value;
        } else if (name.equals("rm_version")) {
            this.rm_version = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1252479343: {
                return this.getArchetype_id();
            }
            case 1769642752: {
                return this.getTemplate_id();
            }
            case -1956878636: {
                return this.getRm_versionElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1252479343: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ARCHETYPE-ID"};
            }
            case 1769642752: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TEMPLATE-ID"};
            }
            case -1956878636: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("archetype_id")) {
            this.archetype_id = new ARCHETYPE_ID();
            return this.archetype_id;
        }
        if (name.equals("template_id")) {
            this.template_id = new TEMPLATE_ID();
            return this.template_id;
        }
        if (name.equals("rm_version")) {
            throw new FHIRException("Cannot call addChild on a singleton property ARCHETYPED.rm_version");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ARCHETYPED";
    }

    @Override
    public ARCHETYPED copy() {
        ARCHETYPED dst = new ARCHETYPED();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ARCHETYPED dst) {
        super.copyValues(dst);
        dst.archetype_id = this.archetype_id == null ? null : this.archetype_id.copy();
        dst.template_id = this.template_id == null ? null : this.template_id.copy();
        dst.rm_version = this.rm_version == null ? null : this.rm_version.copy();
    }

    protected ARCHETYPED typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ARCHETYPED)) {
            return false;
        }
        ARCHETYPED o = (ARCHETYPED)other_;
        return ARCHETYPED.compareDeep(this.archetype_id, o.archetype_id, true) && ARCHETYPED.compareDeep(this.template_id, o.template_id, true) && ARCHETYPED.compareDeep(this.rm_version, o.rm_version, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ARCHETYPED)) {
            return false;
        }
        ARCHETYPED o = (ARCHETYPED)other_;
        return ARCHETYPED.compareValues(this.rm_version, o.rm_version, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.archetype_id, this.template_id, this.rm_version});
    }
}

