/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ENTRY;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;

@DatatypeDef(name="ADMIN_ENTRY")
public class ADMIN_ENTRY
extends ENTRY
implements ICompositeType {
    @Child(name="data", type={ITEM_STRUCTURE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Content of the Admin Entry. The data of the Entry; modelled in archetypes", formalDefinition="Content of the Admin Entry. The data of the Entry; modelled in archetypes.")
    protected ITEM_STRUCTURE data;
    private static final long serialVersionUID = 583338983L;

    public ADMIN_ENTRY() {
    }

    public ADMIN_ENTRY(ITEM_STRUCTURE data) {
        this.setData(data);
    }

    public ITEM_STRUCTURE getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public ADMIN_ENTRY setData(ITEM_STRUCTURE value) {
        this.data = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("data", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Content of the Admin Entry. The data of the Entry; modelled in archetypes.", 0, 1, this.data));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3076010: {
                return new Property("data", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Content of the Admin Entry. The data of the Entry; modelled in archetypes.", 0, 1, this.data);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.data;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3076010: {
                this.data = (ITEM_STRUCTURE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("data")) {
            return super.setProperty(name, value);
        }
        this.data = (ITEM_STRUCTURE)value;
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3076010: {
                throw new Error("Unable to make an instance of the abstract property 'data'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3076010: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on an abstract type ADMIN_ENTRY.data");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ADMIN_ENTRY";
    }

    @Override
    public ADMIN_ENTRY copy() {
        ADMIN_ENTRY dst = new ADMIN_ENTRY();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ADMIN_ENTRY dst) {
        super.copyValues(dst);
        dst.data = this.data == null ? null : this.data.copy();
    }

    protected ADMIN_ENTRY typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ADMIN_ENTRY)) {
            return false;
        }
        ADMIN_ENTRY o = (ADMIN_ENTRY)other_;
        return ADMIN_ENTRY.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ADMIN_ENTRY)) {
            return false;
        }
        ADMIN_ENTRY o = (ADMIN_ENTRY)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.data});
    }
}

