/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;

public class NamedElementExtension
extends Element {
    private static final long serialVersionUID = -3624826962424387196L;
    private final String elementName;
    private StructureDefinition definition;
    private Base value;

    public NamedElementExtension(String elementName) {
        this.elementName = elementName;
    }

    public NamedElementExtension(String elementName, Base value) {
        this.elementName = elementName;
        this.setValue(value);
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Base getValue() {
        return this.value;
    }

    public NamedElementExtension setValue(Base value) {
        this.value = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value[x]", "Base", "Value of extension", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "Base", "Value of extension", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("value[x]")) {
            return super.setProperty(name, value);
        }
        this.value = TypeConvertor.castToType(value);
        return value;
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"Base"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public String fhirType() {
        return "NamedElementExtension";
    }

    @Override
    public NamedElementExtension copy() {
        NamedElementExtension dst = new NamedElementExtension(this.elementName);
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(NamedElementExtension dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected NamedElementExtension typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof NamedElementExtension)) {
            return false;
        }
        NamedElementExtension o = (NamedElementExtension)other_;
        return NamedElementExtension.compareDeep(this.elementName, o.elementName, true) && NamedElementExtension.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof NamedElementExtension)) {
            return false;
        }
        NamedElementExtension o = (NamedElementExtension)other_;
        return NamedElementExtension.compareDeep(this.elementName, o.elementName, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value});
    }
}

