/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.parser.DataFormatException;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.r5.model.PrimitiveType;

@DatatypeDef(name="boolean")
public class BooleanType
extends PrimitiveType<Boolean>
implements IBaseBooleanDatatype {
    private static final long serialVersionUID = 3L;

    public BooleanType() {
    }

    public BooleanType(boolean theBoolean) {
        this.setValue((Object)theBoolean);
    }

    public BooleanType(Boolean theBoolean) {
        this.setValue(theBoolean);
    }

    public BooleanType(String value) {
        this.setValueAsString(value);
    }

    public boolean booleanValue() {
        return (Boolean)this.getValue();
    }

    @Override
    public BooleanType copy() {
        BooleanType ret = new BooleanType((Boolean)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    protected String encode(Boolean theValue) {
        if (Boolean.TRUE.equals(theValue)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String fhirType() {
        return "boolean";
    }

    @Override
    protected Boolean parse(String theValue) {
        String value = theValue.trim();
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new DataFormatException("Invalid boolean string: '" + theValue + "'");
    }

    @Override
    public boolean isBooleanPrimitive() {
        return true;
    }
}

