/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.ips;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.utils.client.FHIRToolingClient;
import org.hl7.fhir.utilities.UUIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtil;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class IPSBuilder {
    public static Bundle generateIPS(FHIRToolingClient server, String patientId) {
        Patient pat = server.fetchResource(Patient.class, patientId);
        Bundle bnd = IPSBuilder.initBundle();
        Composition cmp = IPSBuilder.initComposition(bnd, server.getAddress(), pat);
        pat = IPSBuilder.processPatient(bnd, server.getAddress(), pat);
        IPSBuilder.addConditions(bnd, cmp, server, patientId);
        return bnd;
    }

    private static Bundle initBundle() {
        Bundle bnd = new Bundle();
        bnd.getIdentifier().setSystem("urn:ietf:rfc:3986");
        bnd.getIdentifier().setValue(UUIDUtilities.makeUuidUrn());
        bnd.setType(Bundle.BundleType.DOCUMENT);
        bnd.setTimestamp(new Date());
        return bnd;
    }

    private static Composition initComposition(Bundle bnd, String url, Patient pat) {
        Composition cmp = new Composition();
        cmp.setIdBase(UUIDUtilities.makeUuidLC());
        cmp.setStatus(Enumerations.CompositionStatus.FINAL);
        cmp.getType().addCoding().setSystem("http://loinc.org").setCode("60591-5");
        cmp.setDate(new Date());
        cmp.setTitle("International Patient Summary");
        cmp.addSubject().setReference("Patient/" + pat.getIdBase());
        cmp.addAuthor().setReference("Device/java");
        bnd.addEntry().setResource(cmp).setFullUrl(Utilities.pathURL((String[])new String[]{url, "Composition", cmp.getIdBase()}));
        Device dev = new Device();
        dev.setId("java");
        dev.addName().setValue("Java Core Library");
        dev.addVersion().setValue(VersionUtil.getVersion());
        bnd.addEntry().setResource(dev).setFullUrl(Utilities.pathURL((String[])new String[]{url, "Device", dev.getIdBase()}));
        return cmp;
    }

    private static Patient processPatient(Bundle bnd, String url, Patient pat) {
        bnd.addEntry().setResource(pat).setFullUrl(Utilities.pathURL((String[])new String[]{url, "Patient", pat.getIdBase()}));
        return pat;
    }

    private static void addMedications(Bundle bnd, Composition cmp, FHIRToolingClient server, String patientId) {
        Bundle sb = server.search("MedicationStatement", "?patient=" + patientId + "&_include=MedicationStatement:medication&_include=MedicationStatement:source");
        Composition.SectionComponent sct = cmp.addSection();
        sct.setTitle("Medications");
        sct.getCode().addCoding().setSystem("http://loinc.org").setCode("10160-0");
        sct.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        XhtmlNode x = sct.getText().getDiv();
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode tr = tbl.tr();
        tr.th().tx("Medication");
        tr.th().tx("Category");
        tr.th().tx("Status");
        tr.th().tx("When");
        tr.th().tx("Dosage");
        tr.th().tx("Reason");
        tr.th().tx("Source");
        tr.th().tx("Notes");
        boolean ok = false;
        for (Bundle.BundleEntryComponent be : sb.getEntry()) {
            if (!be.hasResource() || !(be.getResource() instanceof MedicationStatement)) continue;
            MedicationStatement mdstmt = (MedicationStatement)be.getResource();
            ok = true;
            bnd.addEntry().setResource(mdstmt).setFullUrl(Utilities.pathURL((String[])new String[]{server.getAddress(), "MedicationStatement", mdstmt.getIdBase()}));
            sct.addEntry().setReference("MedicationStatement/" + mdstmt.getIdBase());
            tr = tbl.tr();
            if (mdstmt.hasMedication() && mdstmt.getMedication().hasReference()) {
                Medication med = IPSBuilder.findMedication(sb, server, mdstmt, mdstmt.getMedication().getReference());
                if (med == null) {
                    tr.td().b().tx("Unknown?");
                } else {
                    tr.td().tx(IPSBuilder.summarise(med));
                    bnd.addEntry().setResource(med).setFullUrl(Utilities.pathURL((String[])new String[]{server.getAddress(), "Medication", med.getIdBase()}));
                }
            } else {
                tr.td().tx(IPSBuilder.genCC(mdstmt.getMedication().getConcept()));
            }
            tr.td().tx(IPSBuilder.genCC(mdstmt.getCategory()));
            XhtmlNode td = tr.td();
            td.tx(mdstmt.getStatus().getDisplay());
            if (mdstmt.hasReason()) {
                td.tx(" (");
                for (CodeableReference cc : mdstmt.getReason()) {
                    if (cc.hasConcept()) {
                        td.tx(IPSBuilder.genCC(cc.getConcept()));
                        continue;
                    }
                    td.tx(IPSBuilder.genReference(mdstmt, cc.getReference(), bnd, sb, server));
                }
                td.tx(")");
            }
            tr.td().tx(IPSBuilder.genDT(mdstmt.getEffective()));
            IPSBuilder.genDosages(tr.td(), mdstmt.getDosage());
            for (Reference is : mdstmt.getInformationSource()) {
                tr.td().tx(IPSBuilder.genReference(mdstmt, is, bnd, sb, server));
            }
            IPSBuilder.genNotes(tr.td(), mdstmt.getNote());
        }
        if (!ok) {
            Condition cnd = new Condition();
            cnd.setId(UUIDUtilities.makeUuidLC());
            cnd.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
            XhtmlNode rx = cnd.getText().getDiv();
            rx.tx("No information is provided about the patient's medical problems");
            tr = tbl.tr();
            tr.td().colspan(7).tx("No information is provided about the patient's medical problems");
            cnd.getClinicalStatus().addCoding().setSystem("http://terminology.hl7.org/CodeSystem/condition-clinical").setCode("active").setDisplay("Active");
            cnd.getCode().addCoding().setSystem("http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips").setCode("no-problem-info").setDisplay("No information about current problems");
            cnd.getSubject().setReference("Patient/" + patientId);
        }
    }

    private static void genDosages(XhtmlNode x, List<Dosage> dosages) {
        if (dosages != null && dosages.size() != 0) {
            if (dosages.size() == 1) {
                IPSBuilder.genDosage(x, dosages.get(0));
            } else {
                XhtmlNode ul = x.ul();
                for (Dosage d : dosages) {
                    IPSBuilder.genDosage(ul.li(), d);
                }
            }
        }
    }

    private static void genDosage(XhtmlNode x, Dosage dosage) {
        x.tx(dosage.getText());
        if (dosage.hasAsNeeded() || dosage.hasAsNeededFor()) {
            x.nbsp();
            if (dosage.hasAsNeeded()) {
                if (dosage.getAsNeeded()) {
                    x.tx(" (as needed)");
                }
            } else {
                for (CodeableConcept cc : dosage.getAsNeededFor()) {
                    x.tx(IPSBuilder.genDT(cc));
                }
            }
        } else if (dosage.hasTiming()) {
            x.nbsp();
            x.tx(IPSBuilder.genDT(dosage.getTiming()));
        }
        if (dosage.hasSite()) {
            x.tx(". ");
            x.tx(IPSBuilder.genDT(dosage.getSite()));
        }
        if (dosage.hasRoute()) {
            x.tx(". ");
            x.tx(IPSBuilder.genDT(dosage.getRoute()));
        }
    }

    private static Medication findMedication(Bundle sb, FHIRToolingClient server, MedicationStatement mdstmt, Reference ref) {
        if (ref == null || !ref.hasReference()) {
            return null;
        }
        if (ref.getReference().startsWith("#")) {
            // empty if block
        }
        return null;
    }

    private static void addConditions(Bundle bnd, Composition cmp, FHIRToolingClient server, String patientId) {
        Bundle sb = server.search("Condition", "?patient=" + patientId + "&_include=Condition:asserter");
        Composition.SectionComponent sct = cmp.addSection();
        sct.setTitle("Problems");
        sct.getCode().addCoding().setSystem("http://loinc.org").setCode("11450-4");
        sct.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        XhtmlNode x = sct.getText().getDiv();
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode tr = tbl.tr();
        tr.th().tx("Code");
        tr.th().tx("Category");
        tr.th().tx("Severity");
        tr.th().tx("Status");
        tr.th().tx("Onset");
        tr.th().tx("Abatement");
        tr.th().tx("Source");
        tr.th().tx("Notes");
        boolean ok = false;
        for (Bundle.BundleEntryComponent be : sb.getEntry()) {
            if (!be.hasResource() || !(be.getResource() instanceof Condition)) continue;
            Condition cnd = (Condition)be.getResource();
            ok = true;
            bnd.addEntry().setResource(cnd).setFullUrl(Utilities.pathURL((String[])new String[]{server.getAddress(), "Condition", cnd.getIdBase()}));
            sct.addEntry().setReference("Condition/" + cnd.getIdBase());
            tr = tbl.tr();
            tr.td().tx(IPSBuilder.genCC(cnd.getCode()));
            tr.td().tx(IPSBuilder.genCC(cnd.getCategory()));
            tr.td().tx(IPSBuilder.genCC(cnd.getSeverity()));
            tr.td().tx(IPSBuilder.genStatus(cnd));
            tr.td().tx(IPSBuilder.genDT(cnd.getOnset()));
            tr.td().tx(IPSBuilder.genDT(cnd.getAbatement()));
            tr.td().tx(IPSBuilder.genSource(cnd, bnd, sb, server));
            IPSBuilder.genNotes(tr.td(), cnd.getNote());
        }
        if (!ok) {
            Condition cnd = new Condition();
            cnd.setId(UUIDUtilities.makeUuidLC());
            cnd.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
            XhtmlNode rx = cnd.getText().getDiv();
            rx.tx("No information is provided about the patient's medical problems");
            tr = tbl.tr();
            tr.td().colspan(7).tx("No information is provided about the patient's medical problems");
            cnd.getClinicalStatus().addCoding().setSystem("http://terminology.hl7.org/CodeSystem/condition-clinical").setCode("active").setDisplay("Active");
            cnd.getCode().addCoding().setSystem("http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips").setCode("no-problem-info").setDisplay("No information about current problems");
            cnd.getSubject().setReference("Patient/" + patientId);
        }
    }

    private static String genReference(DomainResource src, Reference ref, Bundle bnd, Bundle search, FHIRToolingClient server) {
        if (ref == null || ref.isEmpty()) {
            return null;
        }
        boolean contained = false;
        DomainResource tgt = null;
        if (ref.hasReference()) {
            if (ref.getReference().startsWith("#")) {
                tgt = (DomainResource)src.getContained(ref.getReference());
                contained = true;
            } else {
                TypeAndId tid = IPSBuilder.getTypeAndId(server.getAddress(), ref.getReference());
                if (tid != null) {
                    tgt = IPSBuilder.findInBundle(bnd, Utilities.pathURL((String[])new String[]{server.getAddress(), tid.getType(), tid.getId()}));
                    if (tgt == null) {
                        tgt = IPSBuilder.findInBundle(search, Utilities.pathURL((String[])new String[]{server.getAddress(), tid.getType(), tid.getId()}));
                        if (tgt == null) {
                            tgt = (DomainResource)server.read(tid.getType(), tid.getId());
                        }
                    } else {
                        contained = true;
                    }
                }
            }
        }
        if (tgt != null) {
            if (!contained) {
                bnd.addEntry().setResource(tgt).setFullUrl(Utilities.pathURL((String[])new String[]{server.getAddress(), tgt.fhirType(), tgt.getIdBase()}));
            }
            return IPSBuilder.summarise(tgt);
        }
        if (ref.hasDisplay()) {
            return ref.getDisplay();
        }
        if (ref.hasReference()) {
            return ref.getReference();
        }
        if (ref.hasIdentifier()) {
            return IPSBuilder.genIdentifier(ref.getIdentifier());
        }
        return "unknown";
    }

    private static TypeAndId getTypeAndId(String baseUrl, String url) {
        String[] p;
        if (Utilities.noString((String)url)) {
            return null;
        }
        if (url.startsWith(baseUrl + "/")) {
            url = url.substring(baseUrl.length() + 1);
        }
        if ((p = url.split("\\/")).length > 1) {
            if ("_history".equals(p[p.length - 2]) && p.length > 3) {
                return new TypeAndId(p[p.length - 4], p[p.length - 3]);
            }
            return new TypeAndId(p[p.length - 2], p[p.length - 1]);
        }
        return null;
    }

    private static DomainResource findInBundle(Bundle bnd, String url) {
        for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
            if (!url.equals(be.getFullUrl()) || !be.hasResource() || !(be.getResource() instanceof DomainResource)) continue;
            return (DomainResource)be.getResource();
        }
        return null;
    }

    private static String summarise(DomainResource tgt) {
        return null;
    }

    private static String genIdentifier(Identifier id) {
        return id.getValue();
    }

    private static void genNotes(XhtmlNode td, List<Annotation> notes) {
        if (notes.size() > 0) {
            if (notes.size() == 1) {
                IPSBuilder.genNote(td, notes.get(0));
            } else {
                XhtmlNode ul = td.ul();
                for (Annotation a : notes) {
                    IPSBuilder.genNote(ul.li(), a);
                }
            }
        }
    }

    private static void genNote(XhtmlNode td, Annotation annotation) {
        td.tx(annotation.getText());
    }

    private static String genSource(Condition cnd, Bundle bnd, Bundle sb, FHIRToolingClient server) {
        Iterator<Condition.ConditionParticipantComponent> iterator = cnd.getParticipant().iterator();
        if (iterator.hasNext()) {
            Condition.ConditionParticipantComponent t = iterator.next();
            return IPSBuilder.genCC(t.getFunction()) + " : " + IPSBuilder.genReference(cnd, t.getActor(), bnd, sb, server);
        }
        return "";
    }

    private static String genDT(DataType v) {
        if (v == null) {
            return null;
        }
        if (v.isPrimitive()) {
            return v.primitiveValue();
        }
        if (v instanceof Age) {
            return IPSBuilder.genQty((Age)v);
        }
        if (v instanceof Period) {
            Period p = (Period)v;
            return IPSBuilder.genDT(p.getStartElement()) + " - " + IPSBuilder.genDT(p.getStartElement());
        }
        if (v instanceof Range) {
            Range p = (Range)v;
            return IPSBuilder.genDT(p.getLow()) + " - " + IPSBuilder.genDT(p.getHigh());
        }
        return "not done: " + v.fhirType();
    }

    private static String genQty(Quantity v) {
        return v.getValue().toPlainString() + v.getUnit();
    }

    private static String genStatus(Condition cnd) {
        if (cnd.hasClinicalStatus() && cnd.hasVerificationStatus()) {
            return IPSBuilder.genCC(cnd.getClinicalStatus()) + "/" + IPSBuilder.genCC(cnd.getVerificationStatus());
        }
        if (cnd.hasClinicalStatus()) {
            return IPSBuilder.genCC(cnd.getClinicalStatus());
        }
        if (cnd.hasVerificationStatus()) {
            return IPSBuilder.genCC(cnd.getVerificationStatus());
        }
        return null;
    }

    private static String genCC(List<CodeableConcept> list) {
        if (list != null && list.size() == 1) {
            return IPSBuilder.genCC(list.get(0));
        }
        return null;
    }

    private static String genCC(CodeableConcept code) {
        if (code.hasText()) {
            return code.getText();
        }
        if (code.hasCoding()) {
            Coding c = code.getCodingFirstRep();
            if (c.hasDisplay()) {
                return c.getDisplay();
            }
            return c.getCode();
        }
        return null;
    }

    public static class TypeAndId {
        private String type;
        private String id;

        protected TypeAndId(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }
}

