/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Resource;

public interface IParser {
    public ParserType getType();

    public boolean getHandleComments();

    public IParser setHandleComments(boolean var1);

    public boolean isAllowUnknownContent();

    public IParser setAllowUnknownContent(boolean var1);

    public OutputStyle getOutputStyle();

    public IParser setOutputStyle(OutputStyle var1);

    public IParser setSuppressXhtml(String var1);

    public Resource parse(InputStream var1) throws IOException, FHIRFormatError;

    public Resource parseAndClose(InputStream var1) throws IOException, FHIRFormatError;

    public Resource parse(String var1) throws UnsupportedEncodingException, FHIRFormatError, IOException;

    public Resource parse(byte[] var1) throws FHIRFormatError, IOException;

    public DataType parseType(InputStream var1, String var2) throws IOException, FHIRFormatError;

    public DataType parseAnyType(InputStream var1, String var2) throws IOException, FHIRFormatError;

    public DataType parseType(String var1, String var2) throws UnsupportedEncodingException, FHIRFormatError, IOException;

    public DataType parseType(byte[] var1, String var2) throws FHIRFormatError, IOException;

    public void compose(OutputStream var1, Resource var2) throws IOException;

    public String composeString(Resource var1) throws IOException;

    public byte[] composeBytes(Resource var1) throws IOException;

    public void compose(OutputStream var1, DataType var2, String var3) throws IOException;

    public String composeString(DataType var1, String var2) throws IOException;

    public byte[] composeBytes(DataType var1, String var2) throws IOException;

    public static enum OutputStyle {
        NORMAL,
        PRETTY,
        CANONICAL;

    }
}

