/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class Property {
    private IWorkerContext context;
    private ElementDefinition definition;
    private StructureDefinition structure;
    private ProfileUtilities profileUtilities;
    private ContextUtilities utils;
    private ElementDefinition.TypeRefComponent type;

    public Property(IWorkerContext context, ElementDefinition definition, StructureDefinition structure, ProfileUtilities profileUtilities, ContextUtilities utils) {
        this.context = context;
        this.definition = definition;
        this.structure = structure;
        this.utils = utils;
        this.profileUtilities = profileUtilities;
    }

    public Property(IWorkerContext context, ElementDefinition definition, StructureDefinition structure, ProfileUtilities profileUtilities, ContextUtilities utils, String type) {
        this.context = context;
        this.definition = definition;
        this.structure = structure;
        this.profileUtilities = profileUtilities;
        this.utils = utils;
        for (ElementDefinition.TypeRefComponent tr : definition.getType()) {
            if (!tr.getWorkingCode().equals(type)) continue;
            this.type = tr;
        }
    }

    public Property(IWorkerContext context, ElementDefinition definition, StructureDefinition structure) {
        this(context, definition, structure, new ProfileUtilities(context, null, null), new ContextUtilities(context));
    }

    public String getName() {
        return this.definition.getPath().substring(this.definition.getPath().lastIndexOf(".") + 1);
    }

    public String getJsonName() {
        if (this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-name", "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name")) {
            return ToolingExtensions.readStringExtension((Element)this.definition, "http://hl7.org/fhir/tools/StructureDefinition/json-name", "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name");
        }
        return this.getName();
    }

    public String getXmlName() {
        if (this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/xml-name")) {
            return ToolingExtensions.readStringExtension((Element)this.definition, "http://hl7.org/fhir/tools/StructureDefinition/xml-name");
        }
        if (this.definition.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name")) {
            return ToolingExtensions.readStringExtension((Element)this.definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name");
        }
        return this.getName();
    }

    public String getXmlNamespace() {
        if (ToolingExtensions.hasAnyOfExtensions(this.definition, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
            return ToolingExtensions.readStringExtension((Element)this.definition, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        if (ToolingExtensions.hasAnyOfExtensions(this.structure, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
            return ToolingExtensions.readStringExtension((DomainResource)this.structure, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        return "http://hl7.org/fhir";
    }

    public ElementDefinition getDefinition() {
        return this.definition;
    }

    public String getType() {
        if (this.type != null) {
            return this.type.getWorkingCode();
        }
        if (this.definition.getType().size() == 0) {
            return null;
        }
        if (this.definition.getType().size() > 1) {
            String tn = this.definition.getType().get(0).getWorkingCode();
            for (int i = 1; i < this.definition.getType().size(); ++i) {
                if (tn.equals(this.definition.getType().get(i).getWorkingCode())) continue;
                return null;
            }
            return tn;
        }
        return this.definition.getType().get(0).getWorkingCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getType(String elementName) {
        if (this.type != null) {
            return this.type.getWorkingCode();
        }
        if (!this.definition.getPath().contains(".")) {
            return this.definition.getPath();
        }
        ElementDefinition ed = this.definition;
        if (this.definition.hasContentReference()) {
            Object sd;
            String url = null;
            String path = this.definition.getContentReference();
            if (!path.startsWith("#")) {
                if (!path.contains("#")) throw new Error("Illegal content reference '" + path + "'");
                url = path.substring(0, path.indexOf("#"));
                path = path.substring(path.indexOf("#") + 1);
            } else {
                path = path.substring(1);
            }
            Object object = sd = url == null || url.equals(this.structure.getUrl()) ? this.structure : this.context.fetchResource(StructureDefinition.class, url, this.structure);
            if (sd == null) {
                throw new Error("Unknown Type in content reference '" + path + "'");
            }
            boolean found = false;
            for (ElementDefinition d : ((StructureDefinition)sd).getSnapshot().getElement()) {
                if (!d.hasId() || !d.getId().equals(path)) continue;
                found = true;
                ed = d;
            }
            if (!found) {
                throw new Error("Unable to resolve " + this.definition.getContentReference() + " at " + this.definition.getPath() + " on " + ((StructureDefinition)sd).getUrl());
            }
        }
        if (ed.getType().size() == 0) {
            return null;
        }
        if (ed.getType().size() > 1) {
            String t = ed.getType().get(0).getCode();
            boolean all = true;
            for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                if (t.equals(tr.getCode())) continue;
                all = false;
            }
            if (all) {
                return t;
            }
            String tail = ed.getPath().substring(ed.getPath().lastIndexOf(".") + 1);
            if (tail.endsWith("[x]") && elementName != null && elementName.startsWith(tail.substring(0, tail.length() - 3))) {
                String name = elementName.substring(tail.length() - 3);
                return this.isPrimitive(this.lowFirst(name)) ? this.lowFirst(name) : name;
            }
            if (!ToolingExtensions.hasExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype")) throw new Error("logic error, gettype when types > 1, name mismatch for " + elementName + " on at " + ed.getPath());
            return ToolingExtensions.readStringExtension((Element)ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype");
        }
        if (ed.getType().get(0).getCode() != null) return ed.getType().get(0).getWorkingCode();
        if (!Utilities.existsInList((String)ed.getId(), (String[])new String[]{"Element.id", "Extension.url"})) return this.structure.getId();
        return "string";
    }

    public boolean typeIsConsistent(String typeName) {
        for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
            if (!typeName.equals(tr.getWorkingCode()) && !this.typeSpecializes(tr.getWorkingCode(), typeName)) continue;
            return true;
        }
        return false;
    }

    private boolean typeSpecializes(String workingCode, String typeName) {
        if ("string".equals(typeName)) {
            return Utilities.existsInList((String)workingCode, (String[])new String[]{"uri", "oid", "canonical", "url", "uuid", "id", "markdown"});
        }
        if ("integer".equals(typeName)) {
            return Utilities.existsInList((String)workingCode, (String[])new String[]{"positiveInt", "unsignedInt"});
        }
        return false;
    }

    public boolean hasType(String typeName) {
        if (this.type != null) {
            return false;
        }
        if (this.definition.getType().size() == 0) {
            return false;
        }
        if (this.isJsonPrimitiveChoice()) {
            for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
                if (!typeName.equals(tr.getWorkingCode())) continue;
                return true;
            }
            return false;
        }
        if (this.definition.getType().size() > 1) {
            String t = this.definition.getType().get(0).getCode();
            boolean all = true;
            for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
                if (t.equals(tr.getCode())) continue;
                all = false;
            }
            if (all) {
                return true;
            }
            String tail = this.definition.getPath().substring(this.definition.getPath().lastIndexOf(".") + 1);
            return tail.endsWith("[x]") && typeName.startsWith(tail.substring(0, tail.length() - 3));
        }
        return true;
    }

    public StructureDefinition getStructure() {
        return this.structure;
    }

    public boolean isPrimitiveName(String name) {
        String code = this.getType(name);
        return this.isPrimitive(code);
    }

    public boolean isPrimitive(String code) {
        return this.context.isPrimitiveType(code);
    }

    public boolean isPrimitive() {
        return this.isPrimitive(this.getType());
    }

    private String lowFirst(String t) {
        return t.substring(0, 1).toLowerCase() + t.substring(1);
    }

    public boolean isResource() {
        if (this.type != null) {
            String tc = this.type.getCode();
            return "Resource".equals(tc) || "DomainResource".equals(tc) || this.utils.isResource(tc);
        }
        if (this.definition.getType().size() > 0) {
            String tc = this.definition.getType().get(0).getCode();
            return this.definition.getType().size() == 1 && ("Resource".equals(tc) || "DomainResource".equals(tc) || this.utils.isResource(tc));
        }
        return !this.definition.getPath().contains(".") && this.structure.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    public boolean isList() {
        return !"1".equals(this.definition.getBase().hasMax() ? this.definition.getBase().getMax() : this.definition.getMax());
    }

    public boolean isJsonList() {
        if (this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-name", "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name")) {
            return !"1".equals(this.definition.getMax());
        }
        return !"1".equals(this.definition.getBase().hasMax() ? this.definition.getBase().getMax() : this.definition.getMax());
    }

    public boolean isBaseList() {
        return !"1".equals(this.definition.getBase().getMax());
    }

    public String getScopedPropertyName() {
        return this.definition.getBase().getPath();
    }

    private boolean isElementWithOnlyExtension(ElementDefinition ed, List<ElementDefinition> children) {
        boolean result = false;
        if (!ed.getType().isEmpty()) {
            result = true;
            for (ElementDefinition ele : children) {
                if (ele.getPath().contains("extension")) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean IsLogicalAndHasPrimitiveValue(String name) {
        if (this.structure.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return false;
        }
        if (!this.hasType(name)) {
            return false;
        }
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, this.structure.getUrl().substring(0, this.structure.getUrl().lastIndexOf("/") + 1) + this.getType(name));
        if (sd == null) {
            sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(this.getType(name), null));
        }
        if (sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
            return true;
        }
        if (sd == null || sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return false;
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals(sd.getId() + ".value") || ed.getType().size() != 1 || !this.isPrimitive(ed.getType().get(0).getCode())) continue;
            return true;
        }
        return false;
    }

    public boolean isChoice() {
        if (this.type != null) {
            return true;
        }
        if (this.definition.getType().size() <= 1) {
            return false;
        }
        String tn = this.definition.getType().get(0).getCode();
        for (int i = 1; i < this.definition.getType().size(); ++i) {
            if (this.definition.getType().get(i).getCode().equals(tn)) continue;
            return true;
        }
        return false;
    }

    public List<Property> getChildProperties(String elementName, String statedType) throws FHIRException {
        String cacheKey = this.structure.getVUrl() + "#" + this.definition.getPath() + ":" + elementName + "/" + statedType;
        List<Property> cached = this.profileUtilities.getCachedPropertyList().get(cacheKey);
        if (cached != null) {
            return cached;
        }
        ElementDefinition ed = this.definition;
        StructureDefinition sd = this.structure;
        boolean isCDA = this.isCDAElement(this.structure);
        ProfileUtilities.SourcedChildDefinitions children = this.profileUtilities.getChildMap(sd, ed, false);
        String url = null;
        if (children.getList().isEmpty() || this.isElementWithOnlyExtension(ed, children.getList())) {
            String t = null;
            if (!(ed.getType().size() != 1 || statedType != null && isCDA)) {
                t = ed.getType().get(0).getWorkingCode();
            } else {
                if (ed.getType().size() == 0) {
                    throw new Error("types == 0, and no children found on " + this.getDefinition().getPath());
                }
                t = ed.getType().get(0).getWorkingCode();
                boolean all = true;
                for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                    if (tr.getWorkingCode().equals(t)) continue;
                    all = false;
                    break;
                }
                if (!all || isCDA && statedType != null) {
                    if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR) || isCDA) {
                        t = statedType;
                        if (t == null && ToolingExtensions.hasExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype")) {
                            t = ToolingExtensions.readStringExtension((Element)ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype");
                        }
                        boolean ok = false;
                        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                            if (tr.getWorkingCode().equals(t)) {
                                ok = true;
                            }
                            if (Utilities.isAbsoluteUrl((String)tr.getWorkingCode())) {
                                StructureDefinition sdt = this.context.fetchResource(StructureDefinition.class, tr.getWorkingCode());
                                if (sdt != null && sdt.getTypeTail().equals(t)) {
                                    url = tr.getWorkingCode();
                                    ok = true;
                                }
                                if (!ok && (sdt = this.findAncestor(t, sdt)) != null) {
                                    url = sdt.getUrl();
                                    ok = true;
                                }
                            }
                            if (!ok) continue;
                            break;
                        }
                        if (!ok) {
                            throw new DefinitionException("Type '" + t + "' is not an acceptable type for '" + elementName + "' on property " + this.definition.getPath());
                        }
                    } else {
                        t = elementName.substring(this.tail(ed.getPath()).length() - 3);
                        if (this.isPrimitive(this.lowFirst(t))) {
                            t = this.lowFirst(t);
                        }
                    }
                }
            }
            if (!"xhtml".equals(t)) {
                for (ElementDefinition.TypeRefComponent aType : ed.getType()) {
                    if (!aType.getWorkingCode().equals(t)) continue;
                    if (aType.hasProfile()) {
                        assert (aType.getProfile().size() == 1);
                        url = (String)aType.getProfile().get(0).getValue();
                        break;
                    }
                    url = ProfileUtilities.sdNs(t, null);
                    break;
                }
                if (url == null) {
                    throw new FHIRException("Unable to find type " + t + " for element " + elementName + " with path " + ed.getPath());
                }
                sd = this.context.fetchResource(StructureDefinition.class, url);
                if (sd == null) {
                    throw new DefinitionException("Unable to find definition '" + url + "' for type '" + t + "' for name '" + elementName + "' on property " + this.definition.getPath());
                }
                children = this.profileUtilities.getChildMap(sd, sd.getSnapshot().getElement().get(0), false);
            }
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (ElementDefinition child : children.getList()) {
            properties.add(new Property(this.context, child, sd, this.profileUtilities, this.utils));
        }
        this.profileUtilities.getCachedPropertyList().put(cacheKey, properties);
        return properties;
    }

    private StructureDefinition findAncestor(String type, StructureDefinition sdt) {
        if (sdt != null) {
            StructureDefinition sd;
            StructureDefinition t = sd = this.context.fetchTypeDefinition(type);
            while (t != null) {
                if (t == sdt) {
                    return sd;
                }
                t = this.context.fetchResource(StructureDefinition.class, t.getBaseDefinition());
            }
        }
        return null;
    }

    private boolean isCDAElement(StructureDefinition sd) {
        return sd.hasUrl() && sd.getUrl().startsWith("http://hl7.org/cda/stds/core");
    }

    protected List<Property> getChildProperties(TypeDetails type) throws DefinitionException {
        StructureDefinition sd = this.structure;
        ElementDefinition ed = this.definition;
        ProfileUtilities.SourcedChildDefinitions children = this.profileUtilities.getChildMap(sd, ed, false);
        if (children.getList().isEmpty()) {
            String t = null;
            if (ed.getType().size() == 1) {
                t = ed.getType().get(0).getCode();
            } else {
                if (ed.getType().size() == 0) {
                    throw new Error("types == 0, and no children found");
                }
                t = ed.getType().get(0).getCode();
                boolean all = true;
                for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                    if (tr.getCode().equals(t)) continue;
                    all = false;
                    break;
                }
                if (!all) {
                    t = type.getType();
                }
            }
            if (!"xhtml".equals(t)) {
                sd = this.context.fetchResource(StructureDefinition.class, t);
                if (sd == null) {
                    throw new DefinitionException("Unable to find class '" + t + "' for name '" + ed.getPath() + "' on property " + this.definition.getPath());
                }
                children = this.profileUtilities.getChildMap(sd, sd.getSnapshot().getElement().get(0), false);
            }
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (ElementDefinition child : children.getList()) {
            properties.add(new Property(this.context, child, sd, this.profileUtilities, this.utils));
        }
        return properties;
    }

    private String tail(String path) {
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1) : path;
    }

    public Property getChild(String elementName, String childName) throws FHIRException {
        List<Property> children = this.getChildProperties(elementName, null);
        for (Property p : children) {
            if (!p.getName().equals(childName)) continue;
            return p;
        }
        return null;
    }

    public Property getChild(String name, TypeDetails type) throws DefinitionException {
        List<Property> children = this.getChildProperties(type);
        for (Property p : children) {
            if (!p.getName().equals(name) && !p.getName().equals(name + "[x]")) continue;
            return p;
        }
        return null;
    }

    public Property getChild(String name) throws FHIRException {
        List<Property> children = this.getChildProperties(name, null);
        for (Property p : children) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Property getChildSimpleName(String elementName, String name) throws FHIRException {
        List<Property> children = this.getChildProperties(elementName, null);
        for (Property p : children) {
            if (!p.getName().equals(name) && !p.getName().equals(name + "[x]")) continue;
            return p;
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public String toString() {
        return this.definition.getPath();
    }

    public boolean isJsonKeyArray() {
        return this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-property-key");
    }

    public String getJsonKeyProperty() {
        return ToolingExtensions.readStringExtension((Element)this.definition, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key");
    }

    public boolean hasTypeSpecifier() {
        return this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-specifier");
    }

    public List<StringPair> getTypeSpecifiers() {
        ArrayList<StringPair> res = new ArrayList<StringPair>();
        for (Extension e : this.definition.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
            res.add(new StringPair(ToolingExtensions.readStringExtension((Element)e, "condition"), ToolingExtensions.readStringExtension((Element)e, "type")));
        }
        return res;
    }

    public Property cloneToType(StructureDefinition sd) {
        Property res = new Property(this.context, this.definition.copy(), sd);
        res.definition.getType().clear();
        res.definition.getType().add(new ElementDefinition.TypeRefComponent(sd.getUrl()));
        return res;
    }

    public boolean hasImpliedPrefix() {
        return this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix");
    }

    public String getImpliedPrefix() {
        return ToolingExtensions.readStringExtension((Element)this.definition, "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix");
    }

    public boolean isNullable() {
        return ToolingExtensions.readBoolExtension(this.definition, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable");
    }

    public String summary() {
        return this.structure.getUrl() + "#" + this.definition.getId();
    }

    public boolean canBeEmpty() {
        if (this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior")) {
            return !"absent".equals(ToolingExtensions.readStringExtension((Element)this.definition, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior"));
        }
        return false;
    }

    public boolean isLogical() {
        return this.structure.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL;
    }

    public ProfileUtilities getUtils() {
        return this.profileUtilities;
    }

    public ContextUtilities getContextUtils() {
        return this.utils;
    }

    public boolean isJsonPrimitiveChoice() {
        return ToolingExtensions.readBoolExtension(this.definition, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice");
    }

    public Object typeSummary() {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" | ");
        for (ElementDefinition.TypeRefComponent t : this.definition.getType()) {
            b.append(t.getCode());
        }
        return b.toString();
    }

    public boolean hasJsonName() {
        return this.definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-name", "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name");
    }

    public boolean isTranslatable() {
        boolean ok = ToolingExtensions.readBoolExtension(this.definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable");
        if (!(ok || this.definition.getPath().endsWith(".id") || this.definition.getPath().endsWith(".linkId") || Utilities.existsInList((String)this.definition.getBase().getPath(), (String[])new String[]{"Resource.id", "Reference.reference", "Coding.version", "Identifier.value", "SampledData.offsets", "SampledData.data", "ContactPoint.value"}))) {
            String t = this.getType();
            ok = Utilities.existsInList((String)t, (String[])new String[]{"string", "markdown"});
        }
        if (Utilities.existsInList((String)this.pathForElement(this.getStructure().getType(), this.getDefinition().getBase().getPath()), (String[])new String[]{"CanonicalResource.version"})) {
            return false;
        }
        return ok;
    }

    private String pathForElement(String type, String path) {
        if (this.utils.getCanonicalResourceNames().contains(type)) {
            String fp = path.replace(type + ".", "CanonicalResource.");
            if (Utilities.existsInList((String)fp, (String[])new String[]{"CanonicalResource.url", "CanonicalResource.identifier", "CanonicalResource.version", "CanonicalResource.name", "CanonicalResource.title", "CanonicalResource.status", "CanonicalResource.experimental", "CanonicalResource.date", "CanonicalResource.publisher", "CanonicalResource.contact", "CanonicalResource.description", "CanonicalResource.useContext", "CanonicalResource.jurisdiction"})) {
                return fp;
            }
        }
        return path;
    }

    public String getXmlTypeName() {
        ElementDefinition.TypeRefComponent tr = this.type;
        if (tr == null) {
            tr = this.definition.getTypeFirstRep();
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(tr.getWorkingCode());
        return sd.getSnapshot().getElementFirstRep().getPath();
    }

    public boolean isReference() {
        if (this.type != null) {
            return this.isRef(this.type);
        }
        for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
            boolean ref = this.isRef(tr);
            if (!ref) continue;
            return true;
        }
        return false;
    }

    private boolean isRef(ElementDefinition.TypeRefComponent tr) {
        return Utilities.existsInList((String)tr.getWorkingCode(), (String[])new String[]{"Reference", "url", "uri", "canonical"});
    }

    public boolean canBeType(String type) {
        for (ElementDefinition.TypeRefComponent tr : this.getDefinition().getType()) {
            if (!type.equals(tr.getWorkingCode())) continue;
            return true;
        }
        return false;
    }
}

