/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.AcceptLanguageHeader;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class LanguageUtils {
    private static final Logger log = LoggerFactory.getLogger(LanguageUtils.class);
    public static final List<String> TRANSLATION_SUPPLEMENT_RESOURCE_TYPES = Arrays.asList("CodeSystem", "StructureDefinition", "Questionnaire");
    IWorkerContext context;
    private List<String> crlist;

    public LanguageUtils(IWorkerContext context) {
        this.context = context;
    }

    public void generateTranslations(Element resource, LanguageFileProducer.LanguageProducerLanguageSession session) {
        this.translate(null, resource, session, resource.fhirType());
    }

    private void translate(Element parent, Element element, LanguageFileProducer.LanguageProducerLanguageSession langSession, String path) {
        String base;
        String npath = this.pathForElement(path, element);
        if (element.isPrimitive() && this.isTranslatable(element) && (base = element.primitiveValue()) != null) {
            String translation = this.getSpecialTranslation(path, parent, element, langSession.getTargetLang());
            if (translation == null) {
                translation = element.getTranslation(langSession.getTargetLang());
            }
            langSession.entry(new LanguageFileProducer.TextUnit(npath, this.contextForElement(element), base, translation));
        }
        for (Element c : element.getChildren()) {
            if (c.getName().equals("designation")) continue;
            this.translate(element, c, langSession, npath);
        }
    }

    private String contextForElement(Element element) {
        throw new Error("Not done yet");
    }

    private String getSpecialTranslation(String path, Element parent, Element element, String targetLang) {
        if (parent == null) {
            return null;
        }
        String npath = parent.getBasePath();
        if (Utilities.existsInList((String)npath, (String[])new String[]{"CodeSystem.concept", "CodeSystem.concept.concept"}) && "CodeSystem.concept.display".equals(element.getBasePath())) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        if (Utilities.existsInList((String)npath, (String[])new String[]{"ValueSet.compose.include.concept"}) && "ValueSet.compose.include.concept.display".equals(element.getBasePath())) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        if (Utilities.existsInList((String)npath, (String[])new String[]{"ValueSet.expansion.contains", "ValueSet.expansion.contains.contains"}) && "ValueSet.expansion.contains.display".equals(element.getBasePath())) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        return null;
    }

    private String getDesignationTranslation(Element parent, String targetLang) {
        for (Element e : parent.getChildren("designation")) {
            String lang = e.getNamedChildValue("language");
            if (!LanguageUtils.langsMatch(targetLang, lang)) continue;
            return e.getNamedChildValue("value");
        }
        return null;
    }

    private boolean isTranslatable(Element element) {
        return element.getProperty().isTranslatable();
    }

    private String pathForElement(String path, Element element) {
        if (element.getSpecial() != null) {
            String bp = element.getBasePath();
            return this.pathForElement(bp, element.getProperty().getStructure().getType());
        }
        return path == null ? element.getName() : path + "." + element.getName();
    }

    private String pathForElement(String path, String type) {
        if (this.crlist == null) {
            this.crlist = new ContextUtilities(this.context).getCanonicalResourceNames();
        }
        if (this.crlist.contains(type)) {
            String fp = path.replace(type + ".", "CanonicalResource.");
            if (Utilities.existsInList((String)fp, (String[])new String[]{"CanonicalResource.url", "CanonicalResource.identifier", "CanonicalResource.version", "CanonicalResource.name", "CanonicalResource.title", "CanonicalResource.status", "CanonicalResource.experimental", "CanonicalResource.date", "CanonicalResource.publisher", "CanonicalResource.contact", "CanonicalResource.description", "CanonicalResource.useContext", "CanonicalResource.jurisdiction"})) {
                return fp;
            }
        }
        return path;
    }

    public int importFromTranslations(Element resource, List<LanguageFileProducer.TranslationUnit> translations) {
        return this.importFromTranslations(resource.fhirType(), null, resource, translations, new HashSet<LanguageFileProducer.TranslationUnit>());
    }

    public int importFromTranslations(Element resource, List<LanguageFileProducer.TranslationUnit> translations, List<ValidationMessage> messages) {
        HashSet<LanguageFileProducer.TranslationUnit> usedUnits = new HashSet<LanguageFileProducer.TranslationUnit>();
        int r = 0;
        r = resource.fhirType().equals("StructureDefinition") ? this.importFromTranslationsForSD(null, resource, translations, usedUnits) : this.importFromTranslations(null, null, resource, translations, usedUnits);
        for (LanguageFileProducer.TranslationUnit t : translations) {
            if (usedUnits.contains(t) || messages == null) continue;
            messages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.INFORMATIONAL, t.getId(), "Unused '" + t.getLanguage() + "' translation '" + t.getSrcText() + "' -> '" + t.getTgtText() + "'", ValidationMessage.IssueSeverity.INFORMATION));
        }
        return r;
    }

    public int importFromTranslations(Resource resource, List<LanguageFileProducer.TranslationUnit> translations, List<ValidationMessage> messages) {
        HashSet<LanguageFileProducer.TranslationUnit> usedUnits = new HashSet<LanguageFileProducer.TranslationUnit>();
        int r = 0;
        if (!resource.fhirType().equals("StructureDefinition")) {
            r = this.importResourceFromTranslations(null, resource, translations, usedUnits, resource.fhirType());
        }
        for (LanguageFileProducer.TranslationUnit t : translations) {
            if (usedUnits.contains(t) || messages == null) continue;
            messages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.INFORMATIONAL, t.getId(), "Unused '" + t.getLanguage() + "' translation '" + t.getSrcText() + "' -> '" + t.getTgtText() + "'", ValidationMessage.IssueSeverity.INFORMATION));
        }
        return r;
    }

    private int importFromTranslationsForSD(Object object, Element resource, List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits) {
        int r = 0;
        r += this.checkForTranslations(translations, usedUnits, resource, "StructureDefinition.name", "name");
        r += this.checkForTranslations(translations, usedUnits, resource, "StructureDefinition.title", "title");
        r += this.checkForTranslations(translations, usedUnits, resource, "StructureDefinition.publisher", "publisher");
        for (Element cd : resource.getChildrenByName("contact")) {
            r += this.checkForTranslations(translations, usedUnits, cd, "StructureDefinition.contact.name", "name");
        }
        r += this.checkForTranslations(translations, usedUnits, resource, "StructureDefinition.purpose", "purpose");
        r += this.checkForTranslations(translations, usedUnits, resource, "StructureDefinition.copyright", "copyright");
        Element diff = resource.getNamedChild("differential");
        if (diff != null) {
            for (Element ed : diff.getChildrenByName("element")) {
                String id = ed.getNamedChildValue("id");
                r += this.checkForTranslations(translations, usedUnits, ed, "StructureDefinition.element." + id + "/label", "label");
                r += this.checkForTranslations(translations, usedUnits, ed, "StructureDefinition.element." + id + "/short", "short");
                r += this.checkForTranslations(translations, usedUnits, ed, "StructureDefinition.element." + id + "/definition", "definition");
                r += this.checkForTranslations(translations, usedUnits, ed, "StructureDefinition.element." + id + "/comment", "comment");
                r += this.checkForTranslations(translations, usedUnits, ed, "StructureDefinition.element." + id + "/requirements", "requirements");
                r += this.checkForTranslations(translations, usedUnits, ed, "StructureDefinition.element." + id + "/meaningWhenMissing", "meaningWhenMissing");
                r += this.checkForTranslations(translations, usedUnits, ed, "StructureDefinition.element." + id + "/orderMeaning", "orderMeaning");
            }
        }
        return r;
    }

    private int checkForTranslations(List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits, Element context, String tname, String pname) {
        String v;
        int r = 0;
        Element child = context.getNamedChild(pname);
        if (child != null && (v = child.primitiveValue()) != null) {
            for (LanguageFileProducer.TranslationUnit tu : translations) {
                if (!tname.equals(tu.getId()) || !v.equals(tu.getSrcText())) continue;
                usedUnits.add(tu);
                child.setTranslation(tu.getLanguage(), tu.getTgtText());
                ++r;
            }
        }
        return r;
    }

    private int importResourceFromTranslations(Base parent, Base element, List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits, String path) {
        int t = 0;
        if (element.isPrimitive() && this.isTranslatable(element, path) && element instanceof org.hl7.fhir.r5.model.Element) {
            org.hl7.fhir.r5.model.Element e = (org.hl7.fhir.r5.model.Element)element;
            String base = element.primitiveValue();
            if (base != null) {
                String epath = this.pathForElement(path, element.fhirType());
                Set<LanguageFileProducer.TranslationUnit> tlist = this.findTranslations(epath, base, translations);
                for (LanguageFileProducer.TranslationUnit translation : tlist) {
                    ++t;
                    if (this.handleAsSpecial(parent, element, translation)) continue;
                    usedUnits.add(translation);
                    if (translation.getTgtText() != null) {
                        ToolingExtensions.setLanguageTranslation(e, translation.getLanguage(), translation.getTgtText());
                        continue;
                    }
                    log.warn("?");
                }
            }
        }
        for (Property c : element.children()) {
            for (Base v : c.getValues()) {
                if (c.getName().equals("designation") || this.isTranslation(v)) continue;
                t += this.importResourceFromTranslations(element, v, translations, usedUnits, this.genPath(c, v, path, c.getName()));
            }
        }
        return t;
    }

    private String genPath(Property c, Base v, String path, String name) {
        if ("ImplementationGuide.definition.page".equals(path) && "page".equals(name)) {
            return path;
        }
        if ("ValueSet.expansion.contains".equals(path) && "contains".equals(name)) {
            return path;
        }
        if ("ValueSet.expansion.contains".equals(path) && "contains".equals(name)) {
            return path;
        }
        if (v.isResource() && !"contained".equals(name)) {
            return v.fhirType();
        }
        return path + "." + name;
    }

    private boolean isTranslation(Base element) {
        return "Extension".equals(element.fhirType()) && element.getChildByName("url").hasValues() && "http://hl7.org/fhir/StructureDefinition/translation".equals(element.getChildByName("url").getValues().get(0).primitiveValue());
    }

    private boolean handleAsSpecial(Base parent, Base element, LanguageFileProducer.TranslationUnit translation) {
        return false;
    }

    private boolean isTranslatable(Base element, String path) {
        return (Utilities.existsInList((String)element.fhirType(), (String[])new String[]{"string", "markdown"}) || this.isTranslatable(path)) && !this.isExemptFromTranslations(path);
    }

    private int importFromTranslations(String path, Element parent, Element element, List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits) {
        String base;
        String npath = this.pathForElement(path, element);
        int t = 0;
        if (element.isPrimitive() && this.isTranslatable(element) && !this.isExemptFromTranslations(npath) && (base = element.primitiveValue()) != null) {
            Set<LanguageFileProducer.TranslationUnit> tlist = this.findTranslations(npath, base, translations);
            for (LanguageFileProducer.TranslationUnit translation : tlist) {
                ++t;
                if (this.handleAsSpecial(parent, element, translation)) continue;
                element.setTranslation(translation.getLanguage(), translation.getTgtText());
                usedUnits.add(translation);
            }
        }
        List<Element> childrenCopy = List.copyOf(element.getChildren());
        for (Element c : childrenCopy) {
            if (c.getName().equals("designation")) continue;
            t += this.importFromTranslations(npath, element, c, translations, usedUnits);
        }
        return t;
    }

    private boolean handleAsSpecial(Element parent, Element element, LanguageFileProducer.TranslationUnit translation) {
        if (parent == null) {
            return false;
        }
        if (Utilities.existsInList((String)parent.getBasePath(), (String[])new String[]{"CodeSystem.concept", "CodeSystem.concept.concept"}) && "CodeSystem.concept.display".equals(element.getBasePath())) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        if (Utilities.existsInList((String)parent.getBasePath(), (String[])new String[]{"ValueSet.compose.include.concept"}) && "ValueSet.compose.include.concept.display".equals(element.getBasePath())) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        if (Utilities.existsInList((String)parent.getBasePath(), (String[])new String[]{"ValueSet.expansion.contains", "ValueSet.expansion.contains.contains"}) && "ValueSet.expansion.contains.display".equals(element.getBasePath())) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        return false;
    }

    private boolean setDesignationTranslation(Element parent, String targetLang, String translation) {
        for (Element e : parent.getChildren("designation")) {
            String lang = e.getNamedChildValue("language");
            if (!LanguageUtils.langsMatch(targetLang, lang)) continue;
            Element value = e.getNamedChild("value");
            if (value != null) {
                value.setValue(translation);
            } else {
                e.addElement("value").setValue(translation);
            }
            return true;
        }
        Element d = parent.addElement("designation");
        d.addElement("language").setValue(targetLang);
        d.addElement("value").setValue(translation);
        return true;
    }

    private Set<LanguageFileProducer.TranslationUnit> findTranslations(String path, String src, List<LanguageFileProducer.TranslationUnit> translations) {
        HashSet<LanguageFileProducer.TranslationUnit> res = new HashSet<LanguageFileProducer.TranslationUnit>();
        for (LanguageFileProducer.TranslationUnit translation : translations) {
            if (!path.equals(translation.getId()) || !src.equals(translation.getSrcText())) continue;
            res.add(translation);
        }
        return res;
    }

    public static boolean langsMatchExact(AcceptLanguageHeader langs, String srcLang) {
        if (langs == null) {
            return false;
        }
        for (AcceptLanguageHeader.LanguagePreference lang : langs.getLangs()) {
            if (!(lang.getValue() > 0.0)) continue;
            if ("*".equals(lang.getLang())) {
                return true;
            }
            return LanguageUtils.langsMatch(lang.getLang(), srcLang);
        }
        return false;
    }

    public static boolean langsMatch(AcceptLanguageHeader langs, String srcLang) {
        if (langs == null) {
            return false;
        }
        for (AcceptLanguageHeader.LanguagePreference lang : langs.getLangs()) {
            if (!(lang.getValue() > 0.0)) continue;
            if ("*".equals(lang.getLang())) {
                return true;
            }
            boolean ok = LanguageUtils.langsMatch(lang.getLang(), srcLang);
            if (!ok) continue;
            return true;
        }
        return false;
    }

    public static boolean langsMatchExact(String dstLang, String srcLang) {
        return dstLang == null ? false : dstLang.equals(srcLang);
    }

    public static boolean langsMatch(String dstLang, String srcLang) {
        return dstLang == null || srcLang == null ? Utilities.existsInList((String)srcLang, (String[])new String[]{"en", "en-US"}) : dstLang.startsWith(srcLang) || "*".equals(srcLang);
    }

    public void fillSupplement(CodeSystem csSrc, CodeSystem csDst, List<LanguageFileProducer.TranslationUnit> list) {
        csDst.setUserData("translations.supplemented", csSrc);
        csDst.setUserData("translations.source-list", list);
        for (LanguageFileProducer.TranslationUnit tu : list) {
            String tt;
            CodeSystem.ConceptDefinitionComponent cdSrc;
            String code = tu.getId();
            String subCode = null;
            if (code.contains("@")) {
                subCode = code.substring(code.indexOf("@") + 1);
                code = code.substring(0, code.indexOf("@"));
            }
            if ((cdSrc = CodeSystemUtilities.getCode(csSrc, tu.getId())) == null) {
                this.addOrphanTranslation(csSrc, tu);
                continue;
            }
            CodeSystem.ConceptDefinitionComponent cdDst = CodeSystemUtilities.getCode(csDst, cdSrc.getCode());
            if (cdDst == null) {
                cdDst = csDst.addConcept().setCode(cdSrc.getCode());
            }
            if ((tt = tu.getTgtText()).startsWith("!!")) {
                tt = tt.substring(3);
            }
            if (subCode == null) {
                cdDst.setDisplay(tt);
                continue;
            }
            if ("definition".equals(subCode)) {
                cdDst.setDefinition(tt);
                continue;
            }
            boolean found = false;
            for (CodeSystem.ConceptDefinitionDesignationComponent d : cdSrc.getDesignation()) {
                if (!d.hasUse() || !subCode.equals(d.getUse().getCode())) continue;
                found = true;
                cdDst.addDesignation().setUse(d.getUse()).setLanguage(tu.getLanguage()).setValue(tt);
                break;
            }
            if (!found) {
                for (Extension e : cdSrc.getExtension()) {
                    if (!subCode.equals(this.tail(e.getUrl()))) continue;
                    found = true;
                    cdDst.addExtension().setUrl(e.getUrl()).setValue(e.getValue().fhirType().equals("markdown") ? new MarkdownType(tt) : new StringType(tt));
                    break;
                }
            }
            if (found) continue;
            this.addOrphanTranslation(csSrc, tu);
        }
    }

    private String tail(String url) {
        return url.contains("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
    }

    private void addOrphanTranslation(CodeSystem cs, LanguageFileProducer.TranslationUnit tu) {
        ArrayList<LanguageFileProducer.TranslationUnit> list = (ArrayList<LanguageFileProducer.TranslationUnit>)cs.getUserData("translations.orphans");
        if (list == null) {
            list = new ArrayList<LanguageFileProducer.TranslationUnit>();
            cs.setUserData("translations.orphans", list);
        }
        list.add(tu);
    }

    public String nameForLang(String lang) {
        switch (lang) {
            case "en": {
                return "English";
            }
            case "de": {
                return "German";
            }
            case "es": {
                return "Spanish";
            }
            case "nl": {
                return "Dutch";
            }
        }
        return Utilities.capitalize((String)lang);
    }

    public String titleForLang(String lang) {
        switch (lang) {
            case "en": {
                return "English";
            }
            case "de": {
                return "German";
            }
            case "es": {
                return "Spanish";
            }
            case "nl": {
                return "Dutch";
            }
        }
        return Utilities.capitalize((String)lang);
    }

    public boolean handlesAsResource(Resource resource) {
        return resource instanceof CodeSystem && resource.hasUserData("translations.supplemented") || resource instanceof StructureDefinition;
    }

    public boolean handlesAsElement(Element element) {
        return true;
    }

    public List<LanguageFileProducer.TranslationUnit> generateTranslations(Resource res, String lang) {
        ArrayList<LanguageFileProducer.TranslationUnit> list;
        block5: {
            block4: {
                list = new ArrayList<LanguageFileProducer.TranslationUnit>();
                if (!(res instanceof StructureDefinition)) break block4;
                StructureDefinition sd = (StructureDefinition)res;
                this.generateTranslations(list, sd, lang);
                if (!res.hasUserData("translations.orphans")) break block5;
                List orphans = (List)res.getUserData("translations.orphans");
                for (LanguageFileProducer.TranslationUnit t : orphans) {
                    if (this.hasInList(list, t.getId(), t.getSrcText())) continue;
                    list.add(new LanguageFileProducer.TranslationUnit(lang, "!!" + t.getId(), t.getContext(), t.getSrcText(), t.getTgtText()));
                }
                break block5;
            }
            CodeSystem cs = (CodeSystem)res.getUserData("translations.supplemented");
            ArrayList<LanguageFileProducer.TranslationUnit> inputs = res.hasUserData("translations.source-list") ? (List)res.getUserData("translations.source-list") : new ArrayList();
            for (CodeSystem.ConceptDefinitionComponent cd : cs.getConcept()) {
                this.generateTranslations(list, cd, lang, inputs);
            }
            if (cs.hasUserData("translations.orphans")) {
                List orphans = (List)cs.getUserData("translations.orphans");
                for (LanguageFileProducer.TranslationUnit t : orphans) {
                    if (this.hasInList(list, t.getId(), t.getSrcText())) continue;
                    list.add(new LanguageFileProducer.TranslationUnit(lang, "!!" + t.getId(), t.getContext(), t.getSrcText(), t.getTgtText()));
                }
            }
        }
        return list;
    }

    private void generateTranslations(List<LanguageFileProducer.TranslationUnit> list, StructureDefinition sd, String lang) {
        this.addToList(list, lang, sd, "StructureDefinition.name", "name", sd.getNameElement());
        this.addToList(list, lang, sd, "StructureDefinition.title", "title", sd.getTitleElement());
        this.addToList(list, lang, sd, "StructureDefinition.publisher", "publisher", sd.getPublisherElement());
        for (ContactDetail cd : sd.getContact()) {
            this.addToList(list, lang, cd, "StructureDefinition.contact.name", "name", cd.getNameElement());
        }
        this.addToList(list, lang, sd, "StructureDefinition.purpose", "purpose", sd.getPurposeElement());
        this.addToList(list, lang, sd, "StructureDefinition.copyright", "copyright", sd.getCopyrightElement());
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            this.addToList(list, lang, ed, "StructureDefinition.element." + ed.getId() + "/label", "label", ed.getLabelElement());
            this.addToList(list, lang, ed, "StructureDefinition.element." + ed.getId() + "/short", "short", ed.getShortElement());
            this.addToList(list, lang, ed, "StructureDefinition.element." + ed.getId() + "/definition", "definition", ed.getDefinitionElement());
            this.addToList(list, lang, ed, "StructureDefinition.element." + ed.getId() + "/comment", "comment", ed.getCommentElement());
            this.addToList(list, lang, ed, "StructureDefinition.element." + ed.getId() + "/requirements", "requirements", ed.getRequirementsElement());
            this.addToList(list, lang, ed, "StructureDefinition.element." + ed.getId() + "/meaningWhenMissing", "meaningWhenMissing", ed.getMeaningWhenMissingElement());
            this.addToList(list, lang, ed, "StructureDefinition.element." + ed.getId() + "/orderMeaning", "orderMeaning", ed.getOrderMeaningElement());
            for (ElementDefinition.ElementDefinitionConstraintComponent con : ed.getConstraint()) {
                this.addToList(list, lang, con, "StructureDefinition.element." + ed.getId() + "/constraint", "human", con.getHumanElement());
            }
            if (!ed.hasBinding()) continue;
            this.addToList(list, lang, ed.getBinding(), "StructureDefinition.element." + ed.getId() + "/b/desc", "description", ed.getBinding().getDescriptionElement());
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : ed.getBinding().getAdditional()) {
                this.addToList(list, lang, ab, "StructureDefinition.element." + ed.getId() + "/ab/doco", "documentation", ab.getDocumentationElement());
                this.addToList(list, lang, ab, "StructureDefinition.element." + ed.getId() + "/ab/short", "shortDoco", ab.getShortDocoElement());
            }
        }
    }

    private void addToList(List<LanguageFileProducer.TranslationUnit> list, String lang, Base ctxt, String name, String propName, DataType value) {
        if (value != null && value.hasPrimitiveValue() && !this.hasInList(list, name, value.primitiveValue())) {
            list.add(new LanguageFileProducer.TranslationUnit(lang, name, ctxt.getNamedProperty(propName).getDefinition(), value.primitiveValue(), value.getTranslation(lang)));
        }
    }

    private void generateTranslations(List<LanguageFileProducer.TranslationUnit> list, CodeSystem.ConceptDefinitionComponent cd, String lang, List<LanguageFileProducer.TranslationUnit> inputs) {
        this.addTranslationUnit(list, cd.getCode(), cd.getDisplay(), lang, inputs);
        if (cd.hasDefinition()) {
            this.addTranslationUnit(list, cd.getCode() + "@definition", cd.getDefinition(), lang, inputs);
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cd.getDesignation()) {
            this.addTranslationUnit(list, cd.getCode() + "@" + d.getUse().getCode(), d.getValue(), lang, inputs);
        }
        for (Extension e : cd.getExtension()) {
            this.addTranslationUnit(list, cd.getCode() + "@" + this.tail(e.getUrl()), e.getValue().primitiveValue(), lang, inputs);
        }
    }

    private void addTranslationUnit(List<LanguageFileProducer.TranslationUnit> list, String id, String srcText, String lang, List<LanguageFileProducer.TranslationUnit> inputs) {
        LanguageFileProducer.TranslationUnit existing = null;
        for (LanguageFileProducer.TranslationUnit t : inputs) {
            if (!id.equals(t.getId())) continue;
            existing = t;
            break;
        }
        if (!this.hasInList(list, id, srcText)) {
            if (existing == null) {
                list.add(new LanguageFileProducer.TranslationUnit(lang, id, null, srcText, null));
            } else if (srcText.equals(existing.getSrcText())) {
                list.add(new LanguageFileProducer.TranslationUnit(lang, id, null, srcText, existing.getTgtText()));
            } else {
                list.add(new LanguageFileProducer.TranslationUnit(lang, id, null, srcText, "!!" + existing.getTgtText()).setOriginal(existing.getSrcText()));
            }
        }
    }

    private String getDefinition(CodeSystem.ConceptDefinitionComponent cd) {
        CodeSystem.ConceptPropertyComponent v = CodeSystemUtilities.getProperty(cd, "translation-context");
        if (v != null && v.hasValue()) {
            return v.getValue().primitiveValue();
        }
        return cd.getDefinition();
    }

    public List<LanguageFileProducer.TranslationUnit> generateTranslations(Element e, String lang) {
        TranslationUnitCollection list = new TranslationUnitCollection();
        this.generateTranslations(e, lang, list, e.fhirType());
        return list.list;
    }

    private void generateTranslations(Element e, String lang, TranslationUnitCollection list, String path) {
        String npath = this.pathForElement(path, e);
        if ((e.getProperty().isTranslatable() || this.isTranslatable(e.getProperty().getDefinition().getBase().getPath())) && !this.isExemptFromTranslations(e.getProperty().getDefinition().getBase().getPath())) {
            String id = e.getProperty().getDefinition().getBase().getPath();
            String context = e.getProperty().getDefinition().getDefinition();
            String src = e.primitiveValue();
            String tgt = this.getTranslation(e, lang);
            if (!this.hasInList(list.list, id, src)) {
                list.add(new LanguageFileProducer.TranslationUnit(lang, id, context, src, tgt));
            }
        }
        if (e.hasChildren()) {
            for (Element c : e.getChildren()) {
                this.generateTranslations(c, lang, list, npath);
            }
        }
    }

    private boolean hasInList(List<LanguageFileProducer.TranslationUnit> list, String id, String src) {
        for (LanguageFileProducer.TranslationUnit t : list) {
            if (t.getId() == null || !t.getId().equals(id) || t.getSrcText() == null || !t.getSrcText().equals(src)) continue;
            return true;
        }
        return false;
    }

    private boolean isTranslatable(String path) {
        return Utilities.existsInList((String)path, (String[])new String[]{"TestCases.publisher", "TestCases.contact.telecom.value", "TestCases.definition", "TestCases.parameter.name", "TestCases.parameter.description", "TestCases.scope.description ", "TestCases.dependency.description", "TestCases.mode.description", "TestCases.suite", "TestCases.suite.name", "TestCases.suite.description", "TestCases.suite.test", "TestCases.suite.test.name", "TestCases.suite.test.description", "TestCases.suite.test.assert.human", "ActorDefinition.title", "ActorDefinition.description", "ActorDefinition.purpose", "ActorDefinition.copyright", "ActorDefinition.copyrightLabel", "ActorDefinition.documentation", "Requirements.title", "Requirements.publisher", "Requirements.description", "Requirements.purpose", "Requirements.copyright", "Requirements.copyrightLabel", "Requirements.statement.label", "Requirements.statement.requirement"});
    }

    private boolean isExemptFromTranslations(String path) {
        if (path.endsWith(".reference")) {
            return true;
        }
        return Utilities.existsInList((String)path, (String[])new String[]{"ImplementationGuide.definition.parameter.value", "ImplementationGuide.dependsOn.version", "ImplementationGuide.dependsOn.id", "CanonicalResource.name", "CapabilityStatement.rest.resource.searchRevInclude", "CapabilityStatement.rest.resource.searchInclude", "CapabilityStatement.rest.resource.searchParam.name", "SearchParameter.expression", "SearchParameter.xpath", "ExampleScenario.actor.actorId", "ExampleScenario.instance.resourceId", "ExampleScenario.instance.containedInstance.resourceId", "ExampleScenario.instance.version.versionId", "ExampleScenario.process.step.operation.number", "ExampleScenario.process.step.operation.initiator", "ExampleScenario.process.step.operation.receiver", "ExampleScenario.process.step.operation.number", "ExampleScenario.process.step.operation.initiator", "ExampleScenario.process.step.operation.receiver", "OperationDefinition.parameter.max", "OperationDefinition.overload.parameterName", "StructureMap.group.rule.source.type", "StructureMap.group.rule.source.element", "StructureMap.group.rule.target.element"});
    }

    private String getTranslation(Element e, String lang) {
        if (!e.hasChildren()) {
            return null;
        }
        for (Element ext : e.getChildren()) {
            if (!"Extension".equals(ext.fhirType()) || !"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getNamedChildValue("url"))) continue;
            String l = null;
            String v = null;
            for (Element subExt : ext.getChildren()) {
                if ("Extension".equals(subExt.fhirType()) && "lang".equals(subExt.getNamedChildValue("url"))) {
                    l = subExt.getNamedChildValue("value");
                }
                if (!"Extension".equals(subExt.fhirType()) || !"content".equals(subExt.getNamedChildValue("url"))) continue;
                v = subExt.getNamedChildValue("value");
            }
            if (!lang.equals(l)) continue;
            return v;
        }
        return null;
    }

    public boolean switchLanguage(Base r, String lang, boolean markLanguage, boolean contained) {
        boolean changed = false;
        if (r.isPrimitive()) {
            PrimitiveType dt = (PrimitiveType)r;
            String cnt = ToolingExtensions.getLanguageTranslation(dt, lang);
            dt.removeExtension("http://hl7.org/fhir/StructureDefinition/translation");
            if (cnt != null) {
                dt.setValueAsString(cnt);
                changed = true;
            }
        }
        if (r.fhirType().equals("Narrative")) {
            Base div = r.getChildValueByName("div");
            Base status = r.getChildValueByName("status");
            XhtmlNode xhtml = div.getXhtml();
            if ((xhtml = this.adjustToLang(xhtml, lang, status == null ? null : status.primitiveValue())) == null) {
                r.removeChild("div", div);
            } else {
                div.setXhtml(xhtml);
            }
        }
        for (Property p : r.children()) {
            for (Base c : p.getValues()) {
                changed = this.switchLanguage(c, lang, markLanguage, p.getName().equals("contained")) || changed;
            }
        }
        if (markLanguage && r.isResource() && !contained) {
            Resource res = (Resource)r;
            res.setLanguage(lang);
            changed = true;
        }
        return changed;
    }

    private XhtmlNode adjustToLang(XhtmlNode xhtml, String lang, String status) {
        String l;
        if (xhtml == null) {
            return null;
        }
        for (XhtmlNode div : xhtml.getChildNodes()) {
            String l2;
            if (!"div".equals(div.getName()) || !lang.equals(l2 = div.hasAttribute("lang") ? div.getAttribute("lang") : div.getAttribute("xml:lang"))) continue;
            return div;
        }
        String string = l = xhtml.hasAttribute("lang") ? xhtml.getAttribute("lang") : xhtml.getAttribute("xml:lang");
        if (lang.equals(l)) {
            return xhtml;
        }
        if (l == null && Utilities.existsInList((String)status, (String[])new String[]{"generated", "extensions"})) {
            return null;
        }
        return xhtml;
    }

    public boolean switchLanguage(Element e, String lang, boolean markLanguage) throws IOException {
        boolean changed = false;
        if (e.getProperty().isTranslatable()) {
            String cnt = this.getTranslation(e, lang);
            e.removeExtension("http://hl7.org/fhir/StructureDefinition/translation");
            if (cnt != null) {
                e.setValue(cnt);
                changed = true;
            }
        }
        if (e.fhirType().equals("Narrative") && e.hasChild("div")) {
            XhtmlNode xhtml = e.getNamedChild("div").getXhtml();
            if ((xhtml = this.adjustToLang(xhtml, lang, e.getNamedChildValue("status"))) == null) {
                e.removeChild("div");
            } else {
                e.getNamedChild("div").setXhtml(xhtml);
            }
        }
        if (e.hasChildren()) {
            for (Element c : e.getChildren()) {
                changed = this.switchLanguage(c, lang, markLanguage) || changed;
            }
        }
        if (markLanguage && e.isResource() && e.getSpecial() != Element.SpecialElement.CONTAINED) {
            e.setChildValue("language", lang);
            changed = true;
        }
        return changed;
    }

    public boolean hasTranslation(org.hl7.fhir.r5.model.Element e, String lang) {
        return this.getTranslation(e, lang) != null;
    }

    public String getTranslation(org.hl7.fhir.r5.model.Element e, String lang) {
        for (Extension ext : e.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
            String l = ext.getExtensionString("lang");
            String v = ext.getExtensionString("content");
            if (!LanguageUtils.langsMatch(l, lang) || v == null) continue;
            return v;
        }
        return null;
    }

    public String getTranslationOrBase(PrimitiveType<?> e, String lang) {
        for (Extension ext : e.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
            String l = ext.getExtensionString("lang");
            String v = ext.getExtensionString("content");
            if (!LanguageUtils.langsMatch(l, lang) || v == null) continue;
            return v;
        }
        return e.primitiveValue();
    }

    public Element copyToLanguage(Element element, String lang, boolean markLanguage) throws IOException {
        Element result = (Element)element.copy();
        this.switchLanguage(result, lang, markLanguage);
        return result;
    }

    public Resource copyToLanguage(Resource res, String lang, boolean markLanguage) {
        if (res == null) {
            return null;
        }
        Resource r = res.copy();
        this.switchLanguage(r, lang, markLanguage, false);
        return r;
    }

    public static class TranslationUnitCollection {
        List<LanguageFileProducer.TranslationUnit> list = new ArrayList<LanguageFileProducer.TranslationUnit>();
        Map<String, LanguageFileProducer.TranslationUnit> map = new HashMap<String, LanguageFileProducer.TranslationUnit>();

        public void add(LanguageFileProducer.TranslationUnit tu) {
            String key = tu.getId() + "||" + tu.getSrcText();
            if (!this.map.containsKey(key)) {
                this.map.put(key, tu);
                this.list.add(tu);
            }
        }
    }
}

