/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.event.Level;

@MarkedToMoveToAdjunctPackage
public class Slf4JLoggingService
implements ILoggingService {
    private final Logger logger;
    static final Map<ILoggingService.LogCategory, Marker> markers = new HashMap<ILoggingService.LogCategory, Marker>();

    private static Marker getMarker(ILoggingService.LogCategory category) {
        return markers.computeIfAbsent(category, c -> {
            String markerName = c.name().toLowerCase();
            return MarkerFactory.getMarker((String)markerName);
        });
    }

    @Override
    public void logMessage(String message) {
        this.logger.info(message);
    }

    @Override
    public void logDebugMessage(ILoggingService.LogCategory category, String message) {
        this.logger.makeLoggingEventBuilder(Level.DEBUG).addMarker(Slf4JLoggingService.getMarker(category)).setMessage(message).log();
    }

    public Slf4JLoggingService(Logger logger) {
        this.logger = logger;
    }
}

