/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.r5.context.BaseLogger;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class HTMLClientLogger
extends BaseLogger
implements ToolingClientLogger {
    private static final Logger log = LoggerFactory.getLogger(HTMLClientLogger.class);
    private boolean req = false;
    private PrintStream file;

    public HTMLClientLogger(String log) throws IOException {
        if (log != null) {
            try {
                this.file = new PrintStream(ManagedFileAccess.outStream((String)log));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void logRequest(String method, String url, List<String> headers, byte[] body) {
        log.debug(" txlog req: " + method + " " + url + " " + this.present(body));
        if (this.file == null) {
            return;
        }
        String id = this.nextId();
        this.file.println("<hr/><a name=\"l" + id + "\"> </a>");
        this.file.println("<p>#" + id + "</p>");
        this.file.println("<pre>");
        this.file.println(method + " " + url + " HTTP/1.0");
        if (headers != null) {
            for (String s : headers) {
                this.file.println(Utilities.escapeXmlText((String)s));
            }
        }
        if (body != null) {
            if (body.length > 100000) {
                body = Arrays.copyOf(body, 100000);
            }
            this.file.println("");
            this.file.println(Utilities.escapeXmlText((String)new String(body, StandardCharsets.UTF_8)));
        }
        this.file.println("</pre>");
        this.req = true;
    }

    public void logResponse(String outcome, List<String> headers, byte[] body, long start) {
        log.debug(" txlog resp: " + outcome + " " + this.present(body));
        if (this.file == null) {
            return;
        }
        if (!this.req) {
            log.info("Record Response without request");
        }
        this.req = false;
        this.file.println("<pre>");
        this.file.println(outcome);
        for (String s : headers) {
            this.file.println(Utilities.escapeXml((String)s));
        }
        if (body != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml((String)new String(body, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.file.println("</pre>");
    }

    private String present(byte[] body) {
        if (body == null) {
            return "";
        }
        String cnt = new String(body);
        if ((cnt = cnt.replace("\n", " ").replace("\r", "")).length() > 800) {
            return cnt.substring(0, 798) + "...";
        }
        return cnt;
    }
}

