/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;

@MarkedToMoveToAdjunctPackage
public class MappingAssistant {
    private MappingMergeModeOption mappingMergeMode = MappingMergeModeOption.APPEND;
    private StructureDefinition base;
    private StructureDefinition derived;
    private List<StructureDefinition.StructureDefinitionMappingComponent> masterList = new ArrayList<StructureDefinition.StructureDefinitionMappingComponent>();
    private Map<String, String> renames = new HashMap<String, String>();
    private String version;
    private List<String> suppressedMappings = new ArrayList<String>();

    public MappingAssistant(MappingMergeModeOption mappingMergeMode, StructureDefinition base, StructureDefinition derived, String version, List<String> suppressedMappings) {
        this.mappingMergeMode = mappingMergeMode;
        this.base = base;
        this.derived = derived;
        this.version = version;
        if (suppressedMappings != null) {
            this.suppressedMappings = suppressedMappings;
        }
        for (StructureDefinition.StructureDefinitionMappingComponent m : derived.getMapping()) {
            this.masterList.add(m);
            if (this.isSuppressed(m)) continue;
            m.setUserData("private-marked-as-derived", true);
        }
        for (StructureDefinition.StructureDefinitionMappingComponent m : base.getMapping()) {
            if (!this.notExcluded(m)) continue;
            StructureDefinition.StructureDefinitionMappingComponent md = this.findMatchInDerived(m);
            if (md == null) {
                if (this.nameExists(m.getIdentity())) {
                    int i = 1;
                    String n = m.getIdentity() + i;
                    while (this.nameExists(n)) {
                        n = m.getIdentity() + ++i;
                    }
                    this.renames.put(m.getIdentity(), n);
                    this.masterList.add(m.copy().setName(n));
                    continue;
                }
                this.masterList.add(m.copy());
                continue;
            }
            if (!md.hasName() && m.hasName()) {
                md.setName(m.getName());
            }
            if (!md.hasUri() && m.hasUri()) {
                md.setUri(m.getUri());
            }
            if (!md.hasComment() && m.hasComment()) {
                md.setComment(m.getComment());
            }
            if (m.getIdentity().equals(md.getIdentity())) continue;
            this.renames.put(m.getIdentity(), md.getIdentity());
        }
    }

    private boolean notExcluded(StructureDefinition.StructureDefinitionMappingComponent m) {
        if (!m.hasUri()) {
            return true;
        }
        return !Utilities.existsInList((String)m.getUri(), this.suppressedMappings);
    }

    private boolean notExcluded(ElementDefinition.ElementDefinitionMappingComponent m) {
        if (!m.hasIdentity()) {
            return false;
        }
        StructureDefinition.StructureDefinitionMappingComponent mm = null;
        for (StructureDefinition.StructureDefinitionMappingComponent t : this.base.getMapping()) {
            if (!m.getIdentity().equals(t.getIdentity())) continue;
            mm = t;
            break;
        }
        if (mm == null) {
            return false;
        }
        return this.notExcluded(mm);
    }

    private boolean nameExists(String n) {
        for (StructureDefinition.StructureDefinitionMappingComponent md : this.masterList) {
            if (!n.equals(md.getIdentity())) continue;
            return true;
        }
        return false;
    }

    private StructureDefinition.StructureDefinitionMappingComponent findMatchInDerived(StructureDefinition.StructureDefinitionMappingComponent m) {
        for (StructureDefinition.StructureDefinitionMappingComponent md : this.derived.getMapping()) {
            if (md.hasUri() && m.hasUri() && md.getUri().equals(m.getUri())) {
                return md;
            }
            if (!md.hasIdentity() || !m.hasIdentity() || !md.getIdentity().equals(m.getIdentity()) || md.hasName() && m.hasName() && !md.getName().equals(m.getName())) continue;
            return md;
        }
        return null;
    }

    public void update() {
        HashSet<StructureDefinition.StructureDefinitionMappingComponent> usedList = new HashSet<StructureDefinition.StructureDefinitionMappingComponent>();
        for (ElementDefinition ed : this.derived.getSnapshot().getElement()) {
            for (ElementDefinition.ElementDefinitionMappingComponent m : ed.getMapping()) {
                StructureDefinition.StructureDefinitionMappingComponent def = this.findDefinition(m.getIdentity());
                if (def == null || !this.notExcluded(m)) continue;
                usedList.add(def);
            }
        }
        this.derived.getMapping().clear();
        for (StructureDefinition.StructureDefinitionMappingComponent t : this.masterList) {
            if (!usedList.contains(t) && !t.hasUserData("private-marked-as-derived")) continue;
            this.derived.getMapping().add(t);
        }
    }

    public void merge(ElementDefinition base, ElementDefinition derived) {
        ArrayList<ElementDefinition.ElementDefinitionMappingComponent> list = new ArrayList<ElementDefinition.ElementDefinitionMappingComponent>();
        this.addMappings(list, base.getMapping(), this.renames);
        if (derived.hasMapping()) {
            this.addMappings(list, derived.getMapping(), null);
        }
        derived.setMapping(list);
        for (ElementDefinition.ElementDefinitionMappingComponent m : base.getMapping()) {
            if (!m.hasMap()) continue;
            m.setMap(m.getMap().trim());
        }
    }

    private void addMappings(List<ElementDefinition.ElementDefinitionMappingComponent> destination, List<ElementDefinition.ElementDefinitionMappingComponent> source, Map<String, String> renames2) {
        for (ElementDefinition.ElementDefinitionMappingComponent s : source) {
            String name;
            if (this.isSuppressed(s) || this.isSuppressed(name = s.getIdentity())) continue;
            if (renames2 != null && renames2.containsKey(name)) {
                name = renames2.get(name);
            }
            boolean found = false;
            for (ElementDefinition.ElementDefinitionMappingComponent d : destination) {
                if (!this.compareMaps(name, s, d)) continue;
                found = true;
                d.setUserData("derivation.equals", true);
                break;
            }
            if (found) continue;
            destination.add(s.setIdentity(name));
        }
    }

    private boolean isSuppressed(String name) {
        StructureDefinition.StructureDefinitionMappingComponent m = this.findDefinition(name);
        return m != null && this.isSuppressed(m);
    }

    private boolean isSuppressed(Element s) {
        return ToolingExtensions.readBoolExtension(s, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress");
    }

    private StructureDefinition.StructureDefinitionMappingComponent findDefinition(String name) {
        for (StructureDefinition.StructureDefinitionMappingComponent t : this.masterList) {
            if (!t.getIdentity().equals(name)) continue;
            return t;
        }
        return null;
    }

    private boolean compareMaps(String name, ElementDefinition.ElementDefinitionMappingComponent s, ElementDefinition.ElementDefinitionMappingComponent d) {
        if (d.getIdentity().equals(name) && d.getMap().equals(s.getMap())) {
            return true;
        }
        if (VersionUtilities.isR5Plus((String)this.version)) {
            if (d.getIdentity().equals(name)) {
                switch (this.mappingMergeMode) {
                    case APPEND: {
                        if (!Utilities.splitStrings((String)d.getMap(), (String)"\\,").contains(s.getMap())) {
                            d.setMap(this.mergeMaps(d.getMap(), s.getMap()));
                        }
                        return true;
                    }
                    case DUPLICATE: {
                        return false;
                    }
                    case IGNORE: {
                        d.setMap(s.getMap());
                        return true;
                    }
                    case OVERWRITE: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private String mergeMaps(String map, String map2) {
        List csv1 = CSVReader.splitString((String)map);
        List csv2 = CSVReader.splitString((String)map2);
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(",");
        for (String s : csv1) {
            b.append(s);
        }
        for (String s : csv2) {
            if (csv1.contains(s)) continue;
            b.append(s);
        }
        return b.toString();
    }

    public static enum MappingMergeModeOption {
        DUPLICATE,
        IGNORE,
        OVERWRITE,
        APPEND;

    }
}

