/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.sql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.utils.sql.Column;
import org.hl7.fhir.r5.utils.sql.ColumnKind;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonBoolean;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonNumber;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.model.JsonString;
import org.hl7.fhir.utilities.validation.ValidationMessage;

@MarkedToMoveToAdjunctPackage
public class Validator {
    private IWorkerContext context;
    private FHIRPathEngine fpe;
    private List<String> prohibitedNames = new ArrayList<String>();
    private List<ValidationMessage> issues = new ArrayList<ValidationMessage>();
    private TrueFalseOrUnknown supportsArrays;
    private TrueFalseOrUnknown supportsComplexTypes;
    private TrueFalseOrUnknown supportsNeedsName;
    private String resourceName;
    private String name;

    public Validator(IWorkerContext context, FHIRPathEngine fpe, List<String> prohibitedNames, @Nonnull TrueFalseOrUnknown supportsArrays, @Nonnull TrueFalseOrUnknown supportsComplexTypes, @Nonnull TrueFalseOrUnknown supportsNeedsName) {
        this.context = context;
        this.fpe = fpe;
        this.prohibitedNames = prohibitedNames;
        this.supportsArrays = supportsArrays;
        this.supportsComplexTypes = supportsComplexTypes;
        this.supportsNeedsName = supportsNeedsName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void checkViewDefinition(String path, JsonObject viewDefinition) {
        this.checkProperties(viewDefinition, path, "resourceType", "url", "identifier", "name", "version", "title", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "copyright", "resource", "constant", "select", "where");
        JsonElement nameJ = viewDefinition.get("name");
        if (nameJ == null) {
            if (this.supportsNeedsName == null) {
                this.hint(path, (JsonElement)viewDefinition, "No name provided. A name is required in many contexts where a ViewDefinition is used");
            } else if (this.supportsNeedsName == TrueFalseOrUnknown.TRUE) {
                this.error(path, (JsonElement)viewDefinition, "No name provided", ValidationMessage.IssueType.REQUIRED);
            }
        } else if (!(nameJ instanceof JsonString)) {
            this.error(path, (JsonElement)viewDefinition, "name must be a string", ValidationMessage.IssueType.INVALID);
        } else {
            this.name = nameJ.asString();
            if (!this.isValidName(this.name)) {
                this.error(path + ".name", nameJ, "The name '" + this.name + "' is not valid", ValidationMessage.IssueType.INVARIANT);
            }
            if (this.prohibitedNames.contains(this.name)) {
                this.error(path, nameJ, "The name '" + this.name + "' on the viewDefinition is not allowed in this context", ValidationMessage.IssueType.BUSINESSRULE);
            }
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        viewDefinition.setUserData("columns", columns);
        JsonElement resourceNameJ = viewDefinition.get("resource");
        if (resourceNameJ == null) {
            this.error(path, (JsonElement)viewDefinition, "No resource specified", ValidationMessage.IssueType.REQUIRED);
        } else if (!(resourceNameJ instanceof JsonString)) {
            this.error(path, (JsonElement)viewDefinition, "resource must be a string", ValidationMessage.IssueType.INVALID);
        } else {
            this.resourceName = resourceNameJ.asString();
            if (!this.context.getResourceNamesAsSet().contains(this.resourceName)) {
                this.error(path + ".name", nameJ, "The name '" + this.resourceName + "' is not a valid resource", ValidationMessage.IssueType.BUSINESSRULE);
            } else {
                int i = 0;
                if (this.checkAllObjects(path, viewDefinition, "constant")) {
                    for (JsonObject constant : viewDefinition.getJsonObjects("constant")) {
                        this.checkConstant(path + ".constant[" + i + "]", constant);
                        ++i;
                    }
                }
                i = 0;
                if (this.checkAllObjects(path, viewDefinition, "where")) {
                    for (JsonObject where : viewDefinition.getJsonObjects("where")) {
                        this.checkWhere(viewDefinition, path + ".where[" + i + "]", where);
                        ++i;
                    }
                }
                TypeDetails t = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, this.resourceName);
                i = 0;
                if (this.checkAllObjects(path, viewDefinition, "select")) {
                    for (JsonObject select : viewDefinition.getJsonObjects("select")) {
                        columns.addAll(this.checkSelect(viewDefinition, path + ".select[" + i + "]", select, t));
                        ++i;
                    }
                    if (i == 0) {
                        this.error(path, (JsonElement)viewDefinition, "No select statements found", ValidationMessage.IssueType.REQUIRED);
                    }
                }
            }
        }
    }

    private List<Column> checkSelect(JsonObject vd, String path, JsonObject select, TypeDetails t) {
        ArrayList<Column> columns = new ArrayList<Column>();
        select.setUserData("columns", columns);
        this.checkProperties(select, path, "column", "select", "forEach", "forEachOrNull", "unionAll");
        if (select.has("forEach")) {
            t = this.checkForEach(vd, path, select, select.get("forEach"), t);
        } else if (select.has("forEachOrNull")) {
            t = this.checkForEachOrNull(vd, path, select, select.get("forEachOrNull"), t);
        }
        if (t != null) {
            int i;
            JsonElement a;
            if (select.has("column")) {
                a = select.get("column");
                if (!(a instanceof JsonArray)) {
                    this.error(path + ".column", a, "column is not an array", ValidationMessage.IssueType.INVALID);
                } else {
                    i = 0;
                    for (JsonElement e : (JsonArray)a) {
                        if (!(e instanceof JsonObject)) {
                            this.error(path + ".column[" + i + "]", a, "column[" + i + "] is a " + e.type().toName() + " not an object", ValidationMessage.IssueType.INVALID);
                            continue;
                        }
                        columns.add(this.checkColumn(vd, path + ".column[" + i + "]", (JsonObject)e, t));
                    }
                }
            }
            if (select.has("select")) {
                a = select.get("select");
                if (!(a instanceof JsonArray)) {
                    this.error(path + ".select", a, "select is not an array", ValidationMessage.IssueType.INVALID);
                } else {
                    i = 0;
                    for (JsonElement e : (JsonArray)a) {
                        if (!(e instanceof JsonObject)) {
                            this.error(path + ".select[" + i + "]", e, "select[" + i + "] is not an object", ValidationMessage.IssueType.INVALID);
                            continue;
                        }
                        columns.addAll(this.checkSelect(vd, path + ".select[" + i + "]", (JsonObject)e, t));
                    }
                }
            }
            if (select.has("unionAll")) {
                columns.addAll(this.checkUnion(vd, path, select, select.get("unionAll"), t));
            }
            if (columns.isEmpty()) {
                this.error(path, (JsonElement)select, "The select has no columns or selects", ValidationMessage.IssueType.REQUIRED);
            } else {
                this.checkColumnNamesUnique(select, path, columns);
            }
        }
        return columns;
    }

    private void checkColumnNamesUnique(JsonObject select, String path, List<Column> columns) {
        HashSet<String> names = new HashSet<String>();
        for (Column col : columns) {
            if (col == null) continue;
            if (!names.contains(col.getName())) {
                names.add(col.getName());
                continue;
            }
            if (col.isDuplicateReported()) continue;
            col.setDuplicateReported(true);
            this.error(path, (JsonElement)select, "Duplicate Column Name '" + col.getName() + "'", ValidationMessage.IssueType.BUSINESSRULE);
        }
    }

    private List<Column> checkUnion(JsonObject vd, String path, JsonObject focus, JsonElement expression, TypeDetails t) {
        JsonElement a = focus.get("unionAll");
        if (!(a instanceof JsonArray)) {
            this.error(path + ".unionAll", a, "union is not an array", ValidationMessage.IssueType.INVALID);
            return null;
        }
        ArrayList<List<Column>> unionColumns = new ArrayList<List<Column>>();
        int i = 0;
        for (JsonElement e : (JsonArray)a) {
            if (!(e instanceof JsonObject)) {
                this.error(path + ".unionAll[" + i + "]", e, "unionAll[" + i + "] is not an object", ValidationMessage.IssueType.INVALID);
            } else {
                unionColumns.add(this.checkSelect(vd, path + ".unionAll[" + i + "]", (JsonObject)e, t));
            }
            ++i;
        }
        if (i < 2) {
            this.warning(path + ".unionAll", a, "unionAll should have more than one item");
        }
        if (unionColumns.size() > 1) {
            List columns = (List)unionColumns.get(0);
            for (int ic = 1; ic < unionColumns.size(); ++ic) {
                String diff = this.columnDiffs(columns, (List)unionColumns.get(ic));
                if (diff == null) continue;
                this.error(path + ".unionAll[" + i + "]", ((JsonArray)a).get(ic), "unionAll[" + i + "] column definitions do not match: " + diff, ValidationMessage.IssueType.INVALID);
            }
            a.setUserData("columns", (Object)columns);
            return columns;
        }
        return null;
    }

    private String columnDiffs(List<Column> list1, List<Column> list2) {
        if (list1.size() == list2.size()) {
            for (int i = 0; i < list1.size(); ++i) {
                if (list1.get(i) == null || list2.get(i) == null) {
                    return null;
                }
                String diff = list1.get(i).diff(list2.get(i));
                if (diff == null) continue;
                return diff + " at #" + i;
            }
            return null;
        }
        return "Column counts differ: " + list1.size() + " vs " + list2.size();
    }

    private Column checkColumn(JsonObject vd, String path, JsonObject column, TypeDetails t) {
        this.checkProperties(column, path, "path", "name", "description", "collection", "type", "tag");
        if (!column.has("path")) {
            this.error(path, (JsonElement)column, "no path found", ValidationMessage.IssueType.INVALID);
        } else {
            JsonElement expression = column.get("path");
            if (!(expression instanceof JsonString)) {
                this.error(path + ".forEach", expression, "forEach is not a string", ValidationMessage.IssueType.INVALID);
            } else {
                String expr = expression.asString();
                ArrayList<FHIRPathEngine.IssueMessage> warnings = new ArrayList<FHIRPathEngine.IssueMessage>();
                TypeDetails td = null;
                ExpressionNode node = null;
                try {
                    node = this.fpe.parse(expr);
                    column.setUserData("path", (Object)node);
                    td = this.fpe.checkOnTypes((Object)vd, "Resource", this.resourceName, t, node, warnings);
                }
                catch (Exception e) {
                    this.error(path, expression, e.getMessage(), ValidationMessage.IssueType.INVALID);
                }
                if (td != null && node != null) {
                    for (FHIRPathEngine.IssueMessage s : warnings) {
                        this.warning(path + ".path", expression, s.getMessage());
                    }
                    String columnName = null;
                    JsonElement nameJ = column.get("name");
                    if (nameJ != null) {
                        if (nameJ instanceof JsonString) {
                            columnName = nameJ.asString();
                            if (!this.isValidName(columnName)) {
                                this.error(path + ".name", nameJ, "The name '" + columnName + "' is not valid", ValidationMessage.IssueType.VALUE);
                            }
                        } else {
                            this.error(path + ".name", nameJ, "name must be a string", ValidationMessage.IssueType.INVALID);
                        }
                    }
                    if (columnName == null) {
                        List<String> names = node.getDistalNames();
                        if (names.size() == 1 && names.get(0) != null) {
                            columnName = names.get(0);
                            if (!this.isValidName(columnName)) {
                                this.error(path + ".path", expression, "A column name is required. The natural name to chose is '" + columnName + "' (from the path)", ValidationMessage.IssueType.INVARIANT);
                            } else {
                                this.error(path, (JsonElement)column, "A column name is required", ValidationMessage.IssueType.REQUIRED);
                            }
                        } else {
                            this.error(path, (JsonElement)column, "A column name is required", ValidationMessage.IssueType.REQUIRED);
                        }
                    }
                    if (columnName != null) {
                        column.setUserData("name", (Object)columnName);
                        boolean isColl = false;
                        if (column.has("collection")) {
                            JsonElement collectionJ = column.get("collection");
                            if (!(collectionJ instanceof JsonBoolean)) {
                                this.error(path + ".collection", collectionJ, "collection is not a boolean", ValidationMessage.IssueType.INVALID);
                            } else {
                                boolean collection = collectionJ.asJsonBoolean().asBoolean();
                                if (collection) {
                                    isColl = true;
                                }
                            }
                        }
                        if (isColl) {
                            if (td.getCollectionStatus() == ExpressionNode.CollectionStatus.SINGLETON) {
                                this.hint(path, (JsonElement)column, "collection is true, but the path statement(s) ('" + expr + "') can only return single values for the column '" + columnName + "'");
                            }
                            if (this.supportsArrays == TrueFalseOrUnknown.UNKNOWN) {
                                this.warning(path, expression, "The column '" + columnName + "' is defined as a collection, but collections are not supported in all execution contexts");
                            } else if (this.supportsArrays == TrueFalseOrUnknown.FALSE) {
                                if (td.getCollectionStatus() == ExpressionNode.CollectionStatus.SINGLETON) {
                                    this.warning(path, expression, "The column '" + columnName + "' is defined as a collection, but this is not allowed in the current execution context. Note that the path '" + expr + "' can only return a single value");
                                } else {
                                    this.warning(path, expression, "The column '" + columnName + "' is defined as a collection, but this is not allowed in the current execution context. Note that the path '" + expr + "' can return a collection of values");
                                }
                            }
                        } else if (td.getCollectionStatus() != ExpressionNode.CollectionStatus.SINGLETON) {
                            this.warning(path, (JsonElement)column, "This column is not defined as a collection, but the path statement '" + expr + "' might return multiple values for the column '" + columnName + "' for some inputs");
                        }
                        HashSet<String> types = new HashSet<String>();
                        if (node.isNullSet()) {
                            types.add("null");
                        } else {
                            for (String type : td.getTypes()) {
                                types.add(this.simpleType(type));
                            }
                            JsonElement typeJ = column.get("type");
                            if (typeJ != null) {
                                if (typeJ instanceof JsonString) {
                                    String type;
                                    type = typeJ.asString();
                                    if (!td.hasType(type)) {
                                        this.error(path + ".type", typeJ, "The path expression ('" + expr + "') does not return a value of the type '" + type + "' - found " + td.describe(), ValidationMessage.IssueType.VALUE);
                                    } else {
                                        types.clear();
                                        types.add(this.simpleType(type));
                                    }
                                } else {
                                    this.error(path + ".type", typeJ, "type must be a string", ValidationMessage.IssueType.INVALID);
                                }
                            }
                        }
                        if (types.size() != 1) {
                            this.error(path, (JsonElement)column, "Unable to determine a type (found " + td.describe() + ")", ValidationMessage.IssueType.BUSINESSRULE);
                        } else {
                            String type = (String)types.iterator().next();
                            boolean ok = false;
                            if (!this.isSimpleType(type) && !"null".equals(type)) {
                                if (this.supportsComplexTypes == TrueFalseOrUnknown.UNKNOWN) {
                                    this.warning(path, expression, "Column from path '" + expr + "' is a complex type ('" + type + "'). This is not supported in some Runners");
                                } else if (this.supportsComplexTypes == TrueFalseOrUnknown.FALSE) {
                                    this.error(path, expression, "Column from path '" + expr + "' is a complex type ('" + type + "') but this is not allowed in this context", ValidationMessage.IssueType.BUSINESSRULE);
                                } else {
                                    ok = true;
                                }
                            } else {
                                ok = true;
                            }
                            if (ok) {
                                Column col = new Column(columnName, isColl, type, this.kindForType(type));
                                column.setUserData("column", (Object)col);
                                return col;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private ColumnKind kindForType(String type) {
        switch (type) {
            case "null": {
                return ColumnKind.Null;
            }
            case "dateTime": {
                return ColumnKind.DateTime;
            }
            case "boolean": {
                return ColumnKind.Boolean;
            }
            case "integer": {
                return ColumnKind.Integer;
            }
            case "decimal": {
                return ColumnKind.Decimal;
            }
            case "string": {
                return ColumnKind.String;
            }
            case "canonical": {
                return ColumnKind.String;
            }
            case "url": {
                return ColumnKind.String;
            }
            case "uri": {
                return ColumnKind.String;
            }
            case "oid": {
                return ColumnKind.String;
            }
            case "uuid": {
                return ColumnKind.String;
            }
            case "id": {
                return ColumnKind.String;
            }
            case "code": {
                return ColumnKind.String;
            }
            case "base64Binary": {
                return ColumnKind.Binary;
            }
            case "time": {
                return ColumnKind.Time;
            }
        }
        return ColumnKind.Complex;
    }

    private boolean isSimpleType(String type) {
        return Utilities.existsInList((String)type, (String[])new String[]{"dateTime", "boolean", "integer", "decimal", "string", "base64Binary", "id", "code", "date", "time", "canonical", "uri", "url"});
    }

    private String simpleType(String type) {
        type = type.replace("http://hl7.org/fhirpath/System.", "").replace("http://hl7.org/fhir/StructureDefinition/", "");
        if (Utilities.existsInList((String)type, (String[])new String[]{"date", "dateTime", "instant"})) {
            return "dateTime";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Boolean", "boolean"})) {
            return "boolean";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Integer", "integer", "integer64"})) {
            return "integer";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Decimal", "decimal"})) {
            return "decimal";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"String", "string", "code"})) {
            return "string";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Time", "time"})) {
            return "time";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"base64Binary"})) {
            return "base64Binary";
        }
        return type;
    }

    private TypeDetails checkForEach(JsonObject vd, String path, JsonObject focus, JsonElement expression, TypeDetails t) {
        if (!(expression instanceof JsonString)) {
            this.error(path + ".forEach", expression, "forEach is not a string", ValidationMessage.IssueType.INVALID);
            return null;
        }
        String expr = expression.asString();
        ArrayList<FHIRPathEngine.IssueMessage> warnings = new ArrayList<FHIRPathEngine.IssueMessage>();
        TypeDetails td = null;
        try {
            ExpressionNode n = this.fpe.parse(expr);
            focus.setUserData("forEach", (Object)n);
            td = this.fpe.checkOnTypes((Object)vd, "Resource", this.resourceName, t, n, warnings);
        }
        catch (Exception e) {
            this.error(path, expression, e.getMessage(), ValidationMessage.IssueType.INVALID);
        }
        if (td != null) {
            for (FHIRPathEngine.IssueMessage s : warnings) {
                this.warning(path + ".forEach", expression, s.getMessage());
            }
        }
        return td;
    }

    private TypeDetails checkForEachOrNull(JsonObject vd, String path, JsonObject focus, JsonElement expression, TypeDetails t) {
        if (!(expression instanceof JsonString)) {
            this.error(path + ".forEachOrNull", expression, "forEachOrNull is not a string", ValidationMessage.IssueType.INVALID);
            return null;
        }
        String expr = expression.asString();
        ArrayList<FHIRPathEngine.IssueMessage> warnings = new ArrayList<FHIRPathEngine.IssueMessage>();
        TypeDetails td = null;
        try {
            ExpressionNode n = this.fpe.parse(expr);
            focus.setUserData("forEachOrNull", (Object)n);
            td = this.fpe.checkOnTypes((Object)vd, "Resource", this.resourceName, t, n, warnings);
        }
        catch (Exception e) {
            this.error(path, expression, e.getMessage(), ValidationMessage.IssueType.INVALID);
        }
        if (td != null) {
            for (FHIRPathEngine.IssueMessage s : warnings) {
                this.warning(path + ".forEachOrNull", expression, s.getMessage());
            }
        }
        return td;
    }

    private void checkConstant(String path, JsonObject constant) {
        this.checkProperties(constant, path, "name", "valueBase64Binary", "valueBoolean", "valueCanonical", "valueCode", "valueDate", "valueDateTime", "valueDecimal", "valueId", "valueInstant", "valueInteger", "valueInteger64", "valueOid", "valueString", "valuePositiveInt", "valueTime", "valueUnsignedInt", "valueUri", "valueUrl", "valueUuid");
        JsonElement nameJ = constant.get("name");
        if (nameJ == null) {
            this.error(path, (JsonElement)constant, "No name provided", ValidationMessage.IssueType.REQUIRED);
        } else if (!(nameJ instanceof JsonString)) {
            this.error(path, (JsonElement)constant, "Name must be a string", ValidationMessage.IssueType.INVALID);
        } else {
            String name = constant.asString("name");
            if (!this.isValidName(name)) {
                this.error(path + ".name", nameJ, "The name '" + name + "' is not valid", ValidationMessage.IssueType.INVARIANT);
            }
        }
        if (constant.has("valueBase64Binary")) {
            this.checkIsString(path, constant, "valueBase64Binary", new Base64BinaryType());
        } else if (constant.has("valueBoolean")) {
            this.checkIsBoolean(path, constant, "valueBoolean", new BooleanType());
        } else if (constant.has("valueCanonical")) {
            this.checkIsString(path, constant, "valueCanonical", new CanonicalType());
        } else if (constant.has("valueCode")) {
            this.checkIsString(path, constant, "valueCode", new CodeType());
        } else if (constant.has("valueDate")) {
            this.checkIsString(path, constant, "valueDate", new DateType());
        } else if (constant.has("valueDateTime")) {
            this.checkIsString(path, constant, "valueDateTime", new DateTimeType());
        } else if (constant.has("valueDecimal")) {
            this.checkIsNumber(path, constant, "valueDecimal", new DecimalType());
        } else if (constant.has("valueId")) {
            this.checkIsString(path, constant, "valueId", new IdType());
        } else if (constant.has("valueInstant")) {
            this.checkIsString(path, constant, "valueInstant", new InstantType());
        } else if (constant.has("valueInteger")) {
            this.checkIsNumber(path, constant, "valueInteger", new IntegerType());
        } else if (constant.has("valueInteger64")) {
            this.checkIsNumber(path, constant, "valueInteger64", new Integer64Type());
        } else if (constant.has("valueOid")) {
            this.checkIsString(path, constant, "valueOid", new OidType());
        } else if (constant.has("valueString")) {
            this.checkIsString(path, constant, "valueString", new StringType());
        } else if (constant.has("valuePositiveInt")) {
            this.checkIsNumber(path, constant, "valuePositiveInt", new PositiveIntType());
        } else if (constant.has("valueTime")) {
            this.checkIsString(path, constant, "valueTime", new TimeType());
        } else if (constant.has("valueUnsignedInt")) {
            this.checkIsNumber(path, constant, "valueUnsignedInt", new UnsignedIntType());
        } else if (constant.has("valueUri")) {
            this.checkIsString(path, constant, "valueUri", new UriType());
        } else if (constant.has("valueUrl")) {
            this.checkIsString(path, constant, "valueUrl", new UrlType());
        } else if (constant.has("valueUuid")) {
            this.checkIsString(path, constant, "valueUuid", new UuidType());
        } else {
            this.error(path, (JsonElement)constant, "No value found", ValidationMessage.IssueType.REQUIRED);
        }
    }

    private void checkIsString(String path, JsonObject constant, String name, PrimitiveType<?> value) {
        JsonElement j = constant.get(name);
        if (!(j instanceof JsonString)) {
            this.error(path + "." + name, j, name + " must be a string", ValidationMessage.IssueType.INVALID);
        } else {
            value.setValueAsString(j.asString());
            constant.setUserData("value", value);
        }
    }

    private void checkIsBoolean(String path, JsonObject constant, String name, PrimitiveType<?> value) {
        JsonElement j = constant.get(name);
        if (!(j instanceof JsonBoolean)) {
            this.error(path + "." + name, j, name + " must be a boolean", ValidationMessage.IssueType.INVALID);
        } else {
            value.setValueAsString(j.asString());
            constant.setUserData("value", value);
        }
    }

    private void checkIsNumber(String path, JsonObject constant, String name, PrimitiveType<?> value) {
        JsonElement j = constant.get(name);
        if (!(j instanceof JsonNumber)) {
            this.error(path + "." + name, j, name + " must be a number", ValidationMessage.IssueType.INVALID);
        } else {
            value.setValueAsString(j.asString());
            constant.setUserData("value", value);
        }
    }

    private void checkWhere(JsonObject vd, String path, JsonObject where) {
        this.checkProperties(where, path, "path", "description");
        String expr = where.asString("path");
        if (expr == null) {
            this.error(path, (JsonElement)where, "No path provided", ValidationMessage.IssueType.REQUIRED);
        }
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<FHIRPathEngine.IssueMessage> warnings = new ArrayList<FHIRPathEngine.IssueMessage>();
        types.add(this.resourceName);
        TypeDetails td = null;
        try {
            ExpressionNode n = this.fpe.parse(expr);
            where.setUserData("path", (Object)n);
            td = this.fpe.checkOnTypes((Object)vd, "Resource", this.resourceName, types, n, warnings);
        }
        catch (Exception e) {
            this.error(path, where.get("path"), e.getMessage(), ValidationMessage.IssueType.INVALID);
        }
        if (td != null) {
            if (td.getCollectionStatus() != ExpressionNode.CollectionStatus.SINGLETON || td.getTypes().size() != 1 || !td.hasType("boolean")) {
                this.error(path + ".path", where.get("path"), "A where path must return a boolean, but the expression " + expr + " returns a " + td.describe(), ValidationMessage.IssueType.BUSINESSRULE);
            } else {
                for (FHIRPathEngine.IssueMessage s : warnings) {
                    this.warning(path + ".path", where.get("path"), s.getMessage());
                }
            }
        }
    }

    private void checkProperties(JsonObject obj, String path, String ... names) {
        for (JsonProperty p : obj.getProperties()) {
            boolean nameOk = "extension".equals(p.getName());
            for (String name : names) {
                nameOk = nameOk || name.equals(p.getName());
            }
            if (nameOk) continue;
            this.error(path + "." + p.getName(), p.getValue(), "Unknown JSON property " + p.getName(), ValidationMessage.IssueType.UNKNOWN);
        }
    }

    private boolean isValidName(String name) {
        boolean first = true;
        for (char c : name.toCharArray()) {
            if (!(Character.isAlphabetic(c) || Character.isDigit(c) || !first && c == '_')) {
                return false;
            }
            first = false;
        }
        return true;
    }

    private boolean checkAllObjects(String path, JsonObject focus, String name) {
        if (!focus.has(name)) {
            return true;
        }
        if (!(focus.get(name) instanceof JsonArray)) {
            this.error(path + "." + name, focus.get(name), name + " must be an array", ValidationMessage.IssueType.INVALID);
            return false;
        }
        JsonArray arr = focus.getJsonArray(name);
        int i = 0;
        boolean ok = true;
        for (JsonElement e : arr) {
            if (e instanceof JsonObject) continue;
            this.error(path + "." + name + "[" + i + "]", e, name + "[" + i + "] must be an object", ValidationMessage.IssueType.INVALID);
            ok = false;
        }
        return ok;
    }

    private void error(String path, JsonElement e, String issue, ValidationMessage.IssueType type) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.InstanceValidator, type, e.getStart().getLine(), e.getStart().getCol(), path, issue, ValidationMessage.IssueSeverity.ERROR);
        this.issues.add(vm);
    }

    private void warning(String path, JsonElement e, String issue) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, e.getStart().getLine(), e.getStart().getCol(), path, issue, ValidationMessage.IssueSeverity.WARNING);
        this.issues.add(vm);
    }

    private void hint(String path, JsonElement e, String issue) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, e.getStart().getLine(), e.getStart().getCol(), path, issue, ValidationMessage.IssueSeverity.INFORMATION);
        this.issues.add(vm);
    }

    public void dump() {
        for (ValidationMessage vm : this.issues) {
            System.out.println(vm.summary());
        }
    }

    public void check() {
        if (!this.isOk()) {
            throw new FHIRException("View Definition is not valid");
        }
    }

    public String getName() {
        return this.name;
    }

    public List<ValidationMessage> getIssues() {
        return this.issues;
    }

    public boolean isOk() {
        boolean ok = true;
        for (ValidationMessage vm : this.issues) {
            if (!vm.isError()) continue;
            ok = false;
        }
        return ok;
    }

    public static enum TrueFalseOrUnknown {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

