/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;

@MarkedToMoveToAdjunctPackage
public class JsonResourceTemplateFixer {
    public static void main(String[] args) throws JsonException, IOException {
        new JsonResourceTemplateFixer().execute("/Users/grahamegrieve/work/fhir-tx-ecosystem-ig/tests", "/Users/grahamegrieve/temp/tx-tests", "");
    }

    private void execute(String source, String dest, String path) throws JsonException, IOException {
        File src = new File(source);
        for (File f : src.listFiles()) {
            JsonObject j;
            if (f.isDirectory()) {
                this.execute(f.getAbsolutePath(), dest, "".equals(path) ? f.getName() : Utilities.path((String[])new String[]{path, f.getName()}));
                continue;
            }
            if (!f.getName().endsWith(".json") || !(j = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((File)f)).has("resourceType")) continue;
            FileUtilities.createDirectory((String)Utilities.path((String[])new String[]{dest, "in", path}));
            org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)j, (File)new File(Utilities.path((String[])new String[]{dest, "in", path, f.getName()})), (boolean)true);
            this.checkJsonObject(j);
            FileUtilities.createDirectory((String)Utilities.path((String[])new String[]{dest, "out", path}));
            File tgt = new File(Utilities.path((String[])new String[]{dest, "out", path, f.getName()}));
            org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)j, (File)tgt, (boolean)true);
            try {
                Resource res = new JsonParser().parse(FileUtilities.fileToBytes((File)tgt));
                new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(tgt), res);
            }
            catch (Exception e) {
                System.out.println("Error reading " + tgt.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    private void checkJsonObject(JsonObject j) {
        List names;
        if (j.has("$optional-properties$")) {
            names = j.getJsonArray("$optional-properties$").asStrings();
            j.remove("$optional-properties$");
            this.addExtension(j, "optional-properties", "string", CommaSeparatedStringBuilder.join((String)",", (Collection)names));
        }
        if (j.has("$optional$")) {
            j.remove("$optional$");
            this.addExtension(j, "optional", true);
        }
        if (j.has("$count-arrays$")) {
            names = j.getJsonArray("$count-arrays$").asStrings();
            j.remove("$count-arrays$");
            this.addExtension(j, "count-arrays", "string", CommaSeparatedStringBuilder.join((String)",", (Collection)names));
        }
        for (int i = j.getProperties().size() - 1; i >= 0; --i) {
            JsonProperty p = (JsonProperty)j.getProperties().get(i);
            if (p.getValue().isJsonArray()) {
                for (JsonElement e : p.getValue().asJsonArray()) {
                    this.checkJsonElement(j, p.getName(), e);
                }
                continue;
            }
            this.checkJsonElement(j, p.getName(), p.getValue());
        }
    }

    public void addExtension(JsonObject j, String url, String type, String value) {
        JsonObject ext = new JsonObject();
        ext.set("url", "http://hl7.org/fhir/uv/tools/StructureDefinition/test-template-" + url);
        ext.set("value" + Utilities.capitalize((String)type), value);
        j.forceArray(0, "extension").add((JsonElement)ext);
    }

    public void addExtension(JsonObject j, String url, boolean value) {
        JsonObject ext = new JsonObject();
        ext.set("url", "http://hl7.org/fhir/uv/tools/StructureDefinition/test-template-" + url);
        ext.set("valueBoolean", value);
        j.forceArray(0, "extension").add((JsonElement)ext);
    }

    public void addNamedExtension(JsonObject parent, String name, String url, String type, String value) {
        JsonObject k = parent.getJsonObject("_" + name);
        if (k == null) {
            k = new JsonObject();
            parent.add("_" + name, (JsonElement)k);
        }
        JsonObject ext = new JsonObject();
        ext.set("url", "http://hl7.org/fhir/uv/tools/StructureDefinition/test-template-" + url);
        ext.set("value" + Utilities.capitalize((String)type), value);
        k.forceArray("extension").add((JsonElement)ext);
    }

    private void checkJsonElement(JsonObject parent, String name, JsonElement value) {
        if (value.isJsonObject()) {
            this.checkJsonObject(value.asJsonObject());
        } else if (value.isJsonPrimitive()) {
            this.checkJsonPrimitive(parent, name, value.asString());
        } else {
            System.out.println("What?");
        }
    }

    private void checkJsonPrimitive(JsonObject parent, String name, String value) {
    }
}

