/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.HL7WorkGroups;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;

public class CanonicalResourceUtilities {
    public static void setHl7WG(CanonicalResource cr, String wgc) {
        HL7WorkGroups.HL7WorkGroup wg = HL7WorkGroups.find((String)wgc);
        if (wg == null) {
            throw new Error("Unknown WG " + wgc);
        }
        ToolingExtensions.setCodeExtension(cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg.getCode());
        cr.setPublisher("HL7 International / " + wg.getName());
        boolean found = false;
        for (ContactDetail c : cr.getContact()) {
            for (ContactPoint t : c.getTelecom()) {
                if (t.getSystem() != ContactPoint.ContactPointSystem.URL || !wg.getLink().equals(t.getValue())) continue;
                found = true;
            }
        }
        if (!found) {
            cr.addContact().addTelecom().setSystem(ContactPoint.ContactPointSystem.URL).setValue(wg.getLink());
        }
    }

    public static void setHl7WG(CanonicalResource cr) {
        HL7WorkGroups.HL7WorkGroup wg;
        String wgc = ToolingExtensions.readStringExtension((DomainResource)cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        if (wgc == null) {
            wgc = "fhir";
        }
        if ((wg = HL7WorkGroups.find((String)wgc)) == null) {
            throw new Error("Unknown WG '" + wgc + "' in " + cr.fhirType() + "/" + cr.getIdBase());
        }
        ToolingExtensions.setCodeExtension(cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg.getCode());
        cr.setPublisher("HL7 International / " + wg.getName());
        boolean found = false;
        for (ContactDetail c : cr.getContact()) {
            for (ContactPoint t : c.getTelecom()) {
                if (t.getSystem() != ContactPoint.ContactPointSystem.URL || !wg.getLink().equals(t.getValue())) continue;
                found = true;
            }
        }
        if (!found) {
            cr.addContact().addTelecom().setSystem(ContactPoint.ContactPointSystem.URL).setValue(wg.getLink());
        }
    }

    public static void setHl7WG(Element res, String code) {
        if (VersionUtilities.getExtendedCanonicalResourceNames((String)res.getFHIRPublicationVersion().toCode()).contains(res.fhirType())) {
            HL7WorkGroups.HL7WorkGroup wg = HL7WorkGroups.find((String)code);
            if (wg == null) {
                throw new Error("Unknown WG " + code);
            }
            Element ext = res.getExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
            if (ext == null) {
                ext = res.addElement("extension");
                ext.setChildValue("url", "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
            }
            ext.setChildValue("value[x]", new CodeType(code));
            if (!Utilities.existsInList((String)res.fhirType(), (String[])new String[]{"ClinicalUseDefinition"})) {
                res.setChildValue("publisher", "HL7 International / " + wg.getName());
                while (res.hasChildren("contact")) {
                    res.removeChild("contact");
                }
                Element c = res.addElement("contact");
                Element t = c.addElement("telecom");
                t.setChildValue("system", "url");
                t.setChildValue("value", wg.getLink());
            }
        }
    }
}

