/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.tools.CDSHookContext;
import org.hl7.fhir.r5.tools.CDSHooksElement;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="CDSHooksRequest")
public class CDSHooksRequest
extends CDSHooksElement
implements ICompositeType {
    @Child(name="hook", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The hook that triggered this CDS Service call", formalDefinition="The hook that triggered this CDS Service call")
    protected CodeType hook;
    @Child(name="hookInstance", type={UuidType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A universally unique identifier (UUID) for this particular hook call", formalDefinition="While working in the CDS Client, a user can perform multiple actions in series or in parallel. For example, a clinician might prescribe two drugs in a row; each prescription action would be assigned a unique hookInstance. This allows a CDS Service to uniquely identify each hook invocation")
    protected UuidType hookInstance;
    @Child(name="fhirServer", type={UrlType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The base URL of the CDS Client's FHIR server", formalDefinition="The base URL of the CDS Client's FHIR server. If fhirAuthorization is provided, this field is REQUIRED. The scheme MUST be https when production data is exchanged")
    protected UrlType fhirServer;
    @Child(name="fhirAuthorization", type={CDSHooksElement.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A structure holding an OAuth 2.0 bearer access token granting the CDS Service access to FHIR resources, along with supplemental information relating to the token", formalDefinition="A structure holding an OAuth 2.0 bearer access token granting the CDS Service access to FHIR resources, along with supplemental information relating to the token")
    protected CDSHooksRequestFhirAuthorizationComponent fhirAuthorization;
    @Child(name="context", type={CDSHookContext.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Hook-specific contextual data that the CDS service will need", formalDefinition="Hook-specific contextual data that the CDS service will need")
    protected CDSHookContext context;
    @Child(name="prefetch", type={Base.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Key/value pairs of FHIR queries the CDS Client provides on each call", formalDefinition="An object containing key/value pairs of FHIR queries that this Request is requesting the CDS Client to perform and provide on each Request call. The key is a string that describes the type of data being requested and the value is a string representing the FHIR query")
    protected List<CDSHooksRequestPrefetchComponent> prefetch;
    private static final long serialVersionUID = -858270829L;

    public CDSHooksRequest() {
    }

    public CDSHooksRequest(String hook, String hookInstance, CDSHookContext context) {
        this.setHook(hook);
        this.setHookInstance(hookInstance);
        this.setContext(context);
    }

    public CodeType getHookElement() {
        if (this.hook == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHooksRequest.hook");
            }
            if (Configuration.doAutoCreate()) {
                this.hook = new CodeType();
            }
        }
        return this.hook;
    }

    public boolean hasHookElement() {
        return this.hook != null && !this.hook.isEmpty();
    }

    public boolean hasHook() {
        return this.hook != null && !this.hook.isEmpty();
    }

    public CDSHooksRequest setHookElement(CodeType value) {
        this.hook = value;
        return this;
    }

    public String getHook() {
        return this.hook == null ? null : (String)this.hook.getValue();
    }

    public CDSHooksRequest setHook(String value) {
        if (this.hook == null) {
            this.hook = new CodeType();
        }
        this.hook.setValue(value);
        return this;
    }

    public UuidType getHookInstanceElement() {
        if (this.hookInstance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHooksRequest.hookInstance");
            }
            if (Configuration.doAutoCreate()) {
                this.hookInstance = new UuidType();
            }
        }
        return this.hookInstance;
    }

    public boolean hasHookInstanceElement() {
        return this.hookInstance != null && !this.hookInstance.isEmpty();
    }

    public boolean hasHookInstance() {
        return this.hookInstance != null && !this.hookInstance.isEmpty();
    }

    public CDSHooksRequest setHookInstanceElement(UuidType value) {
        this.hookInstance = value;
        return this;
    }

    public String getHookInstance() {
        return this.hookInstance == null ? null : (String)this.hookInstance.getValue();
    }

    public CDSHooksRequest setHookInstance(String value) {
        if (this.hookInstance == null) {
            this.hookInstance = new UuidType();
        }
        this.hookInstance.setValue(value);
        return this;
    }

    public UrlType getFhirServerElement() {
        if (this.fhirServer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHooksRequest.fhirServer");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirServer = new UrlType();
            }
        }
        return this.fhirServer;
    }

    public boolean hasFhirServerElement() {
        return this.fhirServer != null && !this.fhirServer.isEmpty();
    }

    public boolean hasFhirServer() {
        return this.fhirServer != null && !this.fhirServer.isEmpty();
    }

    public CDSHooksRequest setFhirServerElement(UrlType value) {
        this.fhirServer = value;
        return this;
    }

    public String getFhirServer() {
        return this.fhirServer == null ? null : (String)this.fhirServer.getValue();
    }

    public CDSHooksRequest setFhirServer(String value) {
        if (Utilities.noString((String)value)) {
            this.fhirServer = null;
        } else {
            if (this.fhirServer == null) {
                this.fhirServer = new UrlType();
            }
            this.fhirServer.setValue(value);
        }
        return this;
    }

    public CDSHooksRequestFhirAuthorizationComponent getFhirAuthorization() {
        return this.fhirAuthorization;
    }

    public boolean hasFhirAuthorization() {
        return this.fhirAuthorization != null && !this.fhirAuthorization.isEmpty();
    }

    public CDSHooksRequest setFhirAuthorization(CDSHooksRequestFhirAuthorizationComponent value) {
        this.fhirAuthorization = value;
        return this;
    }

    public CDSHookContext getContext() {
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public CDSHooksRequest setContext(CDSHookContext value) {
        this.context = value;
        return this;
    }

    public List<CDSHooksRequestPrefetchComponent> getPrefetch() {
        if (this.prefetch == null) {
            this.prefetch = new ArrayList<CDSHooksRequestPrefetchComponent>();
        }
        return this.prefetch;
    }

    public CDSHooksRequest setPrefetch(List<CDSHooksRequestPrefetchComponent> thePrefetch) {
        this.prefetch = thePrefetch;
        return this;
    }

    public boolean hasPrefetch() {
        if (this.prefetch == null) {
            return false;
        }
        for (CDSHooksRequestPrefetchComponent item : this.prefetch) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CDSHooksRequestPrefetchComponent addPrefetch() {
        CDSHooksRequestPrefetchComponent t = new CDSHooksRequestPrefetchComponent();
        if (this.prefetch == null) {
            this.prefetch = new ArrayList<CDSHooksRequestPrefetchComponent>();
        }
        this.prefetch.add(t);
        return t;
    }

    public CDSHooksRequest addPrefetch(CDSHooksRequestPrefetchComponent t) {
        if (t == null) {
            return this;
        }
        if (this.prefetch == null) {
            this.prefetch = new ArrayList<CDSHooksRequestPrefetchComponent>();
        }
        this.prefetch.add(t);
        return this;
    }

    public CDSHooksRequestPrefetchComponent getPrefetchFirstRep() {
        if (this.getPrefetch().isEmpty()) {
            this.addPrefetch();
        }
        return this.getPrefetch().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("hook", "code", "The hook that triggered this CDS Service call", 0, 1, this.hook));
        children.add(new Property("hookInstance", "uuid", "While working in the CDS Client, a user can perform multiple actions in series or in parallel. For example, a clinician might prescribe two drugs in a row; each prescription action would be assigned a unique hookInstance. This allows a CDS Service to uniquely identify each hook invocation", 0, 1, this.hookInstance));
        children.add(new Property("fhirServer", "url", "The base URL of the CDS Client's FHIR server. If fhirAuthorization is provided, this field is REQUIRED. The scheme MUST be https when production data is exchanged", 0, 1, this.fhirServer));
        children.add(new Property("fhirAuthorization", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "A structure holding an OAuth 2.0 bearer access token granting the CDS Service access to FHIR resources, along with supplemental information relating to the token", 0, 1, this.fhirAuthorization));
        children.add(new Property("context", "http://hl7.org/fhir/tools/StructureDefinition/CDSHookContext", "Hook-specific contextual data that the CDS service will need", 0, 1, this.context));
        children.add(new Property("prefetch", "Base", "An object containing key/value pairs of FHIR queries that this Request is requesting the CDS Client to perform and provide on each Request call. The key is a string that describes the type of data being requested and the value is a string representing the FHIR query", 0, Integer.MAX_VALUE, this.prefetch));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3208483: {
                return new Property("hook", "code", "The hook that triggered this CDS Service call", 0, 1, this.hook);
            }
            case -1195894056: {
                return new Property("hookInstance", "uuid", "While working in the CDS Client, a user can perform multiple actions in series or in parallel. For example, a clinician might prescribe two drugs in a row; each prescription action would be assigned a unique hookInstance. This allows a CDS Service to uniquely identify each hook invocation", 0, 1, this.hookInstance);
            }
            case 1314459790: {
                return new Property("fhirServer", "url", "The base URL of the CDS Client's FHIR server. If fhirAuthorization is provided, this field is REQUIRED. The scheme MUST be https when production data is exchanged", 0, 1, this.fhirServer);
            }
            case 331089102: {
                return new Property("fhirAuthorization", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement", "A structure holding an OAuth 2.0 bearer access token granting the CDS Service access to FHIR resources, along with supplemental information relating to the token", 0, 1, this.fhirAuthorization);
            }
            case 951530927: {
                return new Property("context", "http://hl7.org/fhir/tools/StructureDefinition/CDSHookContext", "Hook-specific contextual data that the CDS service will need", 0, 1, this.context);
            }
            case -1288666633: {
                return new Property("prefetch", "Base", "An object containing key/value pairs of FHIR queries that this Request is requesting the CDS Client to perform and provide on each Request call. The key is a string that describes the type of data being requested and the value is a string representing the FHIR query", 0, Integer.MAX_VALUE, this.prefetch);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3208483: {
                Base[] baseArray;
                if (this.hook == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.hook;
                }
                return baseArray;
            }
            case -1195894056: {
                Base[] baseArray;
                if (this.hookInstance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.hookInstance;
                }
                return baseArray;
            }
            case 1314459790: {
                Base[] baseArray;
                if (this.fhirServer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.fhirServer;
                }
                return baseArray;
            }
            case 331089102: {
                Base[] baseArray;
                if (this.fhirAuthorization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.fhirAuthorization;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case -1288666633: {
                return this.prefetch == null ? new Base[]{} : this.prefetch.toArray(new Base[this.prefetch.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3208483: {
                this.hook = TypeConvertor.castToCode(value);
                return value;
            }
            case -1195894056: {
                this.hookInstance = TypeConvertor.castToUuid(value);
                return value;
            }
            case 1314459790: {
                this.fhirServer = TypeConvertor.castToUrl(value);
                return value;
            }
            case 331089102: {
                this.fhirAuthorization = (CDSHooksRequestFhirAuthorizationComponent)value;
                return value;
            }
            case 951530927: {
                this.context = (CDSHookContext)value;
                return value;
            }
            case -1288666633: {
                this.getPrefetch().add((CDSHooksRequestPrefetchComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("hook")) {
            this.hook = TypeConvertor.castToCode(value);
        } else if (name.equals("hookInstance")) {
            this.hookInstance = TypeConvertor.castToUuid(value);
        } else if (name.equals("fhirServer")) {
            this.fhirServer = TypeConvertor.castToUrl(value);
        } else if (name.equals("fhirAuthorization")) {
            this.fhirAuthorization = (CDSHooksRequestFhirAuthorizationComponent)value;
        } else if (name.equals("context")) {
            this.context = (CDSHookContext)value;
        } else if (name.equals("prefetch")) {
            this.getPrefetch().add((CDSHooksRequestPrefetchComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3208483: {
                return this.getHookElement();
            }
            case -1195894056: {
                return this.getHookInstanceElement();
            }
            case 1314459790: {
                return this.getFhirServerElement();
            }
            case 331089102: {
                return this.getFhirAuthorization();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1288666633: {
                return this.addPrefetch();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3208483: {
                return new String[]{"code"};
            }
            case -1195894056: {
                return new String[]{"uuid"};
            }
            case 1314459790: {
                return new String[]{"url"};
            }
            case 331089102: {
                return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement"};
            }
            case 951530927: {
                return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHookContext"};
            }
            case -1288666633: {
                return new String[]{"Base"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("hook")) {
            throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.hook");
        }
        if (name.equals("hookInstance")) {
            throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.hookInstance");
        }
        if (name.equals("fhirServer")) {
            throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.fhirServer");
        }
        if (name.equals("fhirAuthorization")) {
            throw new FHIRException("Cannot call addChild on an abstract type CDSHooksRequest.fhirAuthorization");
        }
        if (name.equals("context")) {
            throw new FHIRException("Cannot call addChild on an abstract type CDSHooksRequest.context");
        }
        if (name.equals("prefetch")) {
            throw new FHIRException("Cannot call addChild on an abstract type CDSHooksRequest.prefetch");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CDSHooksRequest";
    }

    @Override
    public CDSHooksRequest copy() {
        CDSHooksRequest dst = new CDSHooksRequest();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CDSHooksRequest dst) {
        super.copyValues(dst);
        dst.hook = this.hook == null ? null : this.hook.copy();
        dst.hookInstance = this.hookInstance == null ? null : this.hookInstance.copy();
        dst.fhirServer = this.fhirServer == null ? null : this.fhirServer.copy();
        dst.fhirAuthorization = this.fhirAuthorization == null ? null : this.fhirAuthorization.copy();
        CDSHookContext cDSHookContext = dst.context = this.context == null ? null : this.context.copy();
        if (this.prefetch != null) {
            dst.prefetch = new ArrayList<CDSHooksRequestPrefetchComponent>();
            for (CDSHooksRequestPrefetchComponent i : this.prefetch) {
                dst.prefetch.add(i.copy());
            }
        }
    }

    protected CDSHooksRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksRequest)) {
            return false;
        }
        CDSHooksRequest o = (CDSHooksRequest)other_;
        return CDSHooksRequest.compareDeep(this.hook, o.hook, true) && CDSHooksRequest.compareDeep(this.hookInstance, o.hookInstance, true) && CDSHooksRequest.compareDeep(this.fhirServer, o.fhirServer, true) && CDSHooksRequest.compareDeep(this.fhirAuthorization, o.fhirAuthorization, true) && CDSHooksRequest.compareDeep(this.context, o.context, true) && CDSHooksRequest.compareDeep(this.prefetch, o.prefetch, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksRequest)) {
            return false;
        }
        CDSHooksRequest o = (CDSHooksRequest)other_;
        return CDSHooksRequest.compareValues(this.hook, o.hook, true) && CDSHooksRequest.compareValues(this.hookInstance, o.hookInstance, true) && CDSHooksRequest.compareValues(this.fhirServer, o.fhirServer, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.hook, this.hookInstance, this.fhirServer, this.fhirAuthorization, this.context, this.prefetch});
    }

    @Block
    public static class CDSHooksRequestPrefetchComponent
    extends LogicalBase {
        @Child(name="key", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Key of FHIR query - name for client to use when sending to Request", formalDefinition="Key of FHIR query - name for client to use when sending to Request")
        protected CodeType key;
        @Child(name="value", type={Resource.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of FHIR query - FHIR Query for client to perform", formalDefinition="Value of FHIR query - FHIR Query for client to perform")
        protected Resource value;
        private static final long serialVersionUID = -18668409L;

        public CDSHooksRequestPrefetchComponent() {
        }

        public CDSHooksRequestPrefetchComponent(String key, Resource value) {
            this.setKey(key);
            this.setValue(value);
        }

        public CodeType getKeyElement() {
            if (this.key == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksRequestPrefetchComponent.key");
                }
                if (Configuration.doAutoCreate()) {
                    this.key = new CodeType();
                }
            }
            return this.key;
        }

        public boolean hasKeyElement() {
            return this.key != null && !this.key.isEmpty();
        }

        public boolean hasKey() {
            return this.key != null && !this.key.isEmpty();
        }

        public CDSHooksRequestPrefetchComponent setKeyElement(CodeType value) {
            this.key = value;
            return this;
        }

        public String getKey() {
            return this.key == null ? null : (String)this.key.getValue();
        }

        public CDSHooksRequestPrefetchComponent setKey(String value) {
            if (this.key == null) {
                this.key = new CodeType();
            }
            this.key.setValue(value);
            return this;
        }

        public Resource getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CDSHooksRequestPrefetchComponent setValue(Resource value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("key", "code", "Key of FHIR query - name for client to use when sending to Request", 0, 1, this.key));
            children.add(new Property("value", "Resource", "Value of FHIR query - FHIR Query for client to perform", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106079: {
                    return new Property("key", "code", "Key of FHIR query - name for client to use when sending to Request", 0, 1, this.key);
                }
                case 111972721: {
                    return new Property("value", "Resource", "Value of FHIR query - FHIR Query for client to perform", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106079: {
                    Base[] baseArray;
                    if (this.key == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.key;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106079: {
                    this.key = TypeConvertor.castToCode(value);
                    return value;
                }
                case 111972721: {
                    this.value = (Resource)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("key")) {
                this.key = TypeConvertor.castToCode(value);
            } else if (name.equals("value")) {
                this.value = (Resource)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return this.getKeyElement();
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106079: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"Resource"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("key")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.prefetch.key");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on an abstract type CDSHooksRequest.prefetch.value");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksRequestPrefetchComponent copy() {
            CDSHooksRequestPrefetchComponent dst = new CDSHooksRequestPrefetchComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksRequestPrefetchComponent dst) {
            super.copyValues(dst);
            dst.key = this.key == null ? null : this.key.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksRequestPrefetchComponent)) {
                return false;
            }
            CDSHooksRequestPrefetchComponent o = (CDSHooksRequestPrefetchComponent)other_;
            return CDSHooksRequestPrefetchComponent.compareDeep(this.key, o.key, true) && CDSHooksRequestPrefetchComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksRequestPrefetchComponent)) {
                return false;
            }
            CDSHooksRequestPrefetchComponent o = (CDSHooksRequestPrefetchComponent)other_;
            return CDSHooksRequestPrefetchComponent.compareValues(this.key, o.key, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.key, this.value});
        }

        @Override
        public String fhirType() {
            return "CDSHooksRequest.prefetch";
        }
    }

    @Block
    public static class CDSHooksRequestFhirAuthorizationComponent
    extends CDSHooksElement {
        @Child(name="accessToken", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="This is the OAuth 2.0 access token that provides access to the FHIR server", formalDefinition="This is the OAuth 2.0 access token that provides access to the FHIR server")
        protected StringType accessToken;
        @Child(name="tokenType", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixed value: Bearer", formalDefinition="Fixed value: Bearer")
        protected CodeType tokenType;
        @Child(name="expiresIn", type={IntegerType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The lifetime in seconds of the access token.", formalDefinition="The lifetime in seconds of the access token.")
        protected IntegerType expiresIn;
        @Child(name="scope", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The scopes the access token grants the CDS Service", formalDefinition="The scopes the access token grants the CDS Service")
        protected StringType scope;
        @Child(name="subject", type={StringType.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server", formalDefinition="The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server")
        protected StringType subject;
        @Child(name="patient", type={IdType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server", formalDefinition="The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server")
        protected IdType patient;
        private static final long serialVersionUID = 265340325L;

        public CDSHooksRequestFhirAuthorizationComponent() {
        }

        public CDSHooksRequestFhirAuthorizationComponent(String accessToken, String tokenType, int expiresIn, String scope, String subject) {
            this.setAccessToken(accessToken);
            this.setTokenType(tokenType);
            this.setExpiresIn(expiresIn);
            this.setScope(scope);
            this.setSubject(subject);
        }

        public StringType getAccessTokenElement() {
            if (this.accessToken == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksRequestFhirAuthorizationComponent.accessToken");
                }
                if (Configuration.doAutoCreate()) {
                    this.accessToken = new StringType();
                }
            }
            return this.accessToken;
        }

        public boolean hasAccessTokenElement() {
            return this.accessToken != null && !this.accessToken.isEmpty();
        }

        public boolean hasAccessToken() {
            return this.accessToken != null && !this.accessToken.isEmpty();
        }

        public CDSHooksRequestFhirAuthorizationComponent setAccessTokenElement(StringType value) {
            this.accessToken = value;
            return this;
        }

        public String getAccessToken() {
            return this.accessToken == null ? null : (String)this.accessToken.getValue();
        }

        public CDSHooksRequestFhirAuthorizationComponent setAccessToken(String value) {
            if (this.accessToken == null) {
                this.accessToken = new StringType();
            }
            this.accessToken.setValue(value);
            return this;
        }

        public CodeType getTokenTypeElement() {
            if (this.tokenType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksRequestFhirAuthorizationComponent.tokenType");
                }
                if (Configuration.doAutoCreate()) {
                    this.tokenType = new CodeType();
                }
            }
            return this.tokenType;
        }

        public boolean hasTokenTypeElement() {
            return this.tokenType != null && !this.tokenType.isEmpty();
        }

        public boolean hasTokenType() {
            return this.tokenType != null && !this.tokenType.isEmpty();
        }

        public CDSHooksRequestFhirAuthorizationComponent setTokenTypeElement(CodeType value) {
            this.tokenType = value;
            return this;
        }

        public String getTokenType() {
            return this.tokenType == null ? null : (String)this.tokenType.getValue();
        }

        public CDSHooksRequestFhirAuthorizationComponent setTokenType(String value) {
            if (this.tokenType == null) {
                this.tokenType = new CodeType();
            }
            this.tokenType.setValue(value);
            return this;
        }

        public IntegerType getExpiresInElement() {
            if (this.expiresIn == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksRequestFhirAuthorizationComponent.expiresIn");
                }
                if (Configuration.doAutoCreate()) {
                    this.expiresIn = new IntegerType();
                }
            }
            return this.expiresIn;
        }

        public boolean hasExpiresInElement() {
            return this.expiresIn != null && !this.expiresIn.isEmpty();
        }

        public boolean hasExpiresIn() {
            return this.expiresIn != null && !this.expiresIn.isEmpty();
        }

        public CDSHooksRequestFhirAuthorizationComponent setExpiresInElement(IntegerType value) {
            this.expiresIn = value;
            return this;
        }

        public int getExpiresIn() {
            return this.expiresIn == null || this.expiresIn.isEmpty() ? 0 : (Integer)this.expiresIn.getValue();
        }

        public CDSHooksRequestFhirAuthorizationComponent setExpiresIn(int value) {
            if (this.expiresIn == null) {
                this.expiresIn = new IntegerType();
            }
            this.expiresIn.setValue((Object)value);
            return this;
        }

        public StringType getScopeElement() {
            if (this.scope == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksRequestFhirAuthorizationComponent.scope");
                }
                if (Configuration.doAutoCreate()) {
                    this.scope = new StringType();
                }
            }
            return this.scope;
        }

        public boolean hasScopeElement() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public boolean hasScope() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public CDSHooksRequestFhirAuthorizationComponent setScopeElement(StringType value) {
            this.scope = value;
            return this;
        }

        public String getScope() {
            return this.scope == null ? null : (String)this.scope.getValue();
        }

        public CDSHooksRequestFhirAuthorizationComponent setScope(String value) {
            if (this.scope == null) {
                this.scope = new StringType();
            }
            this.scope.setValue(value);
            return this;
        }

        public StringType getSubjectElement() {
            if (this.subject == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksRequestFhirAuthorizationComponent.subject");
                }
                if (Configuration.doAutoCreate()) {
                    this.subject = new StringType();
                }
            }
            return this.subject;
        }

        public boolean hasSubjectElement() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public boolean hasSubject() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public CDSHooksRequestFhirAuthorizationComponent setSubjectElement(StringType value) {
            this.subject = value;
            return this;
        }

        public String getSubject() {
            return this.subject == null ? null : (String)this.subject.getValue();
        }

        public CDSHooksRequestFhirAuthorizationComponent setSubject(String value) {
            if (this.subject == null) {
                this.subject = new StringType();
            }
            this.subject.setValue(value);
            return this;
        }

        public IdType getPatientElement() {
            if (this.patient == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CDSHooksRequestFhirAuthorizationComponent.patient");
                }
                if (Configuration.doAutoCreate()) {
                    this.patient = new IdType();
                }
            }
            return this.patient;
        }

        public boolean hasPatientElement() {
            return this.patient != null && !this.patient.isEmpty();
        }

        public boolean hasPatient() {
            return this.patient != null && !this.patient.isEmpty();
        }

        public CDSHooksRequestFhirAuthorizationComponent setPatientElement(IdType value) {
            this.patient = value;
            return this;
        }

        public String getPatient() {
            return this.patient == null ? null : this.patient.getValue();
        }

        public CDSHooksRequestFhirAuthorizationComponent setPatient(String value) {
            if (Utilities.noString((String)value)) {
                this.patient = null;
            } else {
                if (this.patient == null) {
                    this.patient = new IdType();
                }
                this.patient.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("accessToken", "string", "This is the OAuth 2.0 access token that provides access to the FHIR server", 0, 1, this.accessToken));
            children.add(new Property("tokenType", "code", "Fixed value: Bearer", 0, 1, this.tokenType));
            children.add(new Property("expiresIn", "integer", "The lifetime in seconds of the access token.", 0, 1, this.expiresIn));
            children.add(new Property("scope", "string", "The scopes the access token grants the CDS Service", 0, 1, this.scope));
            children.add(new Property("subject", "string", "The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server", 0, 1, this.subject));
            children.add(new Property("patient", "id", "The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server", 0, 1, this.patient));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1042689291: {
                    return new Property("accessToken", "string", "This is the OAuth 2.0 access token that provides access to the FHIR server", 0, 1, this.accessToken);
                }
                case 141498579: {
                    return new Property("tokenType", "code", "Fixed value: Bearer", 0, 1, this.tokenType);
                }
                case 250196857: {
                    return new Property("expiresIn", "integer", "The lifetime in seconds of the access token.", 0, 1, this.expiresIn);
                }
                case 109264468: {
                    return new Property("scope", "string", "The scopes the access token grants the CDS Service", 0, 1, this.scope);
                }
                case -1867885268: {
                    return new Property("subject", "string", "The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server", 0, 1, this.subject);
                }
                case -791418107: {
                    return new Property("patient", "id", "The OAuth 2.0 client identifier of the CDS Service, as registered with the CDS Client's authorization server", 0, 1, this.patient);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1042689291: {
                    Base[] baseArray;
                    if (this.accessToken == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.accessToken;
                    }
                    return baseArray;
                }
                case 141498579: {
                    Base[] baseArray;
                    if (this.tokenType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.tokenType;
                    }
                    return baseArray;
                }
                case 250196857: {
                    Base[] baseArray;
                    if (this.expiresIn == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.expiresIn;
                    }
                    return baseArray;
                }
                case 109264468: {
                    Base[] baseArray;
                    if (this.scope == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.scope;
                    }
                    return baseArray;
                }
                case -1867885268: {
                    Base[] baseArray;
                    if (this.subject == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.subject;
                    }
                    return baseArray;
                }
                case -791418107: {
                    Base[] baseArray;
                    if (this.patient == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.patient;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1042689291: {
                    this.accessToken = TypeConvertor.castToString(value);
                    return value;
                }
                case 141498579: {
                    this.tokenType = TypeConvertor.castToCode(value);
                    return value;
                }
                case 250196857: {
                    this.expiresIn = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 109264468: {
                    this.scope = TypeConvertor.castToString(value);
                    return value;
                }
                case -1867885268: {
                    this.subject = TypeConvertor.castToString(value);
                    return value;
                }
                case -791418107: {
                    this.patient = TypeConvertor.castToId(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("accessToken")) {
                this.accessToken = TypeConvertor.castToString(value);
            } else if (name.equals("tokenType")) {
                this.tokenType = TypeConvertor.castToCode(value);
            } else if (name.equals("expiresIn")) {
                this.expiresIn = TypeConvertor.castToInteger(value);
            } else if (name.equals("scope")) {
                this.scope = TypeConvertor.castToString(value);
            } else if (name.equals("subject")) {
                this.subject = TypeConvertor.castToString(value);
            } else if (name.equals("patient")) {
                this.patient = TypeConvertor.castToId(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1042689291: {
                    return this.getAccessTokenElement();
                }
                case 141498579: {
                    return this.getTokenTypeElement();
                }
                case 250196857: {
                    return this.getExpiresInElement();
                }
                case 109264468: {
                    return this.getScopeElement();
                }
                case -1867885268: {
                    return this.getSubjectElement();
                }
                case -791418107: {
                    return this.getPatientElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1042689291: {
                    return new String[]{"string"};
                }
                case 141498579: {
                    return new String[]{"code"};
                }
                case 250196857: {
                    return new String[]{"integer"};
                }
                case 109264468: {
                    return new String[]{"string"};
                }
                case -1867885268: {
                    return new String[]{"string"};
                }
                case -791418107: {
                    return new String[]{"id"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("accessToken")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.fhirAuthorization.accessToken");
            }
            if (name.equals("tokenType")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.fhirAuthorization.tokenType");
            }
            if (name.equals("expiresIn")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.fhirAuthorization.expiresIn");
            }
            if (name.equals("scope")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.fhirAuthorization.scope");
            }
            if (name.equals("subject")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.fhirAuthorization.subject");
            }
            if (name.equals("patient")) {
                throw new FHIRException("Cannot call addChild on a singleton property CDSHooksRequest.fhirAuthorization.patient");
            }
            return super.addChild(name);
        }

        @Override
        public CDSHooksRequestFhirAuthorizationComponent copy() {
            CDSHooksRequestFhirAuthorizationComponent dst = new CDSHooksRequestFhirAuthorizationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CDSHooksRequestFhirAuthorizationComponent dst) {
            super.copyValues(dst);
            dst.accessToken = this.accessToken == null ? null : this.accessToken.copy();
            dst.tokenType = this.tokenType == null ? null : this.tokenType.copy();
            dst.expiresIn = this.expiresIn == null ? null : this.expiresIn.copy();
            dst.scope = this.scope == null ? null : this.scope.copy();
            dst.subject = this.subject == null ? null : this.subject.copy();
            dst.patient = this.patient == null ? null : this.patient.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksRequestFhirAuthorizationComponent)) {
                return false;
            }
            CDSHooksRequestFhirAuthorizationComponent o = (CDSHooksRequestFhirAuthorizationComponent)other_;
            return CDSHooksRequestFhirAuthorizationComponent.compareDeep(this.accessToken, o.accessToken, true) && CDSHooksRequestFhirAuthorizationComponent.compareDeep(this.tokenType, o.tokenType, true) && CDSHooksRequestFhirAuthorizationComponent.compareDeep(this.expiresIn, o.expiresIn, true) && CDSHooksRequestFhirAuthorizationComponent.compareDeep(this.scope, o.scope, true) && CDSHooksRequestFhirAuthorizationComponent.compareDeep(this.subject, o.subject, true) && CDSHooksRequestFhirAuthorizationComponent.compareDeep(this.patient, o.patient, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CDSHooksRequestFhirAuthorizationComponent)) {
                return false;
            }
            CDSHooksRequestFhirAuthorizationComponent o = (CDSHooksRequestFhirAuthorizationComponent)other_;
            return CDSHooksRequestFhirAuthorizationComponent.compareValues(this.accessToken, o.accessToken, true) && CDSHooksRequestFhirAuthorizationComponent.compareValues(this.tokenType, o.tokenType, true) && CDSHooksRequestFhirAuthorizationComponent.compareValues(this.expiresIn, o.expiresIn, true) && CDSHooksRequestFhirAuthorizationComponent.compareValues(this.scope, o.scope, true) && CDSHooksRequestFhirAuthorizationComponent.compareValues(this.subject, o.subject, true) && CDSHooksRequestFhirAuthorizationComponent.compareValues(this.patient, o.patient, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.accessToken, this.tokenType, this.expiresIn, this.scope, this.subject, this.patient});
        }

        @Override
        public String fhirType() {
            return "CDSHooksRequest.fhirAuthorization";
        }
    }
}

