/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.tools.CDSHooksExtensions;

@DatatypeDef(name="CDSHooksElement")
public abstract class CDSHooksElement
extends LogicalBase
implements ICompositeType {
    @Child(name="extension", type={CDSHooksExtensions.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Object that has Named Extension Properties", formalDefinition="A JSON object that has properties where the names are defined by the extension definitions")
    protected CDSHooksExtensions extension;
    private static final long serialVersionUID = 362241525L;

    public CDSHooksExtensions getExtension() {
        if (this.extension == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CDSHooksElement.extension");
            }
            if (Configuration.doAutoCreate()) {
                this.extension = new CDSHooksExtensions();
            }
        }
        return this.extension;
    }

    public boolean hasExtension() {
        return this.extension != null && !this.extension.isEmpty();
    }

    public CDSHooksElement setExtension(CDSHooksExtensions value) {
        this.extension = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("extension", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksExtensions", "A JSON object that has properties where the names are defined by the extension definitions", 0, 1, this.extension));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -612557761: {
                return new Property("extension", "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksExtensions", "A JSON object that has properties where the names are defined by the extension definitions", 0, 1, this.extension);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -612557761: {
                Base[] baseArray;
                if (this.extension == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.extension;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -612557761: {
                this.extension = (CDSHooksExtensions)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("extension")) {
            return super.setProperty(name, value);
        }
        this.extension = (CDSHooksExtensions)value;
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -612557761: {
                return this.getExtension();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -612557761: {
                return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/CDSHooksExtensions"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("extension")) {
            this.extension = new CDSHooksExtensions();
            return this.extension;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CDSHooksElement";
    }

    @Override
    public abstract CDSHooksElement copy();

    public void copyValues(CDSHooksElement dst) {
        super.copyValues(dst);
        dst.extension = this.extension == null ? null : this.extension.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksElement)) {
            return false;
        }
        CDSHooksElement o = (CDSHooksElement)other_;
        return CDSHooksElement.compareDeep(this.extension, o.extension, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksElement)) {
            return false;
        }
        CDSHooksElement o = (CDSHooksElement)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.extension});
    }
}

