/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.testfactory.dataprovider;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.testfactory.dataprovider.TableDataProvider;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class ValueSetDataProvider
extends TableDataProvider {
    ValueSet.ValueSetExpansionComponent expansion;
    private List<ColumnSpecifier> columns;
    private List<String> columnNames;
    private int cursor;

    public ValueSetDataProvider(ValueSet.ValueSetExpansionComponent expansion) {
        this.expansion = expansion;
        this.process();
    }

    private void process() {
        this.columns = new ArrayList<ColumnSpecifier>();
        this.columns.add(new ColumnSpecifier("counter", ColumnSpecifierType.COUNTER));
        this.columns.add(new ColumnSpecifier("system", ColumnSpecifierType.SYSTEM));
        this.columns.add(new ColumnSpecifier("version", ColumnSpecifierType.VERSION));
        this.columns.add(new ColumnSpecifier("code", ColumnSpecifierType.CODE));
        this.columns.add(new ColumnSpecifier("display", ColumnSpecifierType.DISPLAY));
        this.columns.add(new ColumnSpecifier("abstract", ColumnSpecifierType.ABSTRACT));
        this.columns.add(new ColumnSpecifier("inactive", ColumnSpecifierType.INACTIVE));
        for (ValueSet.ValueSetExpansionContainsComponent cc : this.expansion.getContains()) {
            for (ValueSet.ConceptPropertyComponent p : cc.getProperty()) {
                if (this.hasColumn(ColumnSpecifierType.PROPERTY, p.getCode())) continue;
                this.columns.add(new ColumnSpecifier("property." + p.getCode(), ColumnSpecifierType.PROPERTY, p.getCode()));
            }
        }
        this.columnNames = new ArrayList<String>();
        for (ColumnSpecifier sp : this.columns) {
            this.columnNames.add(sp.name);
        }
    }

    private boolean hasColumn(ColumnSpecifierType type, String details) {
        for (ColumnSpecifier sp : this.columns) {
            if (sp.type != type || !details.equals(sp.details)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> columns() {
        return this.columnNames;
    }

    @Override
    public boolean nextRow() throws FHIRException {
        ++this.cursor;
        return this.cursor < this.expansion.getContains().size();
    }

    @Override
    public List<String> cells() throws FHIRException {
        ArrayList<String> cells = new ArrayList<String>();
        ValueSet.ValueSetExpansionContainsComponent cc = this.expansion.getContains().get(this.cursor);
        block10: for (ColumnSpecifier sp : this.columns) {
            switch (sp.type) {
                case ABSTRACT: {
                    cells.add("" + cc.getAbstract());
                    break;
                }
                case CODE: {
                    cells.add(cc.getCode());
                    break;
                }
                case COUNTER: {
                    cells.add("" + this.cursor);
                    break;
                }
                case DISPLAY: {
                    cells.add(cc.getDisplay());
                    break;
                }
                case INACTIVE: {
                    cells.add("" + cc.getInactive());
                    break;
                }
                case PROPERTY: {
                    for (ValueSet.ConceptPropertyComponent p : cc.getProperty()) {
                        if (!sp.details.equals(p.getCode())) continue;
                        cells.add(p.getValue().primitiveValue());
                    }
                    continue block10;
                }
                case SYSTEM: {
                    cells.add(cc.getSystem());
                    break;
                }
                case VERSION: {
                    cells.add(cc.getVersion());
                    break;
                }
            }
        }
        return cells;
    }

    @Override
    public String cell(String name) throws FHIRException {
        int i = this.columns.indexOf(name);
        return i == -1 ? null : this.cells().get(i);
    }

    @Override
    public void reset() throws FHIRException {
        this.cursor = -1;
    }

    public class ColumnSpecifier {
        private String name;
        private ColumnSpecifierType type;
        private String details;

        public ColumnSpecifier(String name, ColumnSpecifierType type) {
            this.name = name;
            this.type = type;
        }

        public ColumnSpecifier(String name, ColumnSpecifierType type, String details) {
            this.name = name;
            this.type = type;
            this.details = details;
        }
    }

    public static enum ColumnSpecifierType {
        COUNTER,
        SYSTEM,
        VERSION,
        CODE,
        DISPLAY,
        ABSTRACT,
        INACTIVE,
        PROPERTY;

    }
}

