/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.testfactory.dataprovider;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.testfactory.dataprovider.TableDataProvider;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

@MarkedToMoveToAdjunctPackage
public class ExcelDataProvider
extends TableDataProvider {
    private Workbook workbook;
    private Sheet sheet;
    private List<String> columnHeaders;
    private int currentRowIndex = -1;
    private Map<String, Integer> columnIndexMap = new HashMap<String, Integer>();
    private Row currentRow;
    private DataFormatter df;
    private int startRow = 0;
    private int startCol = 0;
    private int endRow = -1;
    private int endCol = -1;

    public ExcelDataProvider(String filename, String sheetName, String range, Locale locale) throws IOException, InvalidFormatException {
        FileInputStream fis = new FileInputStream(ManagedFileAccess.file((String)filename));
        this.workbook = WorkbookFactory.create((InputStream)fis);
        if (sheetName != null) {
            this.sheet = this.workbook.getSheet(sheetName);
        }
        this.df = new DataFormatter(locale);
        if (this.sheet == null) {
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                names.add(this.workbook.getSheetName(i));
            }
            if (sheetName == null && names.size() > 0) {
                this.sheet = this.workbook.getSheet((String)names.get(0));
            } else {
                throw new IllegalArgumentException("Sheet '" + sheetName + "' does not exist in the file. Sheet Names = " + CommaSeparatedStringBuilder.join((String)",", names));
            }
        }
        if (range != null) {
            String[] parts = range.split(":");
            CellReference startCell = new CellReference(parts[0]);
            this.startRow = startCell.getRow();
            this.startCol = startCell.getCol();
            if (parts.length == 2) {
                CellReference endCell = new CellReference(parts[1]);
                this.endRow = endCell.getRow();
                this.endCol = endCell.getCol();
            }
        }
        this.loadColumnHeaders();
    }

    public ExcelDataProvider(String filename) throws InvalidFormatException, IOException {
        FileInputStream fis = new FileInputStream(ManagedFileAccess.file((String)filename));
        this.workbook = WorkbookFactory.create((InputStream)fis);
        this.sheet = this.workbook.getSheetAt(0);
        this.loadColumnHeaders();
    }

    private void loadColumnHeaders() {
        this.columnHeaders = new ArrayList<String>();
        this.columnHeaders.add("counter");
        Row headerRow = this.sheet.getRow(this.startRow);
        if (headerRow != null) {
            for (Cell cell : headerRow) {
                if (cell.getColumnIndex() < this.startCol || this.endCol != -1 && cell.getColumnIndex() > this.endCol) continue;
                String headerName = cell.getStringCellValue().trim();
                this.columnHeaders.add(headerName);
                this.columnIndexMap.put(headerName, cell.getColumnIndex());
            }
        }
    }

    @Override
    public List<String> columns() {
        return this.columnHeaders;
    }

    @Override
    public boolean nextRow() {
        ++this.currentRowIndex;
        this.currentRow = this.sheet.getRow(this.startRow + this.currentRowIndex + 1);
        if (this.currentRow != null && this.endRow != -1 && this.endRow == this.startRow + this.currentRowIndex) {
            this.currentRow = null;
        }
        return this.currentRow != null;
    }

    @Override
    public List<String> cells() {
        ArrayList<String> cellValues = new ArrayList<String>();
        cellValues.add("" + (this.currentRowIndex + 1));
        if (this.currentRow != null) {
            for (Cell cell : this.currentRow) {
                int i = cell.getColumnIndex();
                if (i < this.startCol || this.endCol != -1 && i > this.endCol) continue;
                while (cellValues.size() <= i - this.startCol) {
                    cellValues.add("");
                }
                cellValues.add(this.getCellValue(cell).trim());
            }
        }
        return cellValues;
    }

    @Override
    public String cell(String name) {
        if ("counter".equals(name)) {
            return "" + this.currentRowIndex;
        }
        Integer columnIndex = this.columnIndexMap.get(name);
        if (columnIndex == null || this.currentRow == null) {
            return null;
        }
        Cell cell = this.currentRow.getCell(columnIndex.intValue());
        return cell == null ? null : this.getCellValue(cell).trim();
    }

    private String getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return this.df.formatCellValue(cell);
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case BLANK: {
                return "";
            }
        }
        return "";
    }

    public void close() throws IOException {
        if (this.workbook != null) {
            this.workbook.close();
        }
    }

    @Override
    public void reset() throws FHIRException {
        this.currentRowIndex = -1;
    }
}

