/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class ProvenanceRenderer
extends ResourceRenderer {
    public ProvenanceRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper prv) throws UnsupportedEncodingException, IOException {
        return this.context.formatPhrase("PROV_FOR", new Object[]{this.displayReference(prv.firstChild("target"))}) + " ";
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper prv) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode tr;
        this.renderResourceTechDetails(prv, x);
        if (prv.has("target")) {
            List<ResourceWrapper> tl = prv.children("target");
            if (tl.size() == 1) {
                XhtmlNode p = x.para();
                p.tx(this.context.formatPhrase("PROV_PROV", new Object[0]) + " ");
                this.renderReference(status, p, tl.get(0));
            } else {
                x.para().tx(this.context.formatPhrase("PROV_PROVE", new Object[0]) + " ");
                XhtmlNode ul = x.ul();
                for (ResourceWrapper ref : tl) {
                    this.renderReference(status, ul.li(), ref);
                }
            }
        }
        x.para().tx(this.context.formatPhrase("GENERAL_SUMM", new Object[0]));
        XhtmlNode t = x.table("grid", false);
        if (prv.has("occurred")) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_OCC", new Object[0]));
            this.renderDataType(status, tr.td(), prv.child("occurred"));
        }
        if (prv.has("recorded")) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_REC", new Object[0]));
            this.renderDataType(status, tr.td(), prv.child("recorded"));
        }
        if (prv.has("policy")) {
            List<ResourceWrapper> tl = prv.children("policy");
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_POL", new Object[0]));
            if (tl.size() == 1) {
                this.renderDataType(status, tr.td(), tl.get(0));
            } else {
                XhtmlNode ul = tr.td().ul();
                for (ResourceWrapper u : tl) {
                    this.renderDataType(status, ul.li(), u);
                }
            }
        }
        if (prv.has("location")) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_LOCATION", new Object[0]));
            this.renderDataType(status, tr.td(), prv.child("location"));
        }
        if (prv.has("activity")) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_ACT", new Object[0]));
            this.renderDataType(status, tr.td(), prv.child("activity"));
        }
        boolean hasType = false;
        boolean hasRole = false;
        boolean hasOnBehalfOf = false;
        for (ResourceWrapper a : prv.children("agent")) {
            hasType = hasType || a.has("type");
            hasRole = hasRole || a.has("role");
            hasOnBehalfOf = hasOnBehalfOf || a.has("onBehalfOf");
        }
        x.para().b().tx(this.context.formatPhrase("PROV_AGE", new Object[0]));
        t = x.table("grid", false);
        tr = t.tr();
        if (hasType) {
            tr.td().b().tx(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        }
        if (hasRole) {
            tr.td().b().tx(this.context.formatPhrase("PROV_ROLE", new Object[0]));
        }
        tr.td().b().tx(this.context.formatPhrase("PROV_WHO", new Object[0]));
        if (hasOnBehalfOf) {
            tr.td().b().tx(this.context.formatPhrase("PROV_BEHALF", new Object[0]));
        }
        for (ResourceWrapper a : prv.children("agent")) {
            tr = t.tr();
            if (hasType) {
                if (a.has("type")) {
                    this.renderDataType(status, tr.td(), a.child("type"));
                } else {
                    tr.td();
                }
            }
            if (hasRole) {
                List<ResourceWrapper> tl = prv.children("role");
                if (tl.size() == 0) {
                    tr.td();
                } else if (tl.size() == 1) {
                    this.renderCodeableConcept(status, tr.td(), tl.get(0));
                } else {
                    XhtmlNode ul = tr.td().ul();
                    for (ResourceWrapper cc : tl) {
                        this.renderCodeableConcept(status, ul.li(), cc);
                    }
                }
            }
            if (a.has("who")) {
                this.renderReference(status, tr.td(), a.child("who"));
            } else {
                tr.td();
            }
            if (!hasOnBehalfOf) continue;
            if (a.has("onBehalfOf")) {
                this.renderReference(status, tr.td(), a.child("onBehalfOf"));
                continue;
            }
            tr.td();
        }
    }
}

