/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class OperationDefinitionRenderer
extends TerminologyRenderer {
    public static final String EXT_OPDEF_ORIGINAL_TYPE = "http://hl7.org/fhir/4.0/StructureDefinition/extension-OperationDefinition.parameter.type";

    public OperationDefinitionRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (r.isDirect()) {
            this.renderResourceTechDetails(r, x);
            this.genSummaryTable(status, x, (OperationDefinition)r.getBase());
            this.render(status, x, (OperationDefinition)r.getBase());
        } else {
            x.para().tx("OperationDefinitionRenderer only renders native resources directly");
        }
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, OperationDefinition opd) throws IOException, FHIRException, EOperationOutcome {
        StructureDefinition sd;
        XhtmlNode p;
        if (this.context.isShowSummaryTable()) {
            x.h2().addText(opd.getName());
            x.para().addText(Utilities.capitalize((String)opd.getKind().toString()) + ": " + opd.getName());
            x.para().tx(this.context.formatPhrase("OP_DEF_OFFIC", new Object[0]) + " ");
            x.pre().tx(opd.getUrl());
            this.addMarkdown(x, opd.getDescription());
        }
        if (opd.getSystem()) {
            x.para().tx(this.context.formatPhrase("OP_DEF_URLS", new Object[]{opd.getCode()}));
        }
        for (Enumeration<Enumerations.VersionIndependentResourceTypesAll> c : opd.getResource()) {
            if (opd.getType()) {
                x.para().tx(this.context.formatPhrase("OP_DEF_URL", new Object[]{c.getCode() + "/$" + opd.getCode()}));
            }
            if (!opd.getInstance()) continue;
            x.para().tx(this.context.formatPhrase("OP_DEF_URL", new Object[]{c.getCode() + "/[id]/$" + opd.getCode()}));
        }
        if (opd.hasInputProfile()) {
            p = x.para();
            p.tx(this.context.formatPhrase("OP_DEF_INPAR", new Object[0]));
            sd = this.context.getContext().fetchResource(StructureDefinition.class, opd.getInputProfile(), opd);
            if (sd == null) {
                p.pre().tx(opd.getInputProfile());
            } else {
                p.ah(this.context.prefixLocalHref(sd.getWebPath())).tx(sd.present());
            }
        }
        if (opd.hasOutputProfile()) {
            p = x.para();
            p.tx(this.context.formatPhrase("OP_DEF_OUTPAR", new Object[0]));
            sd = this.context.getContext().fetchResource(StructureDefinition.class, opd.getOutputProfile(), opd);
            if (sd == null) {
                p.pre().tx(opd.getOutputProfile());
            } else {
                p.ah(this.context.prefixLocalHref(sd.getWebPath())).tx(sd.present());
            }
        }
        x.h3().tx(this.context.formatPhrase("GENERAL_PARS", new Object[0]));
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx(this.context.formatPhrase("OP_DEF_USE", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("GENERAL_NAME", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("OP_DEF_SCO", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("GENERAL_CARDINALITY", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("GENERAL_BINDING", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("GENERAL_DOCUMENTATION", new Object[0]));
        for (OperationDefinition.OperationDefinitionParameterComponent p2 : opd.getParameter()) {
            this.genOpParam(tbl, "", p2, opd);
        }
        this.addMarkdown(x, opd.getComment());
    }

    public void describe(XhtmlNode x, OperationDefinition opd) {
        x.tx(this.display(opd));
    }

    public String display(OperationDefinition opd) {
        return opd.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((OperationDefinition)r).present();
    }

    private void genOpParam(XhtmlNode tbl, String path, OperationDefinition.OperationDefinitionParameterComponent p, Resource opd) throws EOperationOutcome, FHIRException, IOException {
        StructureDefinition sdt;
        String s;
        StructureDefinition sd;
        XhtmlNode tr = tbl.tr();
        tr.td().addText(p.getUse().toString());
        XhtmlNode td = tr.td();
        td.addText(path + p.getName());
        StandardsStatus ss = ToolingExtensions.getStandardsStatus(p);
        this.genStandardsStatus(td, ss);
        td = tr.td();
        if (p.hasScope()) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Enumeration<OperationDefinition.OperationParameterScope> s2 : p.getScope()) {
                b.append(s2.getCode());
            }
            td.tx(b.toString());
        }
        tr.td().addText(Integer.toString(p.getMin()) + ".." + p.getMax());
        td = tr.td();
        String actualType = this.translateTypeToVersion(p.getTypeElement());
        StructureDefinition structureDefinition = sd = actualType != null ? this.context.getWorker().fetchTypeDefinition(actualType) : null;
        if (sd == null) {
            td.tx(p.hasType() ? actualType : "");
        } else if (sd.getAbstract() && p.hasExtension("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
            boolean first = true;
            for (Extension extension : p.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(" | ");
                }
                s = extension.getValue().primitiveValue();
                sdt = this.context.getWorker().fetchTypeDefinition(s);
                if (sdt == null) {
                    td.tx(p.hasType() ? actualType : "");
                    continue;
                }
                td.ah(this.context.prefixLocalHref(sdt.getWebPath())).tx(s);
            }
        } else if (sd.getAbstract() && p.hasAllowedType()) {
            boolean first = true;
            for (Enumeration enumeration : p.getAllowedType()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(" | ");
                }
                s = enumeration.primitiveValue();
                sdt = this.context.getWorker().fetchTypeDefinition(s);
                if (sdt == null) {
                    td.tx(p.hasType() ? actualType : "");
                    continue;
                }
                td.ah(this.context.prefixLocalHref(sdt.getWebPath())).tx(s);
            }
        } else {
            td.ah(this.context.prefixLocalHref(sd.getWebPath())).tx(actualType);
        }
        if (p.hasTargetProfile()) {
            td.tx(" (");
            boolean first = true;
            for (CanonicalType canonicalType : p.getTargetProfile()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                StructureDefinition sdt2 = this.context.getWorker().fetchTypeDefinition(canonicalType.asStringValue());
                if (sdt2 == null || !sdt2.hasWebPath()) {
                    td.code().tx(canonicalType.asStringValue());
                    continue;
                }
                td.ah(this.context.prefixLocalHref(sdt2.getWebPath()), canonicalType.asStringValue()).tx(sdt2.present());
            }
            td.tx(")");
        }
        if (p.hasSearchType()) {
            td.br();
            td.tx("(");
            td.ah(this.context.prefixLocalHref((String)(this.context.getLink(RenderingContext.KnownLinkType.SPEC) == null ? "search.html#" + p.getSearchType().toCode() : Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "search.html#" + p.getSearchType().toCode()})))).tx(p.getSearchType().toCode());
            td.tx(")");
        }
        td = tr.td();
        if (p.hasBinding() && p.getBinding().hasValueSet()) {
            this.AddVsRef(p.getBinding().getValueSet(), td, opd);
            td.tx(" (" + p.getBinding().getStrength().getDisplay() + ")");
        }
        this.addMarkdown(tr.td(), p.getDocumentation());
        if (!p.hasType()) {
            for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
                this.genOpParam(tbl, path + p.getName() + ".", pp, opd);
            }
        }
    }

    private String translateTypeToVersion(Enumeration<Enumerations.FHIRTypes> src) {
        if (src.hasExtension(EXT_OPDEF_ORIGINAL_TYPE)) {
            return src.getExtensionString(EXT_OPDEF_ORIGINAL_TYPE);
        }
        return src.asStringValue();
    }
}

