/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class LibraryRenderer
extends ResourceRenderer {
    private static final int DATA_IMG_SIZE_CUTOFF = 4000;

    public LibraryRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper lib) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        List<ResourceWrapper> contents;
        List<ResourceWrapper> dataRequirements;
        List<ResourceWrapper> parameters;
        List<ResourceWrapper> artifacts;
        this.renderResourceTechDetails(lib, x);
        this.genSummaryTable(status, x, (CanonicalResource)lib.getResourceNative());
        List<ResourceWrapper> authors = lib.children("author");
        List<ResourceWrapper> editors = lib.children("editor");
        List<ResourceWrapper> reviewers = lib.children("reviewer");
        List<ResourceWrapper> endorsers = lib.children("endorser");
        if (!(authors.isEmpty() && editors.isEmpty() && reviewers.isEmpty() && endorsers.isEmpty())) {
            boolean email = this.hasCT(authors, "email") || this.hasCT(editors, "email") || this.hasCT(reviewers, "email") || this.hasCT(endorsers, "email");
            boolean phone = this.hasCT(authors, "phone") || this.hasCT(editors, "phone") || this.hasCT(reviewers, "phone") || this.hasCT(endorsers, "phone");
            boolean url = this.hasCT(authors, "url") || this.hasCT(editors, "url") || this.hasCT(reviewers, "url") || this.hasCT(endorsers, "url");
            x.h2().tx(this.context.formatPhrase("LIB_REND_PAR", new Object[0]));
            XhtmlNode t = x.table("grid", false);
            for (ResourceWrapper resourceWrapper : authors) {
                this.participantRow(status, t, this.context.formatPhrase("LIB_REND_AUT", new Object[0]), resourceWrapper, email, phone, url);
            }
            for (ResourceWrapper resourceWrapper : editors) {
                this.participantRow(status, t, this.context.formatPhrase("LIB_REND_ED", new Object[0]), resourceWrapper, email, phone, url);
            }
            for (ResourceWrapper resourceWrapper : reviewers) {
                this.participantRow(status, t, this.context.formatPhrase("LIB_REND_REV", new Object[0]), resourceWrapper, email, phone, url);
            }
            for (ResourceWrapper resourceWrapper : endorsers) {
                this.participantRow(status, t, this.context.formatPhrase("LIB_REND_END", new Object[0]), resourceWrapper, email, phone, url);
            }
        }
        if (!(artifacts = lib.children("relatedArtifact")).isEmpty()) {
            x.h2().tx(this.context.formatPhrase("LIB_REND_ART", new Object[0]));
            XhtmlNode t = x.table("grid", false);
            boolean label = false;
            boolean display = false;
            boolean citation = false;
            for (ResourceWrapper ra : artifacts) {
                label = label || ra.has("label");
                display = display || ra.has("display");
                citation = citation || ra.has("citation");
            }
            for (ResourceWrapper ra : artifacts) {
                this.renderArtifact(status, t, ra, lib, label, display, citation);
            }
        }
        if (!(parameters = lib.children("parameter")).isEmpty()) {
            x.h2().tx(this.context.formatPhrase("GENERAL_PARS", new Object[0]));
            XhtmlNode t = x.table("grid", false);
            boolean doco = false;
            for (ResourceWrapper resourceWrapper : parameters) {
                doco = doco || resourceWrapper.has("documentation");
            }
            for (ResourceWrapper resourceWrapper : parameters) {
                this.renderParameter(t, resourceWrapper, doco);
            }
        }
        if (!(dataRequirements = lib.children("dataRequirement")).isEmpty()) {
            x.h2().tx(this.context.formatPhrase("LIB_REND_REQ", new Object[0]));
            for (ResourceWrapper p : dataRequirements) {
                this.renderDataRequirement(status, x, p);
            }
        }
        if (!(contents = lib.children("content")).isEmpty()) {
            x.h2().tx(this.context.formatPhrase("LIB_REND_CONT", new Object[0]));
            boolean isCql = false;
            boolean bl = false;
            for (ResourceWrapper p : contents) {
                void var13_39;
                this.renderAttachment(x, p, isCql, (int)var13_39, lib.getId());
                isCql = isCql || p.has("contentType") && p.primitiveValue("contentType").startsWith("text/cql");
                ++var13_39;
            }
        }
    }

    private boolean hasCT(List<ResourceWrapper> list, String type) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ResourceWrapper cd : list) {
            List<ResourceWrapper> telecoms = cd.children("telecom");
            if (!this.hasContactPoint(telecoms, type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasContactPoint(List<ResourceWrapper> list, String type) {
        for (ResourceWrapper cd : list) {
            for (ResourceWrapper t : cd.children("telecom")) {
                if (!type.equals(t.primitiveValue("system"))) continue;
                return true;
            }
        }
        return false;
    }

    private ResourceWrapper getContactPoint(List<ResourceWrapper> list, String type) {
        for (ResourceWrapper cd : list) {
            for (ResourceWrapper t : cd.children("telecom")) {
                if (!type.equals(t.primitiveValue("system"))) continue;
                return t;
            }
        }
        return null;
    }

    private void renderParameter(XhtmlNode t, ResourceWrapper p, boolean doco) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = t.tr();
        tr.td().tx(p.has("name") ? p.primitiveValue("name") : null);
        tr.td().tx(p.has("use") ? p.primitiveValue("use") : null);
        tr.td().tx(p.has("min") ? p.primitiveValue("min") : null);
        tr.td().tx(p.has("max") ? p.primitiveValue("max") : null);
        tr.td().tx(p.has("type") ? p.primitiveValue("type") : null);
        if (doco) {
            tr.td().tx(p.has("documentation") ? p.primitiveValue("documentation") : null);
        }
    }

    private void renderArtifact(Renderer.RenderingStatus status, XhtmlNode t, ResourceWrapper ra, ResourceWrapper lib, boolean label, boolean display, boolean citation) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = t.tr();
        tr.td().tx(ra.has("type") ? this.getTranslatedCode(ra.child("type")) : null);
        if (label) {
            tr.td().tx(ra.has("label") ? ra.primitiveValue("label") : null);
        }
        if (display) {
            tr.td().tx(ra.has("display") ? ra.primitiveValue("display") : null);
        }
        if (citation) {
            tr.td().markdown(ra.has("citation") ? ra.primitiveValue("citation") : null, "Citation");
        }
        if (ra.has("resource")) {
            this.renderCanonical(status, tr.td(), Resource.class, ra.child("resource"));
        } else {
            tr.td().tx(ra.has("url") ? ra.primitiveValue("url") : null);
        }
    }

    private void participantRow(Renderer.RenderingStatus status, XhtmlNode t, String label, ResourceWrapper cd, boolean email, boolean phone, boolean url) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = t.tr();
        tr.td().tx(label);
        tr.td().tx(cd.has("name") ? cd.primitiveValue("name") : null);
        List<ResourceWrapper> telecoms = cd.children("telecom");
        if (email) {
            this.renderContactPoint(status, tr.td(), this.getContactPoint(telecoms, "email"));
        }
        if (phone) {
            this.renderContactPoint(status, tr.td(), this.getContactPoint(telecoms, "phone"));
        }
        if (url) {
            this.renderContactPoint(status, tr.td(), this.getContactPoint(telecoms, "url"));
        }
    }

    private void renderAttachment(XhtmlNode x, ResourceWrapper att, boolean noShowData, int counter, String baseId) {
        boolean ref;
        String url = att.primitiveValue("url");
        String title = att.primitiveValue("title");
        String ct = att.primitiveValue("contentType");
        boolean bl = ref = !att.has("data") && att.has("url");
        if (ref) {
            Resource res;
            XhtmlNode p = x.para();
            if (att.has("title")) {
                p.tx(title);
                p.tx(": ");
            }
            if ((res = this.context.getContext().fetchResource(Resource.class, url)) == null || !res.hasWebPath()) {
                p.code().ah(this.context.prefixLocalHref(url)).tx(url);
            } else if (res instanceof CanonicalResource) {
                p.code().ah(this.context.prefixLocalHref(res.getWebPath())).tx(((CanonicalResource)res).present());
            } else {
                p.code().ah(this.context.prefixLocalHref(res.getWebPath())).tx(url);
            }
            p.tx(" (");
            p.code().tx(ct);
            p.tx(this.lang(att));
            p.tx(")");
        } else if (!att.has("data")) {
            XhtmlNode p = x.para();
            if (att.has("title")) {
                p.tx(title);
                p.tx(": ");
            }
            p.code().tx(this.context.formatPhrase("LIB_REND_NOCONT", new Object[0]));
            p.tx(" (");
            p.code().tx(ct);
            p.tx(this.lang(att));
            p.tx(")");
        } else {
            byte[] cnt = Base64.decodeBase64((String)att.primitiveValue("data"));
            String txt = this.getText(cnt);
            if (this.isImage(ct)) {
                XhtmlNode p = x.para();
                if (att.has("title")) {
                    p.tx(title);
                    p.tx(": (");
                    p.code().tx(ct);
                    p.tx(this.lang(att));
                    p.tx(")");
                } else {
                    p.code().tx(ct + this.lang(att));
                }
                if (cnt.length < 4000) {
                    x.img("data: " + ct + ">;base64," + this.b64(cnt), "data");
                } else {
                    String filename = "Library-" + baseId + (String)(counter == 0 ? "" : "-" + Integer.toString(counter)) + "." + this.imgExtension(ct);
                    x.img(filename, "data");
                }
            } else if (txt != null && !noShowData) {
                XhtmlNode p = x.para();
                if (att.has("title")) {
                    p.tx(title);
                    p.tx(": (");
                    p.code().tx(ct);
                    p.tx(this.lang(att));
                    p.tx(")");
                } else {
                    p.code().tx(ct + this.lang(att));
                }
                String prismCode = this.determinePrismCode(ct);
                if (prismCode != null && !this.tooBig(txt)) {
                    x.pre().code().setAttribute("class", "language-" + prismCode).tx(txt);
                } else {
                    x.pre().code().tx(txt);
                }
            } else {
                XhtmlNode p = x.para();
                if (att.has("title")) {
                    p.tx(title);
                    p.tx(": ");
                }
                p.code().tx(this.context.formatPhrase("LIB_REND_SHOW", new Object[0]));
                p.code().tx(ct);
                p.tx(this.lang(att));
                p.tx(this.context.formatPhrase("LIB_REND_SIZE", new Object[]{Utilities.describeSize((int)cnt.length)}) + " )");
            }
        }
    }

    private boolean tooBig(String txt) {
        return txt.length() > 16384;
    }

    private String imgExtension(String contentType) {
        if (contentType != null && contentType.startsWith("image/")) {
            if (contentType.startsWith("image/png")) {
                return "png";
            }
            if (contentType.startsWith("image/jpeg")) {
                return "jpg";
            }
        }
        return null;
    }

    private String b64(byte[] data) {
        byte[] encodeBase64 = Base64.encodeBase64((byte[])data);
        return new String(encodeBase64);
    }

    private boolean isImage(String contentType) {
        return this.imgExtension(contentType) != null;
    }

    private String lang(ResourceWrapper att) {
        if (att.has("language")) {
            return ", language = " + this.describeLang(att.primitiveValue("language"));
        }
        return "";
    }

    private String getText(byte[] cnt) {
        try {
            String src2;
            try {
                src2 = new String(cnt, "UTF-8");
                if (this.checkString(src2)) {
                    return src2;
                }
            }
            catch (Exception src2) {
                // empty catch block
            }
            try {
                src2 = new String(cnt, "UTF-16");
                if (this.checkString(src2)) {
                    return src2;
                }
            }
            catch (Exception src3) {
                // empty catch block
            }
            try {
                src2 = new String(cnt, "ASCII");
                if (this.checkString(src2)) {
                    return src2;
                }
            }
            catch (Exception src4) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean checkString(String src) {
        for (char ch : src.toCharArray()) {
            if (ch >= ' ' || ch == '\r' || ch == '\n' || ch == '\t') continue;
            return false;
        }
        return true;
    }

    private String determinePrismCode(String ct) {
        if (!Utilities.noString((String)ct)) {
            if (ct.contains(";")) {
                ct = ct.substring(0, ct.indexOf(";"));
            }
            switch (ct) {
                case "text/html": {
                    return "html";
                }
                case "text/xml": {
                    return "xml";
                }
                case "application/xml": {
                    return "xml";
                }
                case "text/markdown": {
                    return "markdown";
                }
                case "application/js": {
                    return "JavaScript";
                }
                case "application/css": {
                    return "css";
                }
                case "text/x-csrc": {
                    return "c";
                }
                case "text/x-csharp": {
                    return "csharp";
                }
                case "text/x-c++src": {
                    return "cpp";
                }
                case "application/graphql": {
                    return "graphql";
                }
                case "application/x-java": {
                    return "java";
                }
                case "application/json": {
                    return "json";
                }
                case "text/json": {
                    return "json";
                }
                case "application/liquid": {
                    return "liquid";
                }
                case "text/x-pascal": {
                    return "pascal";
                }
                case "text/x-python": {
                    return "python";
                }
                case "text/x-rsrc": {
                    return "r";
                }
                case "text/x-ruby": {
                    return "ruby";
                }
                case "text/x-sas": {
                    return "sas";
                }
                case "text/x-sql": {
                    return "sql";
                }
                case "application/typescript": {
                    return "typescript";
                }
                case "text/cql": {
                    return "sql";
                }
            }
            if (ct.contains("json+") || ct.contains("+json")) {
                return "json";
            }
            if (ct.contains("xml+") || ct.contains("+xml")) {
                return "xml";
            }
        }
        return null;
    }
}

