/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class FeatureDefinitionRenderer
extends ResourceRenderer {
    public FeatureDefinitionRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean renderingUsesValidation() {
        return true;
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper fd) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(fd, x);
        this.genSummaryTable(status, x, fd);
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode td = tbl.tr().td();
        td.tx("Feature ");
        td.code().tx(fd.primitiveValue("url"));
        this.addMarkdown(tbl.tr().td(), fd.primitiveValue("description"));
        td = tbl.tr().td();
        td.b().tx("Type: ");
        td.tx(fd.primitiveValue("valueType"));
        td = tbl.tr().td();
        td.b().tx("Contexts");
        XhtmlNode ul = td.ul();
        for (ResourceWrapper c : fd.children("context")) {
            String url = c.primitiveValue();
            XhtmlNode li = ul.li();
            if (url.contains("#")) {
                String type = url.substring(0, url.indexOf("#"));
                String id = url.substring(url.indexOf("#") + 1);
                StructureDefinition sd = this.context.getContext().fetchTypeDefinition(type);
                if (sd != null && sd.hasWebPath()) {
                    li.ah(sd.getWebPath()).tx(sd.present());
                } else {
                    li.tx(url);
                }
                if (id == null) continue;
                li.tx(" element ");
                li.code().tx(id);
                continue;
            }
            li.tx(url);
        }
        td = tbl.tr().td();
        if (fd.has("qualifier")) {
            td.b().tx("Qualifiers");
            XhtmlNode tbl2 = td.table("lines", false);
            XhtmlNode tr = tbl2.tr();
            tr.td().b().tx("Name");
            tr.td().b().tx("Type");
            tr.td().b().tx("Optional");
            tr.td().b().tx("Description");
            for (ResourceWrapper q : fd.children("qualifier")) {
                tr = tbl2.tr();
                tr.td().tx(q.primitiveValue("name"));
                tr.td().tx(q.primitiveValue("valueType"));
                tr.td().tx(q.primitiveValue("optional"));
                tr.td().tx(q.primitiveValue("description"));
            }
        } else {
            td.tx("This feature doesn't have any qualifiers");
        }
    }

    private void renderSelect(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper vd, ResourceWrapper select) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_vd_select.png", "Select");
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c1 = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "Select", null, null);
        r.getCells().add(c1);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, null, null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null);
        if (select.has("forEach")) {
            this.addFHIRPath((HierarchicalTableGenerator.Piece)cell.getPieces().get(0), "for each ", select.primitiveValue("forEach"), null);
        } else if (select.has("forEachOrNull")) {
            this.addFHIRPath((HierarchicalTableGenerator.Piece)cell.getPieces().get(0), "for each ", select.primitiveValue("forEachOrNull"), ", or null");
        }
        r.getCells().add(cell);
        for (ResourceWrapper column : select.children("column")) {
            this.renderColumn(status, gen, r.getSubRows(), vd, select, column);
        }
        for (ResourceWrapper child : select.children("select")) {
            this.renderSelect(status, gen, r.getSubRows(), vd, child);
        }
    }

    private void renderColumn(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper vd, ResourceWrapper select, ResourceWrapper column) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_vd_col.png", "Column");
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c1 = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, column.primitiveValue("name"), null, null);
        r.getCells().add(c1);
        String coll = column.has("collection") ? ("true".equals(column.primitiveValue("collection")) ? "Y" : "N") : "";
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, coll, null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, column.primitiveValue("type"), null, null));
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null);
        this.addFHIRPath((HierarchicalTableGenerator.Piece)cell.getPieces().get(0), null, column.primitiveValue("path"), null);
        if (column.has("description")) {
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, "br"));
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, column.primitiveValue("description"), null));
        }
        for (ResourceWrapper tag : column.children("tag")) {
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, "br"));
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator8);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, tag.primitiveValue("name") + "=" + tag.primitiveValue("value"), null));
        }
        r.getCells().add(cell);
    }

    private void addFHIRPath(HierarchicalTableGenerator.Piece p, String pfx, String expr, String sfx) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "span").style("font-size: 11px");
        p.addHtml(x);
        if (pfx != null) {
            x.tx(pfx);
        }
        x.code(expr);
        if (sfx != null) {
            x.tx(sfx);
        }
    }

    private HierarchicalTableGenerator.Row addViewRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper vd) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_vd_view.png", this.context.formatPhrase("QUEST_ROOT", new Object[0]));
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, vd.primitiveValue("name"), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, vd.primitiveValue("resource"), null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, vd.primitiveValue("description"), null, null));
        return r;
    }
}

