/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class BundleRenderer
extends ResourceRenderer {
    public BundleRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.context.formatPhrase("BUNDLE_SUMMARY", new Object[]{this.getTranslatedCode(r.child("type")), r.children("entry").size()});
    }

    @Override
    public BundleRenderer setMultiLangMode(boolean multiLangMode) {
        this.multiLangMode = multiLangMode;
        return this;
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper b) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        List<ResourceWrapper> entries = b.children("entry");
        if (!"collection".equals(b.primitiveValue("type")) || !BundleRenderer.allEntriesAreHistoryProvenance(entries)) {
            int start = 0;
            XhtmlNode root = x;
            if ("document".equals(b.primitiveValue("type"))) {
                if (entries.isEmpty() || entries.get(0).has("resource") && !"Composition".equals(entries.get(0).child("resource").fhirType())) {
                    throw new FHIRException(this.context.formatPhrase("BUND_REND_INVALID_DOC", new Object[]{b.getId(), entries.get(0).child("resource").fhirType() + "')"}));
                }
                this.renderDocument(status, root, b, entries);
                if (!this.context.isTechnicalMode()) {
                    return;
                }
                start = 1;
                root.hr();
                root.h2().addText(this.formatPhrase("BUNDLE_HEADER_DOCUMENT_CONTENTS", new Object[0]));
            } else {
                this.renderResourceTechDetails(b, x);
                root.para().addText(this.formatPhrase("BUNDLE_HEADER_ROOT", b.getId(), b.primitiveValue("type")));
            }
            int i = 0;
            for (ResourceWrapper be : entries) {
                if (++i < start) continue;
                Object link = null;
                if (be.has("fullUrl") && !this.context.hasAnchor((String)(link = BundleRenderer.makeInternalBundleLink(b, be.primitiveValue("fullUrl"))))) {
                    this.context.addAnchor((String)link);
                    root.an(this.context.prefixAnchor((String)link));
                }
                ResourceWrapper res = be.child("resource");
                if (be.has("resource")) {
                    String ver;
                    String id = res.has("id") ? res.primitiveValue("id") : this.makeIdFromBundleEntry(be.primitiveValue("fullUrl"));
                    String anchor = res.fhirType() + "_" + id;
                    if (id != null && !this.context.hasAnchor(anchor)) {
                        this.context.addAnchor(anchor);
                        root.an(this.context.prefixAnchor(anchor));
                    }
                    anchor = "hc" + anchor;
                    if (id != null && !this.context.hasAnchor(anchor)) {
                        this.context.addAnchor(anchor);
                        root.an(this.context.prefixAnchor(anchor));
                    }
                    String string = ver = res.has("meta") ? res.child("meta").primitiveValue("version") : null;
                    if (ver != null) {
                        if (link != null && !this.context.hasAnchor((String)(link = (String)link + "/" + ver))) {
                            this.context.addAnchor((String)link);
                            root.an(this.context.prefixAnchor((String)link));
                        }
                        if (id != null && !this.context.hasAnchor(anchor = anchor + "/" + ver)) {
                            this.context.addAnchor(anchor);
                            root.an(this.context.prefixAnchor(anchor));
                        }
                    }
                }
                root.hr();
                if (be.has("fullUrl")) {
                    root.para().addText(this.formatPhrase("BUNDLE_HEADER_ENTRY_URL", Integer.toString(i), be.primitiveValue("fullUrl")));
                } else {
                    root.para().addText(this.formatPhrase("BUNDLE_HEADER_ENTRY", Integer.toString(i)));
                }
                if (be.has("search")) {
                    this.renderSearch(x, be.child("search"));
                }
                if (be.has("resource")) {
                    ResourceWrapper r = res;
                    root.para().addText(this.formatPhrase("BUNDLE_RESOURCE", r.fhirType()));
                    XhtmlNode xn = r.getNarrative();
                    if (xn == null || xn.isEmpty()) {
                        ResourceRenderer rr = RendererFactory.factory(r, this.context);
                        try {
                            xn = new XhtmlNode(NodeType.Element, "div");
                            rr.buildNarrative(new Renderer.RenderingStatus(), xn, r);
                        }
                        catch (Exception e) {
                            xn = new XhtmlNode();
                            xn.para().b().tx(this.context.formatPhrase("BUNDLE_REV_EXCP", new Object[]{e.getMessage()}) + " ");
                        }
                    } else {
                        xn.stripAnchorsByName(this.context.getAnchors());
                    }
                    root.blockquote().addChildren(xn);
                }
                if (be.has("request")) {
                    this.renderRequest(x, be.child("request"));
                }
                if (!be.has("response")) continue;
                this.renderResponse(x, be.child("response"));
            }
        }
    }

    private void renderDocument(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper b, List<ResourceWrapper> entries) throws UnsupportedEncodingException, FHIRException, IOException, EOperationOutcome {
        ResourceWrapper comp = entries.get(0).child("resource");
        XhtmlNode sum = this.renderResourceTechDetails(b, this.docSection(x, "Document Details"), comp.primitiveValueMN("title", "name"));
        List<ResourceWrapper> subjectList = comp.children("subject");
        if (sum != null) {
            XhtmlNode p = sum.para();
            p.startScript("doc");
            this.renderDataType(status, p.param("status"), comp.child("status"));
            this.renderDataType(status, p.param("date"), comp.child("date"));
            this.renderDataTypes(status, p.param("author"), comp.children("author"));
            this.renderDataTypes(status, p.param("subject"), subjectList);
            if (comp.has("encounter")) {
                this.renderDataType(status, p.param("encounter"), comp.child("encounter"));
                p.paramValue("has-encounter", "true");
            } else {
                p.paramValue("has-encounter", "false");
            }
            p.execScript(this.context.formatMessage("DOCUMENT_SUMMARY", new Object[0]));
            p.closeScript();
            x.hr();
        }
        List<ResourceWrapper> subjects = this.resolveReferences(entries, subjectList);
        int i = 0;
        for (ResourceWrapper subject : subjects) {
            XhtmlNode sec = this.docSection(x, "Document Subject");
            if (subject != null) {
                if (subject.hasNarrative()) {
                    sec.addChildren(subject.getNarrative());
                } else {
                    RendererFactory.factory(subject, this.context).buildNarrative(status, sec, subject);
                }
            } else {
                sec.para().b().tx("Unable to resolve subject '" + this.displayReference(subjects.get(i)) + "'");
            }
            ++i;
        }
        x.hr();
        XhtmlNode sec = this.docSection(x, "Document Content");
        if (comp.hasNarrative()) {
            sec.addChildren(comp.getNarrative());
            sec.hr();
        }
        List<ResourceWrapper> sections = comp.children("section");
        for (ResourceWrapper section : sections) {
            this.addSection(status, sec, section, 2, false);
        }
    }

    private void renderDataTypes(Renderer.RenderingStatus status, XhtmlNode param, List<ResourceWrapper> children) throws FHIRFormatError, DefinitionException, IOException {
        if (children != null && !children.isEmpty()) {
            boolean first = true;
            for (ResourceWrapper child : children) {
                if (first) {
                    first = false;
                } else {
                    param.tx(", ");
                }
                this.renderDataType(status, param, child);
            }
        }
    }

    private XhtmlNode docSection(XhtmlNode x, String name) {
        XhtmlNode div = x.div();
        div.style("border: 1px solid maroon; padding: 10px; background-color: #f2faf9; min-height: 160px;");
        div.para().b().tx(name);
        return div;
    }

    private void addSection(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper section, int level, boolean nested) throws UnsupportedEncodingException, FHIRException, IOException {
        if (section.has("title") || section.has("code") || section.has("text") || section.has("section")) {
            XhtmlNode div = x.div();
            if (section.has("title")) {
                div.h(level).tx(section.primitiveValue("title"));
            } else if (section.has("code")) {
                this.renderDataType(status, div.h(level), section.child("code"));
            }
            if (section.has("text")) {
                ResourceWrapper narrative = section.child("text");
                ResourceWrapper xh = narrative.child("div");
                x.addChildren(xh.getXhtml());
            }
            if (section.has("section")) {
                List<ResourceWrapper> sections = section.children("section");
                for (ResourceWrapper child : sections) {
                    if (nested) {
                        this.addSection(status, x.blockquote().para(), child, level + 1, true);
                        continue;
                    }
                    this.addSection(status, x, child, level + 1, true);
                }
            }
        }
    }

    private List<ResourceWrapper> resolveReferences(List<ResourceWrapper> entries, List<ResourceWrapper> baselist) throws UnsupportedEncodingException, FHIRException, IOException {
        ArrayList<ResourceWrapper> list = new ArrayList<ResourceWrapper>();
        if (baselist != null) {
            for (ResourceWrapper base : baselist) {
                ResourceWrapper res = null;
                ResourceWrapper prop = base.child("reference");
                String ref = prop.primitiveValue();
                if (prop == null || !prop.hasPrimitiveValue()) continue;
                for (ResourceWrapper entry : entries) {
                    String id;
                    String type;
                    String fu;
                    if (entry.has("fullUrl") && ref.equals(fu = entry.primitiveValue("fullUrl"))) {
                        res = entry.child("resource");
                    }
                    if (!entry.has("resource") || !ref.equals((type = entry.child("resource").fhirType()) + "/" + (id = entry.child("resource").primitiveValue("id")))) continue;
                    res = entry.child("resource");
                }
                list.add(res);
            }
        }
        return list;
    }

    private ResourceWrapper resolveReference(List<ResourceWrapper> entries, ResourceWrapper base) throws UnsupportedEncodingException, FHIRException, IOException {
        if (base == null) {
            return null;
        }
        ResourceWrapper prop = base.child("reference");
        if (prop != null && prop.hasPrimitiveValue()) {
            for (ResourceWrapper entry : entries) {
                if (!entry.has("fullUrl")) continue;
                String fu = entry.primitiveValue("fullUrl");
                if (!prop.primitiveValue().equals(fu)) continue;
                return entry.child("resource");
            }
        }
        return null;
    }

    public static boolean allEntriesAreHistoryProvenance(List<ResourceWrapper> entries) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ResourceWrapper be : entries) {
            if (be.has("child") && "Provenance".equals(be.child("resource").fhirType())) continue;
            return false;
        }
        return !entries.isEmpty();
    }

    private boolean allEntresAreHistoryProvenance(Bundle b) {
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            if (be.getResource() instanceof Provenance) continue;
            return false;
        }
        return !b.getEntry().isEmpty();
    }

    private void renderSearch(XhtmlNode root, ResourceWrapper search) {
        StringBuilder b = new StringBuilder();
        b.append(this.formatPhrase("BUNDLE_SEARCH", new Object[0]));
        if (search.has("mode")) {
            b.append(this.formatPhrase("BUNDLE_SEARCH_MODE", search.primitiveValue("mode")));
        }
        if (search.has("score")) {
            if (search.has("mode")) {
                b.append(",");
            }
            b.append(this.formatPhrase("BUNDLE_SEARCH_SCORE", search.primitiveValue("score")));
        }
        root.para().addText(b.toString());
    }

    private void renderResponse(XhtmlNode root, ResourceWrapper response) {
        root.para().addText(this.formatPhrase("BUNDLE_RESPONSE", new Object[0]));
        StringBuilder b = new StringBuilder();
        b.append(response.primitiveValue("status") + "\r\n");
        if (response.has("location")) {
            b.append(this.formatPhrase("BUNDLE_LOCATION", response.primitiveValue("location")) + "\r\n");
        }
        if (response.has("etag")) {
            b.append(this.formatPhrase("BUNDLE_ETAG", response.primitiveValue("etag")) + "\r\n");
        }
        if (response.has("lastModified")) {
            b.append(this.formatPhrase("BUNDLE_LAST_MOD", response.primitiveValue("lastModified")) + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    private void renderRequest(XhtmlNode root, ResourceWrapper request) {
        root.para().addText(this.formatPhrase("BUNDLE_REQUEST", new Object[0]));
        StringBuilder b = new StringBuilder();
        b.append(request.primitiveValue("method") + " " + request.primitiveValue("url") + "\r\n");
        if (request.has("ifNoneMatch")) {
            b.append(this.formatPhrase("BUNDLE_IF_NON_MATCH", request.primitiveValue("ifNoneMatch")) + "\r\n");
        }
        if (request.has("ifModifiedSince")) {
            b.append(this.formatPhrase("BUNDLE_IF_MOD", request.primitiveValue("ifModifiedSince")) + "\r\n");
        }
        if (request.has("ifMatch")) {
            b.append(this.formatPhrase("BUNDLE_IF_MATCH", request.primitiveValue("ifMatch")) + "\r\n");
        }
        if (request.has("ifNoneExist")) {
            b.append(this.formatPhrase("BUNDLE_IF_NONE", request.primitiveValue("ifNoneExist")) + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    public boolean canRender(Bundle b) {
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            ResourceRenderer rr;
            if (!be.hasResource() || (rr = RendererFactory.factory(be.getResource(), this.context)).canRender(be.getResource())) continue;
            return false;
        }
        return true;
    }
}

