/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openapi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hl7.fhir.r5.openapi.BaseWriter;
import org.hl7.fhir.r5.openapi.SchemaWriter;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class ParameterWriter
extends BaseWriter {
    public ParameterWriter(JsonObject object) {
        super(object);
    }

    public ParameterWriter in(ParameterLocation value) {
        this.object.addProperty("in", value.toString());
        return this;
    }

    public ParameterWriter name(String value) {
        this.object.addProperty("name", value);
        return this;
    }

    public ParameterWriter allowEmptyValue() {
        this.object.addProperty("allowEmptyValue", Boolean.valueOf(true));
        return this;
    }

    public ParameterWriter description(String value) {
        if (value != null) {
            this.object.addProperty("description", value);
        }
        return this;
    }

    public ParameterWriter required(boolean value) {
        this.object.addProperty("required", Boolean.valueOf(value));
        return this;
    }

    public ParameterWriter deprecated(boolean value) {
        this.object.addProperty("deprecated", Boolean.valueOf(value));
        return this;
    }

    public ParameterWriter allowEmptyValue(boolean value) {
        this.object.addProperty("allowEmptyValue", Boolean.valueOf(value));
        return this;
    }

    public ParameterWriter style(ParameterStyle value) {
        this.object.addProperty("style", value.toString());
        return this;
    }

    public ParameterWriter explode(boolean value) {
        this.object.addProperty("explode", Boolean.valueOf(value));
        return this;
    }

    public ParameterWriter allowReserved(boolean value) {
        this.object.addProperty("allowReserved", Boolean.valueOf(value));
        return this;
    }

    public ParameterWriter schema(JsonObject jsonSchema) {
        this.object.add("schema", (JsonElement)jsonSchema);
        return this;
    }

    public SchemaWriter schema() {
        JsonObject so = new JsonObject();
        this.object.add("schema", (JsonElement)so);
        return new SchemaWriter(so);
    }

    public ParameterWriter schemaRef(String name, String uri) {
        JsonObject schema = new JsonObject();
        schema.addProperty("$ref", uri);
        this.object.add("schema", (JsonElement)schema);
        return this;
    }

    public ParameterWriter example(JsonObject example) {
        this.object.add("example", (JsonElement)example);
        return this;
    }

    public static enum ParameterStyle {
        matrix,
        label,
        form,
        simple,
        spaceDelimited,
        pipeDelimited,
        deepObject;

    }

    public static enum ParameterLocation {
        query,
        header,
        path,
        cookie;

    }
}

