/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class PackageInformation {
    private String id;
    private String version;
    private Date date;
    private String name;
    private String canonical;
    private String web;
    private List<String> dependencies = new ArrayList<String>();
    private String fhirVersion;

    public PackageInformation(String id, String version, String fhirVersion, Date date, String name, String canonical, String web) {
        this.id = id;
        this.version = version;
        this.date = date;
        this.name = name;
        this.canonical = canonical;
        this.web = web;
        this.fhirVersion = fhirVersion;
    }

    public PackageInformation(String src, String fhirVersion, Date date) {
        this.id = src;
        this.date = date;
        this.fhirVersion = fhirVersion;
    }

    public PackageInformation(NpmPackage pi) {
        this.id = pi.name();
        this.version = pi.version();
        this.date = pi.dateAsDate();
        this.name = pi.title();
        this.canonical = pi.canonical();
        this.web = pi.getWebLocation();
        this.fhirVersion = pi.fhirVersion();
        this.dependencies.addAll(pi.dependencies());
    }

    public PackageInformation(String id, String version, String fhirVersion, Date date) {
        this.id = id;
        this.version = version;
        this.fhirVersion = fhirVersion;
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public String getWeb() {
        return this.web;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isExamplesPackage() {
        boolean b = this.id.startsWith("hl7.fhir.r") && this.id.endsWith(".examples");
        return b;
    }

    public boolean isHTO() {
        boolean b = this.id.startsWith("hl7.terminology.r");
        return b;
    }

    public String getVID() {
        return this.id + "#" + this.version;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public String toString() {
        return this.getVID();
    }

    public boolean isCore() {
        boolean b = this.id.startsWith("hl7.fhir.r") && this.id.endsWith(".core");
        return b;
    }
}

