/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ObservationDefinition", profile="http://hl7.org/fhir/StructureDefinition/ObservationDefinition")
public class ObservationDefinition
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical canonical URL to reference this ObservationDefinition (globally unique)", formalDefinition="An absolute URL that is used to identify this ObservationDefinition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this ObservationDefinition is (or will be) published. The URL SHOULD include the major version of the ObservationDefinition. For more information see Technical and Business Versions.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier of the ObservationDefinition", formalDefinition="Business identifiers assigned to this ObservationDefinition. by the performer and/or other systems. These identifiers remain constant as the resource is updated and propagates from server to server.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the ObservationDefinition", formalDefinition="The identifier that is used to identify this version of the ObservationDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the ObservationDefinition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this ObservationDefinition (computer friendly)", formalDefinition="A natural language name identifying the ObservationDefinition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this ObservationDefinition (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the ObservationDefinition.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the ObservationDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this ObservationDefinition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date (and optionally time) when the ObservationDefinition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the ObservationDefinition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The name of the individual or organization that published the ObservationDefinition", formalDefinition="Helps establish the \"authority/credibility\" of the ObservationDefinition. May also allow for contact.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the ObservationDefinition", formalDefinition="A free text natural language description of the ObservationDefinition from the consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate ObservationDefinition instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for this ObservationDefinition (if applicable)", formalDefinition="A jurisdiction in which the ObservationDefinition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this ObservationDefinition is defined", formalDefinition="Explains why this ObservationDefinition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="Copyright statement relating to the ObservationDefinition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the ObservationDefinition.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s)", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="approvalDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When ObservationDefinition was approved by publisher", formalDefinition="The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date on which the asset content was last reviewed by the publisher", formalDefinition="The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The effective date range for the ObservationDefinition", formalDefinition="The period during which the ObservationDefinition content was or is planned to be effective.")
    protected Period effectivePeriod;
    @Child(name="derivedFromCanonical", type={CanonicalType.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on FHIR definition of another observation", formalDefinition="The canonical URL pointing to another FHIR-defined ObservationDefinition that is adhered to in whole or in part by this definition.")
    protected List<CanonicalType> derivedFromCanonical;
    @Child(name="derivedFromUri", type={UriType.class}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on external definition", formalDefinition="The URL pointing to an externally-defined observation definition, guideline or other definition that is adhered to in whole or in part by this definition.")
    protected List<UriType> derivedFromUri;
    @Child(name="subject", type={CodeableConcept.class}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of subject for the defined observation", formalDefinition="A code that describes the intended kind of subject of Observation instances conforming to this ObservationDefinition.")
    protected List<CodeableConcept> subject;
    @Child(name="performerType", type={CodeableConcept.class}, order=23, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Desired kind of performer for such kind of observation", formalDefinition="The type of individual/organization/device that is expected to act upon instances of this definition.")
    protected CodeableConcept performerType;
    @Child(name="category", type={CodeableConcept.class}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General type of observation", formalDefinition="A code that classifies the general type of observation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=25, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of observation", formalDefinition="Describes what will be observed. Sometimes this is called the observation \"name\".")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    protected CodeableConcept code;
    @Child(name="permittedDataType", type={CodeType.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Quantity | CodeableConcept | string | boolean | integer | Range | Ratio | SampledData | time | dateTime | Period", formalDefinition="The data types allowed for the value element of the instance observations conforming to this ObservationDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/permitted-data-type")
    protected List<Enumeration<ObservationDataType>> permittedDataType;
    @Child(name="multipleResultsAllowed", type={BooleanType.class}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Multiple results allowed for conforming observations", formalDefinition="Multiple results allowed for observations conforming to this ObservationDefinition.")
    protected BooleanType multipleResultsAllowed;
    @Child(name="bodySite", type={CodeableConcept.class}, order=28, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Body part to be observed", formalDefinition="The site on the subject's body where the  observation is to be made.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="method", type={CodeableConcept.class}, order=29, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Method used to produce the observation", formalDefinition="The method or technique used to perform the observation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-methods")
    protected CodeableConcept method;
    @Child(name="specimen", type={SpecimenDefinition.class}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Kind of specimen used by this type of observation", formalDefinition="The kind of specimen that this type of observation is produced on.")
    protected List<Reference> specimen;
    @Child(name="device", type={DeviceDefinition.class, Device.class}, order=31, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Measurement device or model of device", formalDefinition="The measurement model of device or actual device used to produce observations of this type.")
    protected List<Reference> device;
    @Child(name="preferredReportName", type={StringType.class}, order=32, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The preferred name to be used when reporting the observation results", formalDefinition="The preferred name to be used when reporting the results of observations conforming to this ObservationDefinition.")
    protected StringType preferredReportName;
    @Child(name="permittedUnit", type={Coding.class}, order=33, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Unit for quantitative results", formalDefinition="Units allowed for the valueQuantity element in the instance observations conforming to this ObservationDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
    protected List<Coding> permittedUnit;
    @Child(name="qualifiedValue", type={}, order=34, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Set of qualified values for observation results", formalDefinition="A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.")
    protected List<ObservationDefinitionQualifiedValueComponent> qualifiedValue;
    @Child(name="hasMember", type={ObservationDefinition.class, Questionnaire.class}, order=35, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Definitions of related resources belonging to this kind of observation group", formalDefinition="This ObservationDefinition defines a group  observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.")
    protected List<Reference> hasMember;
    @Child(name="component", type={}, order=36, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Component results", formalDefinition="Some observations have multiple component observations, expressed as separate code value pairs.")
    protected List<ObservationDefinitionComponentComponent> component;
    private static final long serialVersionUID = -415480292L;
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ActivityDefinition.title | ActorDefinition.title | CapabilityStatement.title | ChargeItemDefinition.title | Citation.title | CodeSystem.title | ConceptMap.title | ConditionDefinition.title | EventDefinition.title | Evidence.title | EvidenceVariable.title | ImplementationGuide.title | Library.title | Measure.title | MessageDefinition.title | ObservationDefinition.title | OperationDefinition.title | PlanDefinition.title | Questionnaire.title | Requirements.title | SpecimenDefinition.title | StructureDefinition.title | StructureMap.title | SubscriptionTopic.title | TerminologyCapabilities.title | TestScript.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition\r\n* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition\r\n* [Citation](citation.html): The human-friendly name of the citation\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition\r\n* [Evidence](evidence.html): The human-friendly name of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [Library](library.html): The human-friendly name of the library\r\n* [Measure](measure.html): The human-friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire\r\n* [Requirements](requirements.html): The human-friendly name of the requirements\r\n* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): The human-friendly name of the test script\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="category", path="ObservationDefinition.category", description="Category (class) of observation", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="code", path="ObservationDefinition.code", description="Observation code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="experimental", path="ObservationDefinition.experimental", description="Not for genuine usage (true)", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="method", path="ObservationDefinition.method", description="Method of observation", type="token")
    public static final String SP_METHOD = "method";
    public static final TokenClientParam METHOD = new TokenClientParam("method");

    public ObservationDefinition() {
    }

    public ObservationDefinition(Enumerations.PublicationStatus status, CodeableConcept code) {
        this.setStatus(status);
        this.setCode(code);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ObservationDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ObservationDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ObservationDefinition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ObservationDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ObservationDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    public boolean hasVersionAlgorithmStringType() {
        return this != null && this.versionAlgorithm instanceof StringType;
    }

    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    public boolean hasVersionAlgorithmCoding() {
        return this != null && this.versionAlgorithm instanceof Coding;
    }

    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    public ObservationDefinition setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for ObservationDefinition.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ObservationDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ObservationDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ObservationDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ObservationDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ObservationDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public ObservationDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public ObservationDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public ObservationDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ObservationDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ObservationDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public ObservationDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public ObservationDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public ObservationDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public ObservationDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ObservationDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ObservationDefinition setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    public ObservationDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    public ObservationDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    public ObservationDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    public ObservationDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ObservationDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ObservationDefinition setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ObservationDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ObservationDefinition setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    public ObservationDefinition setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    public ObservationDefinition setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public ObservationDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public ObservationDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public ObservationDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public ObservationDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public ObservationDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<CanonicalType> getDerivedFromCanonical() {
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        return this.derivedFromCanonical;
    }

    public ObservationDefinition setDerivedFromCanonical(List<CanonicalType> theDerivedFromCanonical) {
        this.derivedFromCanonical = theDerivedFromCanonical;
        return this;
    }

    public boolean hasDerivedFromCanonical() {
        if (this.derivedFromCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.derivedFromCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDerivedFromCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        this.derivedFromCanonical.add(t);
        return t;
    }

    public ObservationDefinition addDerivedFromCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        this.derivedFromCanonical.add(t);
        return this;
    }

    public boolean hasDerivedFromCanonical(String value) {
        if (this.derivedFromCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.derivedFromCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getDerivedFromUri() {
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        return this.derivedFromUri;
    }

    public ObservationDefinition setDerivedFromUri(List<UriType> theDerivedFromUri) {
        this.derivedFromUri = theDerivedFromUri;
        return this;
    }

    public boolean hasDerivedFromUri() {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType item : this.derivedFromUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDerivedFromUriElement() {
        UriType t = new UriType();
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return t;
    }

    public ObservationDefinition addDerivedFromUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return this;
    }

    public boolean hasDerivedFromUri(String value) {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType v : this.derivedFromUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeableConcept> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<CodeableConcept>();
        }
        return this.subject;
    }

    public ObservationDefinition setSubject(List<CodeableConcept> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (CodeableConcept item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSubject() {
        CodeableConcept t = new CodeableConcept();
        if (this.subject == null) {
            this.subject = new ArrayList<CodeableConcept>();
        }
        this.subject.add(t);
        return t;
    }

    public ObservationDefinition addSubject(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<CodeableConcept>();
        }
        this.subject.add(t);
        return this;
    }

    public CodeableConcept getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public CodeableConcept getPerformerType() {
        if (this.performerType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.performerType");
            }
            if (Configuration.doAutoCreate()) {
                this.performerType = new CodeableConcept();
            }
        }
        return this.performerType;
    }

    public boolean hasPerformerType() {
        return this.performerType != null && !this.performerType.isEmpty();
    }

    public ObservationDefinition setPerformerType(CodeableConcept value) {
        this.performerType = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public ObservationDefinition setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public ObservationDefinition addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ObservationDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<Enumeration<ObservationDataType>> getPermittedDataType() {
        if (this.permittedDataType == null) {
            this.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
        }
        return this.permittedDataType;
    }

    public ObservationDefinition setPermittedDataType(List<Enumeration<ObservationDataType>> thePermittedDataType) {
        this.permittedDataType = thePermittedDataType;
        return this;
    }

    public boolean hasPermittedDataType() {
        if (this.permittedDataType == null) {
            return false;
        }
        for (Enumeration<ObservationDataType> item : this.permittedDataType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<ObservationDataType> addPermittedDataTypeElement() {
        Enumeration<ObservationDataType> t = new Enumeration<ObservationDataType>(new ObservationDataTypeEnumFactory());
        if (this.permittedDataType == null) {
            this.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
        }
        this.permittedDataType.add(t);
        return t;
    }

    public ObservationDefinition addPermittedDataType(ObservationDataType value) {
        Enumeration<ObservationDataType> t = new Enumeration<ObservationDataType>(new ObservationDataTypeEnumFactory());
        t.setValue((Object)value);
        if (this.permittedDataType == null) {
            this.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
        }
        this.permittedDataType.add(t);
        return this;
    }

    public boolean hasPermittedDataType(ObservationDataType value) {
        if (this.permittedDataType == null) {
            return false;
        }
        for (Enumeration<ObservationDataType> v : this.permittedDataType) {
            if (!((ObservationDataType)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public BooleanType getMultipleResultsAllowedElement() {
        if (this.multipleResultsAllowed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.multipleResultsAllowed");
            }
            if (Configuration.doAutoCreate()) {
                this.multipleResultsAllowed = new BooleanType();
            }
        }
        return this.multipleResultsAllowed;
    }

    public boolean hasMultipleResultsAllowedElement() {
        return this.multipleResultsAllowed != null && !this.multipleResultsAllowed.isEmpty();
    }

    public boolean hasMultipleResultsAllowed() {
        return this.multipleResultsAllowed != null && !this.multipleResultsAllowed.isEmpty();
    }

    public ObservationDefinition setMultipleResultsAllowedElement(BooleanType value) {
        this.multipleResultsAllowed = value;
        return this;
    }

    public boolean getMultipleResultsAllowed() {
        return this.multipleResultsAllowed == null || this.multipleResultsAllowed.isEmpty() ? false : (Boolean)this.multipleResultsAllowed.getValue();
    }

    public ObservationDefinition setMultipleResultsAllowed(boolean value) {
        if (this.multipleResultsAllowed == null) {
            this.multipleResultsAllowed = new BooleanType();
        }
        this.multipleResultsAllowed.setValue((Object)value);
        return this;
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public ObservationDefinition setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public ObservationDefinition setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public ObservationDefinition setSpecimen(List<Reference> theSpecimen) {
        this.specimen = theSpecimen;
        return this;
    }

    public boolean hasSpecimen() {
        if (this.specimen == null) {
            return false;
        }
        for (Reference item : this.specimen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimen() {
        Reference t = new Reference();
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return t;
    }

    public ObservationDefinition addSpecimen(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return this;
    }

    public Reference getSpecimenFirstRep() {
        if (this.getSpecimen().isEmpty()) {
            this.addSpecimen();
        }
        return this.getSpecimen().get(0);
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public ObservationDefinition setDevice(List<Reference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public ObservationDefinition addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public Reference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    public StringType getPreferredReportNameElement() {
        if (this.preferredReportName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.preferredReportName");
            }
            if (Configuration.doAutoCreate()) {
                this.preferredReportName = new StringType();
            }
        }
        return this.preferredReportName;
    }

    public boolean hasPreferredReportNameElement() {
        return this.preferredReportName != null && !this.preferredReportName.isEmpty();
    }

    public boolean hasPreferredReportName() {
        return this.preferredReportName != null && !this.preferredReportName.isEmpty();
    }

    public ObservationDefinition setPreferredReportNameElement(StringType value) {
        this.preferredReportName = value;
        return this;
    }

    public String getPreferredReportName() {
        return this.preferredReportName == null ? null : (String)this.preferredReportName.getValue();
    }

    public ObservationDefinition setPreferredReportName(String value) {
        if (Utilities.noString((String)value)) {
            this.preferredReportName = null;
        } else {
            if (this.preferredReportName == null) {
                this.preferredReportName = new StringType();
            }
            this.preferredReportName.setValue(value);
        }
        return this;
    }

    public List<Coding> getPermittedUnit() {
        if (this.permittedUnit == null) {
            this.permittedUnit = new ArrayList<Coding>();
        }
        return this.permittedUnit;
    }

    public ObservationDefinition setPermittedUnit(List<Coding> thePermittedUnit) {
        this.permittedUnit = thePermittedUnit;
        return this;
    }

    public boolean hasPermittedUnit() {
        if (this.permittedUnit == null) {
            return false;
        }
        for (Coding item : this.permittedUnit) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addPermittedUnit() {
        Coding t = new Coding();
        if (this.permittedUnit == null) {
            this.permittedUnit = new ArrayList<Coding>();
        }
        this.permittedUnit.add(t);
        return t;
    }

    public ObservationDefinition addPermittedUnit(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.permittedUnit == null) {
            this.permittedUnit = new ArrayList<Coding>();
        }
        this.permittedUnit.add(t);
        return this;
    }

    public Coding getPermittedUnitFirstRep() {
        if (this.getPermittedUnit().isEmpty()) {
            this.addPermittedUnit();
        }
        return this.getPermittedUnit().get(0);
    }

    public List<ObservationDefinitionQualifiedValueComponent> getQualifiedValue() {
        if (this.qualifiedValue == null) {
            this.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
        }
        return this.qualifiedValue;
    }

    public ObservationDefinition setQualifiedValue(List<ObservationDefinitionQualifiedValueComponent> theQualifiedValue) {
        this.qualifiedValue = theQualifiedValue;
        return this;
    }

    public boolean hasQualifiedValue() {
        if (this.qualifiedValue == null) {
            return false;
        }
        for (ObservationDefinitionQualifiedValueComponent item : this.qualifiedValue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationDefinitionQualifiedValueComponent addQualifiedValue() {
        ObservationDefinitionQualifiedValueComponent t = new ObservationDefinitionQualifiedValueComponent();
        if (this.qualifiedValue == null) {
            this.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
        }
        this.qualifiedValue.add(t);
        return t;
    }

    public ObservationDefinition addQualifiedValue(ObservationDefinitionQualifiedValueComponent t) {
        if (t == null) {
            return this;
        }
        if (this.qualifiedValue == null) {
            this.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
        }
        this.qualifiedValue.add(t);
        return this;
    }

    public ObservationDefinitionQualifiedValueComponent getQualifiedValueFirstRep() {
        if (this.getQualifiedValue().isEmpty()) {
            this.addQualifiedValue();
        }
        return this.getQualifiedValue().get(0);
    }

    public List<Reference> getHasMember() {
        if (this.hasMember == null) {
            this.hasMember = new ArrayList<Reference>();
        }
        return this.hasMember;
    }

    public ObservationDefinition setHasMember(List<Reference> theHasMember) {
        this.hasMember = theHasMember;
        return this;
    }

    public boolean hasHasMember() {
        if (this.hasMember == null) {
            return false;
        }
        for (Reference item : this.hasMember) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addHasMember() {
        Reference t = new Reference();
        if (this.hasMember == null) {
            this.hasMember = new ArrayList<Reference>();
        }
        this.hasMember.add(t);
        return t;
    }

    public ObservationDefinition addHasMember(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.hasMember == null) {
            this.hasMember = new ArrayList<Reference>();
        }
        this.hasMember.add(t);
        return this;
    }

    public Reference getHasMemberFirstRep() {
        if (this.getHasMember().isEmpty()) {
            this.addHasMember();
        }
        return this.getHasMember().get(0);
    }

    public List<ObservationDefinitionComponentComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<ObservationDefinitionComponentComponent>();
        }
        return this.component;
    }

    public ObservationDefinition setComponent(List<ObservationDefinitionComponentComponent> theComponent) {
        this.component = theComponent;
        return this;
    }

    public boolean hasComponent() {
        if (this.component == null) {
            return false;
        }
        for (ObservationDefinitionComponentComponent item : this.component) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationDefinitionComponentComponent addComponent() {
        ObservationDefinitionComponentComponent t = new ObservationDefinitionComponentComponent();
        if (this.component == null) {
            this.component = new ArrayList<ObservationDefinitionComponentComponent>();
        }
        this.component.add(t);
        return t;
    }

    public ObservationDefinition addComponent(ObservationDefinitionComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.component == null) {
            this.component = new ArrayList<ObservationDefinitionComponentComponent>();
        }
        this.component.add(t);
        return this;
    }

    public ObservationDefinitionComponentComponent getComponentFirstRep() {
        if (this.getComponent().isEmpty()) {
            this.addComponent();
        }
        return this.getComponent().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this ObservationDefinition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this ObservationDefinition is (or will be) published. The URL SHOULD include the major version of the ObservationDefinition. For more information see Technical and Business Versions.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this ObservationDefinition. by the performer and/or other systems. These identifiers remain constant as the resource is updated and propagates from server to server.", 0, 1, this.identifier));
        children.add(new Property("version", "string", "The identifier that is used to identify this version of the ObservationDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the ObservationDefinition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property("name", "string", "A natural language name identifying the ObservationDefinition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the ObservationDefinition.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, SP_CODE, "The current state of the ObservationDefinition.", 0, 1, this.status));
        children.add(new Property(SP_EXPERIMENTAL, "boolean", "A flag to indicate that this ObservationDefinition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property("date", "dateTime", "The date (and optionally time) when the ObservationDefinition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the ObservationDefinition changes.", 0, 1, this.date));
        children.add(new Property("publisher", "string", "Helps establish the \"authority/credibility\" of the ObservationDefinition. May also allow for contact.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the ObservationDefinition from the consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate ObservationDefinition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the ObservationDefinition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explains why this ObservationDefinition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "Copyright statement relating to the ObservationDefinition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the ObservationDefinition.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("approvalDate", "date", "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", "date", "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the ObservationDefinition content was or is planned to be effective.", 0, 1, this.effectivePeriod));
        children.add(new Property("derivedFromCanonical", "canonical(ObservationDefinition)", "The canonical URL pointing to another FHIR-defined ObservationDefinition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromCanonical));
        children.add(new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined observation definition, guideline or other definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri));
        children.add(new Property("subject", "CodeableConcept", "A code that describes the intended kind of subject of Observation instances conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("performerType", "CodeableConcept", "The type of individual/organization/device that is expected to act upon instances of this definition.", 0, 1, this.performerType));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of observation.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "Describes what will be observed. Sometimes this is called the observation \"name\".", 0, 1, this.code));
        children.add(new Property("permittedDataType", SP_CODE, "The data types allowed for the value element of the instance observations conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.permittedDataType));
        children.add(new Property("multipleResultsAllowed", "boolean", "Multiple results allowed for observations conforming to this ObservationDefinition.", 0, 1, this.multipleResultsAllowed));
        children.add(new Property("bodySite", "CodeableConcept", "The site on the subject's body where the  observation is to be made.", 0, 1, this.bodySite));
        children.add(new Property(SP_METHOD, "CodeableConcept", "The method or technique used to perform the observation.", 0, 1, this.method));
        children.add(new Property("specimen", "Reference(SpecimenDefinition)", "The kind of specimen that this type of observation is produced on.", 0, Integer.MAX_VALUE, this.specimen));
        children.add(new Property("device", "Reference(DeviceDefinition|Device)", "The measurement model of device or actual device used to produce observations of this type.", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("preferredReportName", "string", "The preferred name to be used when reporting the results of observations conforming to this ObservationDefinition.", 0, 1, this.preferredReportName));
        children.add(new Property("permittedUnit", "Coding", "Units allowed for the valueQuantity element in the instance observations conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.permittedUnit));
        children.add(new Property("qualifiedValue", "", "A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.", 0, Integer.MAX_VALUE, this.qualifiedValue));
        children.add(new Property("hasMember", "Reference(ObservationDefinition|Questionnaire)", "This ObservationDefinition defines a group  observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.", 0, Integer.MAX_VALUE, this.hasMember));
        children.add(new Property("component", "", "Some observations have multiple component observations, expressed as separate code value pairs.", 0, Integer.MAX_VALUE, this.component));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URL that is used to identify this ObservationDefinition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this ObservationDefinition is (or will be) published. The URL SHOULD include the major version of the ObservationDefinition. For more information see Technical and Business Versions.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this ObservationDefinition. by the performer and/or other systems. These identifiers remain constant as the resource is updated and propagates from server to server.", 0, 1, this.identifier);
            }
            case 351608024: {
                return new Property("version", "string", "The identifier that is used to identify this version of the ObservationDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the ObservationDefinition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying the ObservationDefinition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the ObservationDefinition.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The current state of the ObservationDefinition.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property(SP_EXPERIMENTAL, "boolean", "A flag to indicate that this ObservationDefinition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property("date", "dateTime", "The date (and optionally time) when the ObservationDefinition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the ObservationDefinition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property("publisher", "string", "Helps establish the \"authority/credibility\" of the ObservationDefinition. May also allow for contact.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the ObservationDefinition from the consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate ObservationDefinition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the ObservationDefinition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explains why this ObservationDefinition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "Copyright statement relating to the ObservationDefinition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the ObservationDefinition.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 223539345: {
                return new Property("approvalDate", "date", "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", "date", "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the ObservationDefinition content was or is planned to be effective.", 0, 1, this.effectivePeriod);
            }
            case -978133683: {
                return new Property("derivedFromCanonical", "canonical(ObservationDefinition)", "The canonical URL pointing to another FHIR-defined ObservationDefinition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromCanonical);
            }
            case -1076333435: {
                return new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined observation definition, guideline or other definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri);
            }
            case -1867885268: {
                return new Property("subject", "CodeableConcept", "A code that describes the intended kind of subject of Observation instances conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -901444568: {
                return new Property("performerType", "CodeableConcept", "The type of individual/organization/device that is expected to act upon instances of this definition.", 0, 1, this.performerType);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of observation.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Describes what will be observed. Sometimes this is called the observation \"name\".", 0, 1, this.code);
            }
            case -99492804: {
                return new Property("permittedDataType", SP_CODE, "The data types allowed for the value element of the instance observations conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.permittedDataType);
            }
            case -2102414590: {
                return new Property("multipleResultsAllowed", "boolean", "Multiple results allowed for observations conforming to this ObservationDefinition.", 0, 1, this.multipleResultsAllowed);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "The site on the subject's body where the  observation is to be made.", 0, 1, this.bodySite);
            }
            case -1077554975: {
                return new Property(SP_METHOD, "CodeableConcept", "The method or technique used to perform the observation.", 0, 1, this.method);
            }
            case -2132868344: {
                return new Property("specimen", "Reference(SpecimenDefinition)", "The kind of specimen that this type of observation is produced on.", 0, Integer.MAX_VALUE, this.specimen);
            }
            case -1335157162: {
                return new Property("device", "Reference(DeviceDefinition|Device)", "The measurement model of device or actual device used to produce observations of this type.", 0, Integer.MAX_VALUE, this.device);
            }
            case -1851030208: {
                return new Property("preferredReportName", "string", "The preferred name to be used when reporting the results of observations conforming to this ObservationDefinition.", 0, 1, this.preferredReportName);
            }
            case 1073054652: {
                return new Property("permittedUnit", "Coding", "Units allowed for the valueQuantity element in the instance observations conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.permittedUnit);
            }
            case -558517707: {
                return new Property("qualifiedValue", "", "A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.", 0, Integer.MAX_VALUE, this.qualifiedValue);
            }
            case -458019372: {
                return new Property("hasMember", "Reference(ObservationDefinition|Questionnaire)", "This ObservationDefinition defines a group  observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.", 0, Integer.MAX_VALUE, this.hasMember);
            }
            case -1399907075: {
                return new Property("component", "", "Some observations have multiple component observations, expressed as separate code value pairs.", 0, Integer.MAX_VALUE, this.component);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -978133683: {
                return this.derivedFromCanonical == null ? new Base[]{} : this.derivedFromCanonical.toArray(new Base[this.derivedFromCanonical.size()]);
            }
            case -1076333435: {
                return this.derivedFromUri == null ? new Base[]{} : this.derivedFromUri.toArray(new Base[this.derivedFromUri.size()]);
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -901444568: {
                Base[] baseArray;
                if (this.performerType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.performerType;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.code;
                }
                return baseArray;
            }
            case -99492804: {
                return this.permittedDataType == null ? new Base[]{} : this.permittedDataType.toArray(new Base[this.permittedDataType.size()]);
            }
            case -2102414590: {
                Base[] baseArray;
                if (this.multipleResultsAllowed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.multipleResultsAllowed;
                }
                return baseArray;
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.bodySite;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.method;
                }
                return baseArray;
            }
            case -2132868344: {
                return this.specimen == null ? new Base[]{} : this.specimen.toArray(new Base[this.specimen.size()]);
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case -1851030208: {
                Base[] baseArray;
                if (this.preferredReportName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.preferredReportName;
                }
                return baseArray;
            }
            case 1073054652: {
                return this.permittedUnit == null ? new Base[]{} : this.permittedUnit.toArray(new Base[this.permittedUnit.size()]);
            }
            case -558517707: {
                return this.qualifiedValue == null ? new Base[]{} : this.qualifiedValue.toArray(new Base[this.qualifiedValue.size()]);
            }
            case -458019372: {
                return this.hasMember == null ? new Base[]{} : this.hasMember.toArray(new Base[this.hasMember.size()]);
            }
            case -1399907075: {
                return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -978133683: {
                this.getDerivedFromCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1076333435: {
                this.getDerivedFromUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -901444568: {
                this.performerType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -99492804: {
                value = new ObservationDataTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getPermittedDataType().add(value);
                return value;
            }
            case -2102414590: {
                this.multipleResultsAllowed = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1077554975: {
                this.method = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -2132868344: {
                this.getSpecimen().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1335157162: {
                this.getDevice().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1851030208: {
                this.preferredReportName = TypeConvertor.castToString(value);
                return value;
            }
            case 1073054652: {
                this.getPermittedUnit().add(TypeConvertor.castToCoding(value));
                return value;
            }
            case -558517707: {
                this.getQualifiedValue().add((ObservationDefinitionQualifiedValueComponent)((Object)value));
                return value;
            }
            case -458019372: {
                this.getHasMember().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1399907075: {
                this.getComponent().add((ObservationDefinitionComponentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals("date")) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("publisher")) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("derivedFromCanonical")) {
            this.getDerivedFromCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("derivedFromUri")) {
            this.getDerivedFromUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("subject")) {
            this.getSubject().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("performerType")) {
            this.performerType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("permittedDataType")) {
            value = new ObservationDataTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getPermittedDataType().add(value);
        } else if (name.equals("multipleResultsAllowed")) {
            this.multipleResultsAllowed = TypeConvertor.castToBoolean(value);
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_METHOD)) {
            this.method = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("specimen")) {
            this.getSpecimen().add(TypeConvertor.castToReference(value));
        } else if (name.equals("device")) {
            this.getDevice().add(TypeConvertor.castToReference(value));
        } else if (name.equals("preferredReportName")) {
            this.preferredReportName = TypeConvertor.castToString(value);
        } else if (name.equals("permittedUnit")) {
            this.getPermittedUnit().add(TypeConvertor.castToCoding(value));
        } else if (name.equals("qualifiedValue")) {
            this.getQualifiedValue().add((ObservationDefinitionQualifiedValueComponent)((Object)value));
        } else if (name.equals("hasMember")) {
            this.getHasMember().add(TypeConvertor.castToReference(value));
        } else if (name.equals("component")) {
            this.getComponent().add((ObservationDefinitionComponentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = null;
        } else if (name.equals("version")) {
            this.version = null;
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = null;
        } else if (name.equals("name")) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = null;
        } else if (name.equals("date")) {
            this.date = null;
        } else if (name.equals("publisher")) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = null;
        } else if (name.equals("approvalDate")) {
            this.approvalDate = null;
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = null;
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = null;
        } else if (name.equals("derivedFromCanonical")) {
            this.getDerivedFromCanonical().remove(value);
        } else if (name.equals("derivedFromUri")) {
            this.getDerivedFromUri().remove(value);
        } else if (name.equals("subject")) {
            this.getSubject().remove(value);
        } else if (name.equals("performerType")) {
            this.performerType = null;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals("permittedDataType")) {
            value = new ObservationDataTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getPermittedDataType().remove(value);
        } else if (name.equals("multipleResultsAllowed")) {
            this.multipleResultsAllowed = null;
        } else if (name.equals("bodySite")) {
            this.bodySite = null;
        } else if (name.equals(SP_METHOD)) {
            this.method = null;
        } else if (name.equals("specimen")) {
            this.getSpecimen().remove(value);
        } else if (name.equals("device")) {
            this.getDevice().remove(value);
        } else if (name.equals("preferredReportName")) {
            this.preferredReportName = null;
        } else if (name.equals("permittedUnit")) {
            this.getPermittedUnit().remove(value);
        } else if (name.equals("qualifiedValue")) {
            this.getQualifiedValue().remove((ObservationDefinitionQualifiedValueComponent)((Object)value));
        } else if (name.equals("hasMember")) {
            this.getHasMember().remove(value);
        } else if (name.equals("component")) {
            this.getComponent().remove((ObservationDefinitionComponentComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -978133683: {
                return this.addDerivedFromCanonicalElement();
            }
            case -1076333435: {
                return this.addDerivedFromUriElement();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case -901444568: {
                return this.getPerformerType();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -99492804: {
                return this.addPermittedDataTypeElement();
            }
            case -2102414590: {
                return this.getMultipleResultsAllowedElement();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case -2132868344: {
                return this.addSpecimen();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case -1851030208: {
                return this.getPreferredReportNameElement();
            }
            case 1073054652: {
                return this.addPermittedUnit();
            }
            case -558517707: {
                return this.addQualifiedValue();
            }
            case -458019372: {
                return this.addHasMember();
            }
            case -1399907075: {
                return this.addComponent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{"date"};
            }
            case -1687512484: {
                return new String[]{"date"};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -978133683: {
                return new String[]{"canonical"};
            }
            case -1076333435: {
                return new String[]{"uri"};
            }
            case -1867885268: {
                return new String[]{"CodeableConcept"};
            }
            case -901444568: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -99492804: {
                return new String[]{SP_CODE};
            }
            case -2102414590: {
                return new String[]{"boolean"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -1851030208: {
                return new String[]{"string"};
            }
            case 1073054652: {
                return new String[]{"Coding"};
            }
            case -558517707: {
                return new String[0];
            }
            case -458019372: {
                return new String[]{"Reference"};
            }
            case -1399907075: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.experimental");
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.date");
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.copyrightLabel");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("derivedFromCanonical")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.derivedFromCanonical");
        }
        if (name.equals("derivedFromUri")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.derivedFromUri");
        }
        if (name.equals("subject")) {
            return this.addSubject();
        }
        if (name.equals("performerType")) {
            this.performerType = new CodeableConcept();
            return this.performerType;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("permittedDataType")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.permittedDataType");
        }
        if (name.equals("multipleResultsAllowed")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.multipleResultsAllowed");
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals(SP_METHOD)) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("specimen")) {
            return this.addSpecimen();
        }
        if (name.equals("device")) {
            return this.addDevice();
        }
        if (name.equals("preferredReportName")) {
            throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.preferredReportName");
        }
        if (name.equals("permittedUnit")) {
            return this.addPermittedUnit();
        }
        if (name.equals("qualifiedValue")) {
            return this.addQualifiedValue();
        }
        if (name.equals("hasMember")) {
            return this.addHasMember();
        }
        if (name.equals("component")) {
            return this.addComponent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ObservationDefinition";
    }

    @Override
    public ObservationDefinition copy() {
        ObservationDefinition dst = new ObservationDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ObservationDefinition dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.derivedFromCanonical != null) {
            dst.derivedFromCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.derivedFromCanonical) {
                dst.derivedFromCanonical.add(canonicalType.copy());
            }
        }
        if (this.derivedFromUri != null) {
            dst.derivedFromUri = new ArrayList<UriType>();
            for (UriType uriType : this.derivedFromUri) {
                dst.derivedFromUri.add(uriType.copy());
            }
        }
        if (this.subject != null) {
            dst.subject = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.subject) {
                dst.subject.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.performerType = this.performerType == null ? null : this.performerType.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        CodeableConcept codeableConcept3 = dst.code = this.code == null ? null : this.code.copy();
        if (this.permittedDataType != null) {
            dst.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
            for (Enumeration enumeration : this.permittedDataType) {
                dst.permittedDataType.add((Enumeration<ObservationDataType>)enumeration.copy());
            }
        }
        dst.multipleResultsAllowed = this.multipleResultsAllowed == null ? null : this.multipleResultsAllowed.copy();
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        CodeableConcept codeableConcept4 = dst.method = this.method == null ? null : this.method.copy();
        if (this.specimen != null) {
            dst.specimen = new ArrayList<Reference>();
            for (Reference reference : this.specimen) {
                dst.specimen.add(reference.copy());
            }
        }
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference : this.device) {
                dst.device.add(reference.copy());
            }
        }
        StringType stringType2 = dst.preferredReportName = this.preferredReportName == null ? null : this.preferredReportName.copy();
        if (this.permittedUnit != null) {
            dst.permittedUnit = new ArrayList<Coding>();
            for (Coding coding : this.permittedUnit) {
                dst.permittedUnit.add(coding.copy());
            }
        }
        if (this.qualifiedValue != null) {
            dst.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
            for (ObservationDefinitionQualifiedValueComponent observationDefinitionQualifiedValueComponent : this.qualifiedValue) {
                dst.qualifiedValue.add(observationDefinitionQualifiedValueComponent.copy());
            }
        }
        if (this.hasMember != null) {
            dst.hasMember = new ArrayList<Reference>();
            for (Reference reference : this.hasMember) {
                dst.hasMember.add(reference.copy());
            }
        }
        if (this.component != null) {
            dst.component = new ArrayList<ObservationDefinitionComponentComponent>();
            for (ObservationDefinitionComponentComponent observationDefinitionComponentComponent : this.component) {
                dst.component.add(observationDefinitionComponentComponent.copy());
            }
        }
    }

    protected ObservationDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ObservationDefinition)) {
            return false;
        }
        ObservationDefinition o = (ObservationDefinition)other_;
        return ObservationDefinition.compareDeep(this.url, o.url, true) && ObservationDefinition.compareDeep(this.identifier, o.identifier, true) && ObservationDefinition.compareDeep(this.version, o.version, true) && ObservationDefinition.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && ObservationDefinition.compareDeep(this.name, o.name, true) && ObservationDefinition.compareDeep(this.title, o.title, true) && ObservationDefinition.compareDeep(this.status, o.status, true) && ObservationDefinition.compareDeep(this.experimental, o.experimental, true) && ObservationDefinition.compareDeep(this.date, o.date, true) && ObservationDefinition.compareDeep(this.publisher, o.publisher, true) && ObservationDefinition.compareDeep(this.contact, o.contact, true) && ObservationDefinition.compareDeep(this.description, o.description, true) && ObservationDefinition.compareDeep(this.useContext, o.useContext, true) && ObservationDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && ObservationDefinition.compareDeep(this.purpose, o.purpose, true) && ObservationDefinition.compareDeep(this.copyright, o.copyright, true) && ObservationDefinition.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && ObservationDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && ObservationDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ObservationDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ObservationDefinition.compareDeep(this.derivedFromCanonical, o.derivedFromCanonical, true) && ObservationDefinition.compareDeep(this.derivedFromUri, o.derivedFromUri, true) && ObservationDefinition.compareDeep(this.subject, o.subject, true) && ObservationDefinition.compareDeep(this.performerType, o.performerType, true) && ObservationDefinition.compareDeep(this.category, o.category, true) && ObservationDefinition.compareDeep(this.code, o.code, true) && ObservationDefinition.compareDeep(this.permittedDataType, o.permittedDataType, true) && ObservationDefinition.compareDeep(this.multipleResultsAllowed, o.multipleResultsAllowed, true) && ObservationDefinition.compareDeep(this.bodySite, o.bodySite, true) && ObservationDefinition.compareDeep(this.method, o.method, true) && ObservationDefinition.compareDeep(this.specimen, o.specimen, true) && ObservationDefinition.compareDeep(this.device, o.device, true) && ObservationDefinition.compareDeep(this.preferredReportName, o.preferredReportName, true) && ObservationDefinition.compareDeep(this.permittedUnit, o.permittedUnit, true) && ObservationDefinition.compareDeep(this.qualifiedValue, o.qualifiedValue, true) && ObservationDefinition.compareDeep(this.hasMember, o.hasMember, true) && ObservationDefinition.compareDeep(this.component, o.component, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ObservationDefinition)) {
            return false;
        }
        ObservationDefinition o = (ObservationDefinition)other_;
        return ObservationDefinition.compareValues(this.url, o.url, true) && ObservationDefinition.compareValues(this.version, o.version, true) && ObservationDefinition.compareValues(this.name, o.name, true) && ObservationDefinition.compareValues(this.title, o.title, true) && ObservationDefinition.compareValues(this.status, o.status, true) && ObservationDefinition.compareValues(this.experimental, o.experimental, true) && ObservationDefinition.compareValues(this.date, o.date, true) && ObservationDefinition.compareValues(this.publisher, o.publisher, true) && ObservationDefinition.compareValues(this.description, o.description, true) && ObservationDefinition.compareValues(this.purpose, o.purpose, true) && ObservationDefinition.compareValues(this.copyright, o.copyright, true) && ObservationDefinition.compareValues(this.copyrightLabel, o.copyrightLabel, true) && ObservationDefinition.compareValues(this.approvalDate, o.approvalDate, true) && ObservationDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true) && ObservationDefinition.compareValues(this.derivedFromCanonical, o.derivedFromCanonical, true) && ObservationDefinition.compareValues(this.derivedFromUri, o.derivedFromUri, true) && ObservationDefinition.compareValues(this.permittedDataType, o.permittedDataType, true) && ObservationDefinition.compareValues(this.multipleResultsAllowed, o.multipleResultsAllowed, true) && ObservationDefinition.compareValues(this.preferredReportName, o.preferredReportName, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.copyrightLabel, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.derivedFromCanonical, this.derivedFromUri, this.subject, this.performerType, this.category, this.code, this.permittedDataType, this.multipleResultsAllowed, this.bodySite, this.method, this.specimen, this.device, this.preferredReportName, this.permittedUnit, this.qualifiedValue, this.hasMember, this.component});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ObservationDefinition;
    }

    @Block
    public static class ObservationDefinitionComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of observation", formalDefinition="Describes what will be observed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept code;
        @Child(name="permittedDataType", type={CodeType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity | CodeableConcept | string | boolean | integer | Range | Ratio | SampledData | time | dateTime | Period", formalDefinition="The data types allowed for the value element of the instance of this component observations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/permitted-data-type")
        protected List<Enumeration<ObservationDataType>> permittedDataType;
        @Child(name="permittedUnit", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unit for quantitative results", formalDefinition="Units allowed for the valueQuantity element in the instance observations conforming to this ObservationDefinition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
        protected List<Coding> permittedUnit;
        @Child(name="qualifiedValue", type={ObservationDefinitionQualifiedValueComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Set of qualified values for observation results", formalDefinition="A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.")
        protected List<ObservationDefinitionQualifiedValueComponent> qualifiedValue;
        private static final long serialVersionUID = 2106051085L;

        public ObservationDefinitionComponentComponent() {
        }

        public ObservationDefinitionComponentComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ObservationDefinitionComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<Enumeration<ObservationDataType>> getPermittedDataType() {
            if (this.permittedDataType == null) {
                this.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
            }
            return this.permittedDataType;
        }

        public ObservationDefinitionComponentComponent setPermittedDataType(List<Enumeration<ObservationDataType>> thePermittedDataType) {
            this.permittedDataType = thePermittedDataType;
            return this;
        }

        public boolean hasPermittedDataType() {
            if (this.permittedDataType == null) {
                return false;
            }
            for (Enumeration<ObservationDataType> item : this.permittedDataType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<ObservationDataType> addPermittedDataTypeElement() {
            Enumeration<ObservationDataType> t = new Enumeration<ObservationDataType>(new ObservationDataTypeEnumFactory());
            if (this.permittedDataType == null) {
                this.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
            }
            this.permittedDataType.add(t);
            return t;
        }

        public ObservationDefinitionComponentComponent addPermittedDataType(ObservationDataType value) {
            Enumeration<ObservationDataType> t = new Enumeration<ObservationDataType>(new ObservationDataTypeEnumFactory());
            t.setValue((Object)value);
            if (this.permittedDataType == null) {
                this.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
            }
            this.permittedDataType.add(t);
            return this;
        }

        public boolean hasPermittedDataType(ObservationDataType value) {
            if (this.permittedDataType == null) {
                return false;
            }
            for (Enumeration<ObservationDataType> v : this.permittedDataType) {
                if (!((ObservationDataType)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public List<Coding> getPermittedUnit() {
            if (this.permittedUnit == null) {
                this.permittedUnit = new ArrayList<Coding>();
            }
            return this.permittedUnit;
        }

        public ObservationDefinitionComponentComponent setPermittedUnit(List<Coding> thePermittedUnit) {
            this.permittedUnit = thePermittedUnit;
            return this;
        }

        public boolean hasPermittedUnit() {
            if (this.permittedUnit == null) {
                return false;
            }
            for (Coding item : this.permittedUnit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addPermittedUnit() {
            Coding t = new Coding();
            if (this.permittedUnit == null) {
                this.permittedUnit = new ArrayList<Coding>();
            }
            this.permittedUnit.add(t);
            return t;
        }

        public ObservationDefinitionComponentComponent addPermittedUnit(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.permittedUnit == null) {
                this.permittedUnit = new ArrayList<Coding>();
            }
            this.permittedUnit.add(t);
            return this;
        }

        public Coding getPermittedUnitFirstRep() {
            if (this.getPermittedUnit().isEmpty()) {
                this.addPermittedUnit();
            }
            return this.getPermittedUnit().get(0);
        }

        public List<ObservationDefinitionQualifiedValueComponent> getQualifiedValue() {
            if (this.qualifiedValue == null) {
                this.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
            }
            return this.qualifiedValue;
        }

        public ObservationDefinitionComponentComponent setQualifiedValue(List<ObservationDefinitionQualifiedValueComponent> theQualifiedValue) {
            this.qualifiedValue = theQualifiedValue;
            return this;
        }

        public boolean hasQualifiedValue() {
            if (this.qualifiedValue == null) {
                return false;
            }
            for (ObservationDefinitionQualifiedValueComponent item : this.qualifiedValue) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ObservationDefinitionQualifiedValueComponent addQualifiedValue() {
            ObservationDefinitionQualifiedValueComponent t = new ObservationDefinitionQualifiedValueComponent();
            if (this.qualifiedValue == null) {
                this.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
            }
            this.qualifiedValue.add(t);
            return t;
        }

        public ObservationDefinitionComponentComponent addQualifiedValue(ObservationDefinitionQualifiedValueComponent t) {
            if (t == null) {
                return this;
            }
            if (this.qualifiedValue == null) {
                this.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
            }
            this.qualifiedValue.add(t);
            return this;
        }

        public ObservationDefinitionQualifiedValueComponent getQualifiedValueFirstRep() {
            if (this.getQualifiedValue().isEmpty()) {
                this.addQualifiedValue();
            }
            return this.getQualifiedValue().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ObservationDefinition.SP_CODE, "CodeableConcept", "Describes what will be observed.", 0, 1, this.code));
            children.add(new Property("permittedDataType", ObservationDefinition.SP_CODE, "The data types allowed for the value element of the instance of this component observations.", 0, Integer.MAX_VALUE, this.permittedDataType));
            children.add(new Property("permittedUnit", "Coding", "Units allowed for the valueQuantity element in the instance observations conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.permittedUnit));
            children.add(new Property("qualifiedValue", "@ObservationDefinition.qualifiedValue", "A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.", 0, Integer.MAX_VALUE, this.qualifiedValue));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(ObservationDefinition.SP_CODE, "CodeableConcept", "Describes what will be observed.", 0, 1, this.code);
                }
                case -99492804: {
                    return new Property("permittedDataType", ObservationDefinition.SP_CODE, "The data types allowed for the value element of the instance of this component observations.", 0, Integer.MAX_VALUE, this.permittedDataType);
                }
                case 1073054652: {
                    return new Property("permittedUnit", "Coding", "Units allowed for the valueQuantity element in the instance observations conforming to this ObservationDefinition.", 0, Integer.MAX_VALUE, this.permittedUnit);
                }
                case -558517707: {
                    return new Property("qualifiedValue", "@ObservationDefinition.qualifiedValue", "A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.", 0, Integer.MAX_VALUE, this.qualifiedValue);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -99492804: {
                    return this.permittedDataType == null ? new Base[]{} : this.permittedDataType.toArray(new Base[this.permittedDataType.size()]);
                }
                case 1073054652: {
                    return this.permittedUnit == null ? new Base[]{} : this.permittedUnit.toArray(new Base[this.permittedUnit.size()]);
                }
                case -558517707: {
                    return this.qualifiedValue == null ? new Base[]{} : this.qualifiedValue.toArray(new Base[this.qualifiedValue.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -99492804: {
                    value = new ObservationDataTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getPermittedDataType().add(value);
                    return value;
                }
                case 1073054652: {
                    this.getPermittedUnit().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case -558517707: {
                    this.getQualifiedValue().add((ObservationDefinitionQualifiedValueComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ObservationDefinition.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("permittedDataType")) {
                value = new ObservationDataTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getPermittedDataType().add(value);
            } else if (name.equals("permittedUnit")) {
                this.getPermittedUnit().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("qualifiedValue")) {
                this.getQualifiedValue().add((ObservationDefinitionQualifiedValueComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ObservationDefinition.SP_CODE)) {
                this.code = null;
            } else if (name.equals("permittedDataType")) {
                value = new ObservationDataTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getPermittedDataType().remove(value);
            } else if (name.equals("permittedUnit")) {
                this.getPermittedUnit().remove(value);
            } else if (name.equals("qualifiedValue")) {
                this.getQualifiedValue().remove((ObservationDefinitionQualifiedValueComponent)((Object)value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -99492804: {
                    return this.addPermittedDataTypeElement();
                }
                case 1073054652: {
                    return this.addPermittedUnit();
                }
                case -558517707: {
                    return this.addQualifiedValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -99492804: {
                    return new String[]{ObservationDefinition.SP_CODE};
                }
                case 1073054652: {
                    return new String[]{"Coding"};
                }
                case -558517707: {
                    return new String[]{"@ObservationDefinition.qualifiedValue"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ObservationDefinition.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("permittedDataType")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.component.permittedDataType");
            }
            if (name.equals("permittedUnit")) {
                return this.addPermittedUnit();
            }
            if (name.equals("qualifiedValue")) {
                return this.addQualifiedValue();
            }
            return super.addChild(name);
        }

        @Override
        public ObservationDefinitionComponentComponent copy() {
            ObservationDefinitionComponentComponent dst = new ObservationDefinitionComponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ObservationDefinitionComponentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.permittedDataType != null) {
                dst.permittedDataType = new ArrayList<Enumeration<ObservationDataType>>();
                for (Enumeration enumeration : this.permittedDataType) {
                    dst.permittedDataType.add((Enumeration<ObservationDataType>)enumeration.copy());
                }
            }
            if (this.permittedUnit != null) {
                dst.permittedUnit = new ArrayList<Coding>();
                for (Coding coding : this.permittedUnit) {
                    dst.permittedUnit.add(coding.copy());
                }
            }
            if (this.qualifiedValue != null) {
                dst.qualifiedValue = new ArrayList<ObservationDefinitionQualifiedValueComponent>();
                for (ObservationDefinitionQualifiedValueComponent observationDefinitionQualifiedValueComponent : this.qualifiedValue) {
                    dst.qualifiedValue.add(observationDefinitionQualifiedValueComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionComponentComponent)) {
                return false;
            }
            ObservationDefinitionComponentComponent o = (ObservationDefinitionComponentComponent)other_;
            return ObservationDefinitionComponentComponent.compareDeep(this.code, o.code, true) && ObservationDefinitionComponentComponent.compareDeep(this.permittedDataType, o.permittedDataType, true) && ObservationDefinitionComponentComponent.compareDeep(this.permittedUnit, o.permittedUnit, true) && ObservationDefinitionComponentComponent.compareDeep(this.qualifiedValue, o.qualifiedValue, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionComponentComponent)) {
                return false;
            }
            ObservationDefinitionComponentComponent o = (ObservationDefinitionComponentComponent)other_;
            return ObservationDefinitionComponentComponent.compareValues(this.permittedDataType, o.permittedDataType, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.permittedDataType, this.permittedUnit, this.qualifiedValue});
        }

        @Override
        public String fhirType() {
            return "ObservationDefinition.component";
        }
    }

    @Block
    public static class ObservationDefinitionQualifiedValueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="context", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Context qualifier for the set of qualified values", formalDefinition="A concept defining the context for this set of qualified values.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-meaning")
        protected CodeableConcept context;
        @Child(name="appliesTo", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Targetted population for the set of qualified values", formalDefinition="The target population this  set of qualified values applies to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-appliesto")
        protected List<CodeableConcept> appliesTo;
        @Child(name="gender", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="male | female | other | unknown", formalDefinition="The gender this  set of qualified values applies to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
        protected Enumeration<Enumerations.AdministrativeGender> gender;
        @Child(name="age", type={Range.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable age range for the set of qualified values", formalDefinition="The age range this  set of qualified values applies to.")
        protected Range age;
        @Child(name="gestationalAge", type={Range.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable gestational age range for the set of qualified values", formalDefinition="The gestational age this  set of qualified values applies to.")
        protected Range gestationalAge;
        @Child(name="condition", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Condition associated with the set of qualified values", formalDefinition="Text based condition for which the the set of qualified values is valid.")
        protected StringType condition;
        @Child(name="rangeCategory", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="reference | critical | absolute", formalDefinition="The category of range of values for continuous or ordinal observations that match the criteria of this set of qualified values.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-range-category")
        protected Enumeration<ObservationRangeCategory> rangeCategory;
        @Child(name="range", type={Range.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The range for continuous or ordinal observations", formalDefinition="The range of values defined for continuous or ordinal observations that match the criteria of this set of qualified values.")
        protected Range range;
        @Child(name="validCodedValueSet", type={CanonicalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value set of valid coded values as part of this set of qualified values", formalDefinition="The set of valid coded results for qualitative observations  that match the criteria of this set of qualified values.")
        protected CanonicalType validCodedValueSet;
        @Child(name="normalCodedValueSet", type={CanonicalType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value set of normal coded values as part of this set of qualified values", formalDefinition="The set of normal coded results for qualitative observations  that match the criteria of this set of qualified values.")
        protected CanonicalType normalCodedValueSet;
        @Child(name="abnormalCodedValueSet", type={CanonicalType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value set of abnormal coded values as part of this set of qualified values", formalDefinition="The set of abnormal coded results for qualitative observations  that match the criteria of this set of qualified values.")
        protected CanonicalType abnormalCodedValueSet;
        @Child(name="criticalCodedValueSet", type={CanonicalType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value set of critical coded values as part of this set of qualified values", formalDefinition="The set of critical coded results for qualitative observations  that match the criteria of this set of qualified values.")
        protected CanonicalType criticalCodedValueSet;
        private static final long serialVersionUID = -538666361L;

        public CodeableConcept getContext() {
            if (this.context == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.context");
                }
                if (Configuration.doAutoCreate()) {
                    this.context = new CodeableConcept();
                }
            }
            return this.context;
        }

        public boolean hasContext() {
            return this.context != null && !this.context.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setContext(CodeableConcept value) {
            this.context = value;
            return this;
        }

        public List<CodeableConcept> getAppliesTo() {
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            return this.appliesTo;
        }

        public ObservationDefinitionQualifiedValueComponent setAppliesTo(List<CodeableConcept> theAppliesTo) {
            this.appliesTo = theAppliesTo;
            return this;
        }

        public boolean hasAppliesTo() {
            if (this.appliesTo == null) {
                return false;
            }
            for (CodeableConcept item : this.appliesTo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAppliesTo() {
            CodeableConcept t = new CodeableConcept();
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return t;
        }

        public ObservationDefinitionQualifiedValueComponent addAppliesTo(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return this;
        }

        public CodeableConcept getAppliesToFirstRep() {
            if (this.getAppliesTo().isEmpty()) {
                this.addAppliesTo();
            }
            return this.getAppliesTo().get(0);
        }

        public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
            if (this.gender == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.gender");
                }
                if (Configuration.doAutoCreate()) {
                    this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
                }
            }
            return this.gender;
        }

        public boolean hasGenderElement() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public boolean hasGender() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
            this.gender = value;
            return this;
        }

        public Enumerations.AdministrativeGender getGender() {
            return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
        }

        public ObservationDefinitionQualifiedValueComponent setGender(Enumerations.AdministrativeGender value) {
            if (value == null) {
                this.gender = null;
            } else {
                if (this.gender == null) {
                    this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
                }
                this.gender.setValue((Object)value);
            }
            return this;
        }

        public Range getAge() {
            if (this.age == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.age");
                }
                if (Configuration.doAutoCreate()) {
                    this.age = new Range();
                }
            }
            return this.age;
        }

        public boolean hasAge() {
            return this.age != null && !this.age.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setAge(Range value) {
            this.age = value;
            return this;
        }

        public Range getGestationalAge() {
            if (this.gestationalAge == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.gestationalAge");
                }
                if (Configuration.doAutoCreate()) {
                    this.gestationalAge = new Range();
                }
            }
            return this.gestationalAge;
        }

        public boolean hasGestationalAge() {
            return this.gestationalAge != null && !this.gestationalAge.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setGestationalAge(Range value) {
            this.gestationalAge = value;
            return this;
        }

        public StringType getConditionElement() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new StringType();
                }
            }
            return this.condition;
        }

        public boolean hasConditionElement() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setConditionElement(StringType value) {
            this.condition = value;
            return this;
        }

        public String getCondition() {
            return this.condition == null ? null : (String)this.condition.getValue();
        }

        public ObservationDefinitionQualifiedValueComponent setCondition(String value) {
            if (Utilities.noString((String)value)) {
                this.condition = null;
            } else {
                if (this.condition == null) {
                    this.condition = new StringType();
                }
                this.condition.setValue(value);
            }
            return this;
        }

        public Enumeration<ObservationRangeCategory> getRangeCategoryElement() {
            if (this.rangeCategory == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.rangeCategory");
                }
                if (Configuration.doAutoCreate()) {
                    this.rangeCategory = new Enumeration<ObservationRangeCategory>(new ObservationRangeCategoryEnumFactory());
                }
            }
            return this.rangeCategory;
        }

        public boolean hasRangeCategoryElement() {
            return this.rangeCategory != null && !this.rangeCategory.isEmpty();
        }

        public boolean hasRangeCategory() {
            return this.rangeCategory != null && !this.rangeCategory.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setRangeCategoryElement(Enumeration<ObservationRangeCategory> value) {
            this.rangeCategory = value;
            return this;
        }

        public ObservationRangeCategory getRangeCategory() {
            return this.rangeCategory == null ? null : (ObservationRangeCategory)((Object)this.rangeCategory.getValue());
        }

        public ObservationDefinitionQualifiedValueComponent setRangeCategory(ObservationRangeCategory value) {
            if (value == null) {
                this.rangeCategory = null;
            } else {
                if (this.rangeCategory == null) {
                    this.rangeCategory = new Enumeration<ObservationRangeCategory>(new ObservationRangeCategoryEnumFactory());
                }
                this.rangeCategory.setValue((Object)value);
            }
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        public CanonicalType getValidCodedValueSetElement() {
            if (this.validCodedValueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.validCodedValueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.validCodedValueSet = new CanonicalType();
                }
            }
            return this.validCodedValueSet;
        }

        public boolean hasValidCodedValueSetElement() {
            return this.validCodedValueSet != null && !this.validCodedValueSet.isEmpty();
        }

        public boolean hasValidCodedValueSet() {
            return this.validCodedValueSet != null && !this.validCodedValueSet.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setValidCodedValueSetElement(CanonicalType value) {
            this.validCodedValueSet = value;
            return this;
        }

        public String getValidCodedValueSet() {
            return this.validCodedValueSet == null ? null : (String)this.validCodedValueSet.getValue();
        }

        public ObservationDefinitionQualifiedValueComponent setValidCodedValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.validCodedValueSet = null;
            } else {
                if (this.validCodedValueSet == null) {
                    this.validCodedValueSet = new CanonicalType();
                }
                this.validCodedValueSet.setValue(value);
            }
            return this;
        }

        public CanonicalType getNormalCodedValueSetElement() {
            if (this.normalCodedValueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.normalCodedValueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.normalCodedValueSet = new CanonicalType();
                }
            }
            return this.normalCodedValueSet;
        }

        public boolean hasNormalCodedValueSetElement() {
            return this.normalCodedValueSet != null && !this.normalCodedValueSet.isEmpty();
        }

        public boolean hasNormalCodedValueSet() {
            return this.normalCodedValueSet != null && !this.normalCodedValueSet.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setNormalCodedValueSetElement(CanonicalType value) {
            this.normalCodedValueSet = value;
            return this;
        }

        public String getNormalCodedValueSet() {
            return this.normalCodedValueSet == null ? null : (String)this.normalCodedValueSet.getValue();
        }

        public ObservationDefinitionQualifiedValueComponent setNormalCodedValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.normalCodedValueSet = null;
            } else {
                if (this.normalCodedValueSet == null) {
                    this.normalCodedValueSet = new CanonicalType();
                }
                this.normalCodedValueSet.setValue(value);
            }
            return this;
        }

        public CanonicalType getAbnormalCodedValueSetElement() {
            if (this.abnormalCodedValueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.abnormalCodedValueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.abnormalCodedValueSet = new CanonicalType();
                }
            }
            return this.abnormalCodedValueSet;
        }

        public boolean hasAbnormalCodedValueSetElement() {
            return this.abnormalCodedValueSet != null && !this.abnormalCodedValueSet.isEmpty();
        }

        public boolean hasAbnormalCodedValueSet() {
            return this.abnormalCodedValueSet != null && !this.abnormalCodedValueSet.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setAbnormalCodedValueSetElement(CanonicalType value) {
            this.abnormalCodedValueSet = value;
            return this;
        }

        public String getAbnormalCodedValueSet() {
            return this.abnormalCodedValueSet == null ? null : (String)this.abnormalCodedValueSet.getValue();
        }

        public ObservationDefinitionQualifiedValueComponent setAbnormalCodedValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.abnormalCodedValueSet = null;
            } else {
                if (this.abnormalCodedValueSet == null) {
                    this.abnormalCodedValueSet = new CanonicalType();
                }
                this.abnormalCodedValueSet.setValue(value);
            }
            return this;
        }

        public CanonicalType getCriticalCodedValueSetElement() {
            if (this.criticalCodedValueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedValueComponent.criticalCodedValueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.criticalCodedValueSet = new CanonicalType();
                }
            }
            return this.criticalCodedValueSet;
        }

        public boolean hasCriticalCodedValueSetElement() {
            return this.criticalCodedValueSet != null && !this.criticalCodedValueSet.isEmpty();
        }

        public boolean hasCriticalCodedValueSet() {
            return this.criticalCodedValueSet != null && !this.criticalCodedValueSet.isEmpty();
        }

        public ObservationDefinitionQualifiedValueComponent setCriticalCodedValueSetElement(CanonicalType value) {
            this.criticalCodedValueSet = value;
            return this;
        }

        public String getCriticalCodedValueSet() {
            return this.criticalCodedValueSet == null ? null : (String)this.criticalCodedValueSet.getValue();
        }

        public ObservationDefinitionQualifiedValueComponent setCriticalCodedValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.criticalCodedValueSet = null;
            } else {
                if (this.criticalCodedValueSet == null) {
                    this.criticalCodedValueSet = new CanonicalType();
                }
                this.criticalCodedValueSet.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("context", "CodeableConcept", "A concept defining the context for this set of qualified values.", 0, 1, this.context));
            children.add(new Property("appliesTo", "CodeableConcept", "The target population this  set of qualified values applies to.", 0, Integer.MAX_VALUE, this.appliesTo));
            children.add(new Property("gender", ObservationDefinition.SP_CODE, "The gender this  set of qualified values applies to.", 0, 1, this.gender));
            children.add(new Property("age", "Range", "The age range this  set of qualified values applies to.", 0, 1, this.age));
            children.add(new Property("gestationalAge", "Range", "The gestational age this  set of qualified values applies to.", 0, 1, this.gestationalAge));
            children.add(new Property("condition", "string", "Text based condition for which the the set of qualified values is valid.", 0, 1, this.condition));
            children.add(new Property("rangeCategory", ObservationDefinition.SP_CODE, "The category of range of values for continuous or ordinal observations that match the criteria of this set of qualified values.", 0, 1, this.rangeCategory));
            children.add(new Property("range", "Range", "The range of values defined for continuous or ordinal observations that match the criteria of this set of qualified values.", 0, 1, this.range));
            children.add(new Property("validCodedValueSet", "canonical(ValueSet)", "The set of valid coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.validCodedValueSet));
            children.add(new Property("normalCodedValueSet", "canonical(ValueSet)", "The set of normal coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.normalCodedValueSet));
            children.add(new Property("abnormalCodedValueSet", "canonical(ValueSet)", "The set of abnormal coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.abnormalCodedValueSet));
            children.add(new Property("criticalCodedValueSet", "canonical(ValueSet)", "The set of critical coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.criticalCodedValueSet));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 951530927: {
                    return new Property("context", "CodeableConcept", "A concept defining the context for this set of qualified values.", 0, 1, this.context);
                }
                case -2089924569: {
                    return new Property("appliesTo", "CodeableConcept", "The target population this  set of qualified values applies to.", 0, Integer.MAX_VALUE, this.appliesTo);
                }
                case -1249512767: {
                    return new Property("gender", ObservationDefinition.SP_CODE, "The gender this  set of qualified values applies to.", 0, 1, this.gender);
                }
                case 96511: {
                    return new Property("age", "Range", "The age range this  set of qualified values applies to.", 0, 1, this.age);
                }
                case -241217538: {
                    return new Property("gestationalAge", "Range", "The gestational age this  set of qualified values applies to.", 0, 1, this.gestationalAge);
                }
                case -861311717: {
                    return new Property("condition", "string", "Text based condition for which the the set of qualified values is valid.", 0, 1, this.condition);
                }
                case -363410085: {
                    return new Property("rangeCategory", ObservationDefinition.SP_CODE, "The category of range of values for continuous or ordinal observations that match the criteria of this set of qualified values.", 0, 1, this.rangeCategory);
                }
                case 108280125: {
                    return new Property("range", "Range", "The range of values defined for continuous or ordinal observations that match the criteria of this set of qualified values.", 0, 1, this.range);
                }
                case 1374640076: {
                    return new Property("validCodedValueSet", "canonical(ValueSet)", "The set of valid coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.validCodedValueSet);
                }
                case -837500735: {
                    return new Property("normalCodedValueSet", "canonical(ValueSet)", "The set of normal coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.normalCodedValueSet);
                }
                case 1073600256: {
                    return new Property("abnormalCodedValueSet", "canonical(ValueSet)", "The set of abnormal coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.abnormalCodedValueSet);
                }
                case 2568457: {
                    return new Property("criticalCodedValueSet", "canonical(ValueSet)", "The set of critical coded results for qualitative observations  that match the criteria of this set of qualified values.", 0, 1, this.criticalCodedValueSet);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    Base[] baseArray;
                    if (this.context == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.context;
                    }
                    return baseArray;
                }
                case -2089924569: {
                    return this.appliesTo == null ? new Base[]{} : this.appliesTo.toArray(new Base[this.appliesTo.size()]);
                }
                case -1249512767: {
                    Base[] baseArray;
                    if (this.gender == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.gender;
                    }
                    return baseArray;
                }
                case 96511: {
                    Base[] baseArray;
                    if (this.age == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.age;
                    }
                    return baseArray;
                }
                case -241217538: {
                    Base[] baseArray;
                    if (this.gestationalAge == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.gestationalAge;
                    }
                    return baseArray;
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.condition;
                    }
                    return baseArray;
                }
                case -363410085: {
                    Base[] baseArray;
                    if (this.rangeCategory == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.rangeCategory;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.range;
                    }
                    return baseArray;
                }
                case 1374640076: {
                    Base[] baseArray;
                    if (this.validCodedValueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.validCodedValueSet;
                    }
                    return baseArray;
                }
                case -837500735: {
                    Base[] baseArray;
                    if (this.normalCodedValueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.normalCodedValueSet;
                    }
                    return baseArray;
                }
                case 1073600256: {
                    Base[] baseArray;
                    if (this.abnormalCodedValueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.abnormalCodedValueSet;
                    }
                    return baseArray;
                }
                case 2568457: {
                    Base[] baseArray;
                    if (this.criticalCodedValueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.criticalCodedValueSet;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    this.context = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2089924569: {
                    this.getAppliesTo().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1249512767: {
                    value = new Enumerations.AdministrativeGenderEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.gender = value;
                    return value;
                }
                case 96511: {
                    this.age = TypeConvertor.castToRange(value);
                    return value;
                }
                case -241217538: {
                    this.gestationalAge = TypeConvertor.castToRange(value);
                    return value;
                }
                case -861311717: {
                    this.condition = TypeConvertor.castToString(value);
                    return value;
                }
                case -363410085: {
                    value = new ObservationRangeCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.rangeCategory = value;
                    return value;
                }
                case 108280125: {
                    this.range = TypeConvertor.castToRange(value);
                    return value;
                }
                case 1374640076: {
                    this.validCodedValueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -837500735: {
                    this.normalCodedValueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 1073600256: {
                    this.abnormalCodedValueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 2568457: {
                    this.criticalCodedValueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("context")) {
                this.context = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("appliesTo")) {
                this.getAppliesTo().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("gender")) {
                value = new Enumerations.AdministrativeGenderEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.gender = value;
            } else if (name.equals("age")) {
                this.age = TypeConvertor.castToRange(value);
            } else if (name.equals("gestationalAge")) {
                this.gestationalAge = TypeConvertor.castToRange(value);
            } else if (name.equals("condition")) {
                this.condition = TypeConvertor.castToString(value);
            } else if (name.equals("rangeCategory")) {
                value = new ObservationRangeCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.rangeCategory = value;
            } else if (name.equals("range")) {
                this.range = TypeConvertor.castToRange(value);
            } else if (name.equals("validCodedValueSet")) {
                this.validCodedValueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("normalCodedValueSet")) {
                this.normalCodedValueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("abnormalCodedValueSet")) {
                this.abnormalCodedValueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("criticalCodedValueSet")) {
                this.criticalCodedValueSet = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("context")) {
                this.context = null;
            } else if (name.equals("appliesTo")) {
                this.getAppliesTo().remove(value);
            } else if (name.equals("gender")) {
                value = new Enumerations.AdministrativeGenderEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.gender = value;
            } else if (name.equals("age")) {
                this.age = null;
            } else if (name.equals("gestationalAge")) {
                this.gestationalAge = null;
            } else if (name.equals("condition")) {
                this.condition = null;
            } else if (name.equals("rangeCategory")) {
                value = new ObservationRangeCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.rangeCategory = value;
            } else if (name.equals("range")) {
                this.range = null;
            } else if (name.equals("validCodedValueSet")) {
                this.validCodedValueSet = null;
            } else if (name.equals("normalCodedValueSet")) {
                this.normalCodedValueSet = null;
            } else if (name.equals("abnormalCodedValueSet")) {
                this.abnormalCodedValueSet = null;
            } else if (name.equals("criticalCodedValueSet")) {
                this.criticalCodedValueSet = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    return this.getContext();
                }
                case -2089924569: {
                    return this.addAppliesTo();
                }
                case -1249512767: {
                    return this.getGenderElement();
                }
                case 96511: {
                    return this.getAge();
                }
                case -241217538: {
                    return this.getGestationalAge();
                }
                case -861311717: {
                    return this.getConditionElement();
                }
                case -363410085: {
                    return this.getRangeCategoryElement();
                }
                case 108280125: {
                    return this.getRange();
                }
                case 1374640076: {
                    return this.getValidCodedValueSetElement();
                }
                case -837500735: {
                    return this.getNormalCodedValueSetElement();
                }
                case 1073600256: {
                    return this.getAbnormalCodedValueSetElement();
                }
                case 2568457: {
                    return this.getCriticalCodedValueSetElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    return new String[]{"CodeableConcept"};
                }
                case -2089924569: {
                    return new String[]{"CodeableConcept"};
                }
                case -1249512767: {
                    return new String[]{ObservationDefinition.SP_CODE};
                }
                case 96511: {
                    return new String[]{"Range"};
                }
                case -241217538: {
                    return new String[]{"Range"};
                }
                case -861311717: {
                    return new String[]{"string"};
                }
                case -363410085: {
                    return new String[]{ObservationDefinition.SP_CODE};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
                case 1374640076: {
                    return new String[]{"canonical"};
                }
                case -837500735: {
                    return new String[]{"canonical"};
                }
                case 1073600256: {
                    return new String[]{"canonical"};
                }
                case 2568457: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("context")) {
                this.context = new CodeableConcept();
                return this.context;
            }
            if (name.equals("appliesTo")) {
                return this.addAppliesTo();
            }
            if (name.equals("gender")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.qualifiedValue.gender");
            }
            if (name.equals("age")) {
                this.age = new Range();
                return this.age;
            }
            if (name.equals("gestationalAge")) {
                this.gestationalAge = new Range();
                return this.gestationalAge;
            }
            if (name.equals("condition")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.qualifiedValue.condition");
            }
            if (name.equals("rangeCategory")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.qualifiedValue.rangeCategory");
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            if (name.equals("validCodedValueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.qualifiedValue.validCodedValueSet");
            }
            if (name.equals("normalCodedValueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.qualifiedValue.normalCodedValueSet");
            }
            if (name.equals("abnormalCodedValueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.qualifiedValue.abnormalCodedValueSet");
            }
            if (name.equals("criticalCodedValueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ObservationDefinition.qualifiedValue.criticalCodedValueSet");
            }
            return super.addChild(name);
        }

        @Override
        public ObservationDefinitionQualifiedValueComponent copy() {
            ObservationDefinitionQualifiedValueComponent dst = new ObservationDefinitionQualifiedValueComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ObservationDefinitionQualifiedValueComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.context = this.context == null ? null : this.context.copy();
            if (this.appliesTo != null) {
                dst.appliesTo = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.appliesTo) {
                    dst.appliesTo.add(i.copy());
                }
            }
            dst.gender = this.gender == null ? null : this.gender.copy();
            dst.age = this.age == null ? null : this.age.copy();
            dst.gestationalAge = this.gestationalAge == null ? null : this.gestationalAge.copy();
            dst.condition = this.condition == null ? null : this.condition.copy();
            dst.rangeCategory = this.rangeCategory == null ? null : this.rangeCategory.copy();
            dst.range = this.range == null ? null : this.range.copy();
            dst.validCodedValueSet = this.validCodedValueSet == null ? null : this.validCodedValueSet.copy();
            dst.normalCodedValueSet = this.normalCodedValueSet == null ? null : this.normalCodedValueSet.copy();
            dst.abnormalCodedValueSet = this.abnormalCodedValueSet == null ? null : this.abnormalCodedValueSet.copy();
            dst.criticalCodedValueSet = this.criticalCodedValueSet == null ? null : this.criticalCodedValueSet.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionQualifiedValueComponent)) {
                return false;
            }
            ObservationDefinitionQualifiedValueComponent o = (ObservationDefinitionQualifiedValueComponent)other_;
            return ObservationDefinitionQualifiedValueComponent.compareDeep(this.context, o.context, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.appliesTo, o.appliesTo, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.gender, o.gender, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.age, o.age, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.gestationalAge, o.gestationalAge, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.condition, o.condition, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.rangeCategory, o.rangeCategory, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.range, o.range, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.validCodedValueSet, o.validCodedValueSet, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.normalCodedValueSet, o.normalCodedValueSet, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.abnormalCodedValueSet, o.abnormalCodedValueSet, true) && ObservationDefinitionQualifiedValueComponent.compareDeep(this.criticalCodedValueSet, o.criticalCodedValueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionQualifiedValueComponent)) {
                return false;
            }
            ObservationDefinitionQualifiedValueComponent o = (ObservationDefinitionQualifiedValueComponent)other_;
            return ObservationDefinitionQualifiedValueComponent.compareValues(this.gender, o.gender, true) && ObservationDefinitionQualifiedValueComponent.compareValues(this.condition, o.condition, true) && ObservationDefinitionQualifiedValueComponent.compareValues(this.rangeCategory, o.rangeCategory, true) && ObservationDefinitionQualifiedValueComponent.compareValues(this.validCodedValueSet, o.validCodedValueSet, true) && ObservationDefinitionQualifiedValueComponent.compareValues(this.normalCodedValueSet, o.normalCodedValueSet, true) && ObservationDefinitionQualifiedValueComponent.compareValues(this.abnormalCodedValueSet, o.abnormalCodedValueSet, true) && ObservationDefinitionQualifiedValueComponent.compareValues(this.criticalCodedValueSet, o.criticalCodedValueSet, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.context, this.appliesTo, this.gender, this.age, this.gestationalAge, this.condition, this.rangeCategory, this.range, this.validCodedValueSet, this.normalCodedValueSet, this.abnormalCodedValueSet, this.criticalCodedValueSet});
        }

        @Override
        public String fhirType() {
            return "ObservationDefinition.qualifiedValue";
        }
    }

    public static class ObservationRangeCategoryEnumFactory
    implements EnumFactory<ObservationRangeCategory> {
        @Override
        public ObservationRangeCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return ObservationRangeCategory.REFERENCE;
            }
            if ("critical".equals(codeString)) {
                return ObservationRangeCategory.CRITICAL;
            }
            if ("absolute".equals(codeString)) {
                return ObservationRangeCategory.ABSOLUTE;
            }
            throw new IllegalArgumentException("Unknown ObservationRangeCategory code '" + codeString + "'");
        }

        public Enumeration<ObservationRangeCategory> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ObservationRangeCategory>(this, ObservationRangeCategory.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ObservationRangeCategory>(this, ObservationRangeCategory.NULL, code);
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<ObservationRangeCategory>(this, ObservationRangeCategory.REFERENCE, code);
            }
            if ("critical".equals(codeString)) {
                return new Enumeration<ObservationRangeCategory>(this, ObservationRangeCategory.CRITICAL, code);
            }
            if ("absolute".equals(codeString)) {
                return new Enumeration<ObservationRangeCategory>(this, ObservationRangeCategory.ABSOLUTE, code);
            }
            throw new FHIRException("Unknown ObservationRangeCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(ObservationRangeCategory code) {
            if (code == ObservationRangeCategory.NULL) {
                return null;
            }
            if (code == ObservationRangeCategory.REFERENCE) {
                return "reference";
            }
            if (code == ObservationRangeCategory.CRITICAL) {
                return "critical";
            }
            if (code == ObservationRangeCategory.ABSOLUTE) {
                return "absolute";
            }
            return "?";
        }

        @Override
        public String toSystem(ObservationRangeCategory code) {
            return code.getSystem();
        }
    }

    public static enum ObservationRangeCategory {
        REFERENCE,
        CRITICAL,
        ABSOLUTE,
        NULL;


        public static ObservationRangeCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("critical".equals(codeString)) {
                return CRITICAL;
            }
            if ("absolute".equals(codeString)) {
                return ABSOLUTE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ObservationRangeCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REFERENCE: {
                    return "reference";
                }
                case CRITICAL: {
                    return "critical";
                }
                case ABSOLUTE: {
                    return "absolute";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REFERENCE: {
                    return "http://hl7.org/fhir/observation-range-category";
                }
                case CRITICAL: {
                    return "http://hl7.org/fhir/observation-range-category";
                }
                case ABSOLUTE: {
                    return "http://hl7.org/fhir/observation-range-category";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REFERENCE: {
                    return "Reference (Normal) Range for Ordinal and Continuous Observations.";
                }
                case CRITICAL: {
                    return "Critical Range for Ordinal and Continuous Observations. Results outside this range are critical.";
                }
                case ABSOLUTE: {
                    return "Absolute Range for Ordinal and Continuous Observations. Results outside this range are not possible.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REFERENCE: {
                    return "reference range";
                }
                case CRITICAL: {
                    return "critical range";
                }
                case ABSOLUTE: {
                    return "absolute range";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ObservationDataTypeEnumFactory
    implements EnumFactory<ObservationDataType> {
        @Override
        public ObservationDataType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Quantity".equals(codeString)) {
                return ObservationDataType.QUANTITY;
            }
            if ("CodeableConcept".equals(codeString)) {
                return ObservationDataType.CODEABLECONCEPT;
            }
            if ("string".equals(codeString)) {
                return ObservationDataType.STRING;
            }
            if ("boolean".equals(codeString)) {
                return ObservationDataType.BOOLEAN;
            }
            if ("integer".equals(codeString)) {
                return ObservationDataType.INTEGER;
            }
            if ("Range".equals(codeString)) {
                return ObservationDataType.RANGE;
            }
            if ("Ratio".equals(codeString)) {
                return ObservationDataType.RATIO;
            }
            if ("SampledData".equals(codeString)) {
                return ObservationDataType.SAMPLEDDATA;
            }
            if ("time".equals(codeString)) {
                return ObservationDataType.TIME;
            }
            if ("dateTime".equals(codeString)) {
                return ObservationDataType.DATETIME;
            }
            if ("Period".equals(codeString)) {
                return ObservationDataType.PERIOD;
            }
            throw new IllegalArgumentException("Unknown ObservationDataType code '" + codeString + "'");
        }

        public Enumeration<ObservationDataType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.NULL, code);
            }
            if ("Quantity".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.QUANTITY, code);
            }
            if ("CodeableConcept".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.CODEABLECONCEPT, code);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.STRING, code);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.BOOLEAN, code);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.INTEGER, code);
            }
            if ("Range".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.RANGE, code);
            }
            if ("Ratio".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.RATIO, code);
            }
            if ("SampledData".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.SAMPLEDDATA, code);
            }
            if ("time".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.TIME, code);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.DATETIME, code);
            }
            if ("Period".equals(codeString)) {
                return new Enumeration<ObservationDataType>(this, ObservationDataType.PERIOD, code);
            }
            throw new FHIRException("Unknown ObservationDataType code '" + codeString + "'");
        }

        @Override
        public String toCode(ObservationDataType code) {
            if (code == ObservationDataType.NULL) {
                return null;
            }
            if (code == ObservationDataType.QUANTITY) {
                return "Quantity";
            }
            if (code == ObservationDataType.CODEABLECONCEPT) {
                return "CodeableConcept";
            }
            if (code == ObservationDataType.STRING) {
                return "string";
            }
            if (code == ObservationDataType.BOOLEAN) {
                return "boolean";
            }
            if (code == ObservationDataType.INTEGER) {
                return "integer";
            }
            if (code == ObservationDataType.RANGE) {
                return "Range";
            }
            if (code == ObservationDataType.RATIO) {
                return "Ratio";
            }
            if (code == ObservationDataType.SAMPLEDDATA) {
                return "SampledData";
            }
            if (code == ObservationDataType.TIME) {
                return "time";
            }
            if (code == ObservationDataType.DATETIME) {
                return "dateTime";
            }
            if (code == ObservationDataType.PERIOD) {
                return "Period";
            }
            return "?";
        }

        @Override
        public String toSystem(ObservationDataType code) {
            return code.getSystem();
        }
    }

    public static enum ObservationDataType {
        QUANTITY,
        CODEABLECONCEPT,
        STRING,
        BOOLEAN,
        INTEGER,
        RANGE,
        RATIO,
        SAMPLEDDATA,
        TIME,
        DATETIME,
        PERIOD,
        NULL;


        public static ObservationDataType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Quantity".equals(codeString)) {
                return QUANTITY;
            }
            if ("CodeableConcept".equals(codeString)) {
                return CODEABLECONCEPT;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if ("Range".equals(codeString)) {
                return RANGE;
            }
            if ("Ratio".equals(codeString)) {
                return RATIO;
            }
            if ("SampledData".equals(codeString)) {
                return SAMPLEDDATA;
            }
            if ("time".equals(codeString)) {
                return TIME;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            if ("Period".equals(codeString)) {
                return PERIOD;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ObservationDataType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case QUANTITY: {
                    return "Quantity";
                }
                case CODEABLECONCEPT: {
                    return "CodeableConcept";
                }
                case STRING: {
                    return "string";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case INTEGER: {
                    return "integer";
                }
                case RANGE: {
                    return "Range";
                }
                case RATIO: {
                    return "Ratio";
                }
                case SAMPLEDDATA: {
                    return "SampledData";
                }
                case TIME: {
                    return "time";
                }
                case DATETIME: {
                    return "dateTime";
                }
                case PERIOD: {
                    return "Period";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case QUANTITY: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case CODEABLECONCEPT: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case STRING: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case RANGE: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case RATIO: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case SAMPLEDDATA: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case TIME: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case PERIOD: {
                    return "http://hl7.org/fhir/permitted-data-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case QUANTITY: {
                    return "A measured amount.";
                }
                case CODEABLECONCEPT: {
                    return "A coded concept from a reference terminology and/or text.";
                }
                case STRING: {
                    return "A sequence of Unicode characters.";
                }
                case BOOLEAN: {
                    return "true or false.";
                }
                case INTEGER: {
                    return "A signed integer.";
                }
                case RANGE: {
                    return "A set of values bounded by low and high.";
                }
                case RATIO: {
                    return "A ratio of two Quantity values - a numerator and a denominator.";
                }
                case SAMPLEDDATA: {
                    return "A series of measurements taken by a device.";
                }
                case TIME: {
                    return "A time during the day, in the format hh:mm:ss.";
                }
                case DATETIME: {
                    return "A date, date-time or partial date (e.g. just year or year + month) as used in human communication.";
                }
                case PERIOD: {
                    return "A time range defined by start and end date/time.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case QUANTITY: {
                    return "Quantity";
                }
                case CODEABLECONCEPT: {
                    return "CodeableConcept";
                }
                case STRING: {
                    return "string";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case INTEGER: {
                    return "integer";
                }
                case RANGE: {
                    return "Range";
                }
                case RATIO: {
                    return "Ratio";
                }
                case SAMPLEDDATA: {
                    return "SampledData";
                }
                case TIME: {
                    return "time";
                }
                case DATETIME: {
                    return "dateTime";
                }
                case PERIOD: {
                    return "Period";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

