/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="FormularyItem", profile="http://hl7.org/fhir/StructureDefinition/FormularyItem")
public class FormularyItem
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this formulary item", formalDefinition="Business identifier for this formulary item.")
    protected List<Identifier> identifier;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Codes that identify this formulary item", formalDefinition="A code (or set of codes) that specify the product or service that is identified by this formulary item.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableConcept code;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | entered-in-error | inactive", formalDefinition="The validity about the information of the formulary item and not of the underlying product or service itself.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/formularyitem-status")
    protected Enumeration<FormularyItemStatusCodes> status;
    private static final long serialVersionUID = 601026823L;
    @SearchParamDefinition(name="code", path="FormularyItem.code", description="Returns formulary items for a specific code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="FormularyItem.identifier", description="Returns formulary items with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public FormularyItem setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public FormularyItem addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FormularyItem.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public FormularyItem setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<FormularyItemStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FormularyItem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FormularyItemStatusCodes>(new FormularyItemStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public FormularyItem setStatusElement(Enumeration<FormularyItemStatusCodes> value) {
        this.status = value;
        return this;
    }

    public FormularyItemStatusCodes getStatus() {
        return this.status == null ? null : (FormularyItemStatusCodes)((Object)this.status.getValue());
    }

    public FormularyItem setStatus(FormularyItemStatusCodes value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<FormularyItemStatusCodes>(new FormularyItemStatusCodesEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this formulary item.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that specify the product or service that is identified by this formulary item.", 0, 1, this.code));
        children.add(new Property("status", SP_CODE, "The validity about the information of the formulary item and not of the underlying product or service itself.", 0, 1, this.status));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this formulary item.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that specify the product or service that is identified by this formulary item.", 0, 1, this.code);
            }
            case -892481550: {
                return new Property("status", SP_CODE, "The validity about the information of the formulary item and not of the underlying product or service itself.", 0, 1, this.status);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new FormularyItemStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("status")) {
            value = new FormularyItemStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals("status")) {
            value = new FormularyItemStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3059181: {
                return this.getCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property FormularyItem.status");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "FormularyItem";
    }

    @Override
    public FormularyItem copy() {
        FormularyItem dst = new FormularyItem();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(FormularyItem dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.status = this.status == null ? null : this.status.copy();
    }

    protected FormularyItem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof FormularyItem)) {
            return false;
        }
        FormularyItem o = (FormularyItem)other_;
        return FormularyItem.compareDeep(this.identifier, o.identifier, true) && FormularyItem.compareDeep(this.code, o.code, true) && FormularyItem.compareDeep(this.status, o.status, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof FormularyItem)) {
            return false;
        }
        FormularyItem o = (FormularyItem)other_;
        return FormularyItem.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.code, this.status});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.FormularyItem;
    }

    public static class FormularyItemStatusCodesEnumFactory
    implements EnumFactory<FormularyItemStatusCodes> {
        @Override
        public FormularyItemStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return FormularyItemStatusCodes.ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return FormularyItemStatusCodes.ENTEREDINERROR;
            }
            if ("inactive".equals(codeString)) {
                return FormularyItemStatusCodes.INACTIVE;
            }
            throw new IllegalArgumentException("Unknown FormularyItemStatusCodes code '" + codeString + "'");
        }

        public Enumeration<FormularyItemStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FormularyItemStatusCodes>(this, FormularyItemStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<FormularyItemStatusCodes>(this, FormularyItemStatusCodes.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<FormularyItemStatusCodes>(this, FormularyItemStatusCodes.ACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FormularyItemStatusCodes>(this, FormularyItemStatusCodes.ENTEREDINERROR, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<FormularyItemStatusCodes>(this, FormularyItemStatusCodes.INACTIVE, code);
            }
            throw new FHIRException("Unknown FormularyItemStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(FormularyItemStatusCodes code) {
            if (code == FormularyItemStatusCodes.NULL) {
                return null;
            }
            if (code == FormularyItemStatusCodes.ACTIVE) {
                return "active";
            }
            if (code == FormularyItemStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == FormularyItemStatusCodes.INACTIVE) {
                return "inactive";
            }
            return "?";
        }

        @Override
        public String toSystem(FormularyItemStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum FormularyItemStatusCodes {
        ACTIVE,
        ENTEREDINERROR,
        INACTIVE,
        NULL;


        public static FormularyItemStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FormularyItemStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/formularyitem-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/formularyitem-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/formularyitem-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The service or product referred to by this FormularyItem is in active use within the drug database or inventory system.";
                }
                case ENTEREDINERROR: {
                    return "The service or product referred to by this FormularyItem was entered in error within the drug database or inventory system.";
                }
                case INACTIVE: {
                    return "The service or product referred to by this FormularyItem is not in active use within the drug database or inventory system.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

