/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.liquid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRLexer;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Tuple;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class LiquidEngine
implements FHIRPathEngine.IEvaluationContext {
    private FHIRPathEngine.IEvaluationContext externalHostServices;
    private FHIRPathEngine engine;
    private ILiquidEngineIncludeResolver includeResolver;
    private ILiquidRenderingSupport renderingSupport;
    private MarkDownProcessor processor = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK);
    private Map<String, Base> vars = new HashMap<String, Base>();

    public LiquidEngine(IWorkerContext context, FHIRPathEngine.IEvaluationContext hostServices) {
        this.externalHostServices = hostServices;
        this.engine = new FHIRPathEngine(context);
        this.engine.setHostServices(this);
        this.engine.setLiquidMode(true);
    }

    public ILiquidEngineIncludeResolver getIncludeResolver() {
        return this.includeResolver;
    }

    public void setIncludeResolver(ILiquidEngineIncludeResolver includeResolver) {
        this.includeResolver = includeResolver;
    }

    public ILiquidRenderingSupport getRenderingSupport() {
        return this.renderingSupport;
    }

    public void setRenderingSupport(ILiquidRenderingSupport renderingSupport) {
        this.renderingSupport = renderingSupport;
    }

    public Map<String, Base> getVars() {
        return this.vars;
    }

    public LiquidDocument parse(String source, String sourceName) throws FHIRException {
        return new LiquidParser(source).parse(sourceName);
    }

    public String evaluate(LiquidDocument document, Base resource, Object appContext) throws FHIRException {
        StringBuilder b = new StringBuilder();
        LiquidEngineContext ctxt = new LiquidEngineContext(appContext, this.vars);
        for (LiquidNode n : document.body) {
            n.evaluate(b, resource, ctxt);
        }
        return b.toString();
    }

    @Override
    public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, boolean beforeContext, boolean explicitConstant) throws PathEngineException {
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        if (ctxt.loopVars.containsKey(name)) {
            return new ArrayList<Base>(Arrays.asList(ctxt.loopVars.get(name)));
        }
        if (ctxt.globalVars.containsKey(name)) {
            return new ArrayList<Base>(Arrays.asList(ctxt.globalVars.get(name)));
        }
        if (this.externalHostServices == null) {
            return new ArrayList<Base>();
        }
        return this.externalHostServices.resolveConstant(engine, ctxt.externalContext, name, beforeContext, explicitConstant);
    }

    @Override
    public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, boolean explicitConstant) throws PathEngineException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.resolveConstantType(engine, ctxt.externalContext, name, explicitConstant);
    }

    @Override
    public boolean log(String argument, List<Base> focus) {
        if (this.externalHostServices == null) {
            return false;
        }
        return this.externalHostServices.log(argument, focus);
    }

    @Override
    public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
        if (this.externalHostServices == null) {
            return null;
        }
        return this.externalHostServices.resolveFunction(engine, functionName);
    }

    @Override
    public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.checkFunction(engine, ctxt.externalContext, functionName, focus, parameters);
    }

    @Override
    public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.externalHostServices.executeFunction(engine, ctxt.externalContext, focus, functionName, parameters);
    }

    @Override
    public Base resolveReference(FHIRPathEngine engine, Object appContext, String url, Base refContext) throws FHIRException {
        if (this.externalHostServices == null) {
            return null;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.resolveReference(engine, ctxt.externalContext, url, refContext);
    }

    @Override
    public boolean conformsToProfile(FHIRPathEngine engine, Object appContext, Base item, String url) throws FHIRException {
        if (this.externalHostServices == null) {
            return false;
        }
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        return this.conformsToProfile(engine, ctxt.externalContext, item, url);
    }

    @Override
    public ValueSet resolveValueSet(FHIRPathEngine engine, Object appContext, String url) {
        LiquidEngineContext ctxt = (LiquidEngineContext)appContext;
        if (this.externalHostServices != null) {
            return this.externalHostServices.resolveValueSet(engine, ctxt.externalContext, url);
        }
        return engine.getWorker().fetchResource(ValueSet.class, url);
    }

    public boolean replaceInHtml(XhtmlNode node, Map<String, String> vars) {
        boolean replaced = false;
        if (node.getNodeType() == NodeType.Text || node.getNodeType() == NodeType.Comment) {
            String cnt = node.getContent();
            for (String n : vars.keySet()) {
                cnt = cnt.replace(n, vars.get(n));
            }
            if (!cnt.equals(node.getContent())) {
                node.setContent(cnt);
                replaced = true;
            }
        } else if (node.getNodeType() == NodeType.Element || node.getNodeType() == NodeType.Document) {
            for (XhtmlNode c : node.getChildNodes()) {
                if (!this.replaceInHtml(c, vars)) continue;
                replaced = true;
            }
            for (String an : node.getAttributes().keySet()) {
                String cnt = (String)node.getAttributes().get(an);
                for (String n : vars.keySet()) {
                    cnt = cnt.replace(n, vars.get(n));
                }
                if (cnt.equals(node.getAttributes().get(an))) continue;
                node.getAttributes().put(an, cnt);
                replaced = true;
            }
        }
        return replaced;
    }

    @Override
    public boolean paramIsType(String name, int index) {
        return false;
    }

    public FHIRPathEngine getEngine() {
        return this.engine;
    }

    private class LiquidParser {
        private String source;
        private int cursor;
        private String name;

        public LiquidParser(String source) {
            this.source = source;
            if (source == null) {
                throw new FHIRException("No Liquid source to parse");
            }
            this.cursor = 0;
        }

        private char next1() {
            if (this.cursor >= this.source.length()) {
                return '\u0000';
            }
            return this.source.charAt(this.cursor);
        }

        private char next2() {
            if (this.cursor >= this.source.length() - 1) {
                return '\u0000';
            }
            return this.source.charAt(this.cursor + 1);
        }

        private char grab() {
            ++this.cursor;
            return this.source.charAt(this.cursor - 1);
        }

        public LiquidDocument parse(String name) throws FHIRException {
            this.name = name;
            LiquidDocument doc = new LiquidDocument();
            this.parseList(doc.body, false, new String[0]);
            return doc;
        }

        public LiquidCycle parseCycle(String cnt) {
            LiquidCycle res = new LiquidCycle();
            cnt = "," + ((String)cnt).substring(5).trim();
            while (!Utilities.noString((String)cnt)) {
                int i;
                if (!((String)cnt).startsWith(",")) {
                    throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_EXPECTING", this.name, Character.valueOf(((String)cnt).charAt(0)), Character.valueOf(',')));
                }
                if (!((String)(cnt = ((String)cnt).substring(1).trim())).startsWith("\"")) {
                    throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_EXPECTING", this.name, Character.valueOf(((String)cnt).charAt(0)), Character.valueOf('\"')));
                }
                cnt = ((String)cnt).substring(1);
                for (i = 0; i < ((String)cnt).length() && ((String)cnt).charAt(i) != '\"'; ++i) {
                }
                if (i == ((String)cnt).length()) {
                    throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_UNTERMINATED", this.name));
                }
                res.list.add(((String)cnt).substring(0, i));
                cnt = ((String)cnt).substring(i + 1).trim();
            }
            return res;
        }

        private String parseList(List<LiquidNode> list, boolean inLoop, String[] terminators) throws FHIRException {
            String close = null;
            while (this.cursor < this.source.length()) {
                if (this.next1() == '{' && (this.next2() == '%' || this.next2() == '{')) {
                    if (this.next2() == '%') {
                        String cnt = this.parseTag('%');
                        if (this.isTerminator(cnt, terminators)) {
                            close = cnt;
                            break;
                        }
                        if (cnt.startsWith("if ")) {
                            list.add(this.parseIf(cnt, inLoop));
                            continue;
                        }
                        if (cnt.startsWith("loop ")) {
                            list.add(this.parseLoop(cnt.substring(4).trim()));
                            continue;
                        }
                        if (cnt.startsWith("for ")) {
                            list.add(this.parseFor(cnt.substring(3).trim()));
                            continue;
                        }
                        if (inLoop && cnt.equals("continue")) {
                            list.add(new LiquidContinue());
                            continue;
                        }
                        if (inLoop && cnt.equals("break")) {
                            list.add(new LiquidBreak());
                            continue;
                        }
                        if (inLoop && cnt.startsWith("cycle ")) {
                            list.add(this.parseCycle(cnt));
                            continue;
                        }
                        if (cnt.startsWith("include ")) {
                            list.add(this.parseInclude(cnt.substring(7).trim()));
                            continue;
                        }
                        if (cnt.startsWith("assign ")) {
                            list.add(this.parseAssign(cnt.substring(6).trim()));
                            continue;
                        }
                        if (cnt.startsWith("capture ")) {
                            list.add(this.parseCapture(cnt.substring(7).trim()));
                            continue;
                        }
                        throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_UNKNOWN_FLOW_STMT", this.name, cnt));
                    }
                    list.add(this.parseStatement());
                    continue;
                }
                if (list.size() == 0 || !(list.get(list.size() - 1) instanceof LiquidConstant)) {
                    list.add(new LiquidConstant());
                }
                ((LiquidConstant)list.get(list.size() - 1)).addChar(this.grab());
            }
            for (LiquidNode n : list) {
                n.closeUp();
            }
            if (terminators.length > 0 && !this.isTerminator(close, terminators)) {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_UNKNOWN_NOEND", this.name, terminators));
            }
            return close;
        }

        private boolean isTerminator(String cnt, String[] terminators) {
            if (Utilities.noString((String)cnt)) {
                return false;
            }
            for (String t : terminators) {
                if (!(t.endsWith(" ") ? cnt.startsWith(t) : cnt.equals(t))) continue;
                return true;
            }
            return false;
        }

        private LiquidNode parseIf(String cnt, boolean inLoop) throws FHIRException {
            LiquidIf res = new LiquidIf();
            res.condition = cnt.substring(3).trim();
            String term = this.parseList(res.thenBody, inLoop, new String[]{"else", "elsif ", "endif"});
            while (term.startsWith("elsif ")) {
                LiquidElsIf elsIf = new LiquidElsIf();
                res.elseIf.add(elsIf);
                elsIf.condition = term.substring(5).trim();
                term = this.parseList(elsIf.body, inLoop, new String[]{"elsif ", "else", "endif"});
            }
            if ("else".equals(term)) {
                term = this.parseList(res.elseBody, inLoop, new String[]{"endif"});
            }
            return res;
        }

        private LiquidNode parseInclude(String cnt) throws FHIRException {
            int i;
            for (i = 1; i < cnt.length() && !Character.isWhitespace(cnt.charAt(i)); ++i) {
            }
            if (i == 0) {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_INCLUDE", this.name, cnt));
            }
            LiquidInclude res = new LiquidInclude();
            res.page = cnt.substring(0, i);
            while (i < cnt.length() && Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            while (i < cnt.length()) {
                int j = i;
                while (i < cnt.length() && cnt.charAt(i) != '=') {
                    ++i;
                }
                if (i >= cnt.length() || j == i) {
                    throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_INCLUDE", this.name, cnt));
                }
                String n = cnt.substring(j, i);
                if (res.params.containsKey(n)) {
                    throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_INCLUDE", this.name, cnt));
                }
                FHIRPathEngine.ExpressionNodeWithOffset t = LiquidEngine.this.engine.parsePartial(cnt, ++i);
                res.params.put(n, t.getNode());
                for (i = t.getOffset(); i < cnt.length() && Character.isWhitespace(cnt.charAt(i)); ++i) {
                }
            }
            return res;
        }

        private LiquidNode parseLoop(String cnt) throws FHIRException {
            int i = 0;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            LiquidFor res = new LiquidFor();
            res.varName = cnt.substring(0, i);
            if ("include".equals(res.varName)) {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_VARIABLE_ILLEGAL", res.varName));
            }
            while (Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            int j = i;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            if (!"in".equals(cnt.substring(j, i))) {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_LOOP", this.name, cnt));
            }
            res.condition = cnt.substring(i).trim();
            this.parseList(res.body, false, new String[]{"endloop"});
            return res;
        }

        private LiquidNode parseFor(String cnt) throws FHIRException {
            int i = 0;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            LiquidFor res = new LiquidFor();
            res.varName = cnt.substring(0, i);
            if ("include".equals(res.varName)) {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_VARIABLE_ILLEGAL", res.varName));
            }
            while (Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            int j = i;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            if (!"in".equals(cnt.substring(j, i))) {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_LOOP", this.name, cnt));
            }
            res.condition = cnt.substring(i).trim();
            String term = this.parseList(res.body, true, new String[]{"endfor", "else"});
            if ("else".equals(term)) {
                this.parseList(res.elseBody, false, new String[]{"endfor"});
            }
            return res;
        }

        private LiquidNode parseCapture(String cnt) throws FHIRException {
            int i;
            for (i = 0; i < cnt.length() && !Character.isWhitespace(cnt.charAt(i)); ++i) {
            }
            LiquidCapture res = new LiquidCapture();
            res.varName = cnt.substring(0, i);
            this.parseList(res.body, true, new String[]{"endcapture"});
            return res;
        }

        private LiquidNode parseAssign(String cnt) throws FHIRException {
            int i = 0;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            LiquidAssign res = new LiquidAssign();
            res.varName = cnt.substring(0, i);
            while (Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            int j = i;
            while (!Character.isWhitespace(cnt.charAt(i))) {
                ++i;
            }
            res.expression = cnt.substring(i).trim();
            return res;
        }

        private String parseTag(char ch) throws FHIRException {
            this.grab();
            this.grab();
            StringBuilder b = new StringBuilder();
            while (this.cursor < this.source.length() && (this.next1() != '%' || this.next2() != '}')) {
                b.append(this.grab());
            }
            if (this.next1() != '%' || this.next2() != '}') {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_NOTERM", this.name, "{% " + b.toString()));
            }
            this.grab();
            this.grab();
            return b.toString().trim();
        }

        private LiquidStatement parseStatement() throws FHIRException {
            this.grab();
            this.grab();
            StringBuilder b = new StringBuilder();
            while (this.cursor < this.source.length() && (this.next1() != '}' || this.next2() != '}')) {
                b.append(this.grab());
            }
            if (this.next1() != '}' || this.next2() != '}') {
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_NOTERM", this.name, "{{ " + b.toString()));
            }
            this.grab();
            this.grab();
            LiquidStatement res = new LiquidStatement();
            res.statement = b.toString().trim();
            return res;
        }
    }

    public static class LiquidDocument {
        private List<LiquidNode> body = new ArrayList<LiquidNode>();
    }

    private class LiquidInclude
    extends LiquidNode {
        private String page;
        private Map<String, ExpressionNode> params;

        private LiquidInclude() {
            this.params = new HashMap<String, ExpressionNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            if (LiquidEngine.this.includeResolver == null) {
                throw new FHIRException("Includes are not supported in this context");
            }
            String src = LiquidEngine.this.includeResolver.fetchInclude(LiquidEngine.this, this.page);
            if (src == null) {
                throw new FHIRException("The include '" + this.page + "' could not be resolved");
            }
            LiquidParser parser = new LiquidParser(src);
            LiquidDocument doc = parser.parse(this.page);
            LiquidEngineContext nctxt = new LiquidEngineContext(ctxt.externalContext, ctxt);
            Tuple incl = new Tuple();
            nctxt.loopVars.put("include", incl);
            for (String s : this.params.keySet()) {
                incl.addProperty(s, LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, this.params.get(s)));
            }
            for (LiquidNode n : doc.body) {
                n.evaluate(b, resource, nctxt);
            }
        }
    }

    private class LiquidCapture
    extends LiquidNode {
        private String varName;
        private List<LiquidNode> body;

        private LiquidCapture() {
            this.body = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            StringBuilder bc = new StringBuilder();
            for (LiquidNode n : this.body) {
                n.evaluate(bc, resource, ctxt);
            }
            ctxt.globalVars.put(this.varName, new StringType(bc.toString()));
        }
    }

    private class LiquidFor
    extends LiquidNode {
        private String varName;
        private String condition;
        private ExpressionNode compiled;
        private boolean reversed;
        private int limit;
        private int offset;
        private List<LiquidNode> body;
        private List<LiquidNode> elseBody;

        private LiquidFor() {
            this.reversed = false;
            this.limit = -1;
            this.offset = -1;
            this.body = new ArrayList<LiquidNode>();
            this.elseBody = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled == null) {
                FHIRPathEngine.ExpressionNodeWithOffset po = LiquidEngine.this.engine.parsePartial(this.condition, 0);
                this.compiled = po.getNode();
                if (po.getOffset() < this.condition.length()) {
                    this.parseModifiers(this.condition.substring(po.getOffset()));
                }
            }
            List<Base> list = LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, this.compiled);
            LiquidEngineContext lctxt = new LiquidEngineContext(ctxt);
            if (list.isEmpty()) {
                for (LiquidNode n : this.elseBody) {
                    n.evaluate(b, resource, lctxt);
                }
            } else {
                if (this.reversed) {
                    Collections.reverse(list);
                }
                int i = 0;
                LiquidForLoopObject parentLoop = (LiquidForLoopObject)lctxt.globalVars.get("forLoop");
                for (Base o : list) {
                    if (this.offset >= 0 && i < this.offset) {
                        ++i;
                        continue;
                    }
                    if (this.limit >= 0 && i == this.limit) break;
                    LiquidForLoopObject forloop = new LiquidForLoopObject(list.size(), i, this.offset, this.limit, parentLoop);
                    lctxt.globalVars.put("forLoop", forloop);
                    if (lctxt.globalVars.containsKey(this.varName)) {
                        throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_VARIABLE_ALREADY_ASSIGNED", this.varName));
                    }
                    lctxt.loopVars.put(this.varName, o);
                    boolean wantBreak = false;
                    for (LiquidNode n : this.body) {
                        try {
                            n.evaluate(b, resource, lctxt);
                        }
                        catch (LiquidContinueExecuted e) {
                            break;
                        }
                        catch (LiquidBreakExecuted e) {
                            wantBreak = true;
                            break;
                        }
                    }
                    if (wantBreak) break;
                    ++i;
                }
                lctxt.globalVars.put("forLoop", parentLoop);
            }
        }

        private void parseModifiers(String cnt) {
            String src = cnt;
            while (!Utilities.noString((String)cnt)) {
                int i;
                if (cnt.startsWith("reversed")) {
                    this.reversed = true;
                    cnt = cnt.substring(8);
                    continue;
                }
                if (cnt.startsWith("limit")) {
                    if (!(cnt = cnt.substring(5).trim()).startsWith(":")) {
                        throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_COLON", src));
                    }
                    cnt = cnt.substring(1).trim();
                    for (i = 0; i < cnt.length() && Character.isDigit(cnt.charAt(i)); ++i) {
                    }
                    if (i == 0) {
                        throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_NUMBER", src));
                    }
                    this.limit = Integer.parseInt(cnt.substring(0, i));
                    cnt = cnt.substring(i);
                    continue;
                }
                if (cnt.startsWith("offset")) {
                    if (!(cnt = cnt.substring(6).trim()).startsWith(":")) {
                        throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_COLON", src));
                    }
                    cnt = cnt.substring(1).trim();
                    for (i = 0; i < cnt.length() && Character.isDigit(cnt.charAt(i)); ++i) {
                    }
                    if (i == 0) {
                        throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_NUMBER", src));
                    }
                    this.offset = Integer.parseInt(cnt.substring(0, i));
                    cnt = cnt.substring(i);
                    continue;
                }
                throw new FHIRException(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_SYNTAX_UNEXPECTED", cnt));
            }
        }
    }

    private class LiquidAssign
    extends LiquidNode {
        private String varName;
        private String expression;
        private ExpressionNode compiled;

        private LiquidAssign() {
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            List<Base> list;
            if (this.compiled == null) {
                boolean dbl = LiquidEngine.this.engine.isAllowDoubleQuotes();
                LiquidEngine.this.engine.setAllowDoubleQuotes(true);
                FHIRPathEngine.ExpressionNodeWithOffset po = LiquidEngine.this.engine.parsePartial(this.expression, 0);
                this.compiled = po.getNode();
                LiquidEngine.this.engine.setAllowDoubleQuotes(dbl);
            }
            if ((list = LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, this.compiled)).isEmpty()) {
                ctxt.globalVars.remove(this.varName);
            } else if (list.size() == 1) {
                ctxt.globalVars.put(this.varName, list.get(0));
            } else {
                throw new Error("Assign returned a list?");
            }
        }
    }

    private class LiquidCycle
    extends LiquidNode {
        private List<String> list;
        private int cursor;

        private LiquidCycle() {
            this.list = new ArrayList<String>();
            this.cursor = 0;
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            b.append(this.list.get(this.cursor));
            ++this.cursor;
            if (this.cursor == this.list.size()) {
                this.cursor = 0;
            }
        }
    }

    private class LiquidBreak
    extends LiquidNode {
        private LiquidBreak() {
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            throw new LiquidBreakExecuted();
        }
    }

    private class LiquidBreakExecuted
    extends FHIRException {
        private static final long serialVersionUID = 6328496371172871082L;

        private LiquidBreakExecuted() {
        }
    }

    private class LiquidContinue
    extends LiquidNode {
        private LiquidContinue() {
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            throw new LiquidContinueExecuted();
        }
    }

    private class LiquidContinueExecuted
    extends FHIRException {
        private static final long serialVersionUID = 4748737094188943721L;

        private LiquidContinueExecuted() {
        }
    }

    private class LiquidIf
    extends LiquidNode {
        private String condition;
        private ExpressionNode compiled;
        private List<LiquidNode> thenBody;
        private List<LiquidElsIf> elseIf;
        private List<LiquidNode> elseBody;

        private LiquidIf() {
            this.thenBody = new ArrayList<LiquidNode>();
            this.elseIf = new ArrayList<LiquidElsIf>();
            this.elseBody = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled == null) {
                this.compiled = LiquidEngine.this.engine.parse(this.condition);
            }
            boolean ok = LiquidEngine.this.engine.evaluateToBoolean((Object)ctxt, resource, resource, resource, this.compiled);
            List<LiquidNode> list = null;
            if (ok) {
                list = this.thenBody;
            } else {
                list = this.elseBody;
                for (LiquidElsIf i : this.elseIf) {
                    if (i.compiled == null) {
                        i.compiled = LiquidEngine.this.engine.parse(i.condition);
                    }
                    if (!(ok = LiquidEngine.this.engine.evaluateToBoolean((Object)ctxt, resource, resource, resource, i.compiled))) continue;
                    list = i.body;
                    break;
                }
            }
            for (LiquidNode n : list) {
                n.evaluate(b, resource, ctxt);
            }
        }
    }

    private class LiquidElsIf
    extends LiquidNode {
        private String condition;
        private ExpressionNode compiled;
        private List<LiquidNode> body;

        private LiquidElsIf() {
            this.body = new ArrayList<LiquidNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            for (LiquidNode n : this.body) {
                n.evaluate(b, resource, ctxt);
            }
        }
    }

    private class LiquidStatement
    extends LiquidNode {
        private String statement;
        private List<LiquidExpressionNode> compiled;

        private LiquidStatement() {
            this.compiled = new ArrayList<LiquidExpressionNode>();
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) throws FHIRException {
            if (this.compiled.size() == 0) {
                FHIRLexer lexer = new FHIRLexer(this.statement, "liquid statement", false, true);
                lexer.setLiquidMode(true);
                this.compiled.add(new LiquidExpressionNode(null, LiquidEngine.this.engine.parse(lexer)));
                while (!lexer.done()) {
                    if (lexer.getCurrent().equals("||")) {
                        lexer.next();
                        String f = lexer.getCurrent();
                        LiquidFilter filter = LiquidFilter.fromCode(f);
                        if (filter == null) {
                            lexer.error(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_UNKNOWN_FILTER", f));
                        }
                        lexer.next();
                        if (!lexer.done() && lexer.getCurrent().equals(":")) {
                            lexer.next();
                            this.compiled.add(new LiquidExpressionNode(filter, LiquidEngine.this.engine.parse(lexer)));
                            continue;
                        }
                        this.compiled.add(new LiquidExpressionNode(filter, null));
                        continue;
                    }
                    lexer.error(LiquidEngine.this.engine.getWorker().formatMessage("LIQUID_UNKNOWN_SYNTAX", new Object[0]));
                }
            }
            Object t = null;
            for (LiquidExpressionNode i : this.compiled) {
                if (i.filter == null) {
                    t = this.stmtToString(ctxt, LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, i.expression));
                    continue;
                }
                switch (i.filter) {
                    case PREPEND: {
                        t = this.stmtToString(ctxt, LiquidEngine.this.engine.evaluate((Object)ctxt, resource, resource, resource, i.expression)) + (String)t;
                        break;
                    }
                    case MARKDOWNIFY: {
                        t = this.processMarkdown((String)t);
                        break;
                    }
                    case UPCASE: {
                        t = ((String)t).toUpperCase();
                        break;
                    }
                    case DOWNCASE: {
                        t = ((String)t).toLowerCase();
                    }
                }
            }
            b.append((String)t);
        }

        private String processMarkdown(String t) {
            return LiquidEngine.this.processor.process(t, "liquid");
        }

        private String stmtToString(LiquidEngineContext ctxt, List<Base> items) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (Base i : items) {
                if (i == null) continue;
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                String s = LiquidEngine.this.renderingSupport != null ? LiquidEngine.this.renderingSupport.renderForLiquid(ctxt.externalContext, i) : null;
                b.append(s != null ? s : LiquidEngine.this.engine.convertToString(i));
            }
            return b.toString();
        }
    }

    private class LiquidExpressionNode {
        private LiquidFilter filter;
        private ExpressionNode expression;

        public LiquidExpressionNode(LiquidFilter filter, ExpressionNode expression) {
            this.filter = filter;
            this.expression = expression;
        }
    }

    private static enum LiquidFilter {
        PREPEND,
        MARKDOWNIFY,
        UPCASE,
        DOWNCASE;


        public static LiquidFilter fromCode(String code) {
            if ("prepend".equals(code)) {
                return PREPEND;
            }
            if ("markdownify".equals(code)) {
                return MARKDOWNIFY;
            }
            if ("upcase".equals(code)) {
                return UPCASE;
            }
            if ("downcase".equals(code)) {
                return DOWNCASE;
            }
            return null;
        }
    }

    private class LiquidConstant
    extends LiquidNode {
        private String constant;
        private StringBuilder b;

        private LiquidConstant() {
            this.b = new StringBuilder();
        }

        @Override
        protected void closeUp() {
            this.constant = this.b.toString();
            this.b = null;
        }

        public void addChar(char ch) {
            this.b.append(ch);
        }

        @Override
        public void evaluate(StringBuilder b, Base resource, LiquidEngineContext ctxt) {
            b.append(this.constant);
        }
    }

    private abstract class LiquidNode {
        private LiquidNode() {
        }

        protected void closeUp() {
        }

        public abstract void evaluate(StringBuilder var1, Base var2, LiquidEngineContext var3) throws FHIRException;
    }

    private class LiquidEngineContext {
        private Object externalContext;
        private Map<String, Base> loopVars = new HashMap<String, Base>();
        private Map<String, Base> globalVars = new HashMap<String, Base>();

        public LiquidEngineContext(Object externalContext, Map<String, Base> vars) {
            this.externalContext = externalContext;
            this.globalVars = new HashMap<String, Base>();
            this.globalVars.putAll(vars);
        }

        public LiquidEngineContext(Object externalContext, LiquidEngineContext existing) {
            this.externalContext = externalContext;
            this.loopVars.putAll(existing.loopVars);
            this.globalVars = existing.globalVars;
        }

        public LiquidEngineContext(LiquidEngineContext existing) {
            this.externalContext = existing.externalContext;
            this.loopVars.putAll(existing.loopVars);
            this.globalVars = existing.globalVars;
        }
    }

    public static interface ILiquidEngineIncludeResolver {
        public String fetchInclude(LiquidEngine var1, String var2);
    }

    public static interface ILiquidRenderingSupport {
        public String renderForLiquid(Object var1, Base var2) throws FHIRException;
    }

    public static class LiquidForLoopObject
    extends Base {
        private static final long serialVersionUID = 6951452522873320076L;
        private boolean first;
        private int index;
        private int index0;
        private int rindex;
        private int rindex0;
        private boolean last;
        private int length;
        private LiquidForLoopObject parentLoop;

        public LiquidForLoopObject(int size, int i, int offset, int limit, LiquidForLoopObject parentLoop) {
            this.parentLoop = parentLoop;
            if (offset == -1) {
                offset = 0;
            }
            if (limit == -1) {
                limit = size;
            }
            this.first = i == offset;
            this.index = i + 1 - offset;
            this.index0 = i - offset;
            this.rindex = limit - offset - 1 - i;
            this.rindex0 = limit - offset - i;
            this.length = limit - offset;
            this.last = i == limit - offset - 1;
        }

        @Override
        public String getIdBase() {
            return null;
        }

        @Override
        public void setIdBase(String value) {
            throw new Error("forLoop is read only");
        }

        @Override
        public Base copy() {
            throw new Error("forLoop is read only");
        }

        @Override
        public FhirPublication getFHIRPublicationVersion() {
            return FhirPublication.R5;
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (name) {
                case "parentLoop": {
                    return this.wrap(this.parentLoop);
                }
                case "first": {
                    return this.wrap(new BooleanType(this.first));
                }
                case "last": {
                    return this.wrap(new BooleanType(this.last));
                }
                case "index": {
                    return this.wrap(new IntegerType(this.index));
                }
                case "index0": {
                    return this.wrap(new IntegerType(this.index0));
                }
                case "rindex": {
                    return this.wrap(new IntegerType(this.rindex));
                }
                case "rindex0": {
                    return this.wrap(new IntegerType(this.rindex0));
                }
                case "length": {
                    return this.wrap(new IntegerType(this.length));
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        private Base[] wrap(Base b) {
            Base[] l = new Base[]{b};
            return l;
        }

        public String toString() {
            return "forLoop";
        }

        @Override
        public String fhirType() {
            return "ForLoop";
        }
    }
}

