/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

@MarkedToMoveToAdjunctPackage
public class OidIndexBuilder {
    private File folder;
    private File target;

    public OidIndexBuilder(File ff, File of) {
        this.folder = ff;
        this.target = of;
    }

    public void build() {
        System.out.println("Generate OID index for " + this.folder.getAbsolutePath());
        this.target.delete();
        try {
            HashSet<String> matches = new HashSet<String>();
            Connection db = DriverManager.getConnection("jdbc:sqlite:" + this.target.getAbsolutePath());
            Statement stmt = db.createStatement();
            stmt.execute("CREATE TABLE OIDMap (\r\nOID            nvarchar NOT NULL,\r\nTYPE           nvarchar NOT NULL,\r\nURL            nvarchar NOT NULL,\r\nVERSION        nvarchar NOT NULL,\r\nStatus         nvarchar NOT NULL,\r\nPRIMARY KEY (OID, URL))\r\n");
            PreparedStatement psql = db.prepareStatement("Insert into OIDMap (OID, TYPE, URL, VERSION, Status) values (?, ?, ?, ?, ?)");
            for (File f : this.folder.listFiles()) {
                if (f.getName().startsWith(".") || !f.getName().endsWith(".json")) continue;
                try {
                    JsonObject json = JsonParser.parseObject((File)f);
                    this.processFile(psql, matches, json);
                }
                catch (Exception e) {
                    System.out.println("Error processing " + f.getAbsolutePath() + " while generating OIDs: " + e.getMessage());
                }
            }
            db.close();
        }
        catch (Exception e) {
            System.out.println("Error processing " + this.folder.getAbsolutePath() + " while generating OIDs: " + e.getMessage());
        }
    }

    private void processFile(PreparedStatement psql, Set<String> matches, JsonObject json) throws SQLException {
        block9: {
            String version;
            String status;
            String url;
            HashSet<String> oids;
            String rt;
            block10: {
                rt = json.asString("resourceType");
                if (rt == null) break block9;
                oids = new HashSet<String>();
                url = null;
                status = json.asString("status");
                version = json.asString("version");
                if (!"NamingSystem".equals(rt)) break block10;
                for (JsonObject id : json.getJsonObjects("uniqueId")) {
                    String t = id.asString("type");
                    String v = id.asString("value");
                    if ("url".equals(t) && v != null) {
                        url = v;
                        continue;
                    }
                    if (!"oid".equals(t) || v == null) continue;
                    oids.add(v);
                }
                if (url == null) break block9;
                for (String s : oids) {
                    this.addOid(psql, matches, s, rt, url, version, status);
                }
                break block9;
            }
            if (json.hasPrimitive("url")) {
                String v;
                url = json.asString("url");
                if (json.has("oid")) {
                    oids.add(json.asString("oid"));
                }
                if (json.has("url") && (v = json.asString("url")) != null && v.startsWith("urn:oid:")) {
                    oids.add(v.substring(8));
                }
                for (JsonObject id : json.getJsonObjects("identifier")) {
                    String v2 = id.asString("value");
                    if (v2 == null || !v2.startsWith("urn:oid:")) continue;
                    oids.add(v2.substring(8));
                }
                if (!oids.isEmpty()) {
                    for (String s : oids) {
                        this.addOid(psql, matches, s, rt, url, version, status);
                    }
                }
            }
        }
    }

    private void addOid(PreparedStatement psql, Set<String> matches, String oid, String type, String url, String version, String status) throws SQLException {
        String key = oid + "@" + url;
        if (!matches.contains(key)) {
            matches.add(key);
            psql.setString(1, oid);
            psql.setString(2, type);
            psql.setString(3, url);
            if (version == null) {
                psql.setNull(4, -9);
            } else {
                psql.setString(4, version);
            }
            psql.setString(5, status);
            psql.execute();
        }
    }
}

