/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

@MarkedToMoveToAdjunctPackage
public class ConstraintJavaGenerator {
    private IWorkerContext context;
    private String version;
    private String folder;
    private String packageName;

    public ConstraintJavaGenerator(IWorkerContext context, String version, String folder, String packageName) {
        this.context = context;
        this.version = version;
        this.folder = folder;
        this.packageName = packageName;
    }

    public String generate(StructureDefinition sd) throws FHIRException, IOException {
        String name;
        String string = name = sd.hasName() ? Utilities.titleize((String)sd.getName().replace(".", "").replace("-", "").replace("\"", "")).replace(" ", "") : "";
        if (!Utilities.nmtokenize((String)name).equals(name)) {
            System.out.println("Cannot generate Java code for profile " + sd.getUrl() + " because the name \"" + name + "\" is not a valid Java class name");
            return null;
        }
        File destFile = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.folder, name + ".java"}));
        OutputStreamWriter dest = new OutputStreamWriter((OutputStream)ManagedFileAccess.outStream((File)destFile), "UTF-8");
        dest.write("package " + this.packageName + ";\r\n");
        dest.write("\r\n");
        dest.write("import org.hl7.fhir.r5.model.ProfilingWrapper;\r\n");
        dest.write("\r\n");
        dest.write("public class " + name + " {\r\n");
        dest.write("\r\n");
        dest.write("}\r\n");
        dest.flush();
        dest.close();
        return destFile.getAbsolutePath();
    }
}

