/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r5.comparison.CapabilityStatementComparer;
import org.hl7.fhir.r5.comparison.CodeSystemComparer;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.StructureDefinitionComparer;
import org.hl7.fhir.r5.comparison.ValueSetComparer;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.liquid.LiquidEngine;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Tuple;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

@MarkedToMoveToAdjunctPackage
public class ComparisonRenderer
implements FHIRPathEngine.IEvaluationContext {
    private IWorkerContext contextLeft;
    private IWorkerContext contextRight;
    private ComparisonSession session;
    private Map<String, String> templates = new HashMap<String, String>();
    private String folder;
    private String preamble;

    public ComparisonRenderer(IWorkerContext contextLeft, IWorkerContext contextRight, String folder, ComparisonSession session) {
        this.contextLeft = contextLeft;
        this.contextRight = contextRight;
        this.folder = folder;
        this.session = session;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public File render(String leftName, String rightName) throws IOException {
        this.dumpBinaries();
        StringBuilder b = new StringBuilder();
        if (this.preamble != null) {
            b.append(this.preamble);
        }
        b.append("<table class=\"grid\">\r\n");
        b.append(" <tr>\r\n");
        b.append("  <td width=\"260\"><b>" + Utilities.escapeXml((String)leftName) + "</b></td>\r\n");
        b.append("  <td width=\"260\"><b>" + Utilities.escapeXml((String)rightName) + "</b></td>\r\n");
        b.append("  <td width=\"100\"><b>Difference</b></td>\r\n");
        b.append("  <td width=\"100\"><b>Union</b></td>\r\n");
        b.append("  <td width=\"100\"><b>Intersection</b></td>\r\n");
        b.append("  <td width=\"260\"><b>Notes</b></td>\r\n");
        b.append(" </tr>\r\n");
        List<String> list = this.sorted(this.session.getCompares().keySet());
        this.processList(list, b, "CodeSystem");
        this.processList(list, b, "ValueSet");
        this.processList(list, b, "StructureDefinition");
        this.processList(list, b, "CapabilityStatement");
        b.append("</table>\r\n");
        HashMap<String, Base> vars = new HashMap<String, Base>();
        vars.put("title", new StringType(this.session.getTitle()));
        vars.put("list", new StringType(b.toString()));
        String template = this.templates.get("Index");
        String cnt = this.processTemplate(template, "CodeSystem", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file("index.html"));
        return ManagedFileAccess.file((String)this.file("index.html"));
    }

    private void processList(List<String> list, StringBuilder b, String name) throws IOException {
        boolean first = true;
        for (String id : list) {
            ResourceComparer.ResourceComparison comp = this.session.getCompares().get(id);
            if (!comp.fhirType().equals(name)) continue;
            if (first) {
                first = false;
                b.append("<tr><td colspan=\"6\"><b>" + Utilities.pluralize((String)name, (int)2) + "</b></td></tr>\r\n");
            }
            try {
                this.renderComparison(id, comp);
            }
            catch (Exception e) {
                System.out.println("Exception rendering " + id + ": " + e.getMessage());
                e.printStackTrace();
            }
            b.append(comp.toTable());
        }
    }

    private List<String> sorted(Set<String> keySet) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(keySet);
        Collections.sort(list);
        return list;
    }

    private void dumpBinaries() throws IOException {
        if (this.contextLeft != null && this.contextLeft.getBinaryKeysAsSet() != null) {
            for (String k : this.contextLeft.getBinaryKeysAsSet()) {
                FileUtilities.bytesToFile((byte[])this.contextLeft.getBinaryForKey(k), (String)Utilities.path((String[])new String[]{this.folder, k}));
            }
        }
        if (this.contextRight != null && this.contextRight.getBinaryKeysAsSet() != null) {
            for (String k : this.contextRight.getBinaryKeysAsSet()) {
                FileUtilities.bytesToFile((byte[])this.contextRight.getBinaryForKey(k), (String)Utilities.path((String[])new String[]{this.folder, k}));
            }
        }
    }

    private void renderComparison(String id, ResourceComparer.ResourceComparison comp) throws IOException, FHIRFormatError, DefinitionException, FHIRException, EOperationOutcome {
        if (comp instanceof StructureDefinitionComparer.ProfileComparison) {
            this.renderProfile(id, (StructureDefinitionComparer.ProfileComparison)comp);
        } else if (comp instanceof ValueSetComparer.ValueSetComparison) {
            this.renderValueSet(id, (ValueSetComparer.ValueSetComparison)comp);
        } else if (comp instanceof CodeSystemComparer.CodeSystemComparison) {
            this.renderCodeSystem(id, (CodeSystemComparer.CodeSystemComparison)comp);
        } else if (comp instanceof CapabilityStatementComparer.CapabilityStatementComparison) {
            this.renderCapabilityStatement(id, (CapabilityStatementComparer.CapabilityStatementComparison)comp);
        } else if (comp instanceof ResourceComparer.PlaceHolderComparison) {
            this.renderPlaceHolder(id, (ResourceComparer.PlaceHolderComparison)comp);
        }
    }

    private void renderPlaceHolder(String id, ResourceComparer.PlaceHolderComparison comp) throws IOException {
        Object cnt = "";
        if (comp.getE() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            comp.getE().printStackTrace(pw);
            cnt = sw.toString();
        }
        cnt = "<html><body><pre>" + (String)cnt + "</pre></body></html>\r\n";
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + ".html"));
    }

    private void renderCodeSystem(String id, CodeSystemComparer.CodeSystemComparison comp) throws IOException, FHIRFormatError, DefinitionException, FHIRException, EOperationOutcome {
        String template = this.templates.get("CodeSystem");
        HashMap<String, Base> vars = new HashMap<String, Base>();
        CodeSystemComparer cs = new CodeSystemComparer(this.session);
        vars.put("left", new StringType(((CodeSystem)comp.getLeft()).present()));
        vars.put("right", new StringType(((CodeSystem)comp.getRight()).present()));
        vars.put("leftId", new StringType(((CodeSystem)comp.getLeft()).getId()));
        vars.put("rightId", new StringType(((CodeSystem)comp.getRight()).getId()));
        vars.put("leftUrl", new StringType(((CodeSystem)comp.getLeft()).getUrl()));
        vars.put("rightUrl", new StringType(((CodeSystem)comp.getRight()).getUrl()));
        vars.put("summary", new StringType(comp.summary()));
        vars.put("errors", new StringType(new XhtmlComposer(true).compose(cs.renderErrors(comp))));
        vars.put("metadata", new StringType(new XhtmlComposer(true).compose(cs.renderMetadata(comp, "", ""))));
        vars.put("concepts", new StringType(new XhtmlComposer(true).compose(cs.renderConcepts(comp, "", ""))));
        String cnt = this.processTemplate(template, "CodeSystem", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + ".html"));
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-union.json"})), (Resource)comp.getUnion());
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-intersection.json"})), (Resource)comp.getIntersection());
        String union = new XhtmlComposer(true).compose(cs.renderUnion(comp, "", this.folder, "http://hl7.org/fhir"));
        String intersection = new XhtmlComposer(true).compose(cs.renderIntersection(comp, "", this.folder, "http://hl7.org/fhir"));
        vars.put("union", new StringType(union));
        vars.put("intersection", new StringType(intersection));
        template = this.templates.get("CodeSystem-Union");
        cnt = this.processTemplate(template, "CodeSystem-Union", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + "-union.html"));
        template = this.templates.get("CodeSystem-Intersection");
        cnt = this.processTemplate(template, "CodeSystem-Intersection", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + "-intersection.html"));
    }

    private String file(String name) throws IOException {
        return Utilities.path((String[])new String[]{this.folder, name});
    }

    private void renderValueSet(String id, ValueSetComparer.ValueSetComparison comp) throws FHIRException, IOException, EOperationOutcome {
        String template = this.templates.get("ValueSet");
        HashMap<String, Base> vars = new HashMap<String, Base>();
        ValueSetComparer cs = new ValueSetComparer(this.session);
        vars.put("left", new StringType(((ValueSet)comp.getLeft()).present()));
        vars.put("right", new StringType(((ValueSet)comp.getRight()).present()));
        vars.put("leftId", new StringType(((ValueSet)comp.getLeft()).getId()));
        vars.put("rightId", new StringType(((ValueSet)comp.getRight()).getId()));
        vars.put("leftUrl", new StringType(((ValueSet)comp.getLeft()).getUrl()));
        vars.put("rightUrl", new StringType(((ValueSet)comp.getRight()).getUrl()));
        vars.put("summary", new StringType(comp.summary()));
        vars.put("errors", new StringType(new XhtmlComposer(true).compose(cs.renderErrors(comp))));
        vars.put("metadata", new StringType(new XhtmlComposer(true).compose(cs.renderMetadata(comp, "", ""))));
        vars.put("compose", new StringType(new XhtmlComposer(true).compose(cs.renderCompose(comp, "", ""))));
        vars.put("expansion", new StringType(new XhtmlComposer(true).compose(cs.renderExpansion(comp, "", ""))));
        String cnt = this.processTemplate(template, "ValueSet", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + ".html"));
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-union.json"})), (Resource)comp.getUnion());
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-intersection.json"})), (Resource)comp.getIntersection());
        String union = new XhtmlComposer(true).compose(cs.renderUnion(comp, "", this.folder, "http://hl7.org/fhir"));
        String intersection = new XhtmlComposer(true).compose(cs.renderIntersection(comp, "", this.folder, "http://hl7.org/fhir"));
        vars.put("union", new StringType(union));
        vars.put("intersection", new StringType(intersection));
        template = this.templates.get("ValueSet-Union");
        cnt = this.processTemplate(template, "ValueSet-Union", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + "-union.html"));
        template = this.templates.get("ValueSet-Intersection");
        cnt = this.processTemplate(template, "ValueSet-Intersection", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + "-intersection.html"));
    }

    private void renderProfile(String id, StructureDefinitionComparer.ProfileComparison comp) throws IOException {
        String template = this.templates.get("Profile");
        HashMap<String, Base> vars = new HashMap<String, Base>();
        StructureDefinitionComparer cs = new StructureDefinitionComparer(this.session, new ProfileUtilities(this.session.getContextLeft(), null, this.session.getPkpLeft()), new ProfileUtilities(this.session.getContextRight(), null, this.session.getPkpRight()));
        vars.put("left", new StringType(((StructureDefinition)comp.getLeft()).present()));
        vars.put("right", new StringType(((StructureDefinition)comp.getRight()).present()));
        vars.put("leftId", new StringType(((StructureDefinition)comp.getLeft()).getId()));
        vars.put("rightId", new StringType(((StructureDefinition)comp.getRight()).getId()));
        vars.put("leftUrl", new StringType(((StructureDefinition)comp.getLeft()).getUrl()));
        vars.put("rightUrl", new StringType(((StructureDefinition)comp.getRight()).getUrl()));
        vars.put("errors", new StringType(new XhtmlComposer(true).compose(cs.renderErrors(comp))));
        vars.put("metadata", new StringType(new XhtmlComposer(true).compose(cs.renderMetadata(comp, "", ""))));
        vars.put("structure", new StringType(new XhtmlComposer(true).compose(cs.renderStructure(comp, "", "", "http://hl7.org/fhir"))));
        String union = new XhtmlComposer(true).compose(cs.renderUnion(comp, "", this.folder, "http://hl7.org/fhir"));
        String intersection = new XhtmlComposer(true).compose(cs.renderIntersection(comp, "", this.folder, "http://hl7.org/fhir"));
        vars.put("union", new StringType(union));
        vars.put("intersection", new StringType(intersection));
        String cnt = this.processTemplate(template, "Profile", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + ".html"));
        template = this.templates.get("Profile-Union");
        cnt = this.processTemplate(template, "Profile-Union", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + "-union.html"));
        template = this.templates.get("Profile-Intersection");
        cnt = this.processTemplate(template, "Profile-Intersection", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + "-intersection.html"));
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-union.json"})), (Resource)comp.getUnion());
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-intersection.json"})), (Resource)comp.getIntersection());
    }

    private void renderCapabilityStatement(String id, CapabilityStatementComparer.CapabilityStatementComparison comp) throws IOException {
        String template = this.templates.get("CapabilityStatement");
        HashMap<String, Base> vars = new HashMap<String, Base>();
        CapabilityStatementComparer cs = new CapabilityStatementComparer(this.session);
        vars.put("left", new StringType(((CapabilityStatement)comp.getLeft()).present()));
        vars.put("right", new StringType(((CapabilityStatement)comp.getRight()).present()));
        vars.put("leftId", new StringType(((CapabilityStatement)comp.getLeft()).getId()));
        vars.put("rightId", new StringType(((CapabilityStatement)comp.getRight()).getId()));
        vars.put("leftUrl", new StringType(((CapabilityStatement)comp.getLeft()).getUrl()));
        vars.put("rightUrl", new StringType(((CapabilityStatement)comp.getRight()).getUrl()));
        vars.put("errors", new StringType(new XhtmlComposer(true).compose(cs.renderErrors(comp))));
        vars.put("metadata", new StringType(new XhtmlComposer(true).compose(cs.renderMetadata(comp, "", ""))));
        vars.put("statement", new StringType(new XhtmlComposer(true).compose(cs.renderStatements(comp, "", ""))));
        String cnt = this.processTemplate(template, "CapabilityStatement", vars);
        FileUtilities.stringToFile((String)cnt, (String)this.file(comp.getId() + ".html"));
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-union.json"})), (Resource)comp.getUnion());
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, comp.getId() + "-intersection.json"})), (Resource)comp.getIntersection());
    }

    private String processTemplate(String template, String name, Map<String, Base> vars) {
        LiquidEngine engine = new LiquidEngine(this.contextRight, this);
        LiquidEngine.LiquidDocument doc = engine.parse(template, name + ".template");
        return engine.evaluate(doc, Tuple.fromMap(FhirPublication.R5, vars), vars);
    }

    @Override
    public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, boolean beforeContext, boolean explicitConstant) throws PathEngineException {
        Map vars = (Map)appContext;
        ArrayList<Base> res = new ArrayList<Base>();
        if (vars.containsKey(name)) {
            res.add((Base)vars.get(name));
        }
        return res;
    }

    @Override
    public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, boolean explicitConstant) throws PathEngineException {
        Map vars = (Map)appContext;
        Base b = (Base)vars.get(name);
        return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, b == null ? "Base" : b.fhirType());
    }

    @Override
    public boolean log(String argument, List<Base> focus) {
        return false;
    }

    @Override
    public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
        return null;
    }

    @Override
    public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
        return null;
    }

    @Override
    public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        return null;
    }

    @Override
    public Base resolveReference(FHIRPathEngine engine, Object appContext, String url, Base refContext) throws FHIRException {
        return null;
    }

    @Override
    public boolean conformsToProfile(FHIRPathEngine engine, Object appContext, Base item, String url) throws FHIRException {
        return false;
    }

    @Override
    public ValueSet resolveValueSet(FHIRPathEngine engine, Object appContext, String url) {
        return null;
    }

    @Override
    public boolean paramIsType(String name, int index) {
        return false;
    }

    public void loadTemplates(IWorkerContext context) {
        this.getTemplates().put("CapabilityStatement", new String(context.getBinaryForKey("template-comparison-CapabilityStatement.html")));
        this.getTemplates().put("CodeSystem-Intersection", new String(context.getBinaryForKey("template-comparison-CodeSystem-Intersection.html")));
        this.getTemplates().put("CodeSystem-Union", new String(context.getBinaryForKey("template-comparison-CodeSystem-Union.html")));
        this.getTemplates().put("CodeSystem", new String(context.getBinaryForKey("template-comparison-CodeSystem.html")));
        this.getTemplates().put("Index", new String(context.getBinaryForKey("template-comparison-index.html")));
        this.getTemplates().put("Profile-Intersection", new String(context.getBinaryForKey("template-comparison-Profile-Intersection.html")));
        this.getTemplates().put("Profile-Union", new String(context.getBinaryForKey("template-comparison-Profile-Union.html")));
        this.getTemplates().put("Profile", new String(context.getBinaryForKey("template-comparison-Profile.html")));
        this.getTemplates().put("ValueSet-Intersection", new String(context.getBinaryForKey("template-comparison-ValueSet-Intersection.html")));
        this.getTemplates().put("ValueSet-Union", new String(context.getBinaryForKey("template-comparison-ValueSet-Union.html")));
        this.getTemplates().put("ValueSet", new String(context.getBinaryForKey("template-comparison-ValueSet.html")));
    }
}

