/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.sql;

import org.hl7.fhir.r5.utils.sql.ColumnKind;

public class Column {
    private String name;
    private int length;
    private String type;
    private ColumnKind kind;
    private boolean isColl;
    private boolean duplicateReported;

    protected Column() {
    }

    protected Column(String name, boolean isColl, String type, ColumnKind kind) {
        this.name = name;
        this.isColl = isColl;
        this.type = type;
        this.kind = kind;
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public ColumnKind getKind() {
        return this.kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setKind(ColumnKind kind) {
        this.kind = kind;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isColl() {
        return this.isColl;
    }

    public void setColl(boolean isColl) {
        this.isColl = isColl;
    }

    public String diff(Column other) {
        if (!this.name.equals(other.name)) {
            return "Names differ: '" + this.name + "' vs '" + other.name + "'";
        }
        if (this.kind != ColumnKind.Null && other.kind != ColumnKind.Null) {
            if (this.length != other.length) {
                return "Lengths differ: '" + this.length + "' vs '" + other.length + "'";
            }
            if (this.kind != other.kind) {
                return "Kinds differ: '" + this.kind + "' vs '" + other.kind + "'";
            }
            if (this.isColl != other.isColl) {
                return "Collection status differs: '" + this.isColl + "' vs '" + other.isColl + "'";
            }
        } else if (this.kind == ColumnKind.Null) {
            this.kind = other.kind;
            this.length = other.length;
            this.isColl = other.isColl;
        }
        return null;
    }

    public boolean isDuplicateReported() {
        return this.duplicateReported;
    }

    public void setDuplicateReported(boolean duplicateReported) {
        this.duplicateReported = duplicateReported;
    }

    public String toString() {
        return "Column [name=" + this.name + ", length=" + this.length + ", type=" + this.type + ", kind=" + this.kind + ", isColl=" + this.isColl + "]";
    }
}

