/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.utilities.Utilities;

public class SnomedUtilities {
    public static String getVersionFromParameters(Parameters p, String version) {
        for (Parameters.ParametersParameterComponent pp : p.getParameter()) {
            switch (pp.getName()) {
                case "system-version": {
                    if (version == null) {
                        return pp.getValue().primitiveValue();
                    }
                }
                case "force-system-version": {
                    return pp.getValue().primitiveValue();
                }
            }
        }
        return version;
    }

    public static String getEditionFromVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.startsWith("http://snomed.info/sct/")) {
            version = version.substring(23);
        }
        if (version.contains("/")) {
            version = version.substring(0, version.indexOf("/"));
        }
        if (Utilities.existsInList((String)version, (String[])new String[]{"900000000000207008", "731000124108", "32506021000036107", "11000172109", "20611000087101", "449081005", "554471000005108", "11000146104", "45991000052106", "2011000195101", "83821000000107", "827022005"})) {
            return version;
        }
        return null;
    }

    public static String getSctLink(String version, String code, Parameters p) {
        if (!Utilities.noString((String)code)) {
            String edId = SnomedUtilities.getEditionFromVersion(version = SnomedUtilities.getVersionFromParameters(p, version));
            if (edId != null) {
                return "http://snomed.info/sct/" + edId + "/id/" + code;
            }
            return "http://snomed.info/id/" + code;
        }
        return "https://browser.ihtsdotools.org/";
    }
}

