/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.expansion;

import java.util.List;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ConceptFilter;
import org.hl7.fhir.utilities.Utilities;

public class KnownPropertyFilter
extends ConceptFilter {
    private ValueSet.ConceptSetFilterComponent filter;
    private String code;

    public KnownPropertyFilter(List<String> allErrors, ValueSet.ConceptSetFilterComponent fc, String code) {
        super(allErrors);
        this.filter = fc;
        this.code = code;
    }

    @Override
    public boolean includeConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        CodeSystem.ConceptPropertyComponent pc = this.getPropertyForConcept(def);
        if (pc != null) {
            String v = pc.getValue().isPrimitive() ? pc.getValue().primitiveValue() : null;
            switch (this.filter.getOp()) {
                case DESCENDENTOF: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case EQUAL: {
                    return this.filter.getValue().equals(v);
                }
                case EXISTS: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case GENERALIZES: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case IN: {
                    return Utilities.existsInListTrimmed((String)v, (String[])this.filter.getValue().split("\\,"));
                }
                case ISA: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case ISNOTA: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case NOTIN: {
                    return Utilities.existsInListTrimmed((String)v, (String[])this.filter.getValue().split("\\,"));
                }
                case NULL: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case REGEX: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
            }
            throw this.fail("Shouldn't get here");
        }
        return false;
    }

    private CodeSystem.ConceptPropertyComponent getPropertyForConcept(CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptPropertyComponent pc : def.getProperty()) {
            if (!pc.hasCode() || !pc.getCode().equals(this.code)) continue;
            return pc;
        }
        return null;
    }
}

