/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;

public class TerminologyClientContext {
    private static boolean canUseCacheId;
    private ITerminologyClient client;
    private boolean initialised = false;
    private CapabilityStatement capabilitiesStatementQuick;
    private TerminologyCapabilities txcaps;
    private TerminologyCache txCache;
    private Map<String, TerminologyClientContextUseCount> useCounts = new HashMap<String, TerminologyClientContextUseCount>();
    private boolean isTxCaching;
    private final Set<String> cached = new HashSet<String>();
    private boolean master;
    private String cacheId;

    protected TerminologyClientContext(ITerminologyClient client, String cacheId, boolean master) {
        this.client = client;
        this.cacheId = cacheId;
        this.master = master;
    }

    public Map<String, TerminologyClientContextUseCount> getUseCounts() {
        return this.useCounts;
    }

    public boolean isMaster() {
        return this.master;
    }

    public ITerminologyClient getClient() {
        return this.client;
    }

    public void seeUse(Set<String> systems, TerminologyClientContextUseType useType) {
        for (String s : systems) {
            this.seeUse(s, useType);
        }
    }

    public void seeUse(String s, TerminologyClientContextUseType useType) {
        TerminologyClientContextUseCount uc = this.useCounts.get(s);
        if (uc == null) {
            uc = new TerminologyClientContextUseCount();
            this.useCounts.put(s, uc);
        }
        switch (useType) {
            case expand: {
                ++uc.expands;
                break;
            }
            case readVS: {
                ++uc.readVS;
                break;
            }
            case readCS: {
                ++uc.readCS;
                break;
            }
            case validate: {
                ++uc.validates;
                break;
            }
        }
    }

    public TerminologyCapabilities getTxCapabilities() {
        return this.txcaps;
    }

    public void setTxCapabilities(TerminologyCapabilities txcaps) {
        this.txcaps = txcaps;
    }

    public Set<String> getCached() {
        return this.cached;
    }

    public boolean alreadyCached(CanonicalResource cr) {
        return this.cached.contains(cr.getVUrl());
    }

    public void addToCache(CanonicalResource cr) {
        this.cached.add(cr.getVUrl());
    }

    public String getAddress() {
        return this.client.getAddress();
    }

    public int getUseCount() {
        return this.getClient().getUseCount();
    }

    public boolean isTxCaching() {
        return this.isTxCaching;
    }

    public void setTxCaching(boolean isTxCaching) {
        this.isTxCaching = isTxCaching;
    }

    public boolean usingCache() {
        return this.isTxCaching && this.cacheId != null;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public TerminologyCache getTxCache() {
        return this.txCache;
    }

    public void setTxCache(TerminologyCache txCache) {
        this.txCache = txCache;
    }

    public void initialize() throws IOException {
        if (!this.initialised) {
            this.capabilitiesStatementQuick = this.client.getCapabilitiesStatementQuick();
            if (this.txCache != null && this.txCache.hasTerminologyCapabilities(this.getAddress())) {
                this.txcaps = this.txCache.getTerminologyCapabilities(this.getAddress());
                if (this.txcaps.getSoftware().hasVersion() && !this.txcaps.getSoftware().getVersion().equals(this.capabilitiesStatementQuick.getSoftware().getVersion())) {
                    this.txcaps = null;
                }
            }
            if (this.txcaps == null) {
                this.txcaps = this.client.getTerminologyCapabilities();
                if (this.txCache != null) {
                    this.txCache.cacheTerminologyCapabilities(this.getAddress(), this.txcaps);
                }
            }
            if (this.txcaps != null && canUseCacheId) {
                for (TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent t : this.txcaps.getExpansion().getParameter()) {
                    if (!"cache-id".equals(t.getName())) continue;
                    this.setTxCaching(true);
                    break;
                }
            }
            this.initialised = true;
        }
    }

    public boolean supportsSystem(String system) throws IOException {
        this.initialize();
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tccs : this.txcaps.getCodeSystem()) {
            if (!system.equals(tccs.getUri())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.client.getAddress();
    }

    public static boolean isCanUseCacheId() {
        return canUseCacheId;
    }

    public static void setCanUseCacheId(boolean canUseCacheId) {
        TerminologyClientContext.canUseCacheId = canUseCacheId;
    }

    public class TerminologyClientContextUseCount {
        private int expands;
        private int validates;
        private int readVS;
        private int readCS;

        public int getReadVS() {
            return this.readVS;
        }

        public void setReadVS(int readVS) {
            this.readVS = readVS;
        }

        public int getReadCS() {
            return this.readCS;
        }

        public void setReadCS(int readCS) {
            this.readCS = readCS;
        }

        public int getExpands() {
            return this.expands;
        }

        public void setExpands(int expands) {
            this.expands = expands;
        }

        public int getValidates() {
            return this.validates;
        }

        public void setValidates(int validates) {
            this.validates = validates;
        }
    }

    public static enum TerminologyClientContextUseType {
        expand,
        validate,
        readVS,
        readCS;

    }
}

