/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ActorDefinitionRenderer
extends ResourceRenderer {
    public ActorDefinitionRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(r, x);
        this.genSummaryTable(status, x, r);
        this.render(status, x, r);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper acd) throws FHIRFormatError, DefinitionException, IOException {
        boolean first;
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx(this.context.formatPhrase("ACTOR_DEF_ACT", new Object[]{this.context.getTranslated(acd.child("name"))}) + " ");
        tr.td().tx(this.context.getTranslated(acd.child("title")));
        tr.td().tx(this.context.formatPhrase("ACTOR_DEF_TYP", new Object[]{acd.primitiveValue("type")}) + " ");
        XhtmlNode td = tbl.tr().td().colspan("3");
        this.addMarkdown(td, this.context.getTranslated(acd.child("documentation")));
        if (acd.has("reference")) {
            tbl.tr().td().tx(this.context.formatPhrase("GENERAL_REFS", new Object[0]));
            td = tr.td().colspan("2");
            first = true;
            for (ResourceWrapper t : acd.children("reference")) {
                if (first) {
                    first = false;
                } else {
                    x.br();
                }
                this.renderUri(status, td, t);
            }
        }
        if (acd.has("capabilities")) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("ACTOR_DEF_CAP", new Object[0]));
            td = tr.td().colspan("2");
            this.renderCanonical(status, td, acd.child("capabilities"));
        }
        if (acd.has("derivedFrom")) {
            tbl.tr().td().tx(this.context.formatPhrase("ACTOR_DEF_DER", new Object[0]));
            td = tr.td().colspan("2");
            first = true;
            for (ResourceWrapper t : acd.children("reference")) {
                if (first) {
                    first = false;
                } else {
                    x.br();
                }
                this.renderUri(status, td, t);
            }
        }
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }
}

