/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.fhirpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

public class TypeDetails {
    public static final String FHIR_NS = "http://hl7.org/fhir/StructureDefinition/";
    public static final String FP_NS = "http://hl7.org/fhirpath/";
    public static final String FP_String = "http://hl7.org/fhirpath/System.String";
    public static final String FP_Boolean = "http://hl7.org/fhirpath/System.Boolean";
    public static final String FP_Integer = "http://hl7.org/fhirpath/System.Integer";
    public static final String FP_Decimal = "http://hl7.org/fhirpath/System.Decimal";
    public static final String FP_Quantity = "http://hl7.org/fhirpath/System.Quantity";
    public static final String FP_DateTime = "http://hl7.org/fhirpath/System.DateTime";
    public static final String FP_Time = "http://hl7.org/fhirpath/System.Time";
    public static final String FP_SimpleTypeInfo = "http://hl7.org/fhirpath/System.SimpleTypeInfo";
    public static final String FP_ClassInfo = "http://hl7.org/fhirpath/System.ClassInfo";
    public static final Set<String> FP_NUMBERS = new HashSet<String>(Arrays.asList("http://hl7.org/fhirpath/System.Integer", "http://hl7.org/fhirpath/System.Decimal"));
    private List<ProfiledType> types = new ArrayList<ProfiledType>();
    private ExpressionNode.CollectionStatus collectionStatus;
    private Set<String> targets;
    private boolean choice;

    public TypeDetails(ExpressionNode.CollectionStatus collectionStatus, String ... names) {
        this.collectionStatus = collectionStatus;
        for (String n : names) {
            this.types.add(new ProfiledType(n));
        }
    }

    public TypeDetails(ExpressionNode.CollectionStatus collectionStatus, Set<String> names) {
        this.collectionStatus = collectionStatus;
        for (String n : names) {
            this.addType(new ProfiledType(n));
        }
    }

    public TypeDetails(ExpressionNode.CollectionStatus collectionStatus, ProfiledType pt) {
        this.collectionStatus = collectionStatus;
        this.types.add(pt);
    }

    private TypeDetails() {
    }

    public String addType(String n) {
        ProfiledType pt = new ProfiledType(n);
        String res = pt.uri;
        this.addType(pt);
        return res;
    }

    public String addType(String n, String p) {
        ProfiledType pt = new ProfiledType(n);
        pt.addProfile(p);
        String res = pt.uri;
        this.addType(pt);
        return res;
    }

    public void addType(ProfiledType pt) {
        for (ProfiledType et : this.types) {
            if (!et.uri.equals(pt.uri)) continue;
            if (pt.profiles != null) {
                for (String p : pt.profiles) {
                    if (et.profiles == null) {
                        et.profiles = new ArrayList<String>();
                    }
                    if (et.profiles.contains(p)) continue;
                    et.profiles.add(p);
                }
            }
            if (pt.bindings != null) {
                for (ElementDefinition.ElementDefinitionBindingComponent b : pt.bindings) {
                    if (et.bindings == null) {
                        et.bindings = new ArrayList<ElementDefinition.ElementDefinitionBindingComponent>();
                    }
                    if (et.hasBinding(b)) continue;
                    et.bindings.add(b);
                }
            }
            return;
        }
        this.types.add(pt);
    }

    public void addType(ExpressionNode.CollectionStatus status, ProfiledType pt) {
        this.addType(pt);
        if (this.collectionStatus == null) {
            this.collectionStatus = status;
        } else {
            switch (status) {
                case ORDERED: {
                    if (this.collectionStatus != ExpressionNode.CollectionStatus.SINGLETON) break;
                    this.collectionStatus = status;
                    break;
                }
                case SINGLETON: {
                    break;
                }
                case UNORDERED: {
                    this.collectionStatus = status;
                    break;
                }
            }
        }
    }

    public void addTypes(Collection<String> names) {
        for (String n : names) {
            this.addType(new ProfiledType(n));
        }
    }

    public boolean hasType(IWorkerContext context, String ... tn) {
        for (String n : tn) {
            Object t = ProfiledType.ns(n);
            if (this.typesContains((String)t)) {
                return true;
            }
            if (Utilities.existsInList((String)n, (String[])new String[]{"boolean", "string", "integer", "decimal", "Quantity", "dateTime", "time", "ClassInfo", "SimpleTypeInfo"}) && this.typesContains((String)(t = "http://hl7.org/fhirpath/System." + Utilities.capitalize((String)n)))) {
                return true;
            }
            t = ProfiledType.ns(n);
            StructureDefinition sd = context.fetchTypeDefinition((String)t);
            if (sd == null || sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || !Utilities.existsInList((String)sd.getType(), (String[])new String[]{"boolean", "string", "integer", "decimal", "Quantity", "dateTime", "time"}) || !this.typesContains((String)(t = "http://hl7.org/fhirpath/System." + Utilities.capitalize((String)sd.getType())))) continue;
            return true;
        }
        for (String n : tn) {
            StructureDefinition sd;
            String id = n.contains("#") ? n.substring(0, n.indexOf("#")) : n;
            String tail = null;
            if (n.contains("#")) {
                tail = n.substring(n.indexOf("#") + 1);
                tail = tail.substring(tail.indexOf("."));
            }
            ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
            if (!Utilities.isAbsoluteUrl((String)n)) {
                list.addAll(context.fetchTypeDefinitions(n));
            } else {
                String t = ProfiledType.ns(n);
                sd = context.fetchResource(StructureDefinition.class, t);
                if (sd != null) {
                    list.add(sd);
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                sd = (StructureDefinition)list.get(i);
                while (sd != null) {
                    if (tail == null && this.typesContains(sd.getUrl())) {
                        return true;
                    }
                    if (tail == null && this.getSystemType(sd.getUrl()) != null && this.typesContains(this.getSystemType(sd.getUrl()))) {
                        return true;
                    }
                    if (tail != null && this.typesContains(sd.getUrl() + "#" + sd.getType() + tail)) {
                        return true;
                    }
                    if ("http://hl7.org/fhir/StructureDefinition/string".equals(sd.getUrl()) && this.typesContains(FP_String)) {
                        return true;
                    }
                    if (sd.hasBaseDefinition()) {
                        if (sd.getType().equals("uri")) {
                            sd = context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/string");
                            continue;
                        }
                        sd = context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                        continue;
                    }
                    sd = null;
                }
            }
        }
        return false;
    }

    private String getSystemType(String url) {
        if (url.startsWith(FHIR_NS)) {
            String code = url.substring(40);
            if (Utilities.existsInList((String)code, (String[])new String[]{"string", "boolean", "integer", "decimal", "dateTime", "time", "Quantity"})) {
                return "http://hl7.org/fhirpath/System.." + Utilities.capitalize((String)code);
            }
        }
        return null;
    }

    private boolean typesContains(String t) {
        for (ProfiledType pt : this.types) {
            if (!pt.uri.equals(t)) continue;
            return true;
        }
        return false;
    }

    public void update(TypeDetails source) {
        for (ProfiledType pt : source.types) {
            this.addType(pt);
        }
        this.collectionStatus = this.collectionStatus == null || this.collectionStatus == ExpressionNode.CollectionStatus.SINGLETON ? source.collectionStatus : (source.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED ? source.collectionStatus : ExpressionNode.CollectionStatus.ORDERED);
        if (source.targets != null) {
            if (this.targets == null) {
                this.targets = new HashSet<String>();
            }
            this.targets.addAll(source.targets);
        }
        if (source.isChoice()) {
            this.choice = true;
        }
    }

    public TypeDetails union(TypeDetails right) {
        TypeDetails result = new TypeDetails(null, new String[0]);
        result.collectionStatus = right.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED || this.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED ? ExpressionNode.CollectionStatus.UNORDERED : ExpressionNode.CollectionStatus.ORDERED;
        for (ProfiledType pt : this.types) {
            result.addType(pt);
        }
        for (ProfiledType pt : right.types) {
            result.addType(pt);
        }
        if (this.targets != null || right.targets != null) {
            result.targets = new HashSet<String>();
            if (this.targets != null) {
                result.targets.addAll(this.targets);
            }
            if (right.targets != null) {
                result.targets.addAll(right.targets);
            }
        }
        return result;
    }

    public TypeDetails intersect(TypeDetails right) {
        TypeDetails result = new TypeDetails(null, new String[0]);
        result.collectionStatus = right.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED || this.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED ? ExpressionNode.CollectionStatus.UNORDERED : ExpressionNode.CollectionStatus.ORDERED;
        for (ProfiledType pt : this.types) {
            boolean found = false;
            for (ProfiledType r : right.types) {
                found = found || pt.uri.equals(r.uri);
            }
            if (!found) continue;
            result.addType(pt);
        }
        for (ProfiledType pt : right.types) {
            result.addType(pt);
        }
        if (this.targets != null && right.targets != null) {
            result.targets = new HashSet<String>();
            for (String s : this.targets) {
                if (!right.targets.contains(s)) continue;
                result.targets.add(s);
            }
        }
        return result;
    }

    public boolean hasNoTypes() {
        return this.types.isEmpty();
    }

    public Set<String> getTypes() {
        HashSet<String> res = new HashSet<String>();
        for (ProfiledType pt : this.types) {
            res.add(pt.uri);
        }
        return res;
    }

    public TypeDetails toSingleton() {
        TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
        result.types.addAll(this.types);
        return result;
    }

    public TypeDetails toOrdered() {
        TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.ORDERED, new String[0]);
        result.types.addAll(this.types);
        return result;
    }

    public TypeDetails toUnordered() {
        TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.UNORDERED, new String[0]);
        result.types.addAll(this.types);
        return result;
    }

    public ExpressionNode.CollectionStatus getCollectionStatus() {
        return this.collectionStatus;
    }

    private boolean hasType(ProfiledType pt) {
        return this.hasType(pt.uri);
    }

    public boolean hasType(String n) {
        Object t = ProfiledType.ns(n);
        if (this.typesContains((String)t)) {
            return true;
        }
        return Utilities.existsInList((String)n, (String[])new String[]{"boolean", "string", "integer", "decimal", "Quantity", "date", "dateTime", "time", "ClassInfo", "SimpleTypeInfo"}) && this.typesContains((String)(t = "http://hl7.org/fhirpath/System." + Utilities.capitalize((String)n)));
    }

    public boolean hasType(Set<String> tn) {
        for (String n : tn) {
            Object t = ProfiledType.ns(n);
            if (this.typesContains((String)t)) {
                return true;
            }
            if (!Utilities.existsInList((String)n, (String[])new String[]{"boolean", "string", "integer", "decimal", "Quantity", "dateTime", "time", "ClassInfo", "SimpleTypeInfo"}) || !this.typesContains((String)(t = "http://hl7.org/fhirpath/System." + Utilities.capitalize((String)n)))) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        return Utilities.sorted(this.getTypes()).toString();
    }

    public String describeMin() {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ProfiledType pt : this.sortedTypes(this.types)) {
            b.append(pt.describeMin());
        }
        return b.toString();
    }

    private List<ProfiledType> sortedTypes(List<ProfiledType> types2) {
        ArrayList<ProfiledType> list = new ArrayList<ProfiledType>();
        Collections.sort(list, new ProfiledTypeSorter());
        return list;
    }

    public String getType() {
        Iterator<ProfiledType> iterator = this.types.iterator();
        if (iterator.hasNext()) {
            ProfiledType pt = iterator.next();
            return pt.uri;
        }
        return null;
    }

    public String toString() {
        return (this.collectionStatus == null ? ExpressionNode.CollectionStatus.SINGLETON.toString() : this.collectionStatus.toString()) + this.getTypes().toString();
    }

    public String getTypeCode() throws DefinitionException {
        if (this.types.size() != 1) {
            throw new DefinitionException("Multiple types? (" + this.types.toString() + ")");
        }
        Iterator<ProfiledType> iterator = this.types.iterator();
        if (iterator.hasNext()) {
            ProfiledType pt = iterator.next();
            if (pt.uri.startsWith(FHIR_NS)) {
                return pt.uri.substring(40);
            }
            return pt.uri;
        }
        return null;
    }

    public List<ProfiledType> getProfiledTypes() {
        return this.types;
    }

    public boolean hasBinding() {
        for (ProfiledType pt : this.types) {
            if (!pt.hasBindings()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinition.ElementDefinitionBindingComponent getBinding() {
        for (ProfiledType pt : this.types) {
            Iterator<ElementDefinition.ElementDefinitionBindingComponent> iterator = pt.getBindings().iterator();
            if (!iterator.hasNext()) continue;
            ElementDefinition.ElementDefinitionBindingComponent b = iterator.next();
            return b;
        }
        return null;
    }

    public void addTarget(String url) {
        if (this.targets == null) {
            this.targets = new HashSet<String>();
        }
        this.targets.add(url);
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public boolean typesHaveTargets() {
        for (ProfiledType pt : this.types) {
            if (!Utilities.existsInList((String)pt.getUri(), (String[])new String[]{"Reference", "CodeableReference", "canonical", "http://hl7.org/fhir/StructureDefinition/Reference", "http://hl7.org/fhir/StructureDefinition/CodeableReference", "http://hl7.org/fhir/StructureDefinition/canonical"})) continue;
            return true;
        }
        return false;
    }

    public void addTargets(Set<String> src) {
        if (src != null) {
            for (String s : src) {
                this.addTarget(s);
            }
        }
    }

    public TypeDetails copy() {
        TypeDetails td = new TypeDetails();
        td.types.addAll(this.types);
        td.collectionStatus = this.collectionStatus;
        if (this.targets != null) {
            td.targets = new HashSet<String>();
            td.targets.addAll(this.targets);
        }
        return td;
    }

    public boolean matches(TypeDetails other) {
        boolean result;
        boolean bl = result = this.collectionStatus == other.collectionStatus && this.types.equals(other.types);
        if (this.targets == null) {
            return result && other.targets == null;
        }
        return result && this.targets.equals(other.targets);
    }

    public void addTypes(TypeDetails other) {
        if (other.collectionStatus != ExpressionNode.CollectionStatus.SINGLETON) {
            this.collectionStatus = other.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED || this.collectionStatus == ExpressionNode.CollectionStatus.UNORDERED ? ExpressionNode.CollectionStatus.UNORDERED : ExpressionNode.CollectionStatus.ORDERED;
        }
        for (ProfiledType pt : other.types) {
            this.addType(pt);
        }
        if (other.targets != null) {
            if (this.targets == null) {
                this.targets = new HashSet<String>();
            }
            this.targets.addAll(other.targets);
        }
    }

    public boolean contains(TypeDetails other) {
        if (other.collectionStatus != this.collectionStatus) {
            return false;
        }
        for (ProfiledType pt : other.types) {
            if (this.hasType(pt)) continue;
            return false;
        }
        return true;
    }

    public static TypeDetails empty() {
        return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
    }

    public boolean isList() {
        return this.collectionStatus != null && this.collectionStatus.isList();
    }

    public void setChoice(boolean b) {
        this.choice = true;
    }

    public boolean isChoice() {
        return this.choice;
    }

    public static class ProfiledType {
        private String uri;
        private List<String> profiles;
        private List<ElementDefinition.ElementDefinitionBindingComponent> bindings;

        public String toString() {
            return this.uri;
        }

        public ProfiledType(String n) {
            this.uri = ProfiledType.ns(n);
        }

        public String getUri() {
            return this.uri;
        }

        public boolean hasProfiles() {
            return this.profiles != null && this.profiles.size() > 0;
        }

        public List<String> getProfiles() {
            return this.profiles;
        }

        public boolean hasBindings() {
            return this.bindings != null && this.bindings.size() > 0;
        }

        public List<ElementDefinition.ElementDefinitionBindingComponent> getBindings() {
            return this.bindings;
        }

        public static String ns(String n) {
            return Utilities.isAbsoluteUrl((String)n) ? n : TypeDetails.FHIR_NS + n;
        }

        public void addProfile(String profile) {
            if (this.profiles == null) {
                this.profiles = new ArrayList<String>();
            }
            this.profiles.add(profile);
        }

        public void addBinding(ElementDefinition.ElementDefinitionBindingComponent binding) {
            this.bindings = new ArrayList<ElementDefinition.ElementDefinitionBindingComponent>();
            this.bindings.add(binding);
        }

        public boolean hasBinding(ElementDefinition.ElementDefinitionBindingComponent b) {
            return false;
        }

        public void addProfiles(List<CanonicalType> list) {
            if (this.profiles == null) {
                this.profiles = new ArrayList<String>();
            }
            for (UriType uriType : list) {
                this.profiles.add((String)uriType.getValue());
            }
        }

        public boolean isSystemType() {
            return this.uri.startsWith(TypeDetails.FP_NS);
        }

        public String describeMin() {
            if (this.uri.startsWith(TypeDetails.FP_NS)) {
                return "System." + this.uri.substring(TypeDetails.FP_NS.length());
            }
            if (this.uri.startsWith(TypeDetails.FHIR_NS)) {
                return "FHIR." + this.uri.substring(TypeDetails.FHIR_NS.length());
            }
            return this.uri;
        }
    }

    public class ProfiledTypeSorter
    implements Comparator<ProfiledType> {
        @Override
        public int compare(ProfiledType o1, ProfiledType o2) {
            return o1.uri.compareTo(o2.uri);
        }
    }
}

