/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.crypto.DirectDecrypter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.SHCParser;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.test.utils.TestingUtilities;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SHLParser
extends ParserBase {
    private static boolean testMode;
    private boolean post = true;
    private String url = null;
    private byte[] key = null;
    private String ct;

    public SHLParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public List<ValidatedFragment> parse(InputStream inStream) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        byte[] content = TextFile.streamToBytes((InputStream)inStream);
        ArrayList<ValidatedFragment> res = new ArrayList<ValidatedFragment>();
        ValidatedFragment shl = this.addNamedElement(res, "shl", "txt", content);
        String src = TextFile.bytesToString((byte[])content);
        if (src.startsWith("shlink:/")) {
            src = src.substring(8);
        } else if (src.contains("#shlink:/")) {
            String pfx = src.substring(0, src.indexOf("#shlink:/"));
            src = src.substring(src.indexOf("#shlink:/") + 9);
            if (!Utilities.isAbsoluteUrlLinkable((String)pfx)) {
                this.logError(shl.getErrors(), "202-08-31", 1, 1, "shl", ValidationMessage.IssueType.STRUCTURE, "if a prefix is present, it must be a URL, not " + pfx, ValidationMessage.IssueSeverity.ERROR);
            }
        } else {
            this.logError(shl.getErrors(), "202-08-31", 1, 1, "shl", ValidationMessage.IssueType.STRUCTURE, "This content does not appear to be an Smart Health Link", ValidationMessage.IssueSeverity.ERROR);
            src = null;
        }
        if (src != null) {
            byte[] cntin = Base64.getUrlDecoder().decode(src);
            ValidatedFragment json = this.addNamedElement(res, "json", "json", cntin);
            JsonObject j = null;
            try {
                j = JsonParser.parseObject((byte[])cntin);
            }
            catch (Exception e) {
                this.logError(json.getErrors(), "202-08-31", 1, 1, "shl.json", ValidationMessage.IssueType.STRUCTURE, "The JSON is not valid: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
            }
            if (j != null) {
                byte[] cntout = JsonParser.composeBytes((JsonElement)j, (boolean)false);
                if (!Arrays.equals(cntin, cntout)) {
                    this.logError(shl.getErrors(), "202-08-31", 1, 1, "shl", ValidationMessage.IssueType.STRUCTURE, "The JSON does not seem to be minified properly", ValidationMessage.IssueSeverity.ERROR);
                }
                if (this.checkJson(json.getErrors(), j)) {
                    HTTPResult cnt = null;
                    if (this.post) {
                        try {
                            cnt = this.fetchManifest();
                        }
                        catch (UnknownHostException e) {
                            this.logError(json.getErrors(), "202-08-31", 1, 1, "shl.json", ValidationMessage.IssueType.STRUCTURE, "The manifest could not be fetched because the host " + e.getMessage() + " is unknown", ValidationMessage.IssueSeverity.ERROR);
                        }
                        catch (Exception e) {
                            this.logError(json.getErrors(), "202-08-31", 1, 1, "shl.json", ValidationMessage.IssueType.STRUCTURE, "The manifest could not be fetched: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
                        }
                        if (cnt != null) {
                            if (cnt.getContentType() == null) {
                                this.logError(json.getErrors(), "202-08-31", 1, 1, "shl.json.url.fetch()", ValidationMessage.IssueType.NOTFOUND, "The server did not return a Content-Type header - should be 'application/json'", ValidationMessage.IssueSeverity.WARNING);
                            } else if (!"application/json".equals(cnt.getContentType())) {
                                this.logError(json.getErrors(), "202-08-31", 1, 1, "shl.json.url.fetch()", ValidationMessage.IssueType.STRUCTURE, "The server returned the wrong Content-Type header '" + cnt.getContentType() + "' - must be 'application/json'", ValidationMessage.IssueSeverity.ERROR);
                            }
                            this.checkManifest(res, cnt);
                        }
                    } else {
                        try {
                            cnt = this.fetchFile(this.url + "?recipient=FHIR%20Validator", "application/jose");
                        }
                        catch (Exception e) {
                            this.logError(json.getErrors(), "202-08-31", 1, 1, "shl,json.url", ValidationMessage.IssueType.STRUCTURE, "The document could not be fetched: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
                        }
                        if (cnt != null) {
                            if (cnt.getContentType() == null) {
                                this.logError(json.getErrors(), "202-08-31", 1, 1, "shl.json.url.fetch()", ValidationMessage.IssueType.NOTFOUND, "The server did not return a Content-Type header - should be 'application/jose'", ValidationMessage.IssueSeverity.WARNING);
                            } else if (!"application/json".equals(cnt.getContentType())) {
                                this.logError(json.getErrors(), "202-08-31", 1, 1, "shl.json.url.fetch()", ValidationMessage.IssueType.STRUCTURE, "The server returned the wrong Content-Type header '" + cnt.getContentType() + "' - must be 'application/jose'", ValidationMessage.IssueSeverity.ERROR);
                            }
                            this.processContent(res, json.getErrors(), "shl.url.fetched()", "document", cnt.getContentAsString(), this.ct);
                        }
                    }
                }
            }
        }
        return res;
    }

    private void checkManifest(List<ValidatedFragment> res, HTTPResult cnt) throws IOException {
        ValidatedFragment manifest = this.addNamedElement(res, "manifest", "json", cnt.getContent());
        if (!cnt.getContentType().equals("application/json")) {
            this.logError(manifest.getErrors(), "202-08-31", 1, 1, "manifest", ValidationMessage.IssueType.STRUCTURE, "The mime type should be application/json not " + cnt.getContentType(), ValidationMessage.IssueSeverity.ERROR);
        } else {
            JsonObject j = null;
            try {
                j = JsonParser.parseObject((byte[])cnt.getContent());
            }
            catch (Exception e) {
                this.logError(manifest.getErrors(), "202-08-31", 1, 1, "manifest", ValidationMessage.IssueType.STRUCTURE, "The JSON is not valid: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
            }
            if (j != null) {
                for (JsonProperty p : j.getProperties()) {
                    if (p.getName().equals("files")) continue;
                    this.logError(manifest.getErrors(), "202-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "manifest." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "Unexpected property name " + p.getName(), ValidationMessage.IssueSeverity.WARNING);
                }
            }
            if (j.has("files")) {
                JsonElement f = j.get("files");
                if (f.isJsonArray()) {
                    int i = 0;
                    for (JsonElement e : f.asJsonArray()) {
                        if (e.isJsonObject()) {
                            this.processManifestEntry(res, manifest.getErrors(), e.asJsonObject(), "manifest.files[" + i + "]", "files[" + i + "]");
                            continue;
                        }
                        this.logError(manifest.getErrors(), "202-08-31", e.getStart().getLine(), e.getStart().getCol(), "manifest.files[" + i + "]", ValidationMessage.IssueType.STRUCTURE, "files must be an object, not a " + f.type().name(), ValidationMessage.IssueSeverity.ERROR);
                    }
                } else {
                    this.logError(manifest.getErrors(), "202-08-31", f.getStart().getLine(), f.getStart().getCol(), "manifest.files", ValidationMessage.IssueType.STRUCTURE, "files must be an array, not a " + f.type().name(), ValidationMessage.IssueSeverity.ERROR);
                }
            } else {
                this.logError(manifest.getErrors(), "202-08-31", j.getStart().getLine(), j.getStart().getCol(), "manifest", ValidationMessage.IssueType.STRUCTURE, "files not found", ValidationMessage.IssueSeverity.WARNING);
            }
        }
    }

    private void processManifestEntry(List<ValidatedFragment> res, List<ValidationMessage> errors, JsonObject j, String path, String name) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        for (JsonProperty p : j.getProperties()) {
            if (Utilities.existsInList((String)p.getName(), (String[])new String[]{"contentType", "location", "embedded"})) continue;
            this.logError(errors, "202-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "manifest." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "Unexpected property " + p.getName(), ValidationMessage.IssueSeverity.WARNING);
        }
        JsonElement cte = j.get("contentType");
        JsonElement loce = j.get("location");
        JsonElement embe = j.get("embedded");
        String ct = null;
        if (cte == null) {
            this.logError(errors, "202-08-31", j.getStart().getLine(), j.getStart().getCol(), path, ValidationMessage.IssueType.STRUCTURE, "contentType not found", ValidationMessage.IssueSeverity.ERROR);
        } else if (!cte.isJsonString()) {
            this.logError(errors, "202-08-31", j.getStart().getLine(), j.getStart().getCol(), path + ".contentType", ValidationMessage.IssueType.STRUCTURE, "contentType must be a string not a " + cte.type().name(), ValidationMessage.IssueSeverity.ERROR);
        } else {
            ct = cte.asString();
            if (!Utilities.existsInList((String)ct, (String[])new String[]{"application/smart-health-card", "application/smart-api-access", "application/fhir+json"})) {
                this.logError(errors, "202-08-31", j.getStart().getLine(), j.getStart().getCol(), path + ".contentType", ValidationMessage.IssueType.STRUCTURE, "contentType must be one of application/smart-health-card, application/smart-api-access or application/fhir+json", ValidationMessage.IssueSeverity.ERROR);
                ct = null;
            }
        }
        if (loce != null && !loce.isJsonString()) {
            this.logError(errors, "202-08-31", j.getStart().getLine(), j.getStart().getCol(), path + ".location", ValidationMessage.IssueType.STRUCTURE, "location must be a string not a " + loce.type().name(), ValidationMessage.IssueSeverity.ERROR);
        }
        if (embe != null && !embe.isJsonString()) {
            this.logError(errors, "202-08-31", j.getStart().getLine(), j.getStart().getCol(), path + ".embedded", ValidationMessage.IssueType.STRUCTURE, "embedded must be a string not a " + embe.type().name(), ValidationMessage.IssueSeverity.ERROR);
        }
        if (loce == null && embe == null) {
            this.logError(errors, "202-08-31", j.getStart().getLine(), j.getStart().getCol(), path, ValidationMessage.IssueType.STRUCTURE, "Found neither a location nor an embedded property", ValidationMessage.IssueSeverity.ERROR);
        } else if (loce != null && embe != null) {
            this.logError(errors, "202-08-31", j.getStart().getLine(), j.getStart().getCol(), path, ValidationMessage.IssueType.STRUCTURE, "Found both a location nor an embedded property - only one can be present", ValidationMessage.IssueSeverity.ERROR);
        } else if (ct != null) {
            if (embe != null) {
                this.processContent(res, errors, path + ".embedded", name, embe.asString(), ct);
            } else if (loce != null) {
                HTTPResult cnt = null;
                try {
                    cnt = this.fetchFile(loce.asString(), "application/jose");
                }
                catch (Exception e) {
                    this.logError(errors, "202-08-31", 1, 1, "shl", ValidationMessage.IssueType.STRUCTURE, "The document could not be fetched: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
                }
                if (cnt != null) {
                    if (cnt.getContentType() == null) {
                        this.logError(errors, "202-08-31", 1, 1, "shl.json.url.fetch()", ValidationMessage.IssueType.NOTFOUND, "The server did not return a Content-Type header - should be 'application/jose'", ValidationMessage.IssueSeverity.WARNING);
                    } else if (!"application/json".equals(cnt.getContentType())) {
                        this.logError(errors, "202-08-31", 1, 1, "shl.json.url.fetch()", ValidationMessage.IssueType.STRUCTURE, "The server returned the wrong Content-Type header '" + cnt.getContentType() + "' - must be 'application/jose'", ValidationMessage.IssueSeverity.ERROR);
                    }
                    this.processContent(res, errors, path + ".url.fetch()", name, cnt.getContentAsString(), ct);
                }
            }
        }
    }

    private void processContent(List<ValidatedFragment> res, List<ValidationMessage> errors, String path, String name, String jose, String ct) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        ValidatedFragment bin = this.addNamedElement(res, "encrypted", "jose", TextFile.stringToBytes((String)jose));
        byte[] cnt = null;
        try {
            JWEObject jwe = JWEObject.parse((String)jose);
            jwe.decrypt((JWEDecrypter)new DirectDecrypter(this.key));
            cnt = jwe.getPayload().toBytes();
        }
        catch (Exception e) {
            this.logError(bin.getErrors(), "202-08-31", 1, 1, path, ValidationMessage.IssueType.STRUCTURE, "Decruption failed: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
        }
        if (cnt != null) {
            switch (ct) {
                case "application/smart-health-card": {
                    SHCParser shc = new SHCParser(this.context);
                    res.addAll(shc.parse(new ByteArrayInputStream(cnt)));
                    break;
                }
                case "application/fhir+json": {
                    ValidatedFragment doc = this.addNamedElement(res, name, "json", cnt);
                    this.logError(doc.getErrors(), "202-08-31", 1, 1, name, ValidationMessage.IssueType.STRUCTURE, "Processing content of type 'application/smart-api-access' is not done yet", ValidationMessage.IssueSeverity.INFORMATION);
                    break;
                }
                case "application/smart-api-access": {
                    ValidatedFragment doc = this.addNamedElement(res, name, "api.json", cnt);
                    this.logError(doc.getErrors(), "202-08-31", 1, 1, name, ValidationMessage.IssueType.STRUCTURE, "Processing content of type 'application/smart-api-access' is not done yet", ValidationMessage.IssueSeverity.INFORMATION);
                    break;
                }
                default: {
                    ValidatedFragment doc = this.addNamedElement(res, name, "bin", cnt);
                    this.logError(doc.getErrors(), "202-08-31", 1, 1, name, ValidationMessage.IssueType.STRUCTURE, "The Content-Type '" + ct + "' is not known", ValidationMessage.IssueSeverity.INFORMATION);
                }
            }
        }
    }

    private ValidatedFragment addNamedElement(List<ValidatedFragment> res, String name, String type, byte[] content) {
        ValidatedFragment result = new ValidatedFragment(name, type, content, true);
        res.add(result);
        return result;
    }

    private HTTPResult fetchFile(String url, String ct) throws IOException {
        HTTPResult res = ManagedWebAccess.get((String)url, (String)ct);
        res.checkThrowException();
        return res;
    }

    private HTTPResult fetchManifest() throws IOException {
        if (testMode) {
            return new HTTPResult(this.url, 200, "OK", "application/json", TextFile.streamToBytes((InputStream)TestingUtilities.loadTestResourceStream((String[])new String[]{"validator", "shlink.manifest.json"})));
        }
        JsonObject j = new JsonObject();
        j.add("recipient", "FHIR Validator");
        HTTPResult res = ManagedWebAccess.post((String)this.url, (byte[])JsonParser.composeBytes((JsonElement)j), (String)"application/json", (String)"application/json");
        res.checkThrowException();
        return res;
    }

    private boolean checkJson(List<ValidationMessage> errors, JsonObject j) {
        boolean ok = true;
        boolean fUrl = false;
        boolean fKey = false;
        boolean fCty = false;
        boolean hp = false;
        boolean hu = false;
        block23: for (JsonProperty p : j.getProperties()) {
            switch (p.getName()) {
                case "url": {
                    fUrl = true;
                    if (!p.getValue().isJsonString()) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "url must be a string", ValidationMessage.IssueSeverity.ERROR);
                        ok = false;
                        break;
                    }
                    if (!Utilities.isAbsoluteUrlLinkable((String)p.getValue().asString())) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "url is not valid: " + p.getValue().asString(), ValidationMessage.IssueSeverity.ERROR);
                        ok = false;
                        break;
                    }
                    this.url = p.getValue().asString();
                    break;
                }
                case "key": {
                    fKey = true;
                    if (!p.getValue().isJsonString()) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "key must be a string", ValidationMessage.IssueSeverity.ERROR);
                        ok = false;
                        break;
                    }
                    if (p.getValue().asString().length() != 43) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "key must contain 43 chars", ValidationMessage.IssueSeverity.ERROR);
                        ok = false;
                        break;
                    }
                    this.key = Base64.getUrlDecoder().decode(p.getValue().asString());
                    break;
                }
                case "exp": {
                    if (!p.getValue().isJsonNumber()) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "exp must be a number", ValidationMessage.IssueSeverity.ERROR);
                        break;
                    }
                    if (!Utilities.isDecimal((String)p.getValue().asJsonNumber().getValue(), (boolean)false)) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "exp must be a valid number", ValidationMessage.IssueSeverity.ERROR);
                        break;
                    }
                    String v = p.getValue().asJsonNumber().getValue();
                    if (v.contains(".")) {
                        v = v.substring(0, v.indexOf("."));
                    }
                    long epochSecs = Long.valueOf(v);
                    LocalDateTime date = LocalDateTime.ofEpochSecond(epochSecs, 0, ZoneOffset.UTC);
                    LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
                    Duration duration = Duration.between(date, now);
                    if (!date.isBefore(now)) continue block23;
                    this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "The content has expired (by " + Utilities.describeDuration((Duration)duration) + ")", ValidationMessage.IssueSeverity.WARNING);
                    break;
                }
                case "flag": {
                    if (!p.getValue().isJsonString()) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "flag must be a string", ValidationMessage.IssueSeverity.ERROR);
                        break;
                    }
                    String flag = p.getValue().asString();
                    block24: for (char c : flag.toCharArray()) {
                        switch (c) {
                            case 'L': {
                                continue block24;
                            }
                            case 'P': {
                                hp = true;
                                continue block24;
                            }
                            case 'U': {
                                hu = true;
                                continue block24;
                            }
                            default: {
                                this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "Illegal Character " + c + " in flag", ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                    }
                    if (hu && hp) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "Illegal combination in flag: both P and U are present", ValidationMessage.IssueSeverity.ERROR);
                    }
                    if (hp) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.BUSINESSRULE, "The validator is unable to retrieve the content referred to by the URL because a password is required", ValidationMessage.IssueSeverity.INFORMATION);
                        ok = false;
                    }
                    if (!hu) continue block23;
                    this.post = false;
                    break;
                }
                case "label": {
                    if (!p.getValue().isJsonString()) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "label must be a string", ValidationMessage.IssueSeverity.ERROR);
                        break;
                    }
                    if (p.getValue().asString().length() <= 80) continue block23;
                    this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "label must be no longer than 80 chars", ValidationMessage.IssueSeverity.ERROR);
                    break;
                }
                case "cty": {
                    if (!p.getValue().isJsonString()) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "cty must be a string", ValidationMessage.IssueSeverity.ERROR);
                        break;
                    }
                    if (!Utilities.existsInList((String)p.getValue().asString(), (String[])new String[]{"application/smart-health-card", "application/smart-api-access", "application/fhir+json"})) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "cty must be one of 'application/smart-health-card/, 'application/smart-api-access', 'application/fhir+json'", ValidationMessage.IssueSeverity.ERROR);
                        break;
                    }
                    this.ct = p.getValue().asString();
                    break;
                }
                case "v": {
                    if (!p.getValue().isJsonString()) {
                        this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "v must be a string", ValidationMessage.IssueSeverity.ERROR);
                        break;
                    }
                    if (p.getValue().asString().length() > 80) continue block23;
                    this.logError(errors, "2023-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "if present, v must be '1'", ValidationMessage.IssueSeverity.ERROR);
                    break;
                }
                default: {
                    this.logError(errors, "202-08-31", p.getValue().getStart().getLine(), p.getValue().getStart().getCol(), "shl." + p.getName(), ValidationMessage.IssueType.STRUCTURE, "Illegal property name " + p.getName(), ValidationMessage.IssueSeverity.ERROR);
                }
            }
        }
        if (hu && !fCty) {
            this.logError(errors, "202-08-31", 1, 1, "shl", ValidationMessage.IssueType.STRUCTURE, "Flag 'U' found, but no 'cty' header which is required for the U flag", ValidationMessage.IssueSeverity.ERROR);
            ok = false;
        }
        if (!fUrl) {
            this.logError(errors, "202-08-31", 1, 1, "shl", ValidationMessage.IssueType.STRUCTURE, "No url found", ValidationMessage.IssueSeverity.ERROR);
            ok = false;
        }
        if (!fKey) {
            this.logError(errors, "202-08-31", 1, 1, "shl", ValidationMessage.IssueType.STRUCTURE, "No key found", ValidationMessage.IssueSeverity.ERROR);
            ok = false;
        }
        return ok;
    }

    @Override
    public void compose(Element e, OutputStream destination, IParser.OutputStyle style, String base) throws FHIRException, IOException {
        throw new FHIRFormatError("Writing resources is not supported for the SHL format");
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static void setTestMode(boolean testMode) {
        SHLParser.testMode = testMode;
    }
}

