/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.stringtemplate.v4.ST;

public class ShExGenerator {
    public boolean doDatatypes = false;
    public boolean withComments = true;
    public boolean completeModel = false;
    public boolean debugMode = false;
    public boolean processConstraints = false;
    public ConstraintTranslationPolicy constraintPolicy = ConstraintTranslationPolicy.ALL;
    private static String SHEX_TEMPLATE = "$header$\n$imports$\n$shapeDefinitions$";
    private static String FHIR = "http://hl7.org/fhir/";
    private static String FHIR_VS = FHIR + "ValueSet/";
    private static String HEADER_TEMPLATE = "PREFIX fhir: <$fhir$> \nPREFIX fhirvs: <$fhirvs$>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n";
    private static String IMPORT_TEMPLATE = "IMPORT <$import$$fileExt$>\n";
    private static String START_TEMPLATE = "\n\nstart=@<$id$> AND {fhir:nodeRole [fhir:treeRoot]}\n";
    private static String ALL_START_TEMPLATE = "\n\nstart=@<All>\n";
    private static String ALL_TEMPLATE = "\n<All> $all_entries$\n";
    private static String ALL_ENTRY_TEMPLATE = "(NOT { fhir:nodeRole [fhir:treeRoot] ; a [fhir:$id$] } OR @<$id$>)";
    private static String SHAPE_DEFINITION_TEMPLATE = "$comment$\n<$id$> CLOSED { $fhirType$ \n    $resourceDecl$\n    $elements$\n    $contextOfUse$\n} $constraints$ \n";
    private List<String> baseDataTypes = Arrays.asList("DataType", "PrimitiveType", "BackboneElement");
    private List<String> shortIdException = Arrays.asList("base64Binary", "boolean", "date", "dateTime", "decimal", "instant", "integer64", "integer", "string", "time", "uri");
    private List<String> mappedFunctions = Arrays.asList("empty", "exists", "hasValue", "matches", "contains", "is");
    private static String ONE_OR_MORE_PREFIX = "OneOrMore_";
    private static String ONE_OR_MORE_CHOICES = "_One-Or-More-Choices_";
    private static String ONE_OR_MORE_TEMPLATE = "\n$comment$\n<$oomType$> CLOSED {\n    rdf:first @<$origType$> $restriction$ ;\n    rdf:rest [rdf:nil] OR @<$oomType$> \n}\n";
    private static String RESOURCE_SHAPE_TEMPLATE = "$comment$\n<Resource> {\n    $elements$\n    $contextOfUse$\n} $constraints$ \n";
    private static String COMPLETE_RESOURCE_TEMPLATE = "<Resource>  @<$resources$>\n\n";
    private static String RESOURCE_DECL_TEMPLATE = "\na [fhir:$id$]?;$root$";
    private static String ROOT_TEMPLATE = "\nfhir:nodeRole [fhir:treeRoot]?;\n";
    private static String ELEMENT_TEMPLATE = "$id$$defn$$card$$comment$";
    private static int COMMENT_COL = 40;
    private static int MAX_CHARS = 35;
    private static int MIN_COMMENT_SEP = 2;
    private static String INNER_SHAPE_TEMPLATE = "($comment$\n    $defn$\n)$card$";
    private static String SIMPLE_ELEMENT_DEFN_TEMPLATE = "@<$typ$>$vsdef$";
    private static String VALUESET_DEFN_TEMPLATE = " AND\n\t{fhir:v @$vsn$}";
    private static String FIXED_VALUE_TEMPLATE = " AND\n\t{fhir:value [\"$val$\"]}";
    private static String PRIMITIVE_ELEMENT_DEFN_TEMPLATE = "$typ$$facets$";
    private static String MINVALUE_TEMPLATE = " MININCLUSIVE $val$";
    private static String MAXVALUE_TEMPLATE = " MAXINCLUSIVE $val$";
    private static String MAXLENGTH_TEMPLATE = " MAXLENGTH $val$";
    private static String PATTERN_TEMPLATE = " PATTERN \"$val$\"";
    private static String ALTERNATIVE_SHAPES_TEMPLATE = "fhir:$id$$comment$\n(   $altEntries$\n)$card$";
    private static String REFERENCE_DEFN_TEMPLATE = "@<$ref$Reference>";
    private static String XHTML_TYPE_TEMPLATE = "xsd:string";
    private static String CONCEPT_REFERENCE_TEMPLATE = "a NONLITERAL?;";
    private static String CONCEPT_REFERENCES_TEMPLATE = "a NONLITERAL*;";
    private static String RESOURCE_LINK_TEMPLATE = "fhir:link IRI?;";
    private static String TYPED_REFERENCE_TEMPLATE = "\n<$refType$Reference> CLOSED {\n    fhir:Element.id @<id>?;\n    fhir:Element.extension @<Extension>*;\n    fhir:link @<$refType$> OR CLOSED {a [fhir:$refType$]}?;\n    fhir:Reference.reference @<string>?;\n    fhir:Reference.display @<string>?;\n}";
    private static String TARGET_REFERENCE_TEMPLATE = "\n<$refType$> {\n    a [fhir:$refType$];\n    fhir:nodeRole [fhir:treeRoot]?\n}";
    private static String VALUE_SET_DEFINITION = "# $comment$\n$vsuri$$val_list$\n";
    private IWorkerContext context;
    private ProfileUtilities profileUtilities;
    private HashSet<Pair<StructureDefinition, ElementDefinition>> innerTypes;
    private HashSet<Pair<StructureDefinition, ElementDefinition>> emittedInnerTypes;
    private List<String> oneOrMoreTypes;
    private List<String> constraintsList;
    private List<String> unMappedFunctions;
    private HashSet<String> datatypes;
    private HashSet<String> emittedDatatypes;
    private HashSet<String> references;
    private LinkedList<StructureDefinition> uniq_structures;
    private HashSet<String> uniq_structure_urls;
    private HashSet<ValueSet> required_value_sets;
    private HashSet<String> known_resources;
    private List<String> excludedSDUrls;
    private List<StructureDefinition> selectedExtensions;
    private List<String> selectedExtensionUrls;
    private List<String> imports;
    private FHIRPathEngine fpe;

    public ShExGenerator(IWorkerContext context) {
        this.context = context;
        this.profileUtilities = new ProfileUtilities(context, null, null);
        this.innerTypes = new HashSet();
        this.oneOrMoreTypes = new ArrayList<String>();
        this.constraintsList = new ArrayList<String>();
        this.unMappedFunctions = new ArrayList<String>();
        this.emittedInnerTypes = new HashSet();
        this.datatypes = new HashSet();
        this.emittedDatatypes = new HashSet();
        this.references = new HashSet();
        this.required_value_sets = new HashSet();
        this.known_resources = new HashSet();
        this.excludedSDUrls = new ArrayList<String>();
        this.selectedExtensions = new ArrayList<StructureDefinition>();
        this.selectedExtensionUrls = new ArrayList<String>();
        this.imports = new ArrayList<String>();
        this.fpe = new FHIRPathEngine(context);
    }

    public String generate(HTMLLinkPolicy links, StructureDefinition structure) {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        list.add(structure);
        this.innerTypes.clear();
        this.oneOrMoreTypes.clear();
        this.constraintsList.clear();
        this.unMappedFunctions.clear();
        this.emittedInnerTypes.clear();
        this.datatypes.clear();
        this.emittedDatatypes.clear();
        this.references.clear();
        this.required_value_sets.clear();
        this.known_resources.clear();
        this.imports.clear();
        return this.generate(links, list);
    }

    public List<String> getExcludedStructureDefinitionUrls() {
        return this.excludedSDUrls;
    }

    public void setExcludedStructureDefinitionUrls(List<String> excludedSDs) {
        this.excludedSDUrls = excludedSDs;
    }

    public List<StructureDefinition> getSelectedExtensions() {
        return this.selectedExtensions;
    }

    public void setSelectedExtension(List<StructureDefinition> selectedExtensions) {
        this.selectedExtensions = selectedExtensions;
        this.selectedExtensionUrls.clear();
        for (StructureDefinition eSD : selectedExtensions) {
            if (this.selectedExtensionUrls.contains(eSD.getUrl())) continue;
            this.selectedExtensionUrls.add(eSD.getUrl());
        }
    }

    private ST tmplt(String template) {
        return new ST(template, '$', '$');
    }

    public String generate(HTMLLinkPolicy links, List<StructureDefinition> structures, List<String> excludedSDUrls) {
        this.excludedSDUrls = excludedSDUrls;
        if (structures != null && this.selectedExtensions != null) {
            structures.addAll(this.selectedExtensions);
        }
        return this.generate(links, structures);
    }

    public String generate(HTMLLinkPolicy links, List<StructureDefinition> structures) {
        ST shex_def = this.tmplt(SHEX_TEMPLATE);
        String start_cmd = this.completeModel || structures.get(0).getKind().equals((Object)StructureDefinition.StructureDefinitionKind.RESOURCE) ? (this.completeModel ? this.tmplt(ALL_START_TEMPLATE).render() : this.tmplt(START_TEMPLATE).add("id", (Object)structures.get(0).getId()).render()) : "";
        shex_def.add("header", (Object)this.tmplt(HEADER_TEMPLATE).add("fhir", (Object)FHIR).add("fhirvs", (Object)FHIR_VS).render());
        Collections.sort(structures, new SortById());
        StringBuilder shapeDefinitions = new StringBuilder();
        this.uniq_structures = new LinkedList();
        this.uniq_structure_urls = new HashSet();
        StringBuffer allStructures = new StringBuffer("");
        for (StructureDefinition structureDefinition : structures) {
            if (this.excludedSDUrls != null && this.excludedSDUrls.contains(structureDefinition.getUrl())) {
                this.printBuildMessage("SKIPPED Generating ShEx for " + structureDefinition.getName() + "  [ " + structureDefinition.getUrl() + " ] !");
                this.printBuildMessage("Reason: It is in excluded list of structures.");
                continue;
            }
            if ("Extension".equals(structureDefinition.getType())) {
                if (!this.selectedExtensionUrls.isEmpty() && !this.selectedExtensionUrls.contains(structureDefinition.getUrl())) {
                    this.printBuildMessage("SKIPPED Generating ShEx for " + structureDefinition.getName() + "  [ " + structureDefinition.getUrl() + " ] !");
                    this.printBuildMessage("Reason: It is NOT included in the list of selected extensions.");
                    continue;
                }
                if (this.constraintPolicy == ConstraintTranslationPolicy.GENERIC_ONLY && structureDefinition.hasContext()) {
                    this.printBuildMessage("SKIPPED Generating ShEx for " + structureDefinition.getName() + "  [ " + structureDefinition.getUrl() + " ] !");
                    this.printBuildMessage("Reason: ConstraintTranslationPolicy is set to GENERIC_ONLY, and this Structure has Context of Use.");
                    continue;
                }
                if (this.constraintPolicy == ConstraintTranslationPolicy.CONTEXT_OF_USE_ONLY && !structureDefinition.hasContext()) {
                    this.printBuildMessage("SKIPPED Generating ShEx for " + structureDefinition.getName() + "  [ " + structureDefinition.getUrl() + " ] !");
                    this.printBuildMessage("Reason: ConstraintTranslationPolicy is set to CONTEXT_OF_USE_ONLY, and this Structure has no Context of Use.");
                    continue;
                }
            }
            if (this.uniq_structure_urls.contains(structureDefinition.getUrl())) continue;
            this.uniq_structures.add(structureDefinition);
            this.uniq_structure_urls.add(structureDefinition.getUrl());
        }
        for (StructureDefinition structureDefinition : this.uniq_structures) {
            this.printBuildMessage(" ---- Generating ShEx for : " + structureDefinition.getName() + "  [ " + structureDefinition.getUrl() + " ] ...");
            String shapeDefinitionStr = this.genShapeDefinition(structureDefinition, true);
            if (!shapeDefinitionStr.isEmpty()) {
                shapeDefinitions.append(shapeDefinitionStr);
                continue;
            }
            this.printBuildMessage(" ---- WARNING! EMPTY/No ShEx SCHEMA Body generated for : " + structureDefinition.getName() + "  [ " + structureDefinition.getUrl() + " ].\nThis might not be an issue, if this resource is normative base or a meta resource");
            shapeDefinitions.append("<" + structureDefinition.getName() + "> CLOSED {\n}");
        }
        shapeDefinitions.append(this.emitInnerTypes());
        if (this.doDatatypes) {
            shapeDefinitions.append("\n#---------------------- Data Types -------------------\n");
            while (this.emittedDatatypes.size() < this.datatypes.size() || this.emittedInnerTypes.size() < this.innerTypes.size()) {
                shapeDefinitions.append(this.emitDataTypes());
                shapeDefinitions.append(this.emitInnerTypes());
            }
        }
        if (this.oneOrMoreTypes.size() > 0) {
            shapeDefinitions.append("\n#---------------------- Cardinality Types (OneOrMore) -------------------\n");
            this.oneOrMoreTypes.forEach(oomType -> shapeDefinitions.append(this.getOneOrMoreType((String)oomType)));
        }
        if (this.references.size() > 0) {
            shapeDefinitions.append("\n#---------------------- Reference Types -------------------\n");
            for (String string : this.references) {
                shapeDefinitions.append("\n").append(this.tmplt(TYPED_REFERENCE_TEMPLATE).add("refType", (Object)string).render()).append("\n");
                if ("Resource".equals(string) || this.known_resources.contains(string)) continue;
                shapeDefinitions.append("\n").append(this.tmplt(TARGET_REFERENCE_TEMPLATE).add("refType", (Object)string).render()).append("\n");
            }
        }
        if (this.completeModel && this.known_resources.size() > 0) {
            shapeDefinitions.append("\n").append(this.tmplt(COMPLETE_RESOURCE_TEMPLATE).add("resources", (Object)StringUtils.join(this.known_resources, (String)"> OR\n\t@<")).render());
            ArrayList<String> all_entries = new ArrayList<String>();
            for (String kr : this.known_resources) {
                all_entries.add(this.tmplt(ALL_ENTRY_TEMPLATE).add("id", (Object)kr).render());
            }
            shapeDefinitions.append("\n").append(this.tmplt(ALL_TEMPLATE).add("all_entries", (Object)StringUtils.join(all_entries, (String)" OR\n\t")).render());
        }
        if (this.required_value_sets.size() > 0) {
            shapeDefinitions.append("\n#---------------------- Value Sets ------------------------\n");
            ArrayList sortedVS = new ArrayList();
            for (ValueSet vs : this.required_value_sets) {
                sortedVS.add(this.genValueSet(vs));
            }
            Collections.sort(sortedVS, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    try {
                        return StringUtils.substringBetween((String)o1, (String)"fhirvs:", (String)" ").compareTo(StringUtils.substringBetween((String)o2, (String)"fhirvs:", (String)" "));
                    }
                    catch (Exception e) {
                        ShExGenerator.this.debug("SORT COMPARISON FAILED BETWEEN \n\t\t" + o1 + "\n\t\t and \n\t\t" + o2);
                        ShExGenerator.this.debug(e.getMessage());
                        return 0;
                    }
                }
            });
            Iterator iterator = sortedVS.iterator();
            while (iterator.hasNext()) {
                String svs = (String)iterator.next();
                shapeDefinitions.append("\n").append(svs);
            }
        }
        if (this.unMappedFunctions != null && !this.unMappedFunctions.isEmpty()) {
            this.debug("------------------------- Unmapped Functions ---------------------");
            for (String string : this.unMappedFunctions) {
                this.debug(string);
            }
        }
        allStructures.append(shapeDefinitions + "\n");
        StringBuffer allImports = new StringBuffer("");
        if (!this.imports.isEmpty()) {
            this.uniq_structures.forEach(sdstruct -> this.imports.removeIf(s -> s.contains(sdstruct.getName())));
            this.imports.sort(Comparator.comparingInt(String::length));
            this.imports.forEach(imp -> {
                ST import_def = this.tmplt(IMPORT_TEMPLATE);
                import_def.add("import", imp);
                import_def.add("fileExt", (Object)".shex");
                allImports.append(import_def.render());
            });
        }
        allImports.append(start_cmd);
        shex_def.add("imports", (Object)allImports);
        shex_def.add("shapeDefinitions", (Object)allStructures.toString());
        return shex_def.render();
    }

    private String getBaseTypeName(StructureDefinition sd) {
        if (sd == null) {
            return null;
        }
        String bd = null;
        if (sd.hasBaseDefinition()) {
            bd = sd.getBaseDefinition();
            String[] els = bd.split("/");
            bd = els[els.length - 1];
        }
        return bd;
    }

    private String getBaseTypeName(ElementDefinition ed) {
        if (ed == null) {
            return null;
        }
        return ed.getType().size() > 0 ? ed.getType().get(0).getCode() : null;
    }

    private String getExtendedType(StructureDefinition sd) {
        String bd = this.getBaseTypeName(sd);
        Object sId = sd.getId();
        if (bd != null) {
            this.addImport("<" + bd + ">");
            sId = (String)sId + "> EXTENDS @<" + bd;
        }
        return sId;
    }

    private String getExtendedType(ElementDefinition ed) {
        Object bd = this.getBaseTypeName(ed);
        if (bd != null) {
            this.addImport("<" + (String)bd + ">");
            bd = "> EXTENDS @<" + (String)bd;
        }
        return bd;
    }

    private String genShapeDefinition(StructureDefinition sd, boolean top_level) {
        ST shape_defn;
        if ("xhtml".equals(sd.getName()) || this.completeModel && "Resource".equals(sd.getName())) {
            return "";
        }
        if ("Resource".equals(sd.getName())) {
            shape_defn = this.tmplt(RESOURCE_SHAPE_TEMPLATE);
            this.known_resources.add(sd.getName());
        } else {
            shape_defn = this.tmplt(SHAPE_DEFINITION_TEMPLATE).add("id", (Object)this.getExtendedType(sd));
            this.known_resources.add(sd.getName());
            if (this.baseDataTypes.contains(sd.getType())) {
                shape_defn.add("resourceDecl", (Object)"\n");
            } else if ("Element".equals(sd.getName())) {
                shape_defn.add("resourceDecl", (Object)this.tmplt(ROOT_TEMPLATE).render());
            } else {
                String rootTmpl = this.tmplt(ROOT_TEMPLATE).render();
                String btn = this.getBaseTypeName(sd);
                if (this.baseDataTypes.contains(btn) || this.shortIdException.contains(btn)) {
                    rootTmpl = "\n";
                }
                ST resource_decl = this.tmplt(RESOURCE_DECL_TEMPLATE).add("id", (Object)sd.getId()).add("root", (Object)rootTmpl);
                shape_defn.add("resourceDecl", (Object)resource_decl.render());
            }
        }
        shape_defn.add("fhirType", (Object)" ");
        ArrayList<String> elements = new ArrayList<String>();
        String sdn = sd.getName();
        if (sdn.equals("Coding")) {
            elements.add(this.tmplt(CONCEPT_REFERENCE_TEMPLATE).render());
        } else if (sdn.equals("CodeableConcept")) {
            elements.add(this.tmplt(CONCEPT_REFERENCES_TEMPLATE).render());
        } else if (sdn.equals("Reference")) {
            elements.add(this.tmplt(RESOURCE_LINK_TEMPLATE).render());
        }
        String root_comment = null;
        this.constraintsList.clear();
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().contains(".")) {
                root_comment = ed.getShort();
                continue;
            }
            if (StringUtils.countMatches((CharSequence)ed.getPath(), (CharSequence)".") == 1 && !"0".equals(ed.getMax()) && ed.hasBase() && (ed.getBase().getPath().startsWith(sdn) || ed.getBase().getPath().startsWith("Extension") || ed.getBase().getPath().startsWith("Element.extension") && ed.hasSliceName())) {
                String elementDefinition = this.genElementDefinition(sd, ed);
                boolean isInnerType = false;
                if (this.isInInnerTypes(ed)) {
                    isInnerType = true;
                }
                if (this.processConstraints) {
                    for (ElementDefinition.ElementDefinitionConstraintComponent constraint : ed.getConstraint()) {
                        String sdType = sd.getType();
                        String cstype = constraint.getSource();
                        if (!cstype.isEmpty() && cstype.indexOf("/") != -1) {
                            String[] els = cstype.split("/");
                            cstype = els[els.length - 1];
                        }
                        String id = ed.hasBase() ? ed.getBase().getPath() : ed.getPath();
                        String shortId = id.substring(id.lastIndexOf(".") + 1);
                        if ((!ed.hasContentReference() || ed.hasType()) && !id.equals(sd.getName() + "." + shortId) || !sdType.equals(cstype) && !this.baseDataTypes.contains(sdType) || isInnerType) continue;
                        this.debug("\n        Key: " + constraint.getKey() + " SD type: " + sd.getType() + " Element: " + ed.getPath() + " Constraint Source: " + constraint.getSource() + " Constraint:" + constraint.getExpression());
                        String transl = this.translateConstraint(sd, ed, constraint);
                        if (transl.isEmpty() || this.constraintsList.contains(transl)) continue;
                        this.constraintsList.add(transl);
                    }
                }
                elements.add(elementDefinition);
                continue;
            }
            List<ElementDefinition> children = this.profileUtilities.getChildList(sd, ed);
            if (children.size() <= 0) continue;
            for (ElementDefinition child : children) {
                if (!child.getPath().startsWith(ed.getPath())) continue;
                this.innerTypes.add((Pair<StructureDefinition, ElementDefinition>)new ImmutablePair((Object)sd, (Object)ed));
            }
        }
        if (this.processConstraints) {
            for (ElementDefinition ded : sd.getDifferential().getElement()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent dconstraint : ded.getConstraint()) {
                    String sdType = sd.getType();
                    String id = ded.hasBase() ? ded.getBase().getPath() : ded.getPath();
                    String shortId = id.substring(id.lastIndexOf(".") + 1);
                    if (this.isInInnerTypes(ded)) continue;
                    this.debug("\n        Key: " + dconstraint.getKey() + " SD type: " + sd.getType() + " Element: " + ded.getPath() + " Constraint Source: " + dconstraint.getSource() + " Constraint:" + dconstraint.getExpression());
                    String dtransl = this.translateConstraint(sd, ded, dconstraint);
                    if (dtransl.isEmpty() || this.constraintsList.contains(dtransl)) continue;
                    this.constraintsList.add(dtransl);
                }
            }
        }
        shape_defn.add("elements", (Object)StringUtils.join(elements, (String)"\n"));
        shape_defn.add("comment", root_comment == null ? " " : "# " + root_comment);
        Object constraintStr = "";
        if (!this.constraintsList.isEmpty()) {
            constraintStr = "AND (\n\n" + StringUtils.join(this.constraintsList, (String)"\n\n) AND (\n\n") + "\n\n)\n";
        }
        shape_defn.add("constraints", constraintStr);
        Object contextOfUseStr = "";
        ArrayList<Object> contextOfUse = new ArrayList<Object>();
        if (!sd.getContext().isEmpty()) {
            for (StructureDefinition.StructureDefinitionContextComponent uc : sd.getContext()) {
                if (uc.getExpression().isEmpty()) continue;
                Object toStore = uc.getExpression();
                this.debug("CONTEXT-OF-USE FOUND: " + (String)toStore);
                if (((String)toStore).indexOf("http") != -1) {
                    this.debug("\t\tWARNING: CONTEXT-OF-USE SKIPPED as it has 'http' in it, might be a URL, instead of '.' delimited string");
                    continue;
                }
                String[] backRefs = ((String)toStore).split("\\.");
                toStore = "a [fhir:" + backRefs[0] + "]";
                for (int i = 1; i < backRefs.length; ++i) {
                    toStore = "^fhir:" + backRefs[i] + " {" + (String)toStore + "}";
                }
                if (contextOfUse.contains(toStore)) continue;
                contextOfUse.add(toStore);
            }
            if (!contextOfUse.isEmpty()) {
                contextOfUseStr = contextOfUse.size() > 1 ? "^fhir:extension { " + StringUtils.join(contextOfUse, (String)"} OR \n      {") + "}\n" : "^fhir:extension { " + (String)contextOfUse.get(0) + "}\n";
            }
        }
        shape_defn.add("contextOfUse", contextOfUseStr);
        return shape_defn.render();
    }

    private String translateConstraint(StructureDefinition sd, ElementDefinition ed, ElementDefinition.ElementDefinitionConstraintComponent constraint) {
        Object translated = "";
        if (constraint != null) {
            String ce = constraint.getExpression();
            String constItem = "FHIR-SD-Path:" + ed.getPath() + " Expression: " + ce;
            try {
                translated = "# Constraint UniqueKey:" + constraint.getKey() + "\n# Human readable:" + constraint.getHuman() + "\n\n# Constraint: " + constraint.getExpression() + "\n# ShEx:\n";
                ExpressionNode expr = this.fpe.parse(ce);
                String shexConstraint = this.processExpressionNode(sd, ed, expr, false, 0);
                shexConstraint = shexConstraint.replaceAll("CALLER", "");
                this.debug("        Parsed to ShEx Constraint:" + shexConstraint);
                if (!shexConstraint.isEmpty()) {
                    translated = (String)translated + "\n" + shexConstraint;
                }
                this.debug("        TRANSLATED\t" + ed.getPath() + "\t" + constraint.getHuman() + "\t" + constraint.getExpression() + "\t" + shexConstraint);
            }
            catch (Exception e) {
                String message = "        FAILED to parse the constraint from Structure Definition: " + constItem;
                e.printStackTrace();
                translated = "";
                this.debug(message);
            }
        }
        return this.commentUnmapped((String)translated);
    }

    private String processExpressionNode(StructureDefinition sd, ElementDefinition ed, ExpressionNode node, boolean quote, int depth) {
        if (node == null) {
            return "";
        }
        boolean toQuote = quote;
        String innerShEx = "";
        if (node.getInner() != null) {
            innerShEx = this.processExpressionNode(sd, ed, node.getInner(), quote, depth + 1);
        }
        Object translatedShEx = "";
        boolean treatBothOpsSame = false;
        String ops = "";
        String endOps = "";
        if (node.getOperation() != null) {
            String opName;
            switch (opName = node.getOperation().name()) {
                case "Or": {
                    ops = " OR ";
                    break;
                }
                case "Union": {
                    ops = " ";
                    break;
                }
                case "In": 
                case "Equals": 
                case "Contains": {
                    if (!node.getOpNext().getKind().equals((Object)ExpressionNode.Kind.Name)) {
                        ops = " { fhir:v [";
                        endOps = "] } ";
                        toQuote = true;
                        break;
                    }
                    String toStore = "UNMAPPED_OPERATOR_" + opName + " in Node type: " + node.getKind();
                    this.addUnmappedFunction(opName);
                    ops = this.TBD(opName);
                    break;
                }
                case "NotEquals": {
                    if (!node.getOpNext().getKind().equals((Object)ExpressionNode.Kind.Name)) {
                        ops = " [fhir:v  . -";
                        endOps = "] ";
                        toQuote = true;
                        break;
                    }
                    String toStore = "UNMAPPED_OPERATOR_" + opName + " in Node type: " + node.getKind();
                    this.addUnmappedFunction(opName);
                    ops = this.TBD(opName);
                    break;
                }
                case "Greater": {
                    if (node.getOpNext().getKind().equals((Object)ExpressionNode.Kind.Constant)) {
                        ops = " { fhir:v MinExclusive ";
                        endOps = " } ";
                        break;
                    }
                    String toStore = "UNMAPPED_OPERATOR_" + opName + " in Node type: " + node.getKind();
                    this.addUnmappedFunction(opName);
                    ops = this.TBD(opName);
                    break;
                }
                case "GreaterOrEqual": {
                    if (node.getOpNext().getKind().equals((Object)ExpressionNode.Kind.Constant)) {
                        ops = " { fhir:v MinInclusive ";
                        endOps = " } ";
                        break;
                    }
                    String toStore = "UNMAPPED_OPERATOR_" + opName + " in Node type: " + node.getKind();
                    this.addUnmappedFunction(opName);
                    ops = this.TBD(opName);
                    break;
                }
                case "Less": 
                case "LessThan": {
                    if (node.getOpNext().getKind().equals((Object)ExpressionNode.Kind.Constant)) {
                        ops = " { fhir:v MaxExclusive ";
                        endOps = " } ";
                        break;
                    }
                    String toStore = "UNMAPPED_OPERATOR_" + opName + " in Node type: " + node.getKind();
                    this.addUnmappedFunction(opName);
                    ops = this.TBD(opName);
                    break;
                }
                case "LessOrEqual": {
                    if (node.getOpNext().getKind().equals((Object)ExpressionNode.Kind.Constant)) {
                        ops = " { fhir:v MaxInclusive ";
                        endOps = " } ";
                        break;
                    }
                    String toStore = "UNMAPPED_OPERATOR_" + opName + " in Node type: " + node.getKind();
                    this.addUnmappedFunction(opName);
                    ops = this.TBD(opName);
                    break;
                }
                case "And": {
                    ops = " AND ";
                    break;
                }
                case "As": 
                case "Is": {
                    ops = " a ";
                    break;
                }
                default: {
                    String toStore = "UNMAPPED_OPERATOR_" + opName + " in Node type: " + node.getKind();
                    if (!this.unMappedFunctions.contains(toStore)) {
                        this.unMappedFunctions.add(toStore);
                    }
                    ops = this.TBD(opName);
                }
            }
        }
        Object fExp = "";
        Object pExp = "";
        boolean isFunctionCall = false;
        ExpressionNode.Kind kind = node.getKind();
        if (kind == ExpressionNode.Kind.Function) {
            String funcName = node.getName();
            if (!this.mappedFunctions.contains(funcName) && node.parameterCount() == 0) {
                if ("not".equals(funcName)) {
                    fExp = " NOT { CALLER }";
                } else {
                    fExp = " " + this.TBD(funcName) + "( CALLER )";
                    this.addUnmappedFunction(node.getFunction().toCode());
                    Object object = this.addUnmappedFunction(node.getFunction().toCode());
                }
            }
            if ("".equals(fExp)) {
                switch (funcName) {
                    case "empty": {
                        fExp = " NOT { CALLER {fhir:v .} } ";
                        break;
                    }
                    case "exists": 
                    case "hasValue": {
                        fExp = " .";
                        break;
                    }
                    case "matches": {
                        ops = " { fhir:v /";
                        endOps = "/ } ";
                        break;
                    }
                    case "contains": {
                        ops = " { fhir:v [";
                        endOps = "] } ";
                        toQuote = true;
                        break;
                    }
                    case "is": {
                        ops = " { a [";
                        endOps = "] } ";
                        break;
                    }
                    default: {
                        fExp = this.TBD(node.getFunction().toCode());
                        String string = this.addUnmappedFunction(node.getFunction().toCode());
                    }
                }
                if (node.parameterCount() > 0) {
                    for (ExpressionNode pen : node.getParameters()) {
                        if (!"".equals(pExp)) {
                            pExp = (String)pExp + ", ";
                        }
                        pExp = (String)pExp + this.processExpressionNode(sd, ed, pen, quote, depth);
                        isFunctionCall = true;
                    }
                }
            }
            if (isFunctionCall) {
                if (!this.mappedFunctions.contains(funcName)) {
                    translatedShEx = (String)translatedShEx + (String)fExp + "(" + (String)pExp + ")";
                } else {
                    translatedShEx = (String)translatedShEx + ops + (String)pExp + endOps;
                    ops = "";
                    endOps = "";
                }
            } else {
                translatedShEx = (String)translatedShEx + (String)fExp;
            }
            translatedShEx = this.positionParts(innerShEx, (String)translatedShEx, this.getNextOps(ops, this.processExpressionNode(sd, ed, node.getOpNext(), toQuote, depth), endOps, treatBothOpsSame), depth, false);
        } else if (kind == ExpressionNode.Kind.Name) {
            Object mT = depth == 0 ? "fhir:" + node.getName() : node.getName();
            translatedShEx = (String)translatedShEx + this.positionParts(innerShEx, (String)mT, this.getNextOps(ops, this.processExpressionNode(sd, ed, node.getOpNext(), toQuote, depth), endOps, treatBothOpsSame), depth, true);
        } else if (kind == ExpressionNode.Kind.Group) {
            translatedShEx = (String)translatedShEx + this.positionParts(innerShEx, this.processExpressionNode(sd, ed, node.getGroup(), toQuote, depth), this.getNextOps(ops, this.processExpressionNode(sd, ed, node.getOpNext(), toQuote, depth), endOps, treatBothOpsSame), depth, true);
        } else if (kind == ExpressionNode.Kind.Constant) {
            Base constantB = node.getConstant();
            boolean toQt = constantB instanceof StringType || !constantB.isPrimitive();
            String constantV = constantB.primitiveValue();
            if (constantV.startsWith("%")) {
                try {
                    List<Base> evaluated = this.fpe.evaluate(null, (Resource)sd, (Resource)sd, (Base)ed, node);
                    if (!evaluated.isEmpty()) {
                        constantV = evaluated.get(0).primitiveValue();
                    }
                }
                catch (Exception e) {
                    this.debug("Failed to evaluate constant expression: " + constantV);
                }
            }
            translatedShEx = (String)translatedShEx + this.positionParts(innerShEx, this.quoteThis(constantV, toQt), this.getNextOps(ops, this.processExpressionNode(sd, ed, node.getOpNext(), toQuote, depth), endOps, treatBothOpsSame), depth, false);
        } else {
            translatedShEx = kind == ExpressionNode.Kind.Unary ? (String)translatedShEx + this.positionParts(innerShEx, node.getName(), this.getNextOps(ops, this.processExpressionNode(sd, ed, node.getOpNext(), toQuote, depth), endOps, treatBothOpsSame), depth, false) : (String)translatedShEx + this.positionParts(innerShEx, node.toString(), this.getNextOps(ops, this.processExpressionNode(sd, ed, node.getOpNext(), toQuote, depth), endOps, treatBothOpsSame), depth, false);
        }
        return translatedShEx;
    }

    private String commentUnmapped(String text) {
        Object pre = "";
        String token = "NNNNN";
        Object temp = text;
        if (text != null && text.indexOf("SHEX_") != -1) {
            pre = "\n# This constraint does not have mapping to a ShEx construct yet.";
            temp = text.replaceAll("\n", token);
            while (((String)temp).indexOf("SHEX_") != -1) {
                pre = (String)pre + "\n# Unmapped construct found: " + StringUtils.substringBetween((String)temp, (String)"SHEX_", (String)"_SHEX");
                temp = ((String)temp).replaceFirst("SHEX_", " ").replaceFirst("_SHEX", " ");
            }
            pre = (String)pre + "\n# ";
        }
        if (((String)temp).indexOf(token) != -1) {
            temp = "#" + (String)temp;
            temp = ((String)temp).replaceAll(token, "\n#");
            temp = ((String)temp).replaceAll("##", "#");
            temp = ((String)temp).replaceAll("# #", "#");
            temp = ((String)temp).replaceAll("# #", "#");
            temp = (String)temp + "\n{}";
        }
        return (String)pre + (String)temp;
    }

    private String addUnmappedFunction(String func) {
        String toStore = "UNMAPPED_FUNCTION_" + func;
        if (!this.unMappedFunctions.contains(toStore)) {
            this.unMappedFunctions.add(toStore);
        }
        return toStore;
    }

    private String getNextOps(String startOp, String opNext, String endOp, boolean treatBothOps) {
        if (treatBothOps) {
            return startOp + opNext + " " + endOp + opNext;
        }
        return startOp + opNext + endOp;
    }

    private String positionParts(String funCall, String mainTxt, String nextText, int depth, boolean complete) {
        if (funCall.indexOf("CALLER") != -1) {
            if (depth == 0) {
                String toReturn = funCall.replaceFirst("CALLER", (String)mainTxt);
                if (complete) {
                    // empty if block
                }
                toReturn = this.postProcessing(toReturn, nextText);
                return toReturn.replaceAll("CALLER", "");
            }
            String mT = mainTxt != null ? ((String)mainTxt).trim() : "";
            String dR = mT.startsWith(".") || mT.startsWith("{") || mT.startsWith("[") ? "" : ".";
            return this.postProcessing(funCall.replaceFirst("CALLER", Matcher.quoteReplacement("CALLER" + dR + mT)), nextText);
        }
        Object fc = funCall;
        if (((String)fc).startsWith("fhir:")) {
            fc = "." + ((String)fc).substring("fhir:".length());
        }
        if (depth == 0 && complete) {
            if (((String)mainTxt).startsWith("fhir:")) {
                if ("".equals(funCall)) {
                    return "{ " + this.postProcessing((String)mainTxt, nextText) + " }";
                }
                if (fc != null && !((String)fc).isEmpty()) {
                    String fT = ((String)fc).trim();
                    String dR = fT.startsWith(".") || fT.startsWith("{") || fT.startsWith("[") ? "" : ".";
                    fc = dR + (String)fc;
                }
                return "{" + this.postProcessing((String)mainTxt + (String)fc, nextText) + "}";
            }
            if (!((String)mainTxt).startsWith("'")) {
                mainTxt = "(" + (String)mainTxt + ")";
            }
            if ("".equals(funCall)) {
                return this.postProcessing((String)mainTxt, nextText);
            }
        }
        if (fc != null && !((String)fc).isEmpty()) {
            String fT = ((String)fc).trim();
            String dR = fT.startsWith(".") || fT.startsWith("{") || fT.startsWith("[") ? "" : ".";
            fc = dR + (String)fc;
        }
        return this.postProcessing((String)mainTxt + (String)fc, nextText);
    }

    private String postProcessing(String p, String q) {
        String qp = q;
        if (q != null && q.trim().startsWith("XOR")) {
            qp = q.split("XOR")[1];
            return "{" + p + "} AND NOT {" + qp + "} OR { NOT {" + p + "} AND " + qp + "} ";
        }
        return p + qp;
    }

    private String TBD(String str) {
        return " SHEX_" + str + "_SHEX ";
    }

    private String quoteThis(String str, boolean quote) {
        if (quote) {
            return "'" + str + "'";
        }
        return str;
    }

    private String emitInnerTypes() {
        StringBuilder itDefs = new StringBuilder();
        while (this.emittedInnerTypes.size() < this.innerTypes.size()) {
            for (Pair<StructureDefinition, ElementDefinition> it : new HashSet<Pair<StructureDefinition, ElementDefinition>>(this.innerTypes)) {
                if (this.emittedInnerTypes.contains(it)) continue;
                itDefs.append("\n").append(this.genInnerTypeDef((StructureDefinition)it.getLeft(), (ElementDefinition)it.getRight()));
                this.emittedInnerTypes.add(it);
            }
        }
        return itDefs.toString();
    }

    private boolean isInInnerTypes(ElementDefinition ed) {
        if (this.innerTypes.isEmpty()) {
            return false;
        }
        Iterator<Pair<StructureDefinition, ElementDefinition>> itr = this.innerTypes.iterator();
        while (itr.hasNext()) {
            if (itr.next().getRight() != ed) continue;
            return true;
        }
        return false;
    }

    private String emitDataTypes() {
        StringBuilder dtDefs = new StringBuilder();
        while (this.emittedDatatypes.size() < this.datatypes.size()) {
            for (String dt : new HashSet<String>(this.datatypes)) {
                if (this.emittedDatatypes.contains(dt)) continue;
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(dt, null));
                if (sd != null && !this.uniq_structure_urls.contains(sd.getUrl())) {
                    dtDefs.append("\n").append(this.genShapeDefinition(sd, false));
                }
                this.emittedDatatypes.add(dt);
            }
        }
        return dtDefs.toString();
    }

    private ArrayList<String> split_text(String text, int max_col) {
        boolean pos = false;
        ArrayList<String> rval = new ArrayList<String>();
        if (text.length() <= max_col) {
            rval.add(text);
        } else {
            String[] words = text.split(" ");
            int word_idx = 0;
            while (word_idx < words.length) {
                StringBuilder accum = new StringBuilder();
                while (word_idx < words.length && accum.length() + words[word_idx].length() < max_col) {
                    accum.append(words[word_idx++] + " ");
                }
                if (accum.length() == 0) {
                    accum.append(words[word_idx].substring(0, max_col - 3) + "-");
                    words[word_idx] = words[word_idx].substring(max_col - 3);
                }
                rval.add(accum.toString());
                accum = new StringBuilder();
            }
        }
        return rval;
    }

    private void addComment(ST tmplt, ElementDefinition ed) {
        if (this.withComments && ed.hasShort() && !ed.getId().startsWith("Extension.")) {
            int nspaces = Integer.max(COMMENT_COL - tmplt.add("comment", (Object)"#").render().indexOf(35), MIN_COMMENT_SEP);
            tmplt.remove("comment");
            char[] sep = new char[nspaces];
            Arrays.fill(sep, ' ');
            ArrayList<String> comment_lines = this.split_text(ed.getShort().replace("\n", " "), MAX_CHARS);
            StringBuilder comment = new StringBuilder("# ");
            char[] indent = new char[COMMENT_COL];
            Arrays.fill(indent, ' ');
            int i = 0;
            while (i < comment_lines.size()) {
                comment.append(comment_lines.get(i++));
                if (i >= comment_lines.size()) continue;
                comment.append("\n" + new String(indent) + "# ");
            }
            tmplt.add("comment", (Object)(new String(sep) + comment.toString()));
        } else {
            tmplt.add("comment", (Object)" ");
        }
    }

    private String genElementDefinition(StructureDefinition sd, ElementDefinition ed) {
        String id;
        String shortId = id = ed.hasBase() ? ed.getBase().getPath() : ed.getPath();
        String typ = id;
        if (ed.getType().size() > 0) {
            typ = ed.getType().get(0).getCode();
        }
        shortId = id.equals("Element.extension") && ed.hasSliceName() ? ed.getSliceName() : id.substring(id.lastIndexOf(".") + 1);
        if (ed.getType().size() > 0 && ed.getType().get(0).getCode().startsWith("http://hl7.org/fhirpath/System.")) {
            if (this.changeShortName(sd, ed)) {
                this.debug("VALUE NAME CHANGED to v from " + shortId + " for " + sd.getName() + ":" + ed.getPath());
                shortId = "v";
            }
            typ = ed.getType().get(0).getWorkingCode();
        }
        Object defn = "";
        Object card = ("*".equals(ed.getMax()) ? (ed.getMin() == 0 ? "*" : "+") : (ed.getMin() == 0 ? "?" : "")) + ";";
        ST element_def = this.tmplt(ELEMENT_TEMPLATE);
        if (id.endsWith("[x]")) {
            element_def.add("id", (Object)("fhir:" + shortId.replace("[x]", "")));
        } else {
            element_def.add("id", (Object)("fhir:" + shortId + " "));
        }
        List<ElementDefinition> children = this.profileUtilities.getChildList(sd, ed);
        if (children.size() > 0) {
            String parentPath = sd.getName();
            if ((!ed.hasContentReference() || ed.hasType()) && id.equals(parentPath + "." + shortId)) {
                this.innerTypes.add((Pair<StructureDefinition, ElementDefinition>)new ImmutablePair((Object)sd, (Object)ed));
            }
        }
        if ("BackboneElement".equals(typ)) {
            typ = id;
        }
        defn = this.simpleElement(sd, ed, typ);
        String refChoices = "";
        if (id.endsWith("[x]")) {
            defn = " " + this.genChoiceTypes(sd, ed, shortId) + " ";
        } else {
            if (ed.getType().size() == 1) {
                if (((String)defn).isEmpty() || typ.equals(sd.getName())) {
                    defn = this.genTypeRef(sd, ed, id, ed.getType().get(0));
                }
            } else if (ed.getContentReference() != null) {
                String ref = ed.getContentReference();
                if (!ref.startsWith("#")) {
                    throw new AssertionError((Object)("Not equipped to deal with absolute path references: " + ref));
                }
                String refPath = null;
                for (ElementDefinition ed1 : sd.getSnapshot().getElement()) {
                    if (ed1.getId() == null || !ed1.getId().equals(ref.substring(1))) continue;
                    refPath = ed1.getPath();
                    break;
                }
                if (refPath == null) {
                    throw new AssertionError((Object)("Reference path not found: " + ref));
                }
                defn = this.simpleElement(sd, ed, refPath);
            }
            ArrayList refValues = new ArrayList();
            if (ed.hasType() && ed.getType().get(0).getWorkingCode().equals("Reference") && ed.getType().get(0).hasTargetProfile()) {
                ed.getType().get(0).getTargetProfile().forEach(tps -> {
                    String[] els = ((String)tps.getValue()).split("/");
                    refValues.add(els[els.length - 1]);
                });
            }
            if (!refValues.isEmpty()) {
                Collections.sort(refValues);
                refChoices = StringUtils.join(refValues, (String)"_OR_");
            }
        }
        if (((String)card).startsWith("*") || ((String)card).startsWith("+")) {
            card = ((String)card).replace("+", "");
            card = ((String)card).replace("*", "?");
            Object defnToStore = defn = ((String)defn).replace("<", "<" + ONE_OR_MORE_PREFIX);
            if (!refChoices.isEmpty()) {
                defnToStore = ((String)defn).replace(">", ONE_OR_MORE_CHOICES + refChoices + ">");
                defn = ((String)defn).replace(">", "_" + refChoices + ">");
            }
            if (!this.oneOrMoreTypes.contains(defnToStore = StringUtils.substringBetween((String)defnToStore, (String)"<", (String)">"))) {
                this.oneOrMoreTypes.add((String)defnToStore);
            }
        } else if (!refChoices.isEmpty()) {
            defn = (String)defn + " AND {fhir:link \n\t\t\t@<" + refChoices.replaceAll("_OR_", "> OR \n\t\t\t@<") + "> ? }";
        }
        element_def.add("defn", defn);
        this.addImport((String)defn);
        element_def.add("card", card);
        this.addComment(element_def, ed);
        return element_def.render();
    }

    private boolean changeShortName(StructureDefinition sd, ElementDefinition ed) {
        return this.shortIdException.contains(sd.getName());
    }

    private void addImport(String typeDefn) {
        if (typeDefn != null && !typeDefn.isEmpty()) {
            Pattern p = Pattern.compile("<([^\\s>/]+)");
            Matcher m = p.matcher(typeDefn);
            while (m.find()) {
                String tag = m.group(1);
                if (tag.indexOf(ONE_OR_MORE_PREFIX) != -1) {
                    tag = tag.substring(ONE_OR_MORE_PREFIX.length());
                }
                if (tag.indexOf("_") != -1 || tag.indexOf("_OR_") != -1 || this.imports.contains(tag)) continue;
                this.imports.add(tag);
            }
        }
    }

    private List<ElementDefinition> getChildren(StructureDefinition derived, ElementDefinition element) {
        ElementDefinition e;
        String p;
        List<ElementDefinition> elements = derived.getSnapshot().getElement();
        String path = element.getPath() + ".";
        ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && (p = (e = elements.get(index)).getPath()).startsWith(path) && !e.hasSliceName(); ++index) {
            if (p.substring(path.length()).contains(".")) continue;
            list.add(e);
        }
        return list;
    }

    private String simpleElement(StructureDefinition sd, ElementDefinition ed, String typ) {
        ValueSet vs;
        String addldef = "";
        ElementDefinition.ElementDefinitionBindingComponent binding = ed.getBinding();
        if (binding.hasStrength() && binding.getStrength() == Enumerations.BindingStrength.REQUIRED && "code".equals(typ) && (vs = this.resolveBindingReference(sd, binding.getValueSet())) != null) {
            addldef = this.tmplt(VALUESET_DEFN_TEMPLATE).add("vsn", (Object)this.vsprefix(vs.getUrl())).render();
            this.required_value_sets.add(vs);
        }
        if (ed.hasFixed()) {
            addldef = this.tmplt(FIXED_VALUE_TEMPLATE).add("val", (Object)ed.getFixed().primitiveValue()).render();
        }
        return this.tmplt(SIMPLE_ELEMENT_DEFN_TEMPLATE).add("typ", (Object)typ).add("vsdef", (Object)addldef).render();
    }

    private String vsprefix(String uri) {
        if (uri.startsWith(FHIR_VS)) {
            return "fhirvs:" + uri.replace(FHIR_VS, "");
        }
        return "<" + uri + ">";
    }

    private String genTypeRef(StructureDefinition sd, ElementDefinition ed, String id, ElementDefinition.TypeRefComponent typ) {
        if (typ.hasProfile()) {
            if (typ.getWorkingCode().equals("Reference")) {
                return this.genReference("", typ);
            }
            if (this.profileUtilities.getChildList(sd, ed).size() > 0) {
                this.innerTypes.add((Pair<StructureDefinition, ElementDefinition>)new ImmutablePair((Object)sd, (Object)ed));
                return this.simpleElement(sd, ed, id);
            }
            String ref = this.getTypeName(typ);
            this.datatypes.add(ref);
            return this.simpleElement(sd, ed, ref);
        }
        if (typ.getCode().startsWith("http://hl7.org/fhirpath/System.")) {
            DataType mv;
            String xt = this.getShexCode(typ.getWorkingCode());
            ST td_entry = this.tmplt(PRIMITIVE_ELEMENT_DEFN_TEMPLATE).add("typ", (Object)xt);
            StringBuilder facets = new StringBuilder();
            if (ed.hasMinValue()) {
                mv = ed.getMinValue();
                facets.append(this.tmplt(MINVALUE_TEMPLATE).add("val", (Object)mv.primitiveValue()).render());
            }
            if (ed.hasMaxValue()) {
                mv = ed.getMaxValue();
                facets.append(this.tmplt(MAXVALUE_TEMPLATE).add("val", (Object)mv.primitiveValue()).render());
            }
            if (ed.hasMaxLength()) {
                int ml = ed.getMaxLength();
                facets.append(this.tmplt(MAXLENGTH_TEMPLATE).add("val", (Object)ml).render());
            }
            if (ed.hasPattern()) {
                DataType pat = ed.getPattern();
                facets.append(this.tmplt(PATTERN_TEMPLATE).add("val", (Object)pat.primitiveValue()).render());
            }
            td_entry.add("facets", (Object)facets.toString());
            return td_entry.render();
        }
        if (typ.getWorkingCode() == null) {
            ST primitive_entry = this.tmplt(PRIMITIVE_ELEMENT_DEFN_TEMPLATE);
            primitive_entry.add("typ", (Object)"xsd:string");
            return primitive_entry.render();
        }
        if (typ.getWorkingCode().equals("xhtml")) {
            return this.tmplt(XHTML_TYPE_TEMPLATE).render();
        }
        this.datatypes.add(typ.getWorkingCode());
        return this.simpleElement(sd, ed, typ.getWorkingCode());
    }

    private String getShexCode(String c) {
        switch (c) {
            case "boolean": {
                return "xsd:boolean";
            }
            case "integer": {
                return "xsd:int";
            }
            case "integer64": {
                return "xsd:long";
            }
            case "decimal": {
                return "xsd:decimal OR xsd:double";
            }
            case "base64Binary": {
                return "xsd:base64Binary";
            }
            case "instant": {
                return "xsd:dateTime";
            }
            case "string": {
                return "xsd:string";
            }
            case "uri": {
                return "xsd:anyURI";
            }
            case "date": {
                return "xsd:gYear OR xsd:gYearMonth OR xsd:date";
            }
            case "dateTime": {
                return "xsd:gYear OR xsd:gYearMonth OR xsd:date OR xsd:dateTime";
            }
            case "time": {
                return "xsd:time";
            }
            case "code": {
                return "xsd:token";
            }
            case "oid": {
                return "xsd:anyURI";
            }
            case "uuid": {
                return "xsd:anyURI";
            }
            case "url": {
                return "xsd:anyURI";
            }
            case "canonical": {
                return "xsd:anyURI";
            }
            case "id": {
                return "xsd:string";
            }
            case "unsignedInt": {
                return "xsd:nonNegativeInteger";
            }
            case "positiveInt": {
                return "xsd:positiveInteger";
            }
            case "markdown": {
                return "xsd:string";
            }
        }
        throw new Error("Not implemented yet");
    }

    private ST genAlternativeTypes(ElementDefinition ed, String id, String shortId) {
        ST shex_alt = this.tmplt(ALTERNATIVE_SHAPES_TEMPLATE);
        ArrayList<String> altEntries = new ArrayList<String>();
        for (ElementDefinition.TypeRefComponent typ : ed.getType()) {
            altEntries.add(this.genAltEntry(id, typ));
        }
        shex_alt.add("altEntries", (Object)StringUtils.join(altEntries, (String)" OR \n    "));
        return shex_alt;
    }

    private String genAltEntry(String id, ElementDefinition.TypeRefComponent typ) {
        if (!typ.getWorkingCode().equals("Reference")) {
            throw new AssertionError((Object)("We do not handle " + typ.getWorkingCode() + " alternatives"));
        }
        return this.genReference(id, typ);
    }

    private String genChoiceTypes(StructureDefinition sd, ElementDefinition ed, String id) {
        ArrayList<Object> choiceEntries = new ArrayList<Object>();
        ArrayList refValues = new ArrayList();
        String base = id.replace("[x]", "");
        for (ElementDefinition.TypeRefComponent typ : ed.getType()) {
            String entry = this.genChoiceEntry(sd, ed, base, typ);
            refValues.clear();
            if (typ.hasTargetProfile()) {
                typ.getTargetProfile().forEach(tps -> {
                    String[] els = ((String)tps.getValue()).split("/");
                    refValues.add("@<" + els[els.length - 1] + ">");
                });
            }
            if (!refValues.isEmpty()) {
                choiceEntries.add("(" + entry + " AND {fhir:link " + StringUtils.join(refValues, (String)" OR \n\t\t\t ") + " }) ");
                continue;
            }
            choiceEntries.add(entry);
        }
        return StringUtils.join(choiceEntries, (String)" OR \n\t\t\t");
    }

    private String genChoiceEntry(StructureDefinition sd, ElementDefinition ed, String id, ElementDefinition.TypeRefComponent typ) {
        ST shex_choice_entry = this.tmplt(ELEMENT_TEMPLATE);
        String ext = typ.getWorkingCode();
        shex_choice_entry.add("id", (Object)"");
        shex_choice_entry.add("card", (Object)"");
        String typeDefn = this.genTypeRef(sd, ed, id, typ);
        shex_choice_entry.add("defn", (Object)typeDefn);
        this.addImport(typeDefn);
        shex_choice_entry.add("comment", (Object)" ");
        return shex_choice_entry.render();
    }

    private String getOneOrMoreType(String oneOrMoreType) {
        if (oneOrMoreType == null || this.oneOrMoreTypes.isEmpty()) {
            return "";
        }
        ST one_or_more_type = this.tmplt(ONE_OR_MORE_TEMPLATE);
        String oomType = oneOrMoreType;
        String origType = oneOrMoreType;
        Object restriction = "";
        if (oneOrMoreType.indexOf(ONE_OR_MORE_CHOICES) != -1) {
            oomType = oneOrMoreType.replaceAll(ONE_OR_MORE_CHOICES, "_");
            origType = oneOrMoreType.split(ONE_OR_MORE_CHOICES)[0];
            restriction = "AND {fhir:link \n\t\t\t@<";
            String choices = oneOrMoreType.split(ONE_OR_MORE_CHOICES)[1];
            restriction = (String)restriction + choices.replaceAll("_OR_", "> OR \n\t\t\t@<") + "> }";
        }
        origType = origType.replaceAll(ONE_OR_MORE_PREFIX, "");
        one_or_more_type.add("oomType", (Object)oomType);
        one_or_more_type.add("origType", (Object)origType);
        one_or_more_type.add("restriction", restriction);
        this.addImport(origType);
        this.addImport((String)restriction);
        one_or_more_type.add("comment", (Object)"");
        return one_or_more_type.render();
    }

    /*
     * WARNING - void declaration
     */
    private String genInnerTypeDef(StructureDefinition sd, ElementDefinition ed) {
        void var8_13;
        String path = ed.hasBase() ? ed.getBase().getPath() : ed.getPath();
        ST element_reference = this.tmplt(SHAPE_DEFINITION_TEMPLATE);
        element_reference.add("resourceDecl", (Object)"");
        element_reference.add("id", (Object)(path + this.getExtendedType(ed)));
        element_reference.add("fhirType", (Object)" ");
        String comment = ed.getShort();
        element_reference.add("comment", comment == null ? " " : "# " + comment);
        ArrayList<String> elements = new ArrayList<String>();
        for (ElementDefinition elementDefinition : this.profileUtilities.getChildList(sd, path, null)) {
            if (!elementDefinition.hasBase() || !elementDefinition.getBase().getPath().startsWith(sd.getName())) continue;
            String elementDefinition2 = this.genElementDefinition(sd, elementDefinition);
            elements.add(elementDefinition2);
        }
        element_reference.add("elements", (Object)StringUtils.join(elements, (String)"\n"));
        ArrayList<String> innerConstraintsList = new ArrayList<String>();
        if (this.processConstraints) {
            for (ElementDefinition.ElementDefinitionConstraintComponent constraint : ed.getConstraint()) {
                String sdType = sd.getType();
                String cstype = constraint.getSource();
                if (cstype != null && cstype.indexOf("/") != -1) {
                    String[] els = cstype.split("/");
                    cstype = els[els.length - 1];
                }
                String id = ed.hasBase() ? ed.getBase().getPath() : ed.getPath();
                String shortId = id.substring(id.lastIndexOf(".") + 1);
                if ((!ed.hasContentReference() || ed.hasType()) && !id.equals(sd.getName() + "." + shortId) || !sdType.equals(cstype) && !this.baseDataTypes.contains(sdType)) continue;
                this.debug("\n        (INNER ED) Key: " + constraint.getKey() + " SD type: " + sd.getType() + " Element: " + ed.getPath() + " Constraint Source: " + constraint.getSource() + " Constraint:" + constraint.getExpression());
                String transl = this.translateConstraint(sd, ed, constraint);
                if (transl.isEmpty() || innerConstraintsList.contains(transl)) continue;
                innerConstraintsList.add(transl);
            }
        }
        String string = "";
        if (!innerConstraintsList.isEmpty()) {
            String string2 = "AND (\n\n" + StringUtils.join(this.constraintsList, (String)"\n\n) AND (\n\n") + "\n\n)\n";
        }
        element_reference.add("constraints", (Object)var8_13);
        element_reference.add("contextOfUse", (Object)"");
        return element_reference.render();
    }

    private String genReference(String id, ElementDefinition.TypeRefComponent typ) {
        ST shex_ref = this.tmplt(REFERENCE_DEFN_TEMPLATE);
        String ref = this.getTypeName(typ);
        shex_ref.add("id", (Object)id);
        shex_ref.add("ref", (Object)ref);
        this.references.add(ref);
        return shex_ref.render();
    }

    private String getTypeName(ElementDefinition.TypeRefComponent typ) {
        if (typ.hasTargetProfile()) {
            String[] els = ((String)typ.getTargetProfile().get(0).getValue()).split("/");
            return els[els.length - 1];
        }
        if (typ.hasProfile()) {
            String[] els = ((String)typ.getProfile().get(0).getValue()).split("/");
            return els[els.length - 1];
        }
        return typ.getWorkingCode();
    }

    private String genValueSet(ValueSet vs) {
        ST vsd = this.tmplt(VALUE_SET_DEFINITION).add("vsuri", (Object)this.vsprefix(vs.getUrl())).add("comment", (Object)vs.getDescription());
        ValueSetExpansionOutcome vse = this.context.expandVS(vs, true, false);
        ArrayList<CallSite> valid_codes = new ArrayList<CallSite>();
        if (vse != null && vse.getValueset() != null && vse.getValueset().hasExpansion() && vse.getValueset().getExpansion().hasContains()) {
            for (ValueSet.ValueSetExpansionContainsComponent vsec : vse.getValueset().getExpansion().getContains()) {
                valid_codes.add((CallSite)((Object)("\"" + vsec.getCode() + "\"")));
            }
        }
        return vsd.add("val_list", valid_codes.size() > 0 ? " [" + StringUtils.join(valid_codes, (String)" ") + "]" : " xsd:string #EXTERNAL").render();
    }

    private ValueSet resolveBindingReference(DomainResource ctxt, String reference) {
        try {
            return this.context.fetchResource(ValueSet.class, reference);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void debug(String message) {
        if (this.debugMode) {
            System.out.println(message);
        }
    }

    private void printBuildMessage(String message) {
    }

    public class SortById
    implements Comparator<StructureDefinition> {
        @Override
        public int compare(StructureDefinition arg0, StructureDefinition arg1) {
            return arg0.getId().compareTo(arg1.getId());
        }
    }

    public static enum ConstraintTranslationPolicy {
        ALL,
        GENERIC_ONLY,
        CONTEXT_OF_USE_ONLY;

    }

    public static enum HTMLLinkPolicy {
        NONE,
        EXTERNAL,
        INTERNAL;

    }
}

