/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.comparison.CanonicalResourceComparer;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.StructuralMatch;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ValueSetComparer
extends CanonicalResourceComparer {
    public ValueSetComparer(ComparisonSession session) {
        super(session);
    }

    public ValueSetComparison compare(ValueSet left, ValueSet right) {
        if (left == null) {
            throw new DefinitionException("No ValueSet provided (left)");
        }
        if (right == null) {
            throw new DefinitionException("No ValueSet provided (right)");
        }
        ValueSetComparison res = new ValueSetComparison(left, right);
        this.session.identify(res);
        ValueSet vs = new ValueSet();
        res.setUnion(vs);
        this.session.identify(vs);
        vs.setName("Union" + left.getName() + "And" + right.getName());
        vs.setTitle("Union of " + left.getTitle() + " And " + right.getTitle());
        vs.setStatus(left.getStatus());
        vs.setDate(new Date());
        ValueSet vs1 = new ValueSet();
        res.setIntersection(vs1);
        this.session.identify(vs1);
        vs1.setName("Intersection" + left.getName() + "And" + right.getName());
        vs1.setTitle("Intersection of " + left.getTitle() + " And " + right.getTitle());
        vs1.setStatus(left.getStatus());
        vs1.setDate(new Date());
        ArrayList<String> chMetadata = new ArrayList<String>();
        boolean ch = this.compareMetadata(left, right, res.getMetadata(), res, chMetadata, right);
        boolean def = false;
        if (this.comparePrimitives("immutable", left.getImmutableElement(), right.getImmutableElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res)) {
            ch = true;
            chMetadata.add("immutable");
        }
        if (left.hasCompose() || right.hasCompose()) {
            if (this.comparePrimitives("compose.lockedDate", left.getCompose().getLockedDateElement(), right.getCompose().getLockedDateElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res)) {
                ch = true;
                chMetadata.add("compose.lockedDate");
            }
            def = this.comparePrimitives("compose.inactive", left.getCompose().getInactiveElement(), right.getCompose().getInactiveElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res) || def;
        }
        res.updatedMetadataState(ch, chMetadata);
        def = this.compareCompose(left.getCompose(), right.getCompose(), res, ((ValueSet)res.getUnion()).getCompose(), ((ValueSet)res.getIntersection()).getCompose()) || def;
        res.updateDefinitionsState(def);
        this.session.annotate(right, res);
        return res;
    }

    private boolean compareCompose(ValueSet.ValueSetComposeComponent left, ValueSet.ValueSetComposeComponent right, ValueSetComparison res, ValueSet.ValueSetComposeComponent union, ValueSet.ValueSetComposeComponent intersection) {
        StructuralMatch<Element> sm;
        ValueSet.ConceptSetComponent csI;
        ValueSet.ConceptSetComponent csM;
        ValueSet.ConceptSetComponent r;
        boolean def = false;
        ArrayList<ValueSet.ConceptSetComponent> matchR = new ArrayList<ValueSet.ConceptSetComponent>();
        for (ValueSet.ConceptSetComponent l : left.getInclude()) {
            r = this.findInList(right.getInclude(), l, left.getInclude());
            if (r == null) {
                union.getInclude().add(l);
                res.updateContentState(true);
                res.getIncludes().getChildren().add(new StructuralMatch<ValueSet.ConceptSetComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed Include", "ValueSet.compose.include")));
                this.session.markDeleted(right, "include", l);
                continue;
            }
            matchR.add(r);
            csM = new ValueSet.ConceptSetComponent();
            csI = new ValueSet.ConceptSetComponent();
            union.getInclude().add(csM);
            intersection.getInclude().add(csI);
            sm = new StructuralMatch<Element>(l, r);
            res.getIncludes().getChildren().add(sm);
            def = this.compareDefinitions("ValueSet.compose.exclude[" + right.getInclude().indexOf(r) + "]", l, r, sm, csM, csI, res) || def;
        }
        for (ValueSet.ConceptSetComponent r2 : right.getInclude()) {
            if (matchR.contains(r2)) continue;
            union.getInclude().add(r2);
            res.updateContentState(true);
            res.getIncludes().getChildren().add(new StructuralMatch<ValueSet.ConceptSetComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added Include", "ValueSet.compose.include"), r2));
            this.session.markAdded(r2);
        }
        matchR.clear();
        for (ValueSet.ConceptSetComponent l : left.getExclude()) {
            r = this.findInList(right.getExclude(), l, left.getExclude());
            if (r == null) {
                union.getExclude().add(l);
                res.updateContentState(true);
                res.getExcludes().getChildren().add(new StructuralMatch<ValueSet.ConceptSetComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed Exclude", "ValueSet.compose.exclude")));
                continue;
            }
            matchR.add(r);
            csM = new ValueSet.ConceptSetComponent();
            csI = new ValueSet.ConceptSetComponent();
            union.getExclude().add(csM);
            intersection.getExclude().add(csI);
            sm = new StructuralMatch<ValueSet.ConceptSetComponent>(l, r);
            res.getExcludes().getChildren().add(sm);
            def = this.compareDefinitions("ValueSet.compose.exclude[" + right.getExclude().indexOf(r) + "]", l, r, sm, csM, csI, res) || def;
        }
        for (ValueSet.ConceptSetComponent r2 : right.getExclude()) {
            if (matchR.contains(r2)) continue;
            union.getExclude().add(r2);
            res.updateContentState(true);
            res.getExcludes().getChildren().add(new StructuralMatch<ValueSet.ConceptSetComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added Exclude", "ValueSet.compose.exclude"), r2));
        }
        return def;
    }

    private ValueSet.ConceptSetComponent findInList(List<ValueSet.ConceptSetComponent> matches, ValueSet.ConceptSetComponent item, List<ValueSet.ConceptSetComponent> source) {
        if (matches.size() == 1 && source.size() == 1) {
            return matches.get(0);
        }
        int matchCount = this.countMatchesBySystem(matches, item);
        int sourceCount = this.countMatchesBySystem(source, item);
        if (matchCount == 1 && sourceCount == 1) {
            for (ValueSet.ConceptSetComponent t : matches) {
                if (t.getSystem() == null || !t.getSystem().equals(item.getSystem())) continue;
                return t;
            }
        }
        for (ValueSet.ConceptSetComponent t : matches) {
            if (!t.equalsDeep(item)) continue;
            return t;
        }
        return null;
    }

    private int countMatchesBySystem(List<ValueSet.ConceptSetComponent> list, ValueSet.ConceptSetComponent item) {
        int c = 0;
        for (ValueSet.ConceptSetComponent t : list) {
            if (!t.hasSystem() || !t.getSystem().equals(item.getSystem())) continue;
            ++c;
        }
        return c;
    }

    private boolean compareDefinitions(String path, ValueSet.ConceptSetComponent left, ValueSet.ConceptSetComponent right, StructuralMatch<Element> combined, ValueSet.ConceptSetComponent union, ValueSet.ConceptSetComponent intersection, ValueSetComparison res) {
        boolean def = false;
        ArrayList<CanonicalType> matchVSR = new ArrayList<CanonicalType>();
        for (CanonicalType canonicalType : left.getValueSet()) {
            CanonicalType canonicalType2 = this.findInList(right.getValueSet(), canonicalType, left.getValueSet());
            if (canonicalType2 == null) {
                union.getValueSet().add(canonicalType);
                res.updateContentState(true);
                combined.getChildren().add(new StructuralMatch<CanonicalType>(canonicalType, this.vmI(ValidationMessage.IssueSeverity.ERROR, "Removed ValueSet", "ValueSet.compose.include.valueSet")));
                if (!this.session.isAnnotate()) continue;
                this.session.markDeleted(right, "valueset", canonicalType);
                continue;
            }
            matchVSR.add(canonicalType2);
            if (((String)canonicalType.getValue()).equals(canonicalType2.getValue())) {
                union.getValueSet().add(canonicalType);
                intersection.getValueSet().add(canonicalType);
                StructuralMatch<CanonicalType> structuralMatch = new StructuralMatch<CanonicalType>(canonicalType, canonicalType2, null);
                combined.getChildren().add(structuralMatch);
                continue;
            }
            union.getValueSet().add(canonicalType);
            union.getValueSet().add(canonicalType2);
            res.updateContentState(true);
            StructuralMatch<CanonicalType> structuralMatch = new StructuralMatch<CanonicalType>(canonicalType, canonicalType2, this.vmI(ValidationMessage.IssueSeverity.WARNING, "Values are different", "ValueSet.compose.include.valueSet"));
            combined.getChildren().add(structuralMatch);
            if (!this.session.isAnnotate()) continue;
            this.session.markChanged(canonicalType2, canonicalType);
        }
        for (CanonicalType canonicalType : right.getValueSet()) {
            if (matchVSR.contains(canonicalType)) continue;
            union.getValueSet().add(canonicalType);
            res.updateContentState(true);
            combined.getChildren().add(new StructuralMatch<CanonicalType>(this.vmI(ValidationMessage.IssueSeverity.ERROR, "Add ValueSet", "ValueSet.compose.include.valueSet"), canonicalType));
            this.session.markAdded(canonicalType);
        }
        ArrayList<ValueSet.ConceptReferenceComponent> matchCR = new ArrayList<ValueSet.ConceptReferenceComponent>();
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : left.getConcept()) {
            ValueSet.ConceptReferenceComponent conceptReferenceComponent2 = this.findInList(right.getConcept(), conceptReferenceComponent, left.getConcept());
            if (conceptReferenceComponent2 == null) {
                union.getConcept().add(conceptReferenceComponent);
                res.updateContentState(true);
                combined.getChildren().add(new StructuralMatch<ValueSet.ConceptReferenceComponent>(conceptReferenceComponent, this.vmI(ValidationMessage.IssueSeverity.ERROR, "Removed this Concept", "ValueSet.compose.include.concept")));
                res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, "Code " + conceptReferenceComponent.getCode() + " removed", ValidationMessage.IssueSeverity.ERROR));
                this.session.markDeleted(right, "concept", conceptReferenceComponent);
                continue;
            }
            matchCR.add(conceptReferenceComponent2);
            if (conceptReferenceComponent.getCode().equals(conceptReferenceComponent2.getCode())) {
                ValueSet.ConceptReferenceComponent cu = new ValueSet.ConceptReferenceComponent();
                ValueSet.ConceptReferenceComponent ci = new ValueSet.ConceptReferenceComponent();
                union.getConcept().add(cu);
                intersection.getConcept().add(ci);
                StructuralMatch<Element> sm = new StructuralMatch<Element>(conceptReferenceComponent, conceptReferenceComponent2);
                combined.getChildren().add(sm);
                def = this.compareConcepts(path + ".concept[" + right.getConcept().indexOf(conceptReferenceComponent2) + "]", conceptReferenceComponent, conceptReferenceComponent2, sm, cu, ci, res) || def;
                continue;
            }
            union.getConcept().add(conceptReferenceComponent);
            union.getConcept().add(conceptReferenceComponent2);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(conceptReferenceComponent, conceptReferenceComponent2, this.vmI(ValidationMessage.IssueSeverity.WARNING, "Concepts are different", "ValueSet.compose.include.concept"));
            combined.getChildren().add(sm);
            res.updateContentState(true);
            this.compareConcepts(path + ".concept[" + right.getConcept().indexOf(conceptReferenceComponent2) + "]", conceptReferenceComponent, conceptReferenceComponent2, sm, null, null, res);
            this.session.markChanged(conceptReferenceComponent2, conceptReferenceComponent);
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : right.getConcept()) {
            if (matchCR.contains(conceptReferenceComponent)) continue;
            union.getConcept().add(conceptReferenceComponent);
            res.updateContentState(true);
            combined.getChildren().add(new StructuralMatch<ValueSet.ConceptReferenceComponent>(this.vmI(ValidationMessage.IssueSeverity.ERROR, "Added this Concept", "ValueSet.compose.include.concept"), conceptReferenceComponent));
            res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, "Code " + conceptReferenceComponent.getCode() + " added", ValidationMessage.IssueSeverity.ERROR));
            this.session.markAdded(conceptReferenceComponent);
        }
        ArrayList<ValueSet.ConceptSetFilterComponent> arrayList = new ArrayList<ValueSet.ConceptSetFilterComponent>();
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : left.getFilter()) {
            ValueSet.ConceptSetFilterComponent r = this.findInList(right.getFilter(), conceptSetFilterComponent, left.getFilter());
            if (r == null) {
                union.getFilter().add(conceptSetFilterComponent);
                res.updateContentState(true);
                combined.getChildren().add(new StructuralMatch<ValueSet.ConceptSetFilterComponent>(conceptSetFilterComponent, this.vmI(ValidationMessage.IssueSeverity.ERROR, "Removed this item", "ValueSet.compose.include.filter")));
                this.session.markDeleted(right, "filter", conceptSetFilterComponent);
                continue;
            }
            arrayList.add(r);
            if (conceptSetFilterComponent.getProperty().equals(r.getProperty()) && conceptSetFilterComponent.getOp().equals((Object)r.getOp())) {
                ValueSet.ConceptSetFilterComponent cu = new ValueSet.ConceptSetFilterComponent();
                ValueSet.ConceptSetFilterComponent ci = new ValueSet.ConceptSetFilterComponent();
                union.getFilter().add(cu);
                intersection.getFilter().add(ci);
                StructuralMatch<Element> sm = new StructuralMatch<Element>(conceptSetFilterComponent, r);
                combined.getChildren().add(sm);
                if (this.compareFilters(conceptSetFilterComponent, r, sm, cu, ci)) continue;
                res.updateContentState(true);
                this.session.markChanged(r, conceptSetFilterComponent);
                continue;
            }
            union.getFilter().add(conceptSetFilterComponent);
            union.getFilter().add(r);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(conceptSetFilterComponent, r, this.vmI(ValidationMessage.IssueSeverity.WARNING, "Codes are different", "ValueSet.compose.include.filter"));
            res.updateContentState(true);
            combined.getChildren().add(sm);
            this.compareFilters(conceptSetFilterComponent, r, sm, null, null);
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : right.getFilter()) {
            if (arrayList.contains(conceptSetFilterComponent)) continue;
            union.getFilter().add(conceptSetFilterComponent);
            res.updateContentState(true);
            combined.getChildren().add(new StructuralMatch<ValueSet.ConceptSetFilterComponent>(this.vmI(ValidationMessage.IssueSeverity.ERROR, "Added this item", "ValueSet.compose.include.filter"), conceptSetFilterComponent));
            this.session.markAdded(conceptSetFilterComponent);
        }
        return def;
    }

    private boolean compareConcepts(String path, ValueSet.ConceptReferenceComponent l, ValueSet.ConceptReferenceComponent r, StructuralMatch<Element> sm, ValueSet.ConceptReferenceComponent cu, ValueSet.ConceptReferenceComponent ci, ValueSetComparison res) {
        boolean def = false;
        sm.getChildren().add(new StructuralMatch<CodeType>(l.getCodeElement(), r.getCodeElement(), l.getCode().equals(r.getCode()) ? null : this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Codes do not match", "ValueSet.compose.include.concept")));
        if (ci != null) {
            ci.setCode(l.getCode());
            cu.setCode(l.getCode());
        }
        if (l.hasDisplay() && r.hasDisplay()) {
            sm.getChildren().add(new StructuralMatch<StringType>(l.getDisplayElement(), r.getDisplayElement(), l.getDisplay().equals(r.getDisplay()) ? null : this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Displays do not match", "ValueSet.compose.include.concept")));
            if (ci != null) {
                ci.setDisplay(r.getDisplay());
                cu.setDisplay(r.getDisplay());
            }
            boolean bl = def = !l.getDisplay().equals(r.getDisplay());
            if (def) {
                res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, "Code " + l.getCode() + " display changed from '" + l.getDisplay() + "' to '" + r.getDisplay() + "'", ValidationMessage.IssueSeverity.WARNING));
                this.session.markChanged(r.getDisplayElement(), l.getDisplayElement());
            }
        } else if (l.hasDisplay()) {
            this.session.markDeleted(r, "display", l.getDisplayElement());
            res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, "Code " + l.getCode() + " display '" + l.getDisplay() + "' removed", ValidationMessage.IssueSeverity.WARNING));
            sm.getChildren().add(new StructuralMatch<Object>(l.getDisplayElement(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Display Removed", "ValueSet.compose.include.concept")));
            if (ci != null) {
                ci.setDisplay(l.getDisplay());
                cu.setDisplay(l.getDisplay());
            }
            def = true;
        } else if (r.hasDisplay()) {
            this.session.markAdded(r.getDisplayElement());
            res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, "Code " + l.getCode() + " display '" + r.getDisplay() + "' added", ValidationMessage.IssueSeverity.WARNING));
            sm.getChildren().add(new StructuralMatch<StringType>(null, r.getDisplayElement(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Display added", "ValueSet.compose.include.concept")));
            if (ci != null) {
                ci.setDisplay(r.getDisplay());
                cu.setDisplay(r.getDisplay());
            }
            def = true;
        } else {
            sm.getChildren().add(new StructuralMatch<Object>(null, null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Display", "ValueSet.compose.include.concept")));
        }
        return def;
    }

    private boolean compareFilters(ValueSet.ConceptSetFilterComponent l, ValueSet.ConceptSetFilterComponent r, StructuralMatch<Element> sm, ValueSet.ConceptSetFilterComponent cu, ValueSet.ConceptSetFilterComponent ci) {
        sm.getChildren().add(new StructuralMatch<CodeType>(l.getPropertyElement(), r.getPropertyElement(), l.getProperty().equals(r.getProperty()) ? null : this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Properties do not match", "ValueSet.compose.include.concept")));
        sm.getChildren().add(new StructuralMatch<Enumeration<Enumerations.FilterOperator>>(l.getOpElement(), r.getOpElement(), l.getOp().equals((Object)r.getOp()) ? null : this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Filter Operations do not match", "ValueSet.compose.include.concept")));
        sm.getChildren().add(new StructuralMatch<StringType>(l.getValueElement(), r.getValueElement(), l.getValue().equals(r.getValue()) ? null : this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Values do not match", "ValueSet.compose.include.concept")));
        if (ci != null) {
            ci.setProperty(l.getProperty());
            ci.setOp(l.getOp());
            ci.setValue(l.getValue());
            cu.setProperty(l.getProperty());
            cu.setOp(l.getOp());
            cu.setValue(l.getValue());
        }
        return !l.getProperty().equals(r.getProperty());
    }

    private CanonicalType findInList(List<CanonicalType> matches, CanonicalType item, List<CanonicalType> source) {
        if (matches.size() == 1 && source.size() == 1) {
            return matches.get(0);
        }
        for (CanonicalType t : matches) {
            if (!((String)t.getValue()).equals(item.getValue())) continue;
            return t;
        }
        return null;
    }

    private ValueSet.ConceptReferenceComponent findInList(List<ValueSet.ConceptReferenceComponent> matches, ValueSet.ConceptReferenceComponent item, List<ValueSet.ConceptReferenceComponent> source) {
        if (matches.size() == 1 && source.size() == 1) {
            return matches.get(0);
        }
        for (ValueSet.ConceptReferenceComponent t : matches) {
            if (!t.getCode().equals(item.getCode())) continue;
            return t;
        }
        return null;
    }

    private ValueSet.ConceptSetFilterComponent findInList(List<ValueSet.ConceptSetFilterComponent> matches, ValueSet.ConceptSetFilterComponent item, List<ValueSet.ConceptSetFilterComponent> source) {
        if (matches.size() == 1 && source.size() == 1) {
            return matches.get(0);
        }
        for (ValueSet.ConceptSetFilterComponent t : matches) {
            if (!t.getProperty().equals(item.getProperty()) || !t.getOp().equals((Object)item.getOp())) continue;
            return t;
        }
        return null;
    }

    private void compareExpansions(ValueSet left, ValueSet right, ValueSetComparison res) {
        ValueSet expR;
        ValueSet expL = left.hasExpansion() ? left : this.expand(left, res, "left", this.session.getContextLeft());
        ValueSet valueSet = expR = right.hasExpansion() ? right : this.expand(right, res, "right", this.session.getContextRight());
        if (expL != null && expR != null) {
            this.compareConcepts(expL.getExpansion().getContains(), expR.getExpansion().getContains(), res.forceExpansion(), ((ValueSet)res.getUnion()).getExpansion().getContains(), ((ValueSet)res.getIntersection()).getExpansion().getContains(), "ValueSet.expansion.contains", res);
        }
    }

    private ValueSet expand(ValueSet vs, ValueSetComparison res, String name, IWorkerContext ctxt) {
        ValueSetExpansionOutcome vse = ctxt.expandVS(vs, true, false);
        if (vse.getValueset() != null) {
            return vse.getValueset();
        }
        res.getMessages().add(new ValidationMessage(ValidationMessage.Source.TerminologyEngine, ValidationMessage.IssueType.EXCEPTION, "ValueSet", "Error Expanding " + name + ":" + vse.getError(), ValidationMessage.IssueSeverity.ERROR));
        return null;
    }

    private void compareConcepts(List<ValueSet.ValueSetExpansionContainsComponent> left, List<ValueSet.ValueSetExpansionContainsComponent> right, StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> combined, List<ValueSet.ValueSetExpansionContainsComponent> union, List<ValueSet.ValueSetExpansionContainsComponent> intersection, String path, ValueSetComparison res) {
        ArrayList<ValueSet.ValueSetExpansionContainsComponent> matchR = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
        for (ValueSet.ValueSetExpansionContainsComponent l : left) {
            ValueSet.ValueSetExpansionContainsComponent r = this.findInList(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<ValueSet.ValueSetExpansionContainsComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed from expansion", path)));
                continue;
            }
            matchR.add(r);
            ValueSet.ValueSetExpansionContainsComponent ccU = this.merge(l, r);
            ValueSet.ValueSetExpansionContainsComponent ccI = this.intersect(l, r);
            union.add(ccU);
            intersection.add(ccI);
            StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> sm = new StructuralMatch<ValueSet.ValueSetExpansionContainsComponent>(l, r);
            this.compareItem(sm.getMessages(), path, l, r, res);
            combined.getChildren().add(sm);
            this.compareConcepts(l.getContains(), r.getContains(), sm, ccU.getContains(), ccI.getContains(), path + ".where(code = '" + l.getCode() + "').contains", res);
        }
        for (ValueSet.ValueSetExpansionContainsComponent r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<ValueSet.ValueSetExpansionContainsComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added to expansion", path), r));
        }
    }

    private void compareItem(List<ValidationMessage> msgs, String path, ValueSet.ValueSetExpansionContainsComponent l, ValueSet.ValueSetExpansionContainsComponent r, ValueSetComparison res) {
        this.compareStrings(path, msgs, l.getDisplay(), r.getDisplay(), "display", ValidationMessage.IssueSeverity.WARNING, res);
    }

    private void compareStrings(String path, List<ValidationMessage> msgs, String left, String right, String name, ValidationMessage.IssueSeverity level, ValueSetComparison res) {
        if (!Utilities.noString((String)right)) {
            if (Utilities.noString((String)left)) {
                msgs.add(this.vmI(level, "Value for " + name + " added", path));
            } else if (!left.equals(right)) {
                if (level != ValidationMessage.IssueSeverity.NULL) {
                    res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path + ".name", "Changed value for " + name + ": '" + left + "' vs '" + right + "'", level));
                }
                msgs.add(this.vmI(level, name + " changed from left to right", path));
            }
        } else if (!Utilities.noString((String)left)) {
            msgs.add(this.vmI(level, "Value for " + name + " removed", path));
        }
    }

    private ValueSet.ValueSetExpansionContainsComponent findInList(List<ValueSet.ValueSetExpansionContainsComponent> list, ValueSet.ValueSetExpansionContainsComponent item) {
        for (ValueSet.ValueSetExpansionContainsComponent t : list) {
            if (!t.getSystem().equals(item.getSystem()) || !t.getCode().equals(item.getCode())) continue;
            return t;
        }
        return null;
    }

    private ValueSet.ValueSetExpansionContainsComponent intersect(ValueSet.ValueSetExpansionContainsComponent l, ValueSet.ValueSetExpansionContainsComponent r) {
        ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
        if (l.hasAbstract() && r.hasAbstract()) {
            res.setAbstract(l.getAbstract());
        }
        if (l.hasCode() && r.hasCode()) {
            res.setCode(l.getCode());
        }
        if (l.hasSystem() && r.hasSystem()) {
            res.setSystem(l.getSystem());
        }
        if (l.hasVersion() && r.hasVersion()) {
            res.setVersion(l.getVersion());
        }
        if (l.hasDisplay() && r.hasDisplay()) {
            res.setDisplay(l.getDisplay());
        }
        return res;
    }

    private ValueSet.ValueSetExpansionContainsComponent merge(ValueSet.ValueSetExpansionContainsComponent l, ValueSet.ValueSetExpansionContainsComponent r) {
        ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
        if (l.hasAbstract()) {
            res.setAbstract(l.getAbstract());
        } else if (r.hasAbstract()) {
            res.setAbstract(r.getAbstract());
        }
        if (l.hasCode()) {
            res.setCode(l.getCode());
        } else if (r.hasCode()) {
            res.setCode(r.getCode());
        }
        if (l.hasSystem()) {
            res.setSystem(l.getSystem());
        } else if (r.hasSystem()) {
            res.setSystem(r.getSystem());
        }
        if (l.hasVersion()) {
            res.setVersion(l.getVersion());
        } else if (r.hasVersion()) {
            res.setVersion(r.getVersion());
        }
        if (l.hasDisplay()) {
            res.setDisplay(l.getDisplay());
        } else if (r.hasDisplay()) {
            res.setDisplay(r.getDisplay());
        }
        return res;
    }

    @Override
    protected String fhirType() {
        return "ValueSet";
    }

    public XhtmlNode renderCompose(ValueSetComparison csc, String id, String prefix) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(new RenderingI18nContext(), Utilities.path((String[])new String[]{"[tmp]", "comparison"}), false, "c");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, true);
        model.setAlternating(true);
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, null, "Item", "The type of item being compared", null, 100));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, null, "Property", "The system for the concept", null, 100, 2));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, null, "Value", "The display for the concept", null, 200, 2));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, null, "Comments", "Additional information about the comparison", null, 200));
        for (StructuralMatch<Element> t : csc.getIncludes().getChildren()) {
            this.addComposeRow(gen, model.getRows(), t, "include");
        }
        for (StructuralMatch<Element> t : csc.getExcludes().getChildren()) {
            this.addComposeRow(gen, model.getRows(), t, "exclude");
        }
        return gen.generate(model, prefix, 0, null);
    }

    private void addComposeRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, String name) {
        ValueSet.ConceptSetComponent cs;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, name, null, null));
        if (t.hasLeft() && t.hasRight()) {
            ValueSet.ConceptSetComponent csL = (ValueSet.ConceptSetComponent)t.getLeft();
            ValueSet.ConceptSetComponent csR = (ValueSet.ConceptSetComponent)t.getRight();
            if (csL.hasSystem() && csL.getSystem().equals(csR.getSystem())) {
                List list2 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, csL.getSystem(), null, null).span(2).center());
            } else {
                List list3 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, csL.getSystem(), null, null).setStyle("background-color: #f0b3ff"));
                List list4 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, csR.getSystem(), null, null).setStyle("background-color: #f0b3ff"));
            }
            if (csL.hasVersion() && csR.hasVersion()) {
                if (csL.getVersion().equals(csR.getVersion())) {
                    List list5 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, csL.getVersion(), null, null).span(2).center());
                } else {
                    List list6 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, csL.getVersion(), null, null).setStyle("background-color: #f0b3ff"));
                    List list7 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, csR.getVersion(), null, null).setStyle("background-color: #f0b3ff"));
                }
            } else if (csL.hasVersion()) {
                List list8 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                list8.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, null, null, csL.getVersion(), null, null));
                r.getCells().add(this.missingCell(gen, "#ffcc33"));
            } else if (csR.hasVersion()) {
                r.getCells().add(this.missingCell(gen, "#ffff4d"));
                List list9 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                list9.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator9, null, null, csR.getVersion(), null, null));
            } else {
                r.getCells().add(this.missingCell(gen).span(2).center());
            }
        } else if (t.hasLeft()) {
            r.setColor("#ffecb3");
            cs = (ValueSet.ConceptSetComponent)t.getLeft();
            List list10 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator10);
            list10.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator10, null, null, cs.getSystem(), null, null));
            r.getCells().add(this.missingCell(gen));
            List list11 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator11);
            list11.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator11, null, null, (String)(cs.hasVersion() ? "Version: " + cs.getVersion() : ""), null, null));
            r.getCells().add(this.missingCell(gen));
        } else {
            r.setColor("#ffffb3");
            cs = (ValueSet.ConceptSetComponent)t.getRight();
            r.getCells().add(this.missingCell(gen));
            List list12 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator12);
            list12.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator12, null, null, cs.getSystem(), null, null));
            r.getCells().add(this.missingCell(gen));
            List list13 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator13);
            list13.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator13, null, null, (String)(cs.hasVersion() ? "Version: " + cs.getVersion() : ""), null, null));
        }
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        for (StructuralMatch<Element> c : t.getChildren()) {
            if (c.either() instanceof ValueSet.ConceptReferenceComponent) {
                this.addSetConceptRow(gen, r.getSubRows(), c);
                continue;
            }
            this.addSetFilterRow(gen, r.getSubRows(), c);
        }
    }

    private void addSetConceptRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "Concept", null, null));
        if (t.hasLeft() && t.hasRight()) {
            ValueSet.ConceptReferenceComponent csL = (ValueSet.ConceptReferenceComponent)t.getLeft();
            ValueSet.ConceptReferenceComponent csR = (ValueSet.ConceptReferenceComponent)t.getRight();
            if (csL.getCode().equals(csR.getCode())) {
                List list2 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, csL.getCode(), null, null).span(2).center());
            } else {
                List list3 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, csL.getCode(), null, null).setStyle("background-color: #f0b3ff"));
                List list4 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, csR.getCode(), null, null).setStyle("background-color: #f0b3ff"));
            }
            if (csL.hasDisplay() && csR.hasDisplay()) {
                if (csL.getDisplay().equals(csR.getDisplay())) {
                    List list5 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, csL.getDisplay(), null, null).span(2).center());
                } else {
                    List list6 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, csL.getDisplay(), null, null).setStyle("background-color: #f0b3ff"));
                    List list7 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, csR.getDisplay(), null, null).setStyle("background-color: #f0b3ff"));
                }
            } else if (csL.hasDisplay()) {
                List list8 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                list8.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, null, null, csL.getDisplay(), null, null));
                r.getCells().add(this.missingCell(gen, "#ffcc33"));
            } else if (csR.hasDisplay()) {
                r.getCells().add(this.missingCell(gen, "#ffff4d"));
                List list9 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                list9.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator9, null, null, csR.getDisplay(), null, null));
            } else {
                r.getCells().add(this.missingCell(gen).span(2).center());
            }
        } else if (t.hasLeft()) {
            r.setColor("#ffecb3");
            ValueSet.ConceptReferenceComponent cs = (ValueSet.ConceptReferenceComponent)t.getLeft();
            List list10 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator10);
            list10.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator10, null, null, cs.getCode(), null, null));
            r.getCells().add(this.missingCell(gen));
            List list11 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator11);
            list11.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator11, null, null, (String)(cs.hasDisplay() ? "Version: " + cs.getDisplay() : ""), null, null));
            r.getCells().add(this.missingCell(gen));
        } else {
            r.setColor("#ffffb3");
            ValueSet.ConceptReferenceComponent cs = (ValueSet.ConceptReferenceComponent)t.getRight();
            r.getCells().add(this.missingCell(gen));
            List list12 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator12);
            list12.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator12, null, null, cs.getCode(), null, null));
            r.getCells().add(this.missingCell(gen));
            List list13 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator13);
            list13.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator13, null, null, (String)(cs.hasDisplay() ? "Version: " + cs.getDisplay() : ""), null, null));
        }
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
    }

    private void addSetFilterRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t) {
    }

    public XhtmlNode renderExpansion(ValueSetComparison csc, String id, String prefix) throws IOException {
        HierarchicalTableGenerator gen;
        if (csc.getExpansion() == null) {
            XhtmlNode p = new XhtmlNode(NodeType.Element, "p");
            p.tx("Unable to generate expansion - see errors");
            return p;
        }
        if (csc.getExpansion().getChildren().isEmpty()) {
            XhtmlNode p = new XhtmlNode(NodeType.Element, "p");
            p.tx("Expansion is empty");
            return p;
        }
        boolean hasSystem = csc.getExpansion().getChildren().isEmpty() ? false : this.getSystemVaries(csc.getExpansion(), csc.getExpansion().getChildren().get(0).either().getSystem());
        boolean hasVersion = this.findVersion(csc.getExpansion());
        boolean hasAbstract = this.findAbstract(csc.getExpansion());
        boolean hasInactive = this.findInactive(csc.getExpansion());
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(new RenderingI18nContext(), Utilities.path((String[])new String[]{"[tmp]", "comparison"}), false, "c");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, true);
        model.setAlternating(true);
        if (hasSystem) {
            List list = model.getTitles();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, null, "System", "The code for the concept", null, 100));
        }
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, null, "Code", "The system for the concept", null, 100));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, null, "Display", "The display for the concept", null, 200, 2));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, null, "Comments", "Additional information about the comparison", null, 200));
        for (StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> t : csc.getExpansion().getChildren()) {
            this.addExpansionRow(gen, model.getRows(), t, hasSystem, hasVersion, hasAbstract, hasInactive);
        }
        return gen.generate(model, prefix, 0, null);
    }

    private void addExpansionRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> t, boolean hasSystem, boolean hasVersion, boolean hasAbstract, boolean hasInactive) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        if (hasSystem) {
            List list = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, t.either().getSystem(), null, null));
        }
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, t.either().getCode(), null, null));
        if (t.hasLeft() && t.hasRight()) {
            if (t.getLeft().hasDisplay() && t.getRight().hasDisplay()) {
                if (t.getLeft().getDisplay().equals(t.getRight().getDisplay())) {
                    List list2 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, t.getLeft().getDisplay(), null, null).span(2).center());
                } else {
                    List list3 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, t.getLeft().getDisplay(), null, null).setStyle("background-color: #f0b3ff"));
                    List list4 = r.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, t.getRight().getDisplay(), null, null).setStyle("background-color: #f0b3ff"));
                }
            } else if (t.getLeft().hasDisplay()) {
                List list5 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, t.getLeft().getDisplay(), null, null));
                r.getCells().add(this.missingCell(gen, "#ffcc33"));
            } else if (t.getRight().hasDisplay()) {
                r.getCells().add(this.missingCell(gen, "#ffff4d"));
                List list6 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, t.getRight().getDisplay(), null, null));
            } else {
                r.getCells().add(this.missingCell(gen).span(2).center());
            }
        } else if (t.hasLeft()) {
            r.setColor("#ffecb3");
            List list7 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, t.either().getDisplay(), null, null));
            r.getCells().add(this.missingCell(gen));
        } else {
            r.setColor("#ffffb3");
            r.getCells().add(this.missingCell(gen));
            List list8 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator8);
            list8.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, null, null, t.either().getDisplay(), null, null));
        }
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        for (StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> c : t.getChildren()) {
            this.addExpansionRow(gen, r.getSubRows(), c, hasSystem, hasVersion, hasAbstract, hasInactive);
        }
    }

    private boolean getSystemVaries(StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> list, String system) {
        for (StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> t : list.getChildren()) {
            if (t.hasLeft() && !system.equals(t.getLeft().getSystem())) {
                return true;
            }
            if (t.hasRight() && !system.equals(t.getRight().getSystem())) {
                return true;
            }
            if (!this.getSystemVaries(t, system)) continue;
            return true;
        }
        return false;
    }

    private boolean findInactive(StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> list) {
        for (StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> t : list.getChildren()) {
            if (t.hasLeft() && t.getLeft().getInactive()) {
                return true;
            }
            if (t.hasRight() && t.getRight().getInactive()) {
                return true;
            }
            if (!this.findInactive(t)) continue;
            return true;
        }
        return false;
    }

    private boolean findAbstract(StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> list) {
        for (StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> t : list.getChildren()) {
            if (t.hasLeft() && t.getLeft().getAbstract()) {
                return true;
            }
            if (t.hasRight() && t.getRight().getAbstract()) {
                return true;
            }
            if (!this.findAbstract(t)) continue;
            return true;
        }
        return false;
    }

    private boolean findVersion(StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> list) {
        for (StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> t : list.getChildren()) {
            if (t.hasLeft() && t.getLeft().hasVersion()) {
                return true;
            }
            if (t.hasRight() && t.getRight().hasVersion()) {
                return true;
            }
            if (!this.findVersion(t)) continue;
            return true;
        }
        return false;
    }

    public class ValueSetComparison
    extends CanonicalResourceComparer.CanonicalResourceComparison<ValueSet> {
        private StructuralMatch<Element> includes;
        private StructuralMatch<Element> excludes;
        private StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> expansion;

        public ValueSetComparison(ValueSet left, ValueSet right) {
            super((CanonicalResourceComparer)ValueSetComparer.this, (CanonicalResource)left, (CanonicalResource)right);
            this.includes = new StructuralMatch();
            this.excludes = new StructuralMatch();
        }

        public StructuralMatch<Element> getIncludes() {
            return this.includes;
        }

        public StructuralMatch<Element> getExcludes() {
            return this.excludes;
        }

        public StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> getExpansion() {
            return this.expansion;
        }

        public StructuralMatch<ValueSet.ValueSetExpansionContainsComponent> forceExpansion() {
            if (this.expansion == null) {
                this.expansion = new StructuralMatch();
            }
            return this.expansion;
        }

        @Override
        protected String abbreviation() {
            return "vs";
        }

        @Override
        protected String summary() {
            String res = "ValueSet: " + ((ValueSet)this.left).present() + " vs " + ((ValueSet)this.right).present();
            String ch = this.changeSummary();
            if (ch != null) {
                res = res + ". " + ch;
            }
            return res;
        }

        @Override
        protected String fhirType() {
            return "ValueSet";
        }

        @Override
        protected void countMessages(ResourceComparer.MessageCounts cnts) {
            super.countMessages(cnts);
            if (this.includes != null) {
                this.includes.countMessages(cnts);
            }
            if (this.excludes != null) {
                this.excludes.countMessages(cnts);
            }
            if (this.expansion != null) {
                this.expansion.countMessages(cnts);
            }
        }
    }
}

