/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class StructuralMatch<T> {
    private String name;
    private T left;
    private T right;
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    private List<StructuralMatch<T>> children = new ArrayList<StructuralMatch<T>>();

    public StructuralMatch() {
    }

    public StructuralMatch(T left, T right) {
        this.left = left;
        this.right = right;
    }

    public StructuralMatch(T left, T right, ValidationMessage msg) {
        this.left = left;
        this.right = right;
        if (msg != null) {
            this.messages.add(msg);
        }
    }

    public StructuralMatch(ValidationMessage msg, T right) {
        this.messages.add(msg);
        this.right = right;
    }

    public StructuralMatch(T left, ValidationMessage msg) {
        this.left = left;
        this.messages.add(msg);
    }

    public T getLeft() {
        return this.left;
    }

    public T getRight() {
        return this.right;
    }

    public List<StructuralMatch<T>> getChildren() {
        return this.children;
    }

    public T either() {
        return this.left != null ? this.left : this.right;
    }

    public boolean hasLeft() {
        return this.left != null;
    }

    public boolean hasRight() {
        return this.right != null;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    public boolean hasErrors() {
        for (ValidationMessage vm : this.messages) {
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    public void countMessages(ResourceComparer.MessageCounts cnts) {
        for (ValidationMessage validationMessage : this.getMessages()) {
            if (validationMessage.getLevel() == ValidationMessage.IssueSeverity.ERROR) {
                cnts.error();
                continue;
            }
            if (validationMessage.getLevel() == ValidationMessage.IssueSeverity.WARNING) {
                cnts.warning();
                continue;
            }
            if (validationMessage.getLevel() != ValidationMessage.IssueSeverity.INFORMATION) continue;
            cnts.hint();
        }
        for (StructuralMatch structuralMatch : this.children) {
            structuralMatch.countMessages(cnts);
        }
    }

    public String getName() {
        return this.name;
    }

    public StructuralMatch<T> setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isDifferent() {
        return this.left == null != (this.right == null) || !this.messages.isEmpty();
    }
}

