/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.HL7WorkGroups;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.xml.XMLUtil;

public class CanonicalResourceUtilities {
    public static void setHl7WG(CanonicalResource cr, String wgc) {
        HL7WorkGroups.HL7WorkGroup wg = HL7WorkGroups.find((String)wgc);
        if (wg == null) {
            throw new Error("Unknown WG " + wgc);
        }
        ToolingExtensions.setCodeExtension(cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg.getCode());
        cr.setPublisher("HL7 International / " + wg.getName());
        boolean found = false;
        for (ContactDetail c : cr.getContact()) {
            for (ContactPoint t : c.getTelecom()) {
                if (t.getSystem() != ContactPoint.ContactPointSystem.URL || !wg.getLink().equals(t.getValue())) continue;
                found = true;
            }
        }
        if (!found) {
            cr.addContact().addTelecom().setSystem(ContactPoint.ContactPointSystem.URL).setValue(wg.getLink());
        }
    }

    public static void setHl7WG(CanonicalResource cr) {
        HL7WorkGroups.HL7WorkGroup wg;
        String wgc = ToolingExtensions.readStringExtension((DomainResource)cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        if (wgc == null) {
            wgc = "fhir";
        }
        if ((wg = HL7WorkGroups.find((String)wgc)) == null) {
            throw new Error("Unknown WG '" + wgc + "' in " + cr.fhirType() + "/" + cr.getIdBase());
        }
        ToolingExtensions.setCodeExtension(cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg.getCode());
        cr.setPublisher("HL7 International / " + wg.getName());
        boolean found = false;
        for (ContactDetail c : cr.getContact()) {
            for (ContactPoint t : c.getTelecom()) {
                if (t.getSystem() != ContactPoint.ContactPointSystem.URL || !wg.getLink().equals(t.getValue())) continue;
                found = true;
            }
        }
        if (!found) {
            cr.addContact().addTelecom().setSystem(ContactPoint.ContactPointSystem.URL).setValue(wg.getLink());
        }
    }

    public static void setHl7WG(Element res, String code) {
        if (VersionUtilities.getExtendedCanonicalResourceNames((String)res.getFHIRPublicationVersion().toCode()).contains(res.fhirType())) {
            HL7WorkGroups.HL7WorkGroup wg = HL7WorkGroups.find((String)code);
            if (wg == null) {
                throw new Error("Unknown WG " + code);
            }
            Element ext = res.getExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
            if (ext == null) {
                ext = res.addElement("extension");
                ext.setChildValue("url", "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
            }
            ext.setChildValue("valueCode", code);
            res.setChildValue("publisher", "HL7 International / " + wg.getName());
            while (res.hasChild("contact")) {
                res.removeChild("contact");
            }
            Element c = res.addElement("contact");
            Element t = c.addElement("telecom");
            t.setChildValue("system", "url");
            t.setChildValue("value", wg.getLink());
        }
    }

    public static void setHl7WG(org.w3c.dom.Element res, String code) {
        String rt = res.getNodeName();
        if (VersionUtilities.getExtendedCanonicalResourceNames((String)"5.0.0").contains(rt)) {
            org.w3c.dom.Element system;
            org.w3c.dom.Element telecom;
            HL7WorkGroups.HL7WorkGroup wg = HL7WorkGroups.find((String)code);
            if (wg == null) {
                throw new Error("Unknown WG " + code);
            }
            List extensions = XMLUtil.getNamedChildren((org.w3c.dom.Element)res, (String)"extension");
            org.w3c.dom.Element wgext = null;
            for (org.w3c.dom.Element ext : extensions) {
                String url = ext.getAttribute("url");
                if (!"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg".equals(url)) continue;
                wgext = ext;
            }
            if (wgext == null) {
                wgext = res.getOwnerDocument().createElementNS("http://hl7.org/fhir", "extension");
                wgext.setAttribute("url", "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
                org.w3c.dom.Element after = XMLUtil.getLastChild((org.w3c.dom.Element)res, (String[])new String[]{"id", "meta", "text", "implicitRules", "language", "text", "contained"});
                if (after != null) {
                    after = XMLUtil.getNextSibling((org.w3c.dom.Element)after);
                }
                res.insertBefore(wgext, after);
                res.insertBefore(res.getOwnerDocument().createTextNode("\n  "), after);
            }
            XMLUtil.clearChildren(wgext);
            org.w3c.dom.Element valueCode = res.getOwnerDocument().createElementNS("http://hl7.org/fhir", "valueCode");
            wgext.appendChild(valueCode);
            valueCode.setAttribute("value", code);
            org.w3c.dom.Element pub = XMLUtil.getNamedChild((org.w3c.dom.Element)res, (String)"publisher");
            if (pub == null) {
                pub = res.getOwnerDocument().createElementNS("http://hl7.org/fhir", "publisher");
                org.w3c.dom.Element after = XMLUtil.getLastChild((org.w3c.dom.Element)res, (String[])new String[]{"id", "meta", "text", "implicitRules", "language", "text", "contained", "extension", "modifierExtension", "url", "identifier", "version", "versionAlgorithmString", "versionAlgorithmCoding", "name", "title", "status", "experimental", "date", "EvidenceReport".equals(rt) ? "subject" : "xx"});
                if (after != null) {
                    after = XMLUtil.getNextSibling((org.w3c.dom.Element)after);
                }
                res.insertBefore(pub, after);
                res.insertBefore(res.getOwnerDocument().createTextNode("\n  "), after);
            }
            pub.setAttribute("value", "HL7 International / " + wg.getName());
            org.w3c.dom.Element contact = XMLUtil.getNamedChild((org.w3c.dom.Element)res, (String)"contact");
            if (contact == null) {
                contact = res.getOwnerDocument().createElementNS("http://hl7.org/fhir", "contact");
                res.insertBefore(contact, XMLUtil.getNextSibling((org.w3c.dom.Element)pub));
                res.insertBefore(res.getOwnerDocument().createTextNode("\n  "), contact.getNextSibling());
            }
            if ((telecom = XMLUtil.getNamedChild((org.w3c.dom.Element)contact, (String)"telecom")) == null) {
                contact.appendChild(res.getOwnerDocument().createTextNode("\n    "));
                telecom = res.getOwnerDocument().createElementNS("http://hl7.org/fhir", "telecom");
                contact.appendChild(telecom);
                contact.appendChild(res.getOwnerDocument().createTextNode("\n  "));
            }
            if ((system = XMLUtil.getNamedChild((org.w3c.dom.Element)telecom, (String)"system")) == null) {
                system = res.getOwnerDocument().createElementNS("http://hl7.org/fhir", "system");
                org.w3c.dom.Element after = XMLUtil.getLastChild((org.w3c.dom.Element)telecom, (String[])new String[]{"id", "extension"});
                if (after != null) {
                    after = XMLUtil.getNextSibling((org.w3c.dom.Element)after);
                }
                telecom.insertBefore(system, after);
                telecom.insertBefore(res.getOwnerDocument().createTextNode("\n      "), after);
            }
            system.setAttribute("value", "url");
            org.w3c.dom.Element value = XMLUtil.getNamedChild((org.w3c.dom.Element)telecom, (String)"value");
            if (value == null) {
                value = res.getOwnerDocument().createElementNS("http://hl7.org/fhir", "value");
                org.w3c.dom.Element after = XMLUtil.getLastChild((org.w3c.dom.Element)telecom, (String[])new String[]{"id", "extension", "system"});
                if (after != null) {
                    after = XMLUtil.getNextSibling((org.w3c.dom.Element)after);
                }
                telecom.insertBefore(system, after);
                telecom.insertBefore(res.getOwnerDocument().createTextNode("\n      "), after);
            }
            value.setAttribute("value", wg.getLink());
        }
    }
}

