/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientContext;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

public class TerminologyClientManager {
    public static final String UNRESOLVED_VALUESET = "--unknown--";
    private static final boolean IGNORE_TX_REGISTRY = false;
    private ITerminologyClientFactory factory;
    private String cacheId;
    private List<TerminologyClientContext> serverList = new ArrayList<TerminologyClientContext>();
    private Map<String, TerminologyClientContext> serverMap = new HashMap<String, TerminologyClientContext>();
    private Map<String, ServerOptionList> resMap = new HashMap<String, ServerOptionList>();
    private List<String> internalLog = new ArrayList<String>();
    protected Parameters expParameters;
    private TerminologyCache cache;
    private File cacheFile;
    private String usage;
    private String monitorServiceURL;
    private boolean useEcosystem;

    public ITerminologyClientFactory getFactory() {
        return this.factory;
    }

    public TerminologyClientManager(ITerminologyClientFactory factory, String cacheId) {
        this.factory = factory;
        this.cacheId = cacheId;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void copy(TerminologyClientManager other) {
        this.cacheId = other.cacheId;
        this.serverList.addAll(other.serverList);
        this.serverMap.putAll(other.serverMap);
        this.resMap.putAll(other.resMap);
        this.useEcosystem = other.useEcosystem;
        this.monitorServiceURL = other.monitorServiceURL;
        this.factory = other.factory;
        this.usage = other.usage;
    }

    public TerminologyClientContext chooseServer(ValueSet vs, Set<String> systems, boolean expand) throws TerminologyServiceException {
        boolean ok;
        if (this.serverList.isEmpty()) {
            return null;
        }
        if (systems.contains(UNRESOLVED_VALUESET) || systems.isEmpty()) {
            return this.serverList.get(0);
        }
        ArrayList<ServerOptionList> choices = new ArrayList<ServerOptionList>();
        for (String s : systems) {
            choices.add(this.findServerForSystem(s, expand));
        }
        for (ServerOptionList ol : choices) {
            for (String s : ol.authoritative) {
                ok = true;
                for (ServerOptionList t : choices) {
                    if (t.authoritative.contains(s)) continue;
                    ok = false;
                }
                if (!ok) continue;
                return this.findClient(s, systems, expand);
            }
        }
        for (ServerOptionList ol : choices) {
            for (String s : ol.authoritative) {
                ok = true;
                for (ServerOptionList t : choices) {
                    if (t.authoritative.contains(s) || t.candidates.contains(s)) continue;
                    ok = false;
                }
                if (!ok) continue;
                return this.findClient(s, systems, expand);
            }
        }
        for (ServerOptionList ol : choices) {
            for (String s : ol.candidates) {
                ok = true;
                for (ServerOptionList t : choices) {
                    if (t.candidates.contains(s)) continue;
                    ok = false;
                }
                if (!ok) continue;
                return this.findClient(s, systems, expand);
            }
        }
        for (String sys : systems) {
            String uri;
            String string = uri = sys.contains("|") ? sys.substring(0, sys.indexOf("|")) : sys;
            if (!Utilities.existsInList((String)uri, (String[])new String[]{"http://unitsofmeasure.org", "http://loinc.org", "http://snomed.info/sct", "http://www.nlm.nih.gov/research/umls/rxnorm", "http://hl7.org/fhir/sid/cvx", "urn:ietf:bcp:13", "urn:ietf:bcp:47", "urn:ietf:rfc:3986", "http://www.ama-assn.org/go/cpt", "urn:oid:1.2.36.1.2001.1005.17", "urn:iso:std:iso:3166", "http://varnomen.hgvs.org", "http://unstats.un.org/unsd/methods/m49/m49.htm", "urn:iso:std:iso:4217", "http://hl7.org/fhir/sid/ndc", "http://fhir.ohdsi.org/CodeSystem/concepts", "http://fdasis.nlm.nih.gov", "https://www.usps.com/"})) continue;
            return this.serverList.get(0);
        }
        if (vs != null) {
            if (vs.hasUserData("External.Link")) {
                if (systems.size() == 1) {
                    this.internalLog.add(vs.getVersionedUrl() + " uses the system " + systems.toString() + " not handled by any servers. Using source @ '" + vs.getUserString("External.Link") + "'");
                } else {
                    this.internalLog.add(vs.getVersionedUrl() + " includes multiple systems " + systems.toString() + " best handled by multiple servers: " + ((Object)choices).toString() + ". Using source @ '" + vs.getUserString("External.Link") + "'");
                }
                return this.findClient(vs.getUserString("External.Link"), systems, expand);
            }
            if (systems.size() == 1) {
                this.internalLog.add(vs.getVersionedUrl() + " uses the system " + systems.toString() + " not handled by any servers. Using master @ '" + this.serverList.get(0) + "'");
            } else {
                this.internalLog.add(vs.getVersionedUrl() + " includes multiple systems " + systems.toString() + " best handled by multiple servers: " + ((Object)choices).toString() + ". Using master @ '" + this.serverList.get(0) + "'");
            }
            return this.findClient(this.serverList.get(0).getAddress(), systems, expand);
        }
        if (systems.size() == 1) {
            this.internalLog.add("Request for system " + systems.toString() + " not handled by any servers. Using master @ '" + this.serverList.get(0) + "'");
        } else {
            this.internalLog.add("Request for multiple systems " + systems.toString() + " best handled by multiple servers: " + ((Object)choices).toString() + ". Using master @ '" + this.serverList.get(0) + "'");
        }
        return this.findClient(this.serverList.get(0).getAddress(), systems, expand);
    }

    private TerminologyClientContext findClient(String server, Set<String> systems, boolean expand) {
        TerminologyClientContext client = this.serverMap.get(server);
        if (client == null) {
            try {
                client = new TerminologyClientContext(this.factory.makeClient("id" + (this.serverList.size() + 1), server, this.getMasterClient().getUserAgent(), this.getMasterClient().getLogger()), this.cacheId, false);
            }
            catch (URISyntaxException e) {
                throw new TerminologyServiceException((Throwable)e);
            }
            client.setTxCache(this.cache);
            this.serverList.add(client);
            this.serverMap.put(server, client);
        }
        client.seeUse(systems, expand ? TerminologyClientContext.TerminologyClientContextUseType.expand : TerminologyClientContext.TerminologyClientContextUseType.validate);
        return client;
    }

    private ServerOptionList findServerForSystem(String s, boolean expand) throws TerminologyServiceException {
        ServerOptionList serverList = this.resMap.get(s);
        if (serverList == null) {
            serverList = this.decideWhichServer(s);
            try {
                serverList.replace("tx.fhir.org", new URL(this.getMasterClient().getAddress()).getHost());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.resMap.put(s, serverList);
            this.save();
        }
        return serverList;
    }

    private ServerOptionList decideWhichServer(String url) {
        if (!this.useEcosystem) {
            return new ServerOptionList(this.getMasterClient().getAddress());
        }
        if (this.expParameters != null) {
            if (!url.contains("|")) {
                for (Parameters.ParametersParameterComponent p : this.expParameters.getParameter()) {
                    if (!Utilities.existsInList((String)p.getName(), (String[])new String[]{"system-version", "force-system-version"}) || !p.hasValuePrimitive() || !p.getValue().primitiveValue().startsWith(url + "|")) continue;
                    url = p.getValue().primitiveValue();
                }
            } else {
                for (Parameters.ParametersParameterComponent p : this.expParameters.getParameter()) {
                    if (!Utilities.existsInList((String)p.getName(), (String[])new String[]{"force-system-version"}) || !p.hasValueCanonicalType() || !p.getValue().primitiveValue().startsWith(url + "|")) continue;
                    url = p.getValue().primitiveValue();
                }
            }
        }
        Object request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&url=" + Utilities.URLEncode((String)url)});
        if (this.usage != null) {
            request = (String)request + "&usage=" + this.usage;
        }
        try {
            ServerOptionList ret = new ServerOptionList();
            JsonObject json = JsonParser.parseObjectFromUrl((String)request);
            for (JsonObject item : json.getJsonObjects("authoritative")) {
                ret.authoritative.add(item.asString("url"));
            }
            for (JsonObject item : json.getJsonObjects("candidates")) {
                ret.candidates.add(item.asString("url"));
            }
            return ret;
        }
        catch (Exception e) {
            String msg = "Error resolving system " + url + ": " + e.getMessage() + " (" + (String)request + ")";
            if (!this.internalLog.contains(msg)) {
                this.internalLog.add(msg);
            }
            if (!this.monitorServiceURL.contains("tx.fhir.org")) {
                e.printStackTrace();
            }
            return new ServerOptionList(this.getMasterClient().getAddress());
        }
    }

    public List<TerminologyClientContext> serverList() {
        return this.serverList;
    }

    public boolean hasClient() {
        return !this.serverList.isEmpty();
    }

    public int getRetryCount() {
        return this.hasClient() ? this.getMasterClient().getRetryCount() : 0;
    }

    public void setRetryCount(int value) {
        if (this.hasClient()) {
            this.getMasterClient().setRetryCount(value);
        }
    }

    public void setUserAgent(String value) {
        if (this.hasClient()) {
            this.getMasterClient().setUserAgent(value);
        }
    }

    public void setLogger(ToolingClientLogger txLog) {
        if (this.hasClient()) {
            this.getMasterClient().setLogger(txLog);
        }
    }

    public TerminologyClientContext setMasterClient(ITerminologyClient client, boolean useEcosystem) {
        this.useEcosystem = useEcosystem;
        TerminologyClientContext details = new TerminologyClientContext(client, this.cacheId, true);
        details.setTxCache(this.cache);
        this.serverList.clear();
        this.serverList.add(details);
        this.serverMap.put(client.getAddress(), details);
        this.monitorServiceURL = Utilities.pathURL((String[])new String[]{Utilities.getDirectoryForURL((String)client.getAddress()), "tx-reg"});
        return details;
    }

    public TerminologyClientContext getMaster() {
        return this.serverList.isEmpty() ? null : this.serverList.get(0);
    }

    public ITerminologyClient getMasterClient() {
        return this.serverList.isEmpty() ? null : this.serverList.get(0).getClient();
    }

    public Map<String, TerminologyClientContext> serverMap() {
        HashMap<String, TerminologyClientContext> map = new HashMap<String, TerminologyClientContext>();
        for (TerminologyClientContext t : this.serverList) {
            map.put(t.getClient().getAddress(), t);
        }
        return map;
    }

    public void setFactory(ITerminologyClientFactory factory) {
        this.factory = factory;
    }

    public void setCache(TerminologyCache cache) {
        this.cache = cache;
        this.cacheFile = null;
        if (cache != null && cache.getFolder() != null) {
            try {
                this.cacheFile = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{cache.getFolder(), "system-map.json"}));
                if (this.cacheFile.exists()) {
                    JsonObject json = JsonParser.parseObject((File)this.cacheFile);
                    for (JsonObject pair : json.getJsonObjects("systems")) {
                        if (pair.has("server")) {
                            this.resMap.put(pair.asString("system"), new ServerOptionList(pair.asString("server")));
                            continue;
                        }
                        this.resMap.put(pair.asString("system"), new ServerOptionList(pair.getStrings("authoritative"), pair.getStrings("candidates")));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void save() {
        if (this.cacheFile != null && this.cache.getFolder() != null) {
            JsonObject json = new JsonObject();
            for (String s : Utilities.sorted(this.resMap.keySet())) {
                JsonObject si = new JsonObject();
                json.forceArray("systems").add((JsonElement)si);
                si.add("system", s);
                si.add("authoritative", this.resMap.get((Object)s).authoritative);
                si.add("candidates", this.resMap.get((Object)s).candidates);
            }
            try {
                JsonParser.compose((JsonElement)json, (File)this.cacheFile, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<String> getInternalLog() {
        return this.internalLog;
    }

    public List<TerminologyClientContext> getServerList() {
        return this.serverList;
    }

    public Map<String, TerminologyClientContext> getServerMap() {
        return this.serverMap;
    }

    public String getMonitorServiceURL() {
        return this.monitorServiceURL;
    }

    public Parameters getExpansionParameters() {
        return this.expParameters;
    }

    public void setExpansionParameters(Parameters expParameters) {
        this.expParameters = expParameters;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public TerminologyCache.SourcedValueSet findValueSetOnServer(String canonical) {
        if (this.getMasterClient() == null) {
            return null;
        }
        Object request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&valueSet=" + Utilities.URLEncode((String)canonical)});
        String server = null;
        try {
            if (!this.useEcosystem) {
                server = this.getMasterClient().getAddress();
            } else {
                if (this.usage != null) {
                    request = (String)request + "&usage=" + this.usage;
                }
                JsonObject json = JsonParser.parseObjectFromUrl((String)request);
                for (JsonObject item : json.getJsonObjects("authoritative")) {
                    if (server != null) continue;
                    server = item.asString("url");
                }
                for (JsonObject item : json.getJsonObjects("candidates")) {
                    if (server != null) continue;
                    server = item.asString("url");
                }
                if (server == null) {
                    return null;
                }
                if (server.contains("://tx.fhir.org")) {
                    try {
                        server = server.replace("tx.fhir.org", new URL(this.getMasterClient().getAddress()).getHost());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            TerminologyClientContext client = this.serverMap.get(server);
            if (client == null) {
                try {
                    client = new TerminologyClientContext(this.factory.makeClient("id" + (this.serverList.size() + 1), server, this.getMasterClient().getUserAgent(), this.getMasterClient().getLogger()), this.cacheId, false);
                }
                catch (URISyntaxException e) {
                    throw new TerminologyServiceException((Throwable)e);
                }
                client.setTxCache(this.cache);
                this.serverList.add(client);
                this.serverMap.put(server, client);
            }
            client.seeUse(canonical, TerminologyClientContext.TerminologyClientContextUseType.readVS);
            String criteria = canonical.contains("|") ? "?_format=json&url=" + Utilities.URLEncode((String)canonical.substring(0, canonical.lastIndexOf("|"))) + "&version=" + Utilities.URLEncode((String)canonical.substring(canonical.lastIndexOf("|") + 1)) : "?_format=json&url=" + Utilities.URLEncode((String)canonical);
            request = Utilities.pathURL((String[])new String[]{client.getAddress(), "ValueSet" + criteria});
            Bundle bnd = client.getClient().search("ValueSet", criteria);
            String rid = null;
            if (bnd.getEntry().size() == 0) {
                return null;
            }
            if (bnd.getEntry().size() > 1) {
                ArrayList<ValueSet> vslist = new ArrayList<ValueSet>();
                for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                    if (!be.hasResource() || !(be.getResource() instanceof ValueSet)) continue;
                    vslist.add((ValueSet)be.getResource());
                }
                Collections.sort(vslist, new ValueSetUtilities.ValueSetSorter());
                rid = ((ValueSet)vslist.get(vslist.size() - 1)).getIdBase();
            } else if (bnd.getEntryFirstRep().hasResource() && bnd.getEntryFirstRep().getResource() instanceof ValueSet) {
                rid = bnd.getEntryFirstRep().getResource().getIdBase();
            }
            if (rid == null) {
                return null;
            }
            ValueSet vs = (ValueSet)client.getClient().read("ValueSet", rid);
            return new TerminologyCache.SourcedValueSet(server, vs);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Error resolving valueSet " + canonical + ": " + e.getMessage() + " (" + (String)request + ")";
            if (!this.internalLog.contains(msg)) {
                this.internalLog.add(msg);
            }
            e.printStackTrace();
            return null;
        }
    }

    public TerminologyCache.SourcedCodeSystem findCodeSystemOnServer(String canonical) {
        if (this.getMasterClient() == null || !this.useEcosystem) {
            return null;
        }
        Object request = Utilities.pathURL((String[])new String[]{this.monitorServiceURL, "resolve?fhirVersion=" + this.factory.getVersion() + "&url=" + Utilities.URLEncode((String)canonical)});
        if (this.usage != null) {
            request = (String)request + "&usage=" + this.usage;
        }
        String server = null;
        try {
            TerminologyClientContext client;
            JsonObject json = JsonParser.parseObjectFromUrl((String)request);
            for (JsonObject item : json.getJsonObjects("authoritative")) {
                if (server != null) continue;
                server = item.asString("url");
            }
            for (JsonObject item : json.getJsonObjects("candidates")) {
                if (server != null) continue;
                server = item.asString("url");
            }
            if (server == null) {
                return null;
            }
            if (server.contains("://tx.fhir.org")) {
                try {
                    server = server.replace("tx.fhir.org", new URL(this.getMasterClient().getAddress()).getHost());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((client = this.serverMap.get(server)) == null) {
                try {
                    client = new TerminologyClientContext(this.factory.makeClient("id" + (this.serverList.size() + 1), server, this.getMasterClient().getUserAgent(), this.getMasterClient().getLogger()), this.cacheId, false);
                }
                catch (URISyntaxException e) {
                    throw new TerminologyServiceException((Throwable)e);
                }
                client.setTxCache(this.cache);
                this.serverList.add(client);
                this.serverMap.put(server, client);
            }
            client.seeUse(canonical, TerminologyClientContext.TerminologyClientContextUseType.readCS);
            String criteria = canonical.contains("|") ? "?_format=json&url=" + Utilities.URLEncode((String)canonical.substring(0, canonical.lastIndexOf("|"))) + "&version=" + Utilities.URLEncode((String)canonical.substring(canonical.lastIndexOf("|") + 1)) : "?_format=json&url=" + Utilities.URLEncode((String)canonical);
            request = Utilities.pathURL((String[])new String[]{client.getAddress(), "CodeSystem" + criteria});
            Bundle bnd = client.getClient().search("CodeSystem", criteria);
            String rid = null;
            if (bnd.getEntry().size() == 0) {
                return null;
            }
            if (bnd.getEntry().size() > 1) {
                ArrayList<CodeSystem> cslist = new ArrayList<CodeSystem>();
                for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                    if (!be.hasResource() || !(be.getResource() instanceof CodeSystem)) continue;
                    cslist.add((CodeSystem)be.getResource());
                }
                Collections.sort(cslist, new CodeSystemUtilities.CodeSystemSorter());
                rid = ((CodeSystem)cslist.get(cslist.size() - 1)).getIdBase();
            } else if (bnd.getEntryFirstRep().hasResource() && bnd.getEntryFirstRep().getResource() instanceof CodeSystem) {
                rid = bnd.getEntryFirstRep().getResource().getIdBase();
            }
            if (rid == null) {
                return null;
            }
            CodeSystem vs = (CodeSystem)client.getClient().read("CodeSystem", rid);
            return new TerminologyCache.SourcedCodeSystem(server, vs);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Error resolving valueSet " + canonical + ": " + e.getMessage() + " (" + (String)request + ")";
            if (!this.internalLog.contains(msg)) {
                this.internalLog.add(msg);
            }
            e.printStackTrace();
            return null;
        }
    }

    public boolean supportsSystem(String system) throws IOException {
        for (TerminologyClientContext client : this.serverList) {
            if (!client.supportsSystem(system)) continue;
            return true;
        }
        return false;
    }

    public static interface ITerminologyClientFactory {
        public ITerminologyClient makeClient(String var1, String var2, String var3, ToolingClientLogger var4) throws URISyntaxException;

        public String getVersion();
    }

    public class ServerOptionList {
        private List<String> authoritative = new ArrayList<String>();
        private List<String> candidates = new ArrayList<String>();

        public ServerOptionList(String address) {
            this.candidates.add(address);
        }

        public ServerOptionList() {
        }

        public ServerOptionList(List<String> auth, List<String> cand) {
            this.authoritative.addAll(auth);
            this.candidates.addAll(cand);
        }

        public void replace(String src, String dst) {
            int i;
            for (i = 0; i < this.candidates.size(); ++i) {
                if (!this.candidates.get(i).contains("://" + src)) continue;
                this.candidates.set(i, this.candidates.get(i).replace("://" + src, "://" + dst));
            }
            for (i = 0; i < this.authoritative.size(); ++i) {
                if (!this.authoritative.get(i).contains("://" + src)) continue;
                this.authoritative.set(i, this.authoritative.get(i).replace("://" + src, "://" + dst));
            }
        }

        public String toString() {
            return "auth = " + CommaSeparatedStringBuilder.join((String)"|", this.authoritative) + ", candidates=" + CommaSeparatedStringBuilder.join((String)"|", this.candidates);
        }
    }
}

