/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.LiquidEngine;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class LiquidRenderer
extends ResourceRenderer
implements LiquidEngine.ILiquidRenderingSupport {
    private String liquidTemplate;

    public LiquidRenderer(RenderingContext context, String liquidTemplate) {
        super(context);
        this.liquidTemplate = liquidTemplate;
    }

    public LiquidRenderer(RenderingContext context, Resolver.ResourceContext rcontext, String liquidTemplate) {
        super(context);
        this.rcontext = rcontext;
        this.liquidTemplate = liquidTemplate;
    }

    @Override
    public boolean render(XhtmlNode x, Resource r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode xn;
        LiquidEngine engine = new LiquidEngine(this.context.getWorker(), this.context.getServices());
        try {
            engine.setIncludeResolver(new LiquidRendererIncludeResolver(this.context));
            engine.setRenderingSupport(this);
            LiquidEngine.LiquidDocument doc = engine.parse(this.liquidTemplate, "template");
            String html = engine.evaluate(doc, r, this.rcontext);
            xn = new XhtmlParser().parseFragment(html);
            if (!x.getName().equals("div")) {
                throw new FHIRException("Error in template: Root element is not 'div'");
            }
        }
        catch (IOException | FHIRException e) {
            xn = new XhtmlNode(NodeType.Element, "div");
            xn.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        x.getChildNodes().addAll((Collection)xn.getChildNodes());
        return true;
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return "not done yet";
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        if (r.has("name")) {
            return r.children("name").get(0).getBase().primitiveValue();
        }
        return "??";
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode xn;
        LiquidEngine engine = new LiquidEngine(this.context.getWorker(), this.context.getServices());
        try {
            engine.setIncludeResolver(new LiquidRendererIncludeResolver(this.context));
            LiquidEngine.LiquidDocument doc = engine.parse(this.liquidTemplate, "template");
            engine.setRenderingSupport(this);
            String html = engine.evaluate(doc, r.getBase(), new LiquidRendererContxt(this.rcontext, r));
            xn = new XhtmlParser().parseFragment(html);
            if (!x.getName().equals("div")) {
                throw new FHIRException("Error in template: Root element is not 'div'");
            }
        }
        catch (IOException | FHIRException e) {
            xn = new XhtmlNode(NodeType.Element, "div");
            xn.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        x.getChildNodes().addAll((Collection)xn.getChildNodes());
        return true;
    }

    @Override
    public ResourceRenderer.RendererType getRendererType() {
        return ResourceRenderer.RendererType.LIQUID;
    }

    @Override
    public String renderForLiquid(Object appContext, Base base) throws FHIRException {
        try {
            if (base instanceof Element) {
                base = this.context.getParser().parseType((Element)base);
            }
            XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
            if (base instanceof Reference) {
                this.renderReference(((LiquidRendererContxt)appContext).getResource(), x, (Reference)base);
            } else if (base instanceof DataType) {
                this.render(x, (DataType)base);
            } else {
                x.tx(base.toString());
            }
            String res = new XhtmlComposer(true).compose(x);
            res = res.substring(5);
            if (res.length() < 6) {
                return "";
            }
            return res.substring(0, res.length() - 6);
        }
        catch (FHIRFormatError e) {
            throw new FHIRException((Throwable)e);
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    private class LiquidRendererIncludeResolver
    implements LiquidEngine.ILiquidEngineIncludeResolver {
        private RenderingContext context;

        public LiquidRendererIncludeResolver(RenderingContext context) {
            this.context = context;
        }

        @Override
        public String fetchInclude(LiquidEngine engine, String name) {
            return this.context.getTemplateProvider().findTemplate(this.context, name);
        }
    }

    public class LiquidRendererContxt {
        private Resolver.ResourceContext rcontext;
        private BaseWrappers.ResourceWrapper resource;

        public LiquidRendererContxt(Resolver.ResourceContext rcontext, BaseWrappers.ResourceWrapper r) {
            this.rcontext = rcontext;
            this.resource = r;
        }

        public BaseWrappers.ResourceWrapper getResource() {
            return this.resource;
        }
    }
}

