/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Subscription", profile="http://hl7.org/fhir/StructureDefinition/Subscription")
public class Subscription
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifiers (business identifier)", formalDefinition="A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human readable name for this subscription", formalDefinition="A natural language name identifying the subscription.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="requested | active | error | off | entered-in-error", formalDefinition="The status of the subscription, which marks the server state for managing the subscription.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-status")
    protected Enumeration<Enumerations.SubscriptionStatusCodes> status;
    @Child(name="topic", type={CanonicalType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the subscription topic being subscribed to", formalDefinition="The reference to the subscription topic to be notified about.")
    protected CanonicalType topic;
    @Child(name="contact", type={ContactPoint.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for source (e.g. troubleshooting)", formalDefinition="Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.")
    protected List<ContactPoint> contact;
    @Child(name="end", type={InstantType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When to automatically delete the subscription", formalDefinition="The time for the server to turn the subscription off.")
    protected InstantType end;
    @Child(name="managingEntity", type={CareTeam.class, HealthcareService.class, Organization.class, RelatedPerson.class, Patient.class, Practitioner.class, PractitionerRole.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Entity responsible for Subscription changes", formalDefinition="Entity with authorization to make subsequent revisions to the Subscription and also determines what data the subscription is authorized to disclose.")
    protected Reference managingEntity;
    @Child(name="reason", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of why this subscription was created", formalDefinition="A description of why this subscription is defined.")
    protected StringType reason;
    @Child(name="filterBy", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Criteria for narrowing the subscription topic stream", formalDefinition="The filter properties to be applied to narrow the subscription topic stream.  When multiple filters are applied, evaluates to true if all the conditions applicable to that resource are met; otherwise it returns false (i.e., logical AND).")
    protected List<SubscriptionFilterByComponent> filterBy;
    @Child(name="channelType", type={Coding.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Channel type for notifications", formalDefinition="The type of channel to send notifications on.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-channel-type")
    protected Coding channelType;
    @Child(name="endpoint", type={UrlType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the channel points to", formalDefinition="The url that describes the actual end-point to send notifications to.")
    protected UrlType endpoint;
    @Child(name="parameter", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Channel type", formalDefinition="Channel-dependent information to send as part of the notification (e.g., HTTP Headers).")
    protected List<SubscriptionParameterComponent> parameter;
    @Child(name="heartbeatPeriod", type={UnsignedIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Interval in seconds to send 'heartbeat' notification", formalDefinition="If present, a 'heartbeat' notification (keep-alive) is sent via this channel with an interval period equal to this elements integer value in seconds.  If not present, a heartbeat notification is not sent.")
    protected UnsignedIntType heartbeatPeriod;
    @Child(name="timeout", type={UnsignedIntType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Timeout in seconds to attempt notification delivery", formalDefinition="If present, the maximum amount of time a server will allow before failing a notification attempt.")
    protected UnsignedIntType timeout;
    @Child(name="contentType", type={CodeType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="MIME type to send, or omit for no payload", formalDefinition="The MIME type to send the payload in - e.g., `application/fhir+xml` or `application/fhir+json`. Note that:\n\n* clients may request notifications in a specific FHIR version by using the [FHIR Version Parameter](http.html#version-parameter) - e.g., `application/fhir+json; fhirVersion=4.0`.\n\n* additional MIME types can be allowed by channels - e.g., `text/plain` and `text/html` are defined by the Email channel.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected CodeType contentType;
    @Child(name="content", type={CodeType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="empty | id-only | full-resource", formalDefinition="How much of the resource content to deliver in the notification payload. The choices are an empty payload, only the resource id, or the full resource content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-payload-content")
    protected Enumeration<SubscriptionPayloadContent> content;
    @Child(name="maxCount", type={PositiveIntType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum number of events that can be combined in a single notification", formalDefinition="If present, the maximum number of events that will be included in a notification bundle. Note that this is not a strict limit on the number of entries in a bundle, as dependent resources can be included.")
    protected PositiveIntType maxCount;
    private static final long serialVersionUID = 1396960420L;
    @SearchParamDefinition(name="contact", path="Subscription.contact", description="Contact details for the subscription", type="token")
    public static final String SP_CONTACT = "contact";
    public static final TokenClientParam CONTACT = new TokenClientParam("contact");
    @SearchParamDefinition(name="content-level", path="Subscription.content", description="Content level included in notifications", type="token")
    public static final String SP_CONTENT_LEVEL = "content-level";
    public static final TokenClientParam CONTENT_LEVEL = new TokenClientParam("content-level");
    @SearchParamDefinition(name="filter-value", path="Subscription.filterBy.value", description="Filter value used to narrow notifications", type="string")
    public static final String SP_FILTER_VALUE = "filter-value";
    public static final StringClientParam FILTER_VALUE = new StringClientParam("filter-value");
    @SearchParamDefinition(name="identifier", path="Subscription.identifier", description="A subscription identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Subscription.name", description="A human-readable name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="owner", path="Subscription.managingEntity", description="The managing entity", type="reference", target={CareTeam.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_OWNER = "owner";
    public static final ReferenceClientParam OWNER = new ReferenceClientParam("owner");
    public static final Include INCLUDE_OWNER = new Include("Subscription:owner").toLocked();
    @SearchParamDefinition(name="payload", path="Subscription.contentType", description="The mime-type of notifications", type="token")
    public static final String SP_PAYLOAD = "payload";
    public static final TokenClientParam PAYLOAD = new TokenClientParam("payload");
    @SearchParamDefinition(name="status", path="Subscription.status", description="The current state of the subscription", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="topic", path="Subscription.topic", description="The canonical topic url that triggers notifications", type="uri")
    public static final String SP_TOPIC = "topic";
    public static final UriClientParam TOPIC = new UriClientParam("topic");
    @SearchParamDefinition(name="type", path="Subscription.channelType", description="The type of channel for the sent notifications", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="Subscription.endpoint", description="The uri that will receive the notifications", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");

    public Subscription() {
    }

    public Subscription(Enumerations.SubscriptionStatusCodes status, String topic, Coding channelType) {
        this.setStatus(status);
        this.setTopic(topic);
        this.setChannelType(channelType);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Subscription setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Subscription addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Subscription setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Subscription setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.SubscriptionStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.SubscriptionStatusCodes>(new Enumerations.SubscriptionStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Subscription setStatusElement(Enumeration<Enumerations.SubscriptionStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.SubscriptionStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.SubscriptionStatusCodes)((Object)this.status.getValue());
    }

    public Subscription setStatus(Enumerations.SubscriptionStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.SubscriptionStatusCodes>(new Enumerations.SubscriptionStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CanonicalType getTopicElement() {
        if (this.topic == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.topic");
            }
            if (Configuration.doAutoCreate()) {
                this.topic = new CanonicalType();
            }
        }
        return this.topic;
    }

    public boolean hasTopicElement() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public boolean hasTopic() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public Subscription setTopicElement(CanonicalType value) {
        this.topic = value;
        return this;
    }

    public String getTopic() {
        return this.topic == null ? null : (String)this.topic.getValue();
    }

    public Subscription setTopic(String value) {
        if (this.topic == null) {
            this.topic = new CanonicalType();
        }
        this.topic.setValue(value);
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Subscription setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Subscription addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Subscription setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Subscription setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public Reference getManagingEntity() {
        if (this.managingEntity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.managingEntity");
            }
            if (Configuration.doAutoCreate()) {
                this.managingEntity = new Reference();
            }
        }
        return this.managingEntity;
    }

    public boolean hasManagingEntity() {
        return this.managingEntity != null && !this.managingEntity.isEmpty();
    }

    public Subscription setManagingEntity(Reference value) {
        this.managingEntity = value;
        return this;
    }

    public StringType getReasonElement() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new StringType();
            }
        }
        return this.reason;
    }

    public boolean hasReasonElement() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Subscription setReasonElement(StringType value) {
        this.reason = value;
        return this;
    }

    public String getReason() {
        return this.reason == null ? null : (String)this.reason.getValue();
    }

    public Subscription setReason(String value) {
        if (Utilities.noString((String)value)) {
            this.reason = null;
        } else {
            if (this.reason == null) {
                this.reason = new StringType();
            }
            this.reason.setValue(value);
        }
        return this;
    }

    public List<SubscriptionFilterByComponent> getFilterBy() {
        if (this.filterBy == null) {
            this.filterBy = new ArrayList<SubscriptionFilterByComponent>();
        }
        return this.filterBy;
    }

    public Subscription setFilterBy(List<SubscriptionFilterByComponent> theFilterBy) {
        this.filterBy = theFilterBy;
        return this;
    }

    public boolean hasFilterBy() {
        if (this.filterBy == null) {
            return false;
        }
        for (SubscriptionFilterByComponent item : this.filterBy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionFilterByComponent addFilterBy() {
        SubscriptionFilterByComponent t = new SubscriptionFilterByComponent();
        if (this.filterBy == null) {
            this.filterBy = new ArrayList<SubscriptionFilterByComponent>();
        }
        this.filterBy.add(t);
        return t;
    }

    public Subscription addFilterBy(SubscriptionFilterByComponent t) {
        if (t == null) {
            return this;
        }
        if (this.filterBy == null) {
            this.filterBy = new ArrayList<SubscriptionFilterByComponent>();
        }
        this.filterBy.add(t);
        return this;
    }

    public SubscriptionFilterByComponent getFilterByFirstRep() {
        if (this.getFilterBy().isEmpty()) {
            this.addFilterBy();
        }
        return this.getFilterBy().get(0);
    }

    public Coding getChannelType() {
        if (this.channelType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.channelType");
            }
            if (Configuration.doAutoCreate()) {
                this.channelType = new Coding();
            }
        }
        return this.channelType;
    }

    public boolean hasChannelType() {
        return this.channelType != null && !this.channelType.isEmpty();
    }

    public Subscription setChannelType(Coding value) {
        this.channelType = value;
        return this;
    }

    public UrlType getEndpointElement() {
        if (this.endpoint == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.endpoint");
            }
            if (Configuration.doAutoCreate()) {
                this.endpoint = new UrlType();
            }
        }
        return this.endpoint;
    }

    public boolean hasEndpointElement() {
        return this.endpoint != null && !this.endpoint.isEmpty();
    }

    public boolean hasEndpoint() {
        return this.endpoint != null && !this.endpoint.isEmpty();
    }

    public Subscription setEndpointElement(UrlType value) {
        this.endpoint = value;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint == null ? null : (String)this.endpoint.getValue();
    }

    public Subscription setEndpoint(String value) {
        if (Utilities.noString((String)value)) {
            this.endpoint = null;
        } else {
            if (this.endpoint == null) {
                this.endpoint = new UrlType();
            }
            this.endpoint.setValue(value);
        }
        return this;
    }

    public List<SubscriptionParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<SubscriptionParameterComponent>();
        }
        return this.parameter;
    }

    public Subscription setParameter(List<SubscriptionParameterComponent> theParameter) {
        this.parameter = theParameter;
        return this;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (SubscriptionParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionParameterComponent addParameter() {
        SubscriptionParameterComponent t = new SubscriptionParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<SubscriptionParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public Subscription addParameter(SubscriptionParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<SubscriptionParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public SubscriptionParameterComponent getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public UnsignedIntType getHeartbeatPeriodElement() {
        if (this.heartbeatPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.heartbeatPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.heartbeatPeriod = new UnsignedIntType();
            }
        }
        return this.heartbeatPeriod;
    }

    public boolean hasHeartbeatPeriodElement() {
        return this.heartbeatPeriod != null && !this.heartbeatPeriod.isEmpty();
    }

    public boolean hasHeartbeatPeriod() {
        return this.heartbeatPeriod != null && !this.heartbeatPeriod.isEmpty();
    }

    public Subscription setHeartbeatPeriodElement(UnsignedIntType value) {
        this.heartbeatPeriod = value;
        return this;
    }

    public int getHeartbeatPeriod() {
        return this.heartbeatPeriod == null || this.heartbeatPeriod.isEmpty() ? 0 : (Integer)this.heartbeatPeriod.getValue();
    }

    public Subscription setHeartbeatPeriod(int value) {
        if (this.heartbeatPeriod == null) {
            this.heartbeatPeriod = new UnsignedIntType();
        }
        this.heartbeatPeriod.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getTimeoutElement() {
        if (this.timeout == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.timeout");
            }
            if (Configuration.doAutoCreate()) {
                this.timeout = new UnsignedIntType();
            }
        }
        return this.timeout;
    }

    public boolean hasTimeoutElement() {
        return this.timeout != null && !this.timeout.isEmpty();
    }

    public boolean hasTimeout() {
        return this.timeout != null && !this.timeout.isEmpty();
    }

    public Subscription setTimeoutElement(UnsignedIntType value) {
        this.timeout = value;
        return this;
    }

    public int getTimeout() {
        return this.timeout == null || this.timeout.isEmpty() ? 0 : (Integer)this.timeout.getValue();
    }

    public Subscription setTimeout(int value) {
        if (this.timeout == null) {
            this.timeout = new UnsignedIntType();
        }
        this.timeout.setValue((Object)value);
        return this;
    }

    public CodeType getContentTypeElement() {
        if (this.contentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.contentType");
            }
            if (Configuration.doAutoCreate()) {
                this.contentType = new CodeType();
            }
        }
        return this.contentType;
    }

    public boolean hasContentTypeElement() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public Subscription setContentTypeElement(CodeType value) {
        this.contentType = value;
        return this;
    }

    public String getContentType() {
        return this.contentType == null ? null : (String)this.contentType.getValue();
    }

    public Subscription setContentType(String value) {
        if (Utilities.noString((String)value)) {
            this.contentType = null;
        } else {
            if (this.contentType == null) {
                this.contentType = new CodeType();
            }
            this.contentType.setValue(value);
        }
        return this;
    }

    public Enumeration<SubscriptionPayloadContent> getContentElement() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Enumeration<SubscriptionPayloadContent>(new SubscriptionPayloadContentEnumFactory());
            }
        }
        return this.content;
    }

    public boolean hasContentElement() {
        return this.content != null && !this.content.isEmpty();
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public Subscription setContentElement(Enumeration<SubscriptionPayloadContent> value) {
        this.content = value;
        return this;
    }

    public SubscriptionPayloadContent getContent() {
        return this.content == null ? null : (SubscriptionPayloadContent)((Object)this.content.getValue());
    }

    public Subscription setContent(SubscriptionPayloadContent value) {
        if (value == null) {
            this.content = null;
        } else {
            if (this.content == null) {
                this.content = new Enumeration<SubscriptionPayloadContent>(new SubscriptionPayloadContentEnumFactory());
            }
            this.content.setValue((Object)value);
        }
        return this;
    }

    public PositiveIntType getMaxCountElement() {
        if (this.maxCount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Subscription.maxCount");
            }
            if (Configuration.doAutoCreate()) {
                this.maxCount = new PositiveIntType();
            }
        }
        return this.maxCount;
    }

    public boolean hasMaxCountElement() {
        return this.maxCount != null && !this.maxCount.isEmpty();
    }

    public boolean hasMaxCount() {
        return this.maxCount != null && !this.maxCount.isEmpty();
    }

    public Subscription setMaxCountElement(PositiveIntType value) {
        this.maxCount = value;
        return this;
    }

    public int getMaxCount() {
        return this.maxCount == null || this.maxCount.isEmpty() ? 0 : (Integer)this.maxCount.getValue();
    }

    public Subscription setMaxCount(int value) {
        if (this.maxCount == null) {
            this.maxCount = new PositiveIntType();
        }
        this.maxCount.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the subscription.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status));
        children.add(new Property(SP_TOPIC, "canonical(SubscriptionTopic)", "The reference to the subscription topic to be notified about.", 0, 1, this.topic));
        children.add(new Property(SP_CONTACT, "ContactPoint", "Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("end", "instant", "The time for the server to turn the subscription off.", 0, 1, this.end));
        children.add(new Property("managingEntity", "Reference(CareTeam|HealthcareService|Organization|RelatedPerson|Patient|Practitioner|PractitionerRole)", "Entity with authorization to make subsequent revisions to the Subscription and also determines what data the subscription is authorized to disclose.", 0, 1, this.managingEntity));
        children.add(new Property("reason", "string", "A description of why this subscription is defined.", 0, 1, this.reason));
        children.add(new Property("filterBy", "", "The filter properties to be applied to narrow the subscription topic stream.  When multiple filters are applied, evaluates to true if all the conditions applicable to that resource are met; otherwise it returns false (i.e., logical AND).", 0, Integer.MAX_VALUE, this.filterBy));
        children.add(new Property("channelType", "Coding", "The type of channel to send notifications on.", 0, 1, this.channelType));
        children.add(new Property("endpoint", SP_URL, "The url that describes the actual end-point to send notifications to.", 0, 1, this.endpoint));
        children.add(new Property("parameter", "", "Channel-dependent information to send as part of the notification (e.g., HTTP Headers).", 0, Integer.MAX_VALUE, this.parameter));
        children.add(new Property("heartbeatPeriod", "unsignedInt", "If present, a 'heartbeat' notification (keep-alive) is sent via this channel with an interval period equal to this elements integer value in seconds.  If not present, a heartbeat notification is not sent.", 0, 1, this.heartbeatPeriod));
        children.add(new Property("timeout", "unsignedInt", "If present, the maximum amount of time a server will allow before failing a notification attempt.", 0, 1, this.timeout));
        children.add(new Property("contentType", "code", "The MIME type to send the payload in - e.g., `application/fhir+xml` or `application/fhir+json`. Note that:\n\n* clients may request notifications in a specific FHIR version by using the [FHIR Version Parameter](http.html#version-parameter) - e.g., `application/fhir+json; fhirVersion=4.0`.\n\n* additional MIME types can be allowed by channels - e.g., `text/plain` and `text/html` are defined by the Email channel.", 0, 1, this.contentType));
        children.add(new Property("content", "code", "How much of the resource content to deliver in the notification payload. The choices are an empty payload, only the resource id, or the full resource content.", 0, 1, this.content));
        children.add(new Property("maxCount", "positiveInt", "If present, the maximum number of events that will be included in a notification bundle. Note that this is not a strict limit on the number of entries in a bundle, as dependent resources can be included.", 0, 1, this.maxCount));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the subscription.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "canonical(SubscriptionTopic)", "The reference to the subscription topic to be notified about.", 0, 1, this.topic);
            }
            case 951526432: {
                return new Property(SP_CONTACT, "ContactPoint", "Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 100571: {
                return new Property("end", "instant", "The time for the server to turn the subscription off.", 0, 1, this.end);
            }
            case -988474523: {
                return new Property("managingEntity", "Reference(CareTeam|HealthcareService|Organization|RelatedPerson|Patient|Practitioner|PractitionerRole)", "Entity with authorization to make subsequent revisions to the Subscription and also determines what data the subscription is authorized to disclose.", 0, 1, this.managingEntity);
            }
            case -934964668: {
                return new Property("reason", "string", "A description of why this subscription is defined.", 0, 1, this.reason);
            }
            case -721168913: {
                return new Property("filterBy", "", "The filter properties to be applied to narrow the subscription topic stream.  When multiple filters are applied, evaluates to true if all the conditions applicable to that resource are met; otherwise it returns false (i.e., logical AND).", 0, Integer.MAX_VALUE, this.filterBy);
            }
            case 274155229: {
                return new Property("channelType", "Coding", "The type of channel to send notifications on.", 0, 1, this.channelType);
            }
            case 1741102485: {
                return new Property("endpoint", SP_URL, "The url that describes the actual end-point to send notifications to.", 0, 1, this.endpoint);
            }
            case 1954460585: {
                return new Property("parameter", "", "Channel-dependent information to send as part of the notification (e.g., HTTP Headers).", 0, Integer.MAX_VALUE, this.parameter);
            }
            case -938465827: {
                return new Property("heartbeatPeriod", "unsignedInt", "If present, a 'heartbeat' notification (keep-alive) is sent via this channel with an interval period equal to this elements integer value in seconds.  If not present, a heartbeat notification is not sent.", 0, 1, this.heartbeatPeriod);
            }
            case -1313911455: {
                return new Property("timeout", "unsignedInt", "If present, the maximum amount of time a server will allow before failing a notification attempt.", 0, 1, this.timeout);
            }
            case -389131437: {
                return new Property("contentType", "code", "The MIME type to send the payload in - e.g., `application/fhir+xml` or `application/fhir+json`. Note that:\n\n* clients may request notifications in a specific FHIR version by using the [FHIR Version Parameter](http.html#version-parameter) - e.g., `application/fhir+json; fhirVersion=4.0`.\n\n* additional MIME types can be allowed by channels - e.g., `text/plain` and `text/html` are defined by the Email channel.", 0, 1, this.contentType);
            }
            case 951530617: {
                return new Property("content", "code", "How much of the resource content to deliver in the notification payload. The choices are an empty payload, only the resource id, or the full resource content.", 0, 1, this.content);
            }
            case 382106123: {
                return new Property("maxCount", "positiveInt", "If present, the maximum number of events that will be included in a notification bundle. Note that this is not a strict limit on the number of entries in a bundle, as dependent resources can be included.", 0, 1, this.maxCount);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 110546223: {
                Base[] baseArray;
                if (this.topic == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.topic;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.end;
                }
                return baseArray;
            }
            case -988474523: {
                Base[] baseArray;
                if (this.managingEntity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.managingEntity;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.reason;
                }
                return baseArray;
            }
            case -721168913: {
                return this.filterBy == null ? new Base[]{} : this.filterBy.toArray(new Base[this.filterBy.size()]);
            }
            case 274155229: {
                Base[] baseArray;
                if (this.channelType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.channelType;
                }
                return baseArray;
            }
            case 1741102485: {
                Base[] baseArray;
                if (this.endpoint == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.endpoint;
                }
                return baseArray;
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case -938465827: {
                Base[] baseArray;
                if (this.heartbeatPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.heartbeatPeriod;
                }
                return baseArray;
            }
            case -1313911455: {
                Base[] baseArray;
                if (this.timeout == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.timeout;
                }
                return baseArray;
            }
            case -389131437: {
                Base[] baseArray;
                if (this.contentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.contentType;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.content;
                }
                return baseArray;
            }
            case 382106123: {
                Base[] baseArray;
                if (this.maxCount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.maxCount;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.SubscriptionStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 110546223: {
                this.topic = TypeConvertor.castToCanonical(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case 100571: {
                this.end = TypeConvertor.castToInstant(value);
                return value;
            }
            case -988474523: {
                this.managingEntity = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = TypeConvertor.castToString(value);
                return value;
            }
            case -721168913: {
                this.getFilterBy().add((SubscriptionFilterByComponent)((Object)value));
                return value;
            }
            case 274155229: {
                this.channelType = TypeConvertor.castToCoding(value);
                return value;
            }
            case 1741102485: {
                this.endpoint = TypeConvertor.castToUrl(value);
                return value;
            }
            case 1954460585: {
                this.getParameter().add((SubscriptionParameterComponent)((Object)value));
                return value;
            }
            case -938465827: {
                this.heartbeatPeriod = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -1313911455: {
                this.timeout = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -389131437: {
                this.contentType = TypeConvertor.castToCode(value);
                return value;
            }
            case 951530617: {
                value = new SubscriptionPayloadContentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.content = value;
                return value;
            }
            case 382106123: {
                this.maxCount = TypeConvertor.castToPositiveInt(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.SubscriptionStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TOPIC)) {
            this.topic = TypeConvertor.castToCanonical(value);
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals("end")) {
            this.end = TypeConvertor.castToInstant(value);
        } else if (name.equals("managingEntity")) {
            this.managingEntity = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.reason = TypeConvertor.castToString(value);
        } else if (name.equals("filterBy")) {
            this.getFilterBy().add((SubscriptionFilterByComponent)((Object)value));
        } else if (name.equals("channelType")) {
            this.channelType = TypeConvertor.castToCoding(value);
        } else if (name.equals("endpoint")) {
            this.endpoint = TypeConvertor.castToUrl(value);
        } else if (name.equals("parameter")) {
            this.getParameter().add((SubscriptionParameterComponent)((Object)value));
        } else if (name.equals("heartbeatPeriod")) {
            this.heartbeatPeriod = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("timeout")) {
            this.timeout = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("contentType")) {
            this.contentType = TypeConvertor.castToCode(value);
        } else if (name.equals("content")) {
            value = new SubscriptionPayloadContentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.content = value;
        } else if (name.equals("maxCount")) {
            this.maxCount = TypeConvertor.castToPositiveInt(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.SubscriptionStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TOPIC)) {
            this.topic = null;
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().remove(value);
        } else if (name.equals("end")) {
            this.end = null;
        } else if (name.equals("managingEntity")) {
            this.managingEntity = null;
        } else if (name.equals("reason")) {
            this.reason = null;
        } else if (name.equals("filterBy")) {
            this.getFilterBy().remove((SubscriptionFilterByComponent)((Object)value));
        } else if (name.equals("channelType")) {
            this.channelType = null;
        } else if (name.equals("endpoint")) {
            this.endpoint = null;
        } else if (name.equals("parameter")) {
            this.getParameter().remove((SubscriptionParameterComponent)((Object)value));
        } else if (name.equals("heartbeatPeriod")) {
            this.heartbeatPeriod = null;
        } else if (name.equals("timeout")) {
            this.timeout = null;
        } else if (name.equals("contentType")) {
            this.contentType = null;
        } else if (name.equals("content")) {
            value = new SubscriptionPayloadContentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.content = value;
        } else if (name.equals("maxCount")) {
            this.maxCount = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 110546223: {
                return this.getTopicElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case 100571: {
                return this.getEndElement();
            }
            case -988474523: {
                return this.getManagingEntity();
            }
            case -934964668: {
                return this.getReasonElement();
            }
            case -721168913: {
                return this.addFilterBy();
            }
            case 274155229: {
                return this.getChannelType();
            }
            case 1741102485: {
                return this.getEndpointElement();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case -938465827: {
                return this.getHeartbeatPeriodElement();
            }
            case -1313911455: {
                return this.getTimeoutElement();
            }
            case -389131437: {
                return this.getContentTypeElement();
            }
            case 951530617: {
                return this.getContentElement();
            }
            case 382106123: {
                return this.getMaxCountElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 110546223: {
                return new String[]{"canonical"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case 100571: {
                return new String[]{"instant"};
            }
            case -988474523: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"string"};
            }
            case -721168913: {
                return new String[0];
            }
            case 274155229: {
                return new String[]{"Coding"};
            }
            case 1741102485: {
                return new String[]{SP_URL};
            }
            case 1954460585: {
                return new String[0];
            }
            case -938465827: {
                return new String[]{"unsignedInt"};
            }
            case -1313911455: {
                return new String[]{"unsignedInt"};
            }
            case -389131437: {
                return new String[]{"code"};
            }
            case 951530617: {
                return new String[]{"code"};
            }
            case 382106123: {
                return new String[]{"positiveInt"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.status");
        }
        if (name.equals(SP_TOPIC)) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.topic");
        }
        if (name.equals(SP_CONTACT)) {
            return this.addContact();
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.end");
        }
        if (name.equals("managingEntity")) {
            this.managingEntity = new Reference();
            return this.managingEntity;
        }
        if (name.equals("reason")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.reason");
        }
        if (name.equals("filterBy")) {
            return this.addFilterBy();
        }
        if (name.equals("channelType")) {
            this.channelType = new Coding();
            return this.channelType;
        }
        if (name.equals("endpoint")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.endpoint");
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals("heartbeatPeriod")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.heartbeatPeriod");
        }
        if (name.equals("timeout")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.timeout");
        }
        if (name.equals("contentType")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.contentType");
        }
        if (name.equals("content")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.content");
        }
        if (name.equals("maxCount")) {
            throw new FHIRException("Cannot call addChild on a singleton property Subscription.maxCount");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Subscription";
    }

    @Override
    public Subscription copy() {
        Subscription dst = new Subscription();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Subscription dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        CanonicalType canonicalType = dst.topic = this.topic == null ? null : this.topic.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.end = this.end == null ? null : this.end.copy();
        dst.managingEntity = this.managingEntity == null ? null : this.managingEntity.copy();
        StringType stringType = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.filterBy != null) {
            dst.filterBy = new ArrayList<SubscriptionFilterByComponent>();
            for (SubscriptionFilterByComponent subscriptionFilterByComponent : this.filterBy) {
                dst.filterBy.add(subscriptionFilterByComponent.copy());
            }
        }
        dst.channelType = this.channelType == null ? null : this.channelType.copy();
        UrlType urlType = dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
        if (this.parameter != null) {
            dst.parameter = new ArrayList<SubscriptionParameterComponent>();
            for (SubscriptionParameterComponent subscriptionParameterComponent : this.parameter) {
                dst.parameter.add(subscriptionParameterComponent.copy());
            }
        }
        dst.heartbeatPeriod = this.heartbeatPeriod == null ? null : this.heartbeatPeriod.copy();
        dst.timeout = this.timeout == null ? null : this.timeout.copy();
        dst.contentType = this.contentType == null ? null : this.contentType.copy();
        dst.content = this.content == null ? null : this.content.copy();
        dst.maxCount = this.maxCount == null ? null : this.maxCount.copy();
    }

    protected Subscription typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Subscription)) {
            return false;
        }
        Subscription o = (Subscription)other_;
        return Subscription.compareDeep(this.identifier, o.identifier, true) && Subscription.compareDeep(this.name, o.name, true) && Subscription.compareDeep(this.status, o.status, true) && Subscription.compareDeep(this.topic, o.topic, true) && Subscription.compareDeep(this.contact, o.contact, true) && Subscription.compareDeep(this.end, o.end, true) && Subscription.compareDeep(this.managingEntity, o.managingEntity, true) && Subscription.compareDeep(this.reason, o.reason, true) && Subscription.compareDeep(this.filterBy, o.filterBy, true) && Subscription.compareDeep(this.channelType, o.channelType, true) && Subscription.compareDeep(this.endpoint, o.endpoint, true) && Subscription.compareDeep(this.parameter, o.parameter, true) && Subscription.compareDeep(this.heartbeatPeriod, o.heartbeatPeriod, true) && Subscription.compareDeep(this.timeout, o.timeout, true) && Subscription.compareDeep(this.contentType, o.contentType, true) && Subscription.compareDeep(this.content, o.content, true) && Subscription.compareDeep(this.maxCount, o.maxCount, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Subscription)) {
            return false;
        }
        Subscription o = (Subscription)other_;
        return Subscription.compareValues(this.name, o.name, true) && Subscription.compareValues(this.status, o.status, true) && Subscription.compareValues(this.topic, o.topic, true) && Subscription.compareValues(this.end, o.end, true) && Subscription.compareValues(this.reason, o.reason, true) && Subscription.compareValues(this.endpoint, o.endpoint, true) && Subscription.compareValues(this.heartbeatPeriod, o.heartbeatPeriod, true) && Subscription.compareValues(this.timeout, o.timeout, true) && Subscription.compareValues(this.contentType, o.contentType, true) && Subscription.compareValues(this.content, o.content, true) && Subscription.compareValues(this.maxCount, o.maxCount, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.name, this.status, this.topic, this.contact, this.end, this.managingEntity, this.reason, this.filterBy, this.channelType, this.endpoint, this.parameter, this.heartbeatPeriod, this.timeout, this.contentType, this.content, this.maxCount});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Subscription;
    }

    @Block
    public static class SubscriptionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name (key) of the parameter", formalDefinition="Parameter name for information passed to the channel for notifications, for example in the case of a REST hook wanting to pass through an authorization header, the name would be Authorization.")
        protected StringType name;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the parameter to use or pass through", formalDefinition="Parameter value for information passed to the channel for notifications, for example in the case of a REST hook wanting to pass through an authorization header, the value would be `Bearer 0193...`.")
        protected StringType value;
        private static final long serialVersionUID = 395259392L;

        public SubscriptionParameterComponent() {
        }

        public SubscriptionParameterComponent(String name, String value) {
            this.setName(name);
            this.setValue(value);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubscriptionParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubscriptionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionParameterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SubscriptionParameterComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SubscriptionParameterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Subscription.SP_NAME, "string", "Parameter name for information passed to the channel for notifications, for example in the case of a REST hook wanting to pass through an authorization header, the name would be Authorization.", 0, 1, this.name));
            children.add(new Property("value", "string", "Parameter value for information passed to the channel for notifications, for example in the case of a REST hook wanting to pass through an authorization header, the value would be `Bearer 0193...`.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(Subscription.SP_NAME, "string", "Parameter name for information passed to the channel for notifications, for example in the case of a REST hook wanting to pass through an authorization header, the name would be Authorization.", 0, 1, this.name);
                }
                case 111972721: {
                    return new Property("value", "string", "Parameter value for information passed to the channel for notifications, for example in the case of a REST hook wanting to pass through an authorization header, the value would be `Bearer 0193...`.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Subscription.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Subscription.SP_NAME)) {
                this.name = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Subscription.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property Subscription.parameter.name");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property Subscription.parameter.value");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionParameterComponent copy() {
            SubscriptionParameterComponent dst = new SubscriptionParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionParameterComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionParameterComponent)) {
                return false;
            }
            SubscriptionParameterComponent o = (SubscriptionParameterComponent)other_;
            return SubscriptionParameterComponent.compareDeep(this.name, o.name, true) && SubscriptionParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionParameterComponent)) {
                return false;
            }
            SubscriptionParameterComponent o = (SubscriptionParameterComponent)other_;
            return SubscriptionParameterComponent.compareValues(this.name, o.name, true) && SubscriptionParameterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.value});
        }

        @Override
        public String fhirType() {
            return "Subscription.parameter";
        }
    }

    @Block
    public static class SubscriptionFilterByComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resourceType", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allowed Resource (reference to definition) for this Subscription filter", formalDefinition="A resource listed in the `SubscriptionTopic` this `Subscription` references (`SubscriptionTopic.canFilterBy.resource`). This element can be used to differentiate filters for topics that include more than one resource type.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-types")
        protected UriType resourceType;
        @Child(name="filterParameter", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Filter label defined in SubscriptionTopic", formalDefinition="The filter as defined in the `SubscriptionTopic.canFilterBy.filterParameter` element.")
        protected StringType filterParameter;
        @Child(name="comparator", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="eq | ne | gt | lt | ge | le | sa | eb | ap", formalDefinition="Comparator applied to this filter parameter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-comparator")
        protected Enumeration<Enumerations.SearchComparator> comparator;
        @Child(name="modifier", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="missing | exact | contains | not | text | in | not-in | below | above | type | identifier | of-type | code-text | text-advanced | iterate", formalDefinition="Modifier applied to this filter parameter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-modifier-code")
        protected Enumeration<Enumerations.SearchModifierCode> modifier;
        @Child(name="value", type={StringType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Literal value or resource path", formalDefinition="The literal value or resource path as is legal in search - for example, `Patient/123` or `le1950`.")
        protected StringType value;
        private static final long serialVersionUID = 765605139L;

        public SubscriptionFilterByComponent() {
        }

        public SubscriptionFilterByComponent(String filterParameter, String value) {
            this.setFilterParameter(filterParameter);
            this.setValue(value);
        }

        public UriType getResourceTypeElement() {
            if (this.resourceType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.resourceType");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceType = new UriType();
                }
            }
            return this.resourceType;
        }

        public boolean hasResourceTypeElement() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public boolean hasResourceType() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public SubscriptionFilterByComponent setResourceTypeElement(UriType value) {
            this.resourceType = value;
            return this;
        }

        public String getResourceType() {
            return this.resourceType == null ? null : (String)this.resourceType.getValue();
        }

        public SubscriptionFilterByComponent setResourceType(String value) {
            if (Utilities.noString((String)value)) {
                this.resourceType = null;
            } else {
                if (this.resourceType == null) {
                    this.resourceType = new UriType();
                }
                this.resourceType.setValue(value);
            }
            return this;
        }

        public StringType getFilterParameterElement() {
            if (this.filterParameter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.filterParameter");
                }
                if (Configuration.doAutoCreate()) {
                    this.filterParameter = new StringType();
                }
            }
            return this.filterParameter;
        }

        public boolean hasFilterParameterElement() {
            return this.filterParameter != null && !this.filterParameter.isEmpty();
        }

        public boolean hasFilterParameter() {
            return this.filterParameter != null && !this.filterParameter.isEmpty();
        }

        public SubscriptionFilterByComponent setFilterParameterElement(StringType value) {
            this.filterParameter = value;
            return this;
        }

        public String getFilterParameter() {
            return this.filterParameter == null ? null : (String)this.filterParameter.getValue();
        }

        public SubscriptionFilterByComponent setFilterParameter(String value) {
            if (this.filterParameter == null) {
                this.filterParameter = new StringType();
            }
            this.filterParameter.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.SearchComparator> getComparatorElement() {
            if (this.comparator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.comparator");
                }
                if (Configuration.doAutoCreate()) {
                    this.comparator = new Enumeration<Enumerations.SearchComparator>(new Enumerations.SearchComparatorEnumFactory());
                }
            }
            return this.comparator;
        }

        public boolean hasComparatorElement() {
            return this.comparator != null && !this.comparator.isEmpty();
        }

        public boolean hasComparator() {
            return this.comparator != null && !this.comparator.isEmpty();
        }

        public SubscriptionFilterByComponent setComparatorElement(Enumeration<Enumerations.SearchComparator> value) {
            this.comparator = value;
            return this;
        }

        public Enumerations.SearchComparator getComparator() {
            return this.comparator == null ? null : (Enumerations.SearchComparator)((Object)this.comparator.getValue());
        }

        public SubscriptionFilterByComponent setComparator(Enumerations.SearchComparator value) {
            if (value == null) {
                this.comparator = null;
            } else {
                if (this.comparator == null) {
                    this.comparator = new Enumeration<Enumerations.SearchComparator>(new Enumerations.SearchComparatorEnumFactory());
                }
                this.comparator.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.SearchModifierCode> getModifierElement() {
            if (this.modifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.modifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.modifier = new Enumeration<Enumerations.SearchModifierCode>(new Enumerations.SearchModifierCodeEnumFactory());
                }
            }
            return this.modifier;
        }

        public boolean hasModifierElement() {
            return this.modifier != null && !this.modifier.isEmpty();
        }

        public boolean hasModifier() {
            return this.modifier != null && !this.modifier.isEmpty();
        }

        public SubscriptionFilterByComponent setModifierElement(Enumeration<Enumerations.SearchModifierCode> value) {
            this.modifier = value;
            return this;
        }

        public Enumerations.SearchModifierCode getModifier() {
            return this.modifier == null ? null : (Enumerations.SearchModifierCode)((Object)this.modifier.getValue());
        }

        public SubscriptionFilterByComponent setModifier(Enumerations.SearchModifierCode value) {
            if (value == null) {
                this.modifier = null;
            } else {
                if (this.modifier == null) {
                    this.modifier = new Enumeration<Enumerations.SearchModifierCode>(new Enumerations.SearchModifierCodeEnumFactory());
                }
                this.modifier.setValue((Object)value);
            }
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionFilterByComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SubscriptionFilterByComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SubscriptionFilterByComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("resourceType", "uri", "A resource listed in the `SubscriptionTopic` this `Subscription` references (`SubscriptionTopic.canFilterBy.resource`). This element can be used to differentiate filters for topics that include more than one resource type.", 0, 1, this.resourceType));
            children.add(new Property("filterParameter", "string", "The filter as defined in the `SubscriptionTopic.canFilterBy.filterParameter` element.", 0, 1, this.filterParameter));
            children.add(new Property("comparator", "code", "Comparator applied to this filter parameter.", 0, 1, this.comparator));
            children.add(new Property("modifier", "code", "Modifier applied to this filter parameter.", 0, 1, this.modifier));
            children.add(new Property("value", "string", "The literal value or resource path as is legal in search - for example, `Patient/123` or `le1950`.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -384364440: {
                    return new Property("resourceType", "uri", "A resource listed in the `SubscriptionTopic` this `Subscription` references (`SubscriptionTopic.canFilterBy.resource`). This element can be used to differentiate filters for topics that include more than one resource type.", 0, 1, this.resourceType);
                }
                case 618257: {
                    return new Property("filterParameter", "string", "The filter as defined in the `SubscriptionTopic.canFilterBy.filterParameter` element.", 0, 1, this.filterParameter);
                }
                case -844673834: {
                    return new Property("comparator", "code", "Comparator applied to this filter parameter.", 0, 1, this.comparator);
                }
                case -615513385: {
                    return new Property("modifier", "code", "Modifier applied to this filter parameter.", 0, 1, this.modifier);
                }
                case 111972721: {
                    return new Property("value", "string", "The literal value or resource path as is legal in search - for example, `Patient/123` or `le1950`.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -384364440: {
                    Base[] baseArray;
                    if (this.resourceType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resourceType;
                    }
                    return baseArray;
                }
                case 618257: {
                    Base[] baseArray;
                    if (this.filterParameter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.filterParameter;
                    }
                    return baseArray;
                }
                case -844673834: {
                    Base[] baseArray;
                    if (this.comparator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.comparator;
                    }
                    return baseArray;
                }
                case -615513385: {
                    Base[] baseArray;
                    if (this.modifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.modifier;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -384364440: {
                    this.resourceType = TypeConvertor.castToUri(value);
                    return value;
                }
                case 618257: {
                    this.filterParameter = TypeConvertor.castToString(value);
                    return value;
                }
                case -844673834: {
                    value = new Enumerations.SearchComparatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.comparator = value;
                    return value;
                }
                case -615513385: {
                    value = new Enumerations.SearchModifierCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.modifier = value;
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resourceType")) {
                this.resourceType = TypeConvertor.castToUri(value);
            } else if (name.equals("filterParameter")) {
                this.filterParameter = TypeConvertor.castToString(value);
            } else if (name.equals("comparator")) {
                value = new Enumerations.SearchComparatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.comparator = value;
            } else if (name.equals("modifier")) {
                value = new Enumerations.SearchModifierCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.modifier = value;
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("resourceType")) {
                this.resourceType = null;
            } else if (name.equals("filterParameter")) {
                this.filterParameter = null;
            } else if (name.equals("comparator")) {
                value = new Enumerations.SearchComparatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.comparator = value;
            } else if (name.equals("modifier")) {
                value = new Enumerations.SearchModifierCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.modifier = value;
            } else if (name.equals("value")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -384364440: {
                    return this.getResourceTypeElement();
                }
                case 618257: {
                    return this.getFilterParameterElement();
                }
                case -844673834: {
                    return this.getComparatorElement();
                }
                case -615513385: {
                    return this.getModifierElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -384364440: {
                    return new String[]{"uri"};
                }
                case 618257: {
                    return new String[]{"string"};
                }
                case -844673834: {
                    return new String[]{"code"};
                }
                case -615513385: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resourceType")) {
                throw new FHIRException("Cannot call addChild on a singleton property Subscription.filterBy.resourceType");
            }
            if (name.equals("filterParameter")) {
                throw new FHIRException("Cannot call addChild on a singleton property Subscription.filterBy.filterParameter");
            }
            if (name.equals("comparator")) {
                throw new FHIRException("Cannot call addChild on a singleton property Subscription.filterBy.comparator");
            }
            if (name.equals("modifier")) {
                throw new FHIRException("Cannot call addChild on a singleton property Subscription.filterBy.modifier");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property Subscription.filterBy.value");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionFilterByComponent copy() {
            SubscriptionFilterByComponent dst = new SubscriptionFilterByComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionFilterByComponent dst) {
            super.copyValues(dst);
            dst.resourceType = this.resourceType == null ? null : this.resourceType.copy();
            dst.filterParameter = this.filterParameter == null ? null : this.filterParameter.copy();
            dst.comparator = this.comparator == null ? null : this.comparator.copy();
            dst.modifier = this.modifier == null ? null : this.modifier.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionFilterByComponent)) {
                return false;
            }
            SubscriptionFilterByComponent o = (SubscriptionFilterByComponent)other_;
            return SubscriptionFilterByComponent.compareDeep(this.resourceType, o.resourceType, true) && SubscriptionFilterByComponent.compareDeep(this.filterParameter, o.filterParameter, true) && SubscriptionFilterByComponent.compareDeep(this.comparator, o.comparator, true) && SubscriptionFilterByComponent.compareDeep(this.modifier, o.modifier, true) && SubscriptionFilterByComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionFilterByComponent)) {
                return false;
            }
            SubscriptionFilterByComponent o = (SubscriptionFilterByComponent)other_;
            return SubscriptionFilterByComponent.compareValues(this.resourceType, o.resourceType, true) && SubscriptionFilterByComponent.compareValues(this.filterParameter, o.filterParameter, true) && SubscriptionFilterByComponent.compareValues(this.comparator, o.comparator, true) && SubscriptionFilterByComponent.compareValues(this.modifier, o.modifier, true) && SubscriptionFilterByComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.resourceType, this.filterParameter, this.comparator, this.modifier, this.value});
        }

        @Override
        public String fhirType() {
            return "Subscription.filterBy";
        }
    }

    public static class SubscriptionPayloadContentEnumFactory
    implements EnumFactory<SubscriptionPayloadContent> {
        @Override
        public SubscriptionPayloadContent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("empty".equals(codeString)) {
                return SubscriptionPayloadContent.EMPTY;
            }
            if ("id-only".equals(codeString)) {
                return SubscriptionPayloadContent.IDONLY;
            }
            if ("full-resource".equals(codeString)) {
                return SubscriptionPayloadContent.FULLRESOURCE;
            }
            throw new IllegalArgumentException("Unknown SubscriptionPayloadContent code '" + codeString + "'");
        }

        public Enumeration<SubscriptionPayloadContent> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.NULL, code);
            }
            if ("empty".equals(codeString)) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.EMPTY, code);
            }
            if ("id-only".equals(codeString)) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.IDONLY, code);
            }
            if ("full-resource".equals(codeString)) {
                return new Enumeration<SubscriptionPayloadContent>(this, SubscriptionPayloadContent.FULLRESOURCE, code);
            }
            throw new FHIRException("Unknown SubscriptionPayloadContent code '" + codeString + "'");
        }

        @Override
        public String toCode(SubscriptionPayloadContent code) {
            if (code == SubscriptionPayloadContent.EMPTY) {
                return "empty";
            }
            if (code == SubscriptionPayloadContent.IDONLY) {
                return "id-only";
            }
            if (code == SubscriptionPayloadContent.FULLRESOURCE) {
                return "full-resource";
            }
            return "?";
        }

        @Override
        public String toSystem(SubscriptionPayloadContent code) {
            return code.getSystem();
        }
    }

    public static enum SubscriptionPayloadContent {
        EMPTY,
        IDONLY,
        FULLRESOURCE,
        NULL;


        public static SubscriptionPayloadContent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("empty".equals(codeString)) {
                return EMPTY;
            }
            if ("id-only".equals(codeString)) {
                return IDONLY;
            }
            if ("full-resource".equals(codeString)) {
                return FULLRESOURCE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SubscriptionPayloadContent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EMPTY: {
                    return "empty";
                }
                case IDONLY: {
                    return "id-only";
                }
                case FULLRESOURCE: {
                    return "full-resource";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EMPTY: {
                    return "http://hl7.org/fhir/subscription-payload-content";
                }
                case IDONLY: {
                    return "http://hl7.org/fhir/subscription-payload-content";
                }
                case FULLRESOURCE: {
                    return "http://hl7.org/fhir/subscription-payload-content";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EMPTY: {
                    return "No resource content is transacted in the notification payload.";
                }
                case IDONLY: {
                    return "Only the resource id is transacted in the notification payload.";
                }
                case FULLRESOURCE: {
                    return "The entire resource is transacted in the notification payload.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EMPTY: {
                    return "Empty";
                }
                case IDONLY: {
                    return "Id-only";
                }
                case FULLRESOURCE: {
                    return "Full-resource";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

